/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.dc.common.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.kuali.coeus.dc.common.db.ConnectionDaoService;

public abstract class AbstractConnectionDaoService
implements ConnectionDaoService {
    private String riceConnectionString;
    private String coeusConnectionString;
    private String riceUser;
    private String coeusUser;
    private String ricePassword;
    private String coeusPassword;
    private static final ThreadLocal<Connection> COEUS_CONNECTIONS = new ThreadLocal();
    private static final ThreadLocal<Connection> RICE_CONNECTIONS = new ThreadLocal();

    public AbstractConnectionDaoService() {
        try {
            Class.forName(this.getDriverClassName()).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e2) {
            throw new RuntimeException(e2);
        }
    }

    public abstract String getDriverClassName();

    @Override
    public Connection getCoeusConnection() {
        Connection c2 = COEUS_CONNECTIONS.get();
        if (c2 == null) {
            try {
                c2 = this.getConnection(this.getCoeusConnectionString(), this.getCoeusUser(), this.getCoeusPassword());
                c2.setAutoCommit(false);
            }
            catch (SQLException e2) {
                e2.printStackTrace();
                throw new RuntimeException(e2);
            }
            COEUS_CONNECTIONS.set(c2);
        }
        return c2;
    }

    @Override
    public Connection getRiceConnection() {
        Connection c2 = RICE_CONNECTIONS.get();
        if (c2 == null) {
            try {
                c2 = this.getConnection(this.getRiceConnectionString(), this.getRiceUser(), this.getRicePassword());
                c2.setAutoCommit(false);
            }
            catch (SQLException e2) {
                throw new RuntimeException(e2);
            }
            RICE_CONNECTIONS.set(c2);
        }
        return c2;
    }

    private Connection getConnection(String con, String user, String pass) throws SQLException {
        if (user != null && !user.trim().equals("")) {
            return DriverManager.getConnection(con, user, pass);
        }
        return DriverManager.getConnection(con);
    }

    public String getRiceConnectionString() {
        return this.riceConnectionString;
    }

    public void setRiceConnectionString(String riceConnectionString) {
        this.riceConnectionString = riceConnectionString;
    }

    public String getCoeusConnectionString() {
        return this.coeusConnectionString;
    }

    public void setCoeusConnectionString(String coeusConnectionString) {
        this.coeusConnectionString = coeusConnectionString;
    }

    private String getRiceUser() {
        return this.riceUser;
    }

    public void setRiceUser(String riceUser) {
        this.riceUser = riceUser;
    }

    private String getCoeusUser() {
        return this.coeusUser;
    }

    public void setCoeusUser(String coeusUser) {
        this.coeusUser = coeusUser;
    }

    private String getRicePassword() {
        return this.ricePassword;
    }

    public void setRicePassword(String ricePassword) {
        this.ricePassword = ricePassword;
    }

    private String getCoeusPassword() {
        return this.coeusPassword;
    }

    public void setCoeusPassword(String coeusPassword) {
        this.coeusPassword = coeusPassword;
    }
}

