/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.bridge;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.NDC;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.impl.ThrowableProxy;
import org.apache.logging.log4j.core.time.Instant;
import org.apache.logging.log4j.core.time.MutableInstant;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.spi.MutableThreadContextStack;
import org.apache.logging.log4j.util.BiConsumer;
import org.apache.logging.log4j.util.ReadOnlyStringMap;
import org.apache.logging.log4j.util.TriConsumer;

public class LogEventWrapper
implements LogEvent {
    private final LoggingEvent event;
    private final ContextDataMap contextData;
    private final MutableThreadContextStack contextStack;
    private volatile Thread thread;

    public LogEventWrapper(LoggingEvent event) {
        this.event = event;
        this.contextData = new ContextDataMap(event.getProperties());
        this.contextStack = new MutableThreadContextStack(NDC.cloneStack());
    }

    @Override
    public LogEvent toImmutable() {
        return null;
    }

    @Override
    public Map<String, String> getContextMap() {
        return this.contextData;
    }

    @Override
    public ReadOnlyStringMap getContextData() {
        return this.contextData;
    }

    @Override
    public ThreadContext.ContextStack getContextStack() {
        return this.contextStack;
    }

    @Override
    public String getLoggerFqcn() {
        return null;
    }

    @Override
    public Level getLevel() {
        return OptionConverter.convertLevel(this.event.getLevel());
    }

    @Override
    public String getLoggerName() {
        return this.event.getLoggerName();
    }

    @Override
    public Marker getMarker() {
        return null;
    }

    @Override
    public Message getMessage() {
        return new SimpleMessage(this.event.getRenderedMessage());
    }

    @Override
    public long getTimeMillis() {
        return this.event.getTimeStamp();
    }

    @Override
    public Instant getInstant() {
        MutableInstant mutable = new MutableInstant();
        mutable.initFromEpochMilli(this.event.getTimeStamp(), 0);
        return mutable;
    }

    @Override
    public StackTraceElement getSource() {
        LocationInfo info = this.event.getLocationInformation();
        return new StackTraceElement(info.getClassName(), info.getMethodName(), info.getFileName(), Integer.parseInt(info.getLineNumber()));
    }

    @Override
    public String getThreadName() {
        return this.event.getThreadName();
    }

    @Override
    public long getThreadId() {
        Thread thread = this.getThread();
        return thread != null ? thread.getId() : 0L;
    }

    @Override
    public int getThreadPriority() {
        Thread thread = this.getThread();
        return thread != null ? thread.getPriority() : 0;
    }

    private Thread getThread() {
        if (this.thread == null) {
            for (Thread thread : Thread.getAllStackTraces().keySet()) {
                if (!thread.getName().equals(this.event.getThreadName())) continue;
                this.thread = thread;
                return thread;
            }
        }
        return null;
    }

    @Override
    public Throwable getThrown() {
        if (this.event.getThrowableInformation() != null) {
            return this.event.getThrowableInformation().getThrowable();
        }
        return null;
    }

    @Override
    public ThrowableProxy getThrownProxy() {
        return null;
    }

    @Override
    public boolean isEndOfBatch() {
        return false;
    }

    @Override
    public boolean isIncludeLocation() {
        return false;
    }

    @Override
    public void setEndOfBatch(boolean endOfBatch) {
    }

    @Override
    public void setIncludeLocation(boolean locationRequired) {
    }

    @Override
    public long getNanoTime() {
        return 0L;
    }

    private static class ContextDataMap
    extends HashMap<String, String>
    implements ReadOnlyStringMap {
        ContextDataMap(Map<String, String> map) {
            if (map != null) {
                super.putAll(map);
            }
        }

        @Override
        public Map<String, String> toMap() {
            return this;
        }

        @Override
        public boolean containsKey(String key) {
            return super.containsKey(key);
        }

        @Override
        public <V> void forEach(BiConsumer<String, ? super V> action) {
            super.forEach((? super K k2, ? super V v2) -> action.accept((String)k2, (Object)v2));
        }

        @Override
        public <V, S> void forEach(TriConsumer<String, ? super V, S> action, S state) {
            super.forEach((? super K k2, ? super V v2) -> action.accept((String)k2, (Object)v2, state));
        }

        @Override
        public <V> V getValue(String key) {
            return super.get(key);
        }
    }
}

