/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.result;

import com.mysql.cj.Constants;
import com.mysql.cj.Messages;
import com.mysql.cj.conf.PropertyKey;
import com.mysql.cj.conf.PropertySet;
import com.mysql.cj.exceptions.NumberOutOfRange;
import com.mysql.cj.result.DefaultValueFactory;
import com.mysql.cj.result.Field;
import com.mysql.cj.util.DataTypeUtil;
import com.mysql.cj.util.StringUtils;
import java.math.BigDecimal;
import java.math.BigInteger;

public class ByteValueFactory
extends DefaultValueFactory<Byte> {
    public ByteValueFactory(PropertySet pset) {
        super(pset);
    }

    @Override
    public Byte createFromBigInteger(BigInteger i2) {
        if (this.jdbcCompliantTruncationForReads && (i2.compareTo(Constants.BIG_INTEGER_MIN_BYTE_VALUE) < 0 || i2.compareTo(Constants.BIG_INTEGER_MAX_BYTE_VALUE) > 0)) {
            throw new NumberOutOfRange(Messages.getString("ResultSet.NumberOutOfRange", new Object[]{i2, this.getTargetTypeName()}));
        }
        return (byte)i2.intValue();
    }

    @Override
    public Byte createFromLong(long l2) {
        if (this.jdbcCompliantTruncationForReads && (l2 < -128L || l2 > 127L)) {
            throw new NumberOutOfRange(Messages.getString("ResultSet.NumberOutOfRange", new Object[]{Long.valueOf(l2).toString(), this.getTargetTypeName()}));
        }
        return (byte)l2;
    }

    @Override
    public Byte createFromBigDecimal(BigDecimal d2) {
        if (this.jdbcCompliantTruncationForReads && (d2.compareTo(Constants.BIG_DECIMAL_MIN_BYTE_VALUE) < 0 || d2.compareTo(Constants.BIG_DECIMAL_MAX_BYTE_VALUE) > 0)) {
            throw new NumberOutOfRange(Messages.getString("ResultSet.NumberOutOfRange", new Object[]{d2, this.getTargetTypeName()}));
        }
        return (byte)d2.longValue();
    }

    @Override
    public Byte createFromDouble(double d2) {
        if (this.jdbcCompliantTruncationForReads && (d2 < -128.0 || d2 > 127.0)) {
            throw new NumberOutOfRange(Messages.getString("ResultSet.NumberOutOfRange", new Object[]{d2, this.getTargetTypeName()}));
        }
        return (byte)d2;
    }

    @Override
    public Byte createFromBit(byte[] bytes, int offset, int length) {
        long l2 = DataTypeUtil.bitToLong(bytes, offset, length);
        if (this.jdbcCompliantTruncationForReads && l2 >> 8 != 0L) {
            throw new NumberOutOfRange(Messages.getString("ResultSet.NumberOutOfRange", new Object[]{Long.valueOf(l2).toString(), this.getTargetTypeName()}));
        }
        return (byte)l2;
    }

    @Override
    public Byte createFromYear(long l2) {
        return this.createFromLong(l2);
    }

    @Override
    public String getTargetTypeName() {
        return Byte.class.getName();
    }

    @Override
    public Byte createFromBytes(byte[] bytes, int offset, int length, Field f2) {
        if (length == 0 && this.pset.getBooleanProperty(PropertyKey.emptyStringsConvertToZero).getValue().booleanValue()) {
            return (byte)0;
        }
        String s2 = StringUtils.toString(bytes, offset, length, f2.getEncoding());
        byte[] newBytes = s2.getBytes();
        if (this.jdbcCompliantTruncationForReads && newBytes.length != 1) {
            throw new NumberOutOfRange(Messages.getString("ResultSet.NumberOutOfRange", new Object[]{s2, this.getTargetTypeName()}));
        }
        return newBytes[0];
    }
}

