/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.result;

import com.mysql.cj.Constants;
import com.mysql.cj.Messages;
import com.mysql.cj.conf.PropertySet;
import com.mysql.cj.exceptions.NumberOutOfRange;
import com.mysql.cj.result.AbstractNumericValueFactory;
import com.mysql.cj.util.DataTypeUtil;
import java.math.BigDecimal;
import java.math.BigInteger;

public class IntegerValueFactory
extends AbstractNumericValueFactory<Integer> {
    public IntegerValueFactory(PropertySet pset) {
        super(pset);
    }

    @Override
    public Integer createFromBigInteger(BigInteger i2) {
        if (this.jdbcCompliantTruncationForReads && (i2.compareTo(Constants.BIG_INTEGER_MIN_INTEGER_VALUE) < 0 || i2.compareTo(Constants.BIG_INTEGER_MAX_INTEGER_VALUE) > 0)) {
            throw new NumberOutOfRange(Messages.getString("ResultSet.NumberOutOfRange", new Object[]{i2, this.getTargetTypeName()}));
        }
        return i2.intValue();
    }

    @Override
    public Integer createFromLong(long l2) {
        if (this.jdbcCompliantTruncationForReads && (l2 < Integer.MIN_VALUE || l2 > Integer.MAX_VALUE)) {
            throw new NumberOutOfRange(Messages.getString("ResultSet.NumberOutOfRange", new Object[]{Long.valueOf(l2).toString(), this.getTargetTypeName()}));
        }
        return (int)l2;
    }

    @Override
    public Integer createFromBigDecimal(BigDecimal d2) {
        if (this.jdbcCompliantTruncationForReads && (d2.compareTo(Constants.BIG_DECIMAL_MIN_INTEGER_VALUE) < 0 || d2.compareTo(Constants.BIG_DECIMAL_MAX_INTEGER_VALUE) > 0)) {
            throw new NumberOutOfRange(Messages.getString("ResultSet.NumberOutOfRange", new Object[]{d2, this.getTargetTypeName()}));
        }
        return (int)d2.longValue();
    }

    @Override
    public Integer createFromDouble(double d2) {
        if (this.jdbcCompliantTruncationForReads && (d2 < -2.147483648E9 || d2 > 2.147483647E9)) {
            throw new NumberOutOfRange(Messages.getString("ResultSet.NumberOutOfRange", new Object[]{d2, this.getTargetTypeName()}));
        }
        return (int)d2;
    }

    @Override
    public Integer createFromBit(byte[] bytes, int offset, int length) {
        long l2 = DataTypeUtil.bitToLong(bytes, offset, length);
        if (this.jdbcCompliantTruncationForReads && l2 >> 32 != 0L) {
            throw new NumberOutOfRange(Messages.getString("ResultSet.NumberOutOfRange", new Object[]{Long.valueOf(l2).toString(), this.getTargetTypeName()}));
        }
        return (int)l2;
    }

    @Override
    public String getTargetTypeName() {
        return Integer.class.getName();
    }
}

