/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle.rlb;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Executable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.jdbc.oracle.OracleLoadBalancingEvent;
import oracle.ucp.jdbc.oracle.RACInstance;
import oracle.ucp.jdbc.oracle.RACInstanceImpl;
import oracle.ucp.logging.ClioSupport;

@DefaultLogger(value="oracle.ucp.jdbc.oracle.rlb")
@Supports(value={Feature.LOAD_BALANCING})
public final class ONSRuntimeLoadBalancingEvent
implements OracleLoadBalancingEvent {
    private static final String ONS_RCLB_EVENT_DELIMITER = "{} =";
    public static final int RLB_INSTANCE_GOOD = 1;
    public static final int RLB_INSTANCE_UNKNOWN = 2;
    public static final int RLB_INSTANCE_VIOLATING = 3;
    public static final int RLB_INSTANCE_NO_DATA = 4;
    public static final int RLB_INSTANCE_BLOCKED = 5;
    public static final int RLB_NUMBER_OF_HITS_PER_INSTANCE = 1000;
    private Set<RACInstance> m_racInstances = Collections.synchronizedSet(new HashSet());
    private byte[] m_eventBody = null;
    private final String m_serviceName;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;

    public ONSRuntimeLoadBalancingEvent(String serviceName, byte[] eventBody) throws UniversalConnectionPoolException {
        this.m_serviceName = serviceName;
        this.m_eventBody = eventBody;
        StringTokenizer strTokens = null;
        String instNameKey = null;
        String dbUniqNameKey = null;
        int percent = 0;
        float percentf = 0.0f;
        OracleLoadBalancingEvent.InstanceStatus flag = OracleLoadBalancingEvent.InstanceStatus.UNKNOWN;
        boolean updateNecessary = false;
        boolean isAffinityEnabledForThisInstance = false;
        try {
            strTokens = new StringTokenizer(new String(eventBody, "UTF-8"), ONS_RCLB_EVENT_DELIMITER, true);
        }
        catch (UnsupportedEncodingException e2) {
            ClioSupport.ilogThrowing(null, null, null, null, e2);
        }
        String st = null;
        String val = null;
        String key = null;
        while (strTokens.hasMoreTokens()) {
            val = null;
            st = strTokens.nextToken();
            if (st.equals("=") && strTokens.hasMoreTokens()) {
                val = strTokens.nextToken();
            } else {
                if (st.equals("}")) {
                    if (!updateNecessary) continue;
                    RACInstanceImpl racInstance = new RACInstanceImpl(this.m_serviceName, instNameKey, "", dbUniqNameKey);
                    if (percentf > 0.0f) {
                        racInstance.setFloatPercent(percentf);
                    } else {
                        racInstance.setPercent(percent);
                    }
                    racInstance.setStatus(flag);
                    racInstance.setAffinityHint(isAffinityEnabledForThisInstance);
                    this.m_racInstances.add(racInstance);
                    updateNecessary = false;
                    isAffinityEnabledForThisInstance = false;
                    continue;
                }
                if (st.equals("{") || st.equals(" ")) continue;
                key = st;
                updateNecessary = true;
            }
            if (key.equalsIgnoreCase("version") && val != null) {
                if (val.startsWith("1.")) continue;
                ClioSupport.ilogFine(null, null, null, null, "Invalid Event version " + val);
                break;
            }
            if (key.equalsIgnoreCase("database") && val != null) {
                dbUniqNameKey = val.trim().toLowerCase();
                continue;
            }
            if (key.equalsIgnoreCase("instance") && val != null) {
                instNameKey = val.trim().toLowerCase();
                continue;
            }
            if (key.equalsIgnoreCase("percent") && val != null) {
                try {
                    percent = Integer.parseInt(val);
                    if (percent != 0) continue;
                    percent = 1;
                }
                catch (NumberFormatException nfe) {
                    ClioSupport.ilogThrowing(null, null, null, null, nfe);
                }
                continue;
            }
            if (key.equalsIgnoreCase("percentf") && val != null) {
                try {
                    percentf = Float.parseFloat(val);
                }
                catch (NumberFormatException nfe) {
                    ClioSupport.ilogThrowing(null, null, null, null, nfe);
                }
                continue;
            }
            if (key.equalsIgnoreCase("flag") && val != null) {
                if (val.equalsIgnoreCase("good")) {
                    flag = OracleLoadBalancingEvent.InstanceStatus.GOOD;
                    continue;
                }
                if (val.equalsIgnoreCase("violating")) {
                    flag = OracleLoadBalancingEvent.InstanceStatus.VIOLATING;
                    continue;
                }
                if (val.equalsIgnoreCase("NO_DATA")) {
                    flag = OracleLoadBalancingEvent.InstanceStatus.NO_DATA;
                    continue;
                }
                if (val.equalsIgnoreCase("UNKNOWN")) {
                    flag = OracleLoadBalancingEvent.InstanceStatus.UNKNOWN;
                    continue;
                }
                if (!val.equalsIgnoreCase("BLOCKED")) continue;
                flag = OracleLoadBalancingEvent.InstanceStatus.BLOCKED;
                continue;
            }
            if (!key.equalsIgnoreCase("aff") || val == null) continue;
            isAffinityEnabledForThisInstance = val.equalsIgnoreCase("true");
        }
    }

    @Override
    public Set<RACInstance> getRACInstances() {
        return this.m_racInstances;
    }

    @Override
    public String getServiceName() {
        return this.m_serviceName;
    }

    @Override
    public byte[] getEventBody() {
        return this.m_eventBody;
    }

    static {
        try {
            $$$methodRef$$$3 = ONSRuntimeLoadBalancingEvent.class.getDeclaredConstructor(String.class, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle.rlb");
        try {
            $$$methodRef$$$2 = ONSRuntimeLoadBalancingEvent.class.getDeclaredMethod("getEventBody", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle.rlb");
        try {
            $$$methodRef$$$1 = ONSRuntimeLoadBalancingEvent.class.getDeclaredMethod("getServiceName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle.rlb");
        try {
            $$$methodRef$$$0 = ONSRuntimeLoadBalancingEvent.class.getDeclaredMethod("getRACInstances", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle.rlb");
    }
}

