/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.routing;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import oracle.jdbc.OracleShardingKey;
import oracle.jdbc.OracleType;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.pool.OracleShardingKeyBuilderImpl;
import oracle.jdbc.pool.OracleShardingKeyImpl;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.common.ServiceMember;
import oracle.ucp.routing.Chunk;
import oracle.ucp.routing.HashRangeShardingKeys;
import oracle.ucp.routing.ShardRoutingCache;
import oracle.ucp.routing.SuperShardingKeys;

@DefaultLogger(value="oracle.ucp.jdbc.routing")
@Supports(value={Feature.CHECK_IN, Feature.CHECK_OUT, Feature.CONN_CONSTRUCTION, Feature.CONN_DESTRUCTION})
public abstract class RACDataAffinityRoutingCache
extends ShardRoutingCache {
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;

    @Override
    protected ShardRoutingCache.RoutingKey makeRoutingKey(Chunk.Metadata chunkInfo) throws SQLException {
        SuperShardingKeys superShardingKeys = SuperShardingKeys.DEFAULT_SUPER_SHARDING_KEYS;
        OracleShardingKeyImpl dummyKey = new OracleShardingKeyBuilderImpl().subkey(chunkInfo.chunkId, OracleType.NUMBER).build();
        HashRangeShardingKeys shardingKeys = new HashRangeShardingKeys(dummyKey, dummyKey);
        return new ShardRoutingCache.RoutingKey(shardingKeys, superShardingKeys);
    }

    @Override
    protected boolean entryContainsRoutingKey(Map.Entry<ShardRoutingCache.RoutingKey, Chunk> routingTableRow, OracleShardingKey shardingKey, OracleShardingKey lookupKey, OracleShardingKey superKey) {
        long chunkIdForKey = this.getChunkId(shardingKey);
        return (long)routingTableRow.getValue().Id().get() == chunkIdForKey;
    }

    @Override
    protected boolean hasKeyMapped(OracleShardingKey shardingKey, OracleShardingKey superKey) {
        return true;
    }

    private long getChunkId(OracleShardingKey shardingKey) {
        long chunkCount = this.chunksCount();
        long hashMask = 1L;
        long bucketSize = chunkCount;
        while ((bucketSize >>= 1) > 0L) {
            hashMask <<= 1;
        }
        hashMask = (hashMask << 1) - 1L;
        long keyHashValue = ((OracleShardingKeyImpl)shardingKey).shardKeyOraHash(this.shardingMetadata());
        long hashBucket = keyHashValue & hashMask;
        if (hashBucket >= chunkCount) {
            hashBucket = keyHashValue & hashMask >> 1;
        }
        return hashBucket + 1L;
    }

    @Override
    public ServiceMember getBestInstanceToGrow(ConnectionRetrievalInfo cri) {
        return this.getAffinitizedInstance(cri);
    }

    @Override
    public Set<ServiceMember> instancesToGrow(ConnectionRetrievalInfo cri) {
        return this.allInstances(cri);
    }

    @Override
    public Set<ServiceMember> allInstances(ConnectionRetrievalInfo cri) {
        HashSet<ServiceMember> affinitizedInstanceSet = new HashSet<ServiceMember>();
        ServiceMember affinitizedInstance = this.getAffinitizedInstance(cri);
        if (affinitizedInstance != null) {
            affinitizedInstanceSet.add(affinitizedInstance);
        }
        return affinitizedInstanceSet;
    }

    @Override
    public Set<ServiceMember> allPriorityInstances(ConnectionRetrievalInfo cri) {
        return this.allInstances(cri);
    }

    private ServiceMember getAffinitizedInstance(ConnectionRetrievalInfo cri) {
        List<Chunk> reqChunks = this.chunks(cri);
        if (reqChunks != null && reqChunks.size() > 0) {
            for (Chunk chunk : reqChunks) {
                Set<ServiceMember> allInstances = chunk.instances();
                for (ServiceMember instance : allInstances) {
                    if (instance.dbInstanceId() != chunk.affinitizedInstId().get()) continue;
                    return instance;
                }
            }
        }
        return null;
    }

    static {
        try {
            $$$methodRef$$$9 = RACDataAffinityRoutingCache.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$8 = RACDataAffinityRoutingCache.class.getDeclaredMethod("getAffinitizedInstance", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$7 = RACDataAffinityRoutingCache.class.getDeclaredMethod("allPriorityInstances", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$6 = RACDataAffinityRoutingCache.class.getDeclaredMethod("allInstances", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$5 = RACDataAffinityRoutingCache.class.getDeclaredMethod("instancesToGrow", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$4 = RACDataAffinityRoutingCache.class.getDeclaredMethod("getBestInstanceToGrow", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$3 = RACDataAffinityRoutingCache.class.getDeclaredMethod("getChunkId", OracleShardingKey.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$2 = RACDataAffinityRoutingCache.class.getDeclaredMethod("hasKeyMapped", OracleShardingKey.class, OracleShardingKey.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$1 = RACDataAffinityRoutingCache.class.getDeclaredMethod("entryContainsRoutingKey", Map.Entry.class, OracleShardingKey.class, OracleShardingKey.class, OracleShardingKey.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$0 = RACDataAffinityRoutingCache.class.getDeclaredMethod("makeRoutingKey", Chunk.Metadata.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
    }
}

