/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.dbcp2.AbandonedTrace;
import org.apache.commons.dbcp2.DelegatingConnection;
import org.apache.commons.dbcp2.DelegatingPreparedStatement;
import org.apache.commons.dbcp2.SQLExceptionList;
import org.apache.commons.pool2.KeyedObjectPool;

public class PoolablePreparedStatement<K>
extends DelegatingPreparedStatement {
    private final KeyedObjectPool<K, PoolablePreparedStatement<K>> pool;
    private final K key;
    private volatile boolean batchAdded = false;

    public PoolablePreparedStatement(PreparedStatement stmt, K key, KeyedObjectPool<K, PoolablePreparedStatement<K>> pool, DelegatingConnection<?> conn) {
        super(conn, stmt);
        this.pool = pool;
        this.key = key;
        this.removeThisTrace(this.getConnectionInternal());
    }

    @Override
    public void addBatch() throws SQLException {
        super.addBatch();
        this.batchAdded = true;
    }

    @Override
    public void clearBatch() throws SQLException {
        this.batchAdded = false;
        super.clearBatch();
    }

    @Override
    public void close() throws SQLException {
        if (!this.isClosed()) {
            try {
                this.pool.returnObject(this.key, this);
            }
            catch (SQLException e2) {
                throw e2;
            }
            catch (RuntimeException e3) {
                throw e3;
            }
            catch (Exception e4) {
                throw new SQLException("Cannot close preparedstatement (return to pool failed)", e4);
            }
        }
    }

    @Override
    public void activate() throws SQLException {
        this.setClosedInternal(false);
        if (this.getConnectionInternal() != null) {
            this.getConnectionInternal().addTrace(this);
        }
        super.activate();
    }

    @Override
    public void passivate() throws SQLException {
        if (this.batchAdded) {
            this.clearBatch();
        }
        this.setClosedInternal(true);
        this.removeThisTrace(this.getConnectionInternal());
        List<AbandonedTrace> resultSetList = this.getTrace();
        if (resultSetList != null) {
            ResultSet[] resultSets;
            ArrayList<Exception> thrown = new ArrayList<Exception>();
            for (ResultSet resultSet : resultSets = resultSetList.toArray(new ResultSet[resultSetList.size()])) {
                if (resultSet == null) continue;
                try {
                    resultSet.close();
                }
                catch (Exception e2) {
                    thrown.add(e2);
                }
            }
            this.clearTrace();
            if (!thrown.isEmpty()) {
                throw new SQLExceptionList(thrown);
            }
        }
        super.passivate();
    }
}

