/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.helpers;

import java.io.InterruptedIOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;
import org.apache.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.LoaderUtil;

public class OptionConverter {
    static String DELIM_START = "${";
    static char DELIM_STOP = (char)125;
    static int DELIM_START_LEN = 2;
    static int DELIM_STOP_LEN = 1;
    private static final Logger LOGGER = LogManager.getLogger(OptionConverter.class);
    private static final CharMap[] charMap = new CharMap[]{new CharMap('n', '\n'), new CharMap('r', '\r'), new CharMap('t', '\t'), new CharMap('f', '\f'), new CharMap('\b', '\b'), new CharMap('\"', '\"'), new CharMap('\'', '\''), new CharMap('\\', '\\')};

    private OptionConverter() {
    }

    public static String[] concatanateArrays(String[] l2, String[] r2) {
        int len = l2.length + r2.length;
        String[] a2 = new String[len];
        System.arraycopy(l2, 0, a2, 0, l2.length);
        System.arraycopy(r2, 0, a2, l2.length, r2.length);
        return a2;
    }

    public static String convertSpecialChars(String s2) {
        int len = s2.length();
        StringBuilder sbuf = new StringBuilder(len);
        int i2 = 0;
        while (i2 < len) {
            char c2;
            if ((c2 = s2.charAt(i2++)) == '\\') {
                c2 = s2.charAt(i2++);
                for (CharMap entry : charMap) {
                    if (entry.key != c2) continue;
                    c2 = entry.replacement;
                }
            }
            sbuf.append(c2);
        }
        return sbuf.toString();
    }

    public static String getSystemProperty(String key, String def) {
        try {
            return System.getProperty(key, def);
        }
        catch (Throwable e2) {
            LOGGER.debug("Was not allowed to read system property \"{}\".", (Object)key);
            return def;
        }
    }

    public static boolean toBoolean(String value, boolean dEfault) {
        if (value == null) {
            return dEfault;
        }
        String trimmedVal = value.trim();
        if ("true".equalsIgnoreCase(trimmedVal)) {
            return true;
        }
        if ("false".equalsIgnoreCase(trimmedVal)) {
            return false;
        }
        return dEfault;
    }

    public static Level toLevel(String value, Level defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        int hashIndex = (value = value.trim()).indexOf(35);
        if (hashIndex == -1) {
            if ("NULL".equalsIgnoreCase(value)) {
                return null;
            }
            return Level.toLevel(value, defaultValue);
        }
        Level result = defaultValue;
        String clazz = value.substring(hashIndex + 1);
        String levelName = value.substring(0, hashIndex);
        if ("NULL".equalsIgnoreCase(levelName)) {
            return null;
        }
        LOGGER.debug("toLevel:class=[" + clazz + "]:pri=[" + levelName + "]");
        try {
            Class<?> customLevel = LoaderUtil.loadClass(clazz);
            Class[] paramTypes = new Class[]{String.class, Level.class};
            Method toLevelMethod = customLevel.getMethod("toLevel", paramTypes);
            Object[] params = new Object[]{levelName, defaultValue};
            Object o2 = toLevelMethod.invoke(null, params);
            result = (Level)o2;
        }
        catch (ClassNotFoundException e2) {
            LOGGER.warn("custom level class [" + clazz + "] not found.");
        }
        catch (NoSuchMethodException e3) {
            LOGGER.warn("custom level class [" + clazz + "] does not have a class function toLevel(String, Level)", (Throwable)e3);
        }
        catch (InvocationTargetException e4) {
            if (e4.getTargetException() instanceof InterruptedException || e4.getTargetException() instanceof InterruptedIOException) {
                Thread.currentThread().interrupt();
            }
            LOGGER.warn("custom level class [" + clazz + "] could not be instantiated", (Throwable)e4);
        }
        catch (ClassCastException e5) {
            LOGGER.warn("class [" + clazz + "] is not a subclass of org.apache.log4j.Level", (Throwable)e5);
        }
        catch (IllegalAccessException e6) {
            LOGGER.warn("class [" + clazz + "] cannot be instantiated due to access restrictions", (Throwable)e6);
        }
        catch (RuntimeException e7) {
            LOGGER.warn("class [" + clazz + "], level [" + levelName + "] conversion failed.", (Throwable)e7);
        }
        return result;
    }

    public static Object instantiateByClassName(String className, Class<?> superClass, Object defaultValue) {
        if (className != null) {
            try {
                Object obj = LoaderUtil.newInstanceOf(className);
                if (!superClass.isAssignableFrom(obj.getClass())) {
                    LOGGER.error("A \"{}\" object is not assignable to a \"{}\" variable", (Object)className, (Object)superClass.getName());
                    return defaultValue;
                }
                return obj;
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e2) {
                LOGGER.error("Could not instantiate class [" + className + "].", (Throwable)e2);
            }
        }
        return defaultValue;
    }

    public static String substVars(String val, Properties props) throws IllegalArgumentException {
        StringBuilder sbuf = new StringBuilder();
        int i2 = 0;
        while (true) {
            int j2;
            if ((j2 = val.indexOf(DELIM_START, i2)) == -1) {
                if (i2 == 0) {
                    return val;
                }
                sbuf.append(val.substring(i2, val.length()));
                return sbuf.toString();
            }
            sbuf.append(val.substring(i2, j2));
            int k2 = val.indexOf(DELIM_STOP, j2);
            if (k2 == -1) {
                throw new IllegalArgumentException('\"' + val + "\" has no closing brace. Opening brace at position " + j2 + '.');
            }
            String key = val.substring(j2 += DELIM_START_LEN, k2);
            String replacement = OptionConverter.getSystemProperty(key, null);
            if (replacement == null && props != null) {
                replacement = props.getProperty(key);
            }
            if (replacement != null) {
                String recursiveReplacement = OptionConverter.substVars(replacement, props);
                sbuf.append(recursiveReplacement);
            }
            i2 = k2 + DELIM_STOP_LEN;
        }
    }

    public static org.apache.logging.log4j.Level convertLevel(String level, org.apache.logging.log4j.Level defaultLevel) {
        Level l2 = OptionConverter.toLevel(level, null);
        return l2 != null ? OptionConverter.convertLevel(l2) : defaultLevel;
    }

    public static org.apache.logging.log4j.Level convertLevel(Level level) {
        if (level == null) {
            return org.apache.logging.log4j.Level.ERROR;
        }
        if (level.isGreaterOrEqual(Level.FATAL)) {
            return org.apache.logging.log4j.Level.FATAL;
        }
        if (level.isGreaterOrEqual(Level.ERROR)) {
            return org.apache.logging.log4j.Level.ERROR;
        }
        if (level.isGreaterOrEqual(Level.WARN)) {
            return org.apache.logging.log4j.Level.WARN;
        }
        if (level.isGreaterOrEqual(Level.INFO)) {
            return org.apache.logging.log4j.Level.INFO;
        }
        if (level.isGreaterOrEqual(Level.DEBUG)) {
            return org.apache.logging.log4j.Level.DEBUG;
        }
        if (level.isGreaterOrEqual(Level.TRACE)) {
            return org.apache.logging.log4j.Level.TRACE;
        }
        return org.apache.logging.log4j.Level.ALL;
    }

    public static Level convertLevel(org.apache.logging.log4j.Level level) {
        if (level == null) {
            return Level.ERROR;
        }
        switch (level.getStandardLevel()) {
            case FATAL: {
                return Level.FATAL;
            }
            case WARN: {
                return Level.WARN;
            }
            case INFO: {
                return Level.INFO;
            }
            case DEBUG: {
                return Level.DEBUG;
            }
            case TRACE: {
                return Level.TRACE;
            }
            case ALL: {
                return Level.ALL;
            }
            case OFF: {
                return Level.OFF;
            }
        }
        return Level.ERROR;
    }

    public static String findAndSubst(String key, Properties props) {
        String value = props.getProperty(key);
        if (value == null) {
            return null;
        }
        try {
            return OptionConverter.substVars(value, props);
        }
        catch (IllegalArgumentException e2) {
            LOGGER.error("Bad option value [{}].", (Object)value, (Object)e2);
            return value;
        }
    }

    private static class CharMap {
        final char key;
        final char replacement;

        public CharMap(char key, char replacement) {
            this.key = key;
            this.replacement = replacement;
        }
    }
}

