/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util;

import java.util.Collection;
import java.util.Map;

public final class Assert {
    private Assert() {
    }

    public static boolean isEmpty(Object o2) {
        if (o2 == null) {
            return true;
        }
        if (o2 instanceof CharSequence) {
            return ((CharSequence)o2).length() == 0;
        }
        if (o2.getClass().isArray()) {
            return ((Object[])o2).length == 0;
        }
        if (o2 instanceof Collection) {
            return ((Collection)o2).isEmpty();
        }
        if (o2 instanceof Map) {
            return ((Map)o2).isEmpty();
        }
        return false;
    }

    public static boolean isNonEmpty(Object o2) {
        return !Assert.isEmpty(o2);
    }

    public static <T> T requireNonEmpty(T value) {
        return Assert.requireNonEmpty(value, "");
    }

    public static <T> T requireNonEmpty(T value, String message) {
        if (Assert.isEmpty(value)) {
            throw new IllegalArgumentException(message);
        }
        return value;
    }

    public static int valueIsAtLeast(int value, int minValue) {
        if (value < minValue) {
            throw new IllegalArgumentException("Value should be at least " + minValue + " but was " + value);
        }
        return value;
    }
}

