/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.api;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.flywaydb.core.api.FlywayException;

public final class MigrationVersion
implements Comparable<MigrationVersion> {
    public static final MigrationVersion EMPTY = new MigrationVersion(null, "<< Empty Schema >>");
    public static final MigrationVersion LATEST = new MigrationVersion(Long.MAX_VALUE, "<< Latest Version >>");
    private static Pattern splitPattern = Pattern.compile("\\.(?=\\d)");
    private final List<Long> versionParts;
    private final String displayText;

    public static MigrationVersion fromVersion(String version) {
        if (LATEST.getVersion().equals(version)) {
            return LATEST;
        }
        if (version == null) {
            return EMPTY;
        }
        return new MigrationVersion(version);
    }

    private MigrationVersion(String version) {
        String normalizedVersion = version.replace('_', '.');
        this.versionParts = this.tokenizeToLongs(normalizedVersion);
        this.displayText = normalizedVersion;
    }

    private MigrationVersion(Long version, String displayText) {
        this.versionParts = new ArrayList<Long>();
        this.versionParts.add(version);
        this.displayText = displayText;
    }

    public String toString() {
        return this.displayText;
    }

    public String getVersion() {
        if (this.equals(EMPTY)) {
            return null;
        }
        if (this.equals(LATEST)) {
            return Long.toString(Long.MAX_VALUE);
        }
        return this.displayText;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        MigrationVersion version1 = (MigrationVersion)o2;
        return this.compareTo(version1) == 0;
    }

    public int hashCode() {
        return this.versionParts == null ? 0 : this.versionParts.hashCode();
    }

    @Override
    public int compareTo(MigrationVersion o2) {
        if (o2 == null) {
            return 1;
        }
        if (this == EMPTY) {
            return o2 == EMPTY ? 0 : Integer.MIN_VALUE;
        }
        if (this == LATEST) {
            return o2 == LATEST ? 0 : Integer.MAX_VALUE;
        }
        if (o2 == EMPTY) {
            return Integer.MAX_VALUE;
        }
        if (o2 == LATEST) {
            return Integer.MIN_VALUE;
        }
        List<Long> elements1 = this.versionParts;
        List<Long> elements2 = o2.versionParts;
        int largestNumberOfElements = Math.max(elements1.size(), elements2.size());
        for (int i2 = 0; i2 < largestNumberOfElements; ++i2) {
            int compared = this.getOrZero(elements1, i2).compareTo(this.getOrZero(elements2, i2));
            if (compared == 0) continue;
            return compared;
        }
        return 0;
    }

    private Long getOrZero(List<Long> elements, int i2) {
        return i2 < elements.size() ? elements.get(i2) : 0L;
    }

    private List<Long> tokenizeToLongs(String str) {
        ArrayList<Long> numbers = new ArrayList<Long>();
        for (String number : splitPattern.split(str)) {
            try {
                numbers.add(Long.valueOf(number));
            }
            catch (NumberFormatException e2) {
                throw new FlywayException("Invalid version containing non-numeric characters. Only 0..9 and . are allowed. Invalid version: " + str);
            }
        }
        for (int i2 = numbers.size() - 1; i2 > 0 && (Long)numbers.get(i2) == 0L; --i2) {
            numbers.remove(i2);
        }
        return numbers;
    }
}

