/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.dbsupport.redshift;

import java.sql.Connection;
import java.sql.SQLException;
import org.flywaydb.core.internal.dbsupport.Schema;
import org.flywaydb.core.internal.dbsupport.postgresql.PostgreSQLDbSupport;
import org.flywaydb.core.internal.dbsupport.redshift.RedshiftSchema;
import org.flywaydb.core.internal.util.StringUtils;
import org.flywaydb.core.internal.util.logging.Log;
import org.flywaydb.core.internal.util.logging.LogFactory;

public class RedshiftDbSupport
extends PostgreSQLDbSupport {
    private static final Log LOG = LogFactory.getLog(RedshiftDbSupport.class);

    public RedshiftDbSupport(Connection connection) {
        super(connection);
    }

    @Override
    public String getDbName() {
        return "redshift";
    }

    @Override
    protected void doSetCurrentSchema(Schema schema) throws SQLException {
        if (schema == null) {
            this.jdbcTemplate.execute("SELECT set_config('search_path', '', false)", new Object[0]);
            return;
        }
        String searchPath = this.jdbcTemplate.queryForString("SHOW search_path", new String[0]);
        if (StringUtils.hasText(searchPath) && !searchPath.equals("unset")) {
            if (searchPath.contains("$user") && !searchPath.contains(this.doQuote("$user"))) {
                searchPath = searchPath.replace("$user", this.doQuote("$user"));
            }
            this.jdbcTemplate.execute("SET search_path = " + schema + "," + searchPath, new Object[0]);
        } else {
            this.jdbcTemplate.execute("SET search_path = " + schema, new Object[0]);
        }
    }

    @Override
    public Schema getSchema(String name) {
        return new RedshiftSchema(this.jdbcTemplate, this, name);
    }

    public boolean detect() {
        try {
            return this.jdbcTemplate.queryForInt("select count(*) from information_schema.tables where table_schema = 'pg_catalog' and table_name = 'stl_s3client'", new String[0]) > 0;
        }
        catch (SQLException e2) {
            LOG.error("Unable to check whether this is a Redshift database", e2);
            return false;
        }
    }
}

