/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.dc.subaward.tmplattach;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.kuali.coeus.dc.common.db.ConnectionDaoService;
import org.kuali.coeus.dc.common.db.PreparedStatementUtils;
import org.kuali.coeus.dc.common.rice.parameter.Parameter;
import org.kuali.coeus.dc.common.rice.parameter.ParameterDao;
import org.kuali.coeus.dc.common.rice.parameter.ParameterKey;
import org.kuali.coeus.dc.subaward.tmplattach.SubawardTemplateAttachmentDao;

public class SubawardTemplateAttachmentDaoImpl
implements SubawardTemplateAttachmentDao {
    private static final Logger LOG = Logger.getLogger(SubawardTemplateAttachmentDaoImpl.class.getName());
    private static final String SELECT_COUNT_ATTACHMENT_TYPE = "SELECT COUNT(*) FROM subaward_attachment_type WHERE ATTACHMENT_TYPE_CODE = ?";
    private static final String INSERT_SELECT_ATTACHMENT_TYPES = "INSERT INTO subaward_tmpl_attach_type (ATTACHMENT_TYPE_CODE, DESCRIPTION, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID) SELECT ATTACHMENT_TYPE_CODE, DESCRIPTION, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID FROM subaward_attachment_type where ATTACHMENT_TYPE_CODE in ";
    private static final String DELETE_ATTACHMENT_TYPES = "DELETE FROM subaward_attachment_type where ATTACHMENT_TYPE_CODE in ";
    private static final String INSERT_SELECT_TEMPLATE_ATTACHMENTS = "INSERT INTO subaward_template_attachments (ATTACHMENT_ID, SUBAWARD_ID, SUBAWARD_CODE, SEQUENCE_NUMBER, ATTACHMENT_TYPE_CODE, DOCUMENT_ID, FILE_NAME, DESCRIPTION, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID, DOCUMENT_STATUS_CODE, LAST_UPDATE_USER, LAST_UPDATE_TIMESTAMP, FILE_DATA_ID, MIME_TYPE) SELECT ATTACHMENT_ID, SUBAWARD_ID, SUBAWARD_CODE, SEQUENCE_NUMBER, ATTACHMENT_TYPE_CODE, DOCUMENT_ID, FILE_NAME, DESCRIPTION, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID, DOCUMENT_STATUS_CODE, LAST_UPDATE_USER, LAST_UPDATE_TIMESTAMP, FILE_DATA_ID, MIME_TYPE FROM subaward_attachments where ATTACHMENT_TYPE_CODE in ";
    private static final String DELETE_TEMPLATE_ATTACHMENTS = "DELETE FROM subaward_attachments where ATTACHMENT_TYPE_CODE in ";
    private ConnectionDaoService connectionDaoService;
    private ParameterDao parameterDao;

    @Override
    public void moveSubawardTemplateAttachments() {
        Parameter parameter = this.parameterDao.getParameter(new ParameterKey("KC-SUBAWARD", "Document", "Subaward_Print_Attachment_Type_Inclusion", "KC"));
        List<String> types = Arrays.stream(parameter.getValue().split(",")).filter(v2 -> !Objects.isNull(v2)).map(String::trim).filter(v2 -> !v2.equals("")).distinct().filter(this::typeExists).collect(Collectors.toList());
        if (!types.isEmpty()) {
            this.copyAttachmentTypes(types);
            this.copyTemplateAttachments(types);
            this.deleteTemplateAttachments(types);
            this.deleteAttachmentTypes(types);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean typeExists(String type) {
        LOG.info(SELECT_COUNT_ATTACHMENT_TYPE);
        try (PreparedStatement statement = PreparedStatementUtils.setString(1, type, this.getConnectionDaoService().getCoeusConnection().prepareStatement(SELECT_COUNT_ATTACHMENT_TYPE));){
            boolean bl;
            block14: {
                ResultSet result = statement.executeQuery();
                try {
                    result.next();
                    boolean bl2 = bl = result.getInt(1) > 0;
                    if (result == null) break block14;
                }
                catch (Throwable throwable) {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                result.close();
            }
            return bl;
        }
        catch (SQLException e2) {
            throw new RuntimeException(e2);
        }
    }

    private String createInCriteria(List<String> types) {
        return "(" + types.stream().map(type -> "?").collect(Collectors.joining(",")) + ")";
    }

    private void copyAttachmentTypes(List<String> types) {
        String insertStatement = INSERT_SELECT_ATTACHMENT_TYPES + this.createInCriteria(types);
        LOG.info(insertStatement);
        try (PreparedStatement statement = PreparedStatementUtils.setStrings(types, this.getConnectionDaoService().getCoeusConnection().prepareStatement(insertStatement));){
            statement.executeUpdate();
        }
        catch (SQLException e2) {
            throw new RuntimeException(e2);
        }
    }

    private void copyTemplateAttachments(List<String> types) {
        String insertStatement = INSERT_SELECT_TEMPLATE_ATTACHMENTS + this.createInCriteria(types);
        LOG.info(insertStatement);
        try (PreparedStatement statement = PreparedStatementUtils.setStrings(types, this.getConnectionDaoService().getCoeusConnection().prepareStatement(insertStatement));){
            statement.executeUpdate();
        }
        catch (SQLException e2) {
            throw new RuntimeException(e2);
        }
    }

    private void deleteTemplateAttachments(List<String> types) {
        String deleteStatement = DELETE_TEMPLATE_ATTACHMENTS + this.createInCriteria(types);
        LOG.info(deleteStatement);
        try (PreparedStatement statement = PreparedStatementUtils.setStrings(types, this.getConnectionDaoService().getCoeusConnection().prepareStatement(deleteStatement));){
            statement.executeUpdate();
        }
        catch (SQLException e2) {
            throw new RuntimeException(e2);
        }
    }

    private void deleteAttachmentTypes(List<String> types) {
        String deleteStatement = DELETE_ATTACHMENT_TYPES + this.createInCriteria(types);
        LOG.info(deleteStatement);
        try (PreparedStatement statement = PreparedStatementUtils.setStrings(types, this.getConnectionDaoService().getCoeusConnection().prepareStatement(deleteStatement));){
            statement.executeUpdate();
        }
        catch (SQLException e2) {
            throw new RuntimeException(e2);
        }
    }

    public ConnectionDaoService getConnectionDaoService() {
        return this.connectionDaoService;
    }

    public void setConnectionDaoService(ConnectionDaoService connectionDaoService) {
        this.connectionDaoService = connectionDaoService;
    }

    public ParameterDao getParameterDao() {
        return this.parameterDao;
    }

    public void setParameterDao(ParameterDao parameterDao) {
        this.parameterDao = parameterDao;
    }
}

