/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.admin;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;
import javax.management.Descriptor;
import javax.management.MBeanException;
import javax.management.MBeanParameterInfo;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.DescriptorSupport;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.ucp.UniversalConnectionPool;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.admin.UniversalConnectionPoolMBeanBase;
import oracle.ucp.jdbc.JDBCConnectionPool;
import oracle.ucp.jdbc.oracle.OracleJDBCConnectionPool;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.Util;

@DefaultLogger(value="oracle.ucp.admin")
@Supports(value={Feature.ADMIN})
public class JDBCUniversalConnectionPoolMBeanImpl
extends UniversalConnectionPoolMBeanBase {
    private JDBCConnectionPool jdbcConnectionPool = null;
    private OracleJDBCConnectionPool oracleJdbcConnectionPool = null;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;

    public JDBCUniversalConnectionPoolMBeanImpl(UniversalConnectionPool connectionPool) throws UniversalConnectionPoolException {
        super(connectionPool);
        if (connectionPool instanceof JDBCConnectionPool) {
            this.jdbcConnectionPool = (JDBCConnectionPool)connectionPool;
            if (connectionPool instanceof OracleJDBCConnectionPool) {
                this.oracleJdbcConnectionPool = (OracleJDBCConnectionPool)connectionPool;
            }
        } else {
            UCPErrorHandler.throwUniversalConnectionPoolException(365);
        }
    }

    public void setSQLForValidateConnection(String SQLString) throws SQLException {
        if (SQLString == null) {
            throw UCPErrorHandler.newSQLException(46);
        }
        this.jdbcConnectionPool.setSQLForValidateConnection(SQLString);
    }

    public String getSQLForValidateConnection() {
        return this.jdbcConnectionPool.getSQLForValidateConnection();
    }

    public void setMaxStatements(int maxStatements) throws SQLException {
        this.jdbcConnectionPool.setMaxStatements(maxStatements);
    }

    public int getMaxStatements() {
        return this.jdbcConnectionPool.getMaxStatements();
    }

    public void setMaxIdleTime(int idleTime) throws UniversalConnectionPoolException {
        this.setInactiveConnectionTimeout(idleTime);
    }

    public int getMaxIdleTime() {
        return this.getInactiveConnectionTimeout();
    }

    public void setPropertyCycle(int propertyCycle) throws UniversalConnectionPoolException {
        this.setTimeoutCheckInterval(propertyCycle);
    }

    public int getPropertyCycle() {
        return this.getTimeoutCheckInterval();
    }

    public void setFastConnectionFailoverEnabled(boolean failoverEnabled) throws UniversalConnectionPoolException {
        this.jdbcConnectionPool.setFailoverEnabled(failoverEnabled);
    }

    public boolean getFastConnectionFailoverEnabled() {
        return this.jdbcConnectionPool.isFailoverEnabled();
    }

    public void setONSConfiguration(String onsConfigStr) throws UniversalConnectionPoolException {
        ClioSupport.ilogFinest(null, null, null, null, "onsConfigStr: " + Util.maskONSConfigurationString(onsConfigStr));
        if (this.oracleJdbcConnectionPool != null) {
            this.oracleJdbcConnectionPool.setONSConfiguration(onsConfigStr);
        } else {
            UCPErrorHandler.throwUniversalConnectionPoolException(378);
        }
    }

    public String getONSConfiguration() throws UniversalConnectionPoolException {
        String onsConfigString = null;
        if (this.oracleJdbcConnectionPool != null) {
            onsConfigString = this.oracleJdbcConnectionPool.getONSConfiguration();
        } else {
            UCPErrorHandler.throwUniversalConnectionPoolException(378);
        }
        return onsConfigString;
    }

    public int getMaxConnectionsPerService() throws UniversalConnectionPoolException {
        int maxPerService = Integer.MAX_VALUE;
        if (this.oracleJdbcConnectionPool != null) {
            maxPerService = this.oracleJdbcConnectionPool.getMaxConnectionsPerService();
        } else {
            UCPErrorHandler.throwUniversalConnectionPoolException(378);
        }
        return maxPerService;
    }

    public void setMaxConnectionsPerService(int maxConnectionsPerService) throws UniversalConnectionPoolException {
        if (this.oracleJdbcConnectionPool != null) {
            this.oracleJdbcConnectionPool.setMaxConnectionsPerService(maxConnectionsPerService);
        } else {
            UCPErrorHandler.throwUniversalConnectionPoolException(378);
        }
    }

    @Override
    public ModelMBeanInfo getMBeanInfo(ObjectName mbeanObjName, String mbeanDisplayName) throws UniversalConnectionPoolException {
        ClioSupport.ilogFinest(null, null, null, null, "constructing MBeanInfo");
        if (mbeanObjName == null) {
            throw UCPErrorHandler.newUniversalConnectionPoolException(381);
        }
        if (mbeanDisplayName == null) {
            throw UCPErrorHandler.newUniversalConnectionPoolException(382);
        }
        ModelMBeanInfoSupport jdbcPoolMBeanInfo = null;
        try {
            String descriptorType = "mbean";
            String mbeanName = "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl";
            String mbeanDescription = "JDBCUniversalConnectionPoolMBeanImpl Object";
            DescriptorSupport modelMBeanDescriptor = new DescriptorSupport("name=" + mbeanObjName, "descriptorType=" + descriptorType, "displayName=" + mbeanDisplayName);
            jdbcPoolMBeanInfo = new ModelMBeanInfoSupport(mbeanName, mbeanDescription, this.getJDBCPoolAttributesInfo(), JDBCUniversalConnectionPoolMBeanImpl.getConstructorsInfo(), this.getJDBCPoolOperationsInfo(), JDBCUniversalConnectionPoolMBeanImpl.getNotificationsInfo());
            jdbcPoolMBeanInfo.setMBeanDescriptor(modelMBeanDescriptor);
        }
        catch (RuntimeOperationsException e2) {
            UCPErrorHandler.throwUniversalConnectionPoolException(367, e2);
        }
        catch (MBeanException e3) {
            UCPErrorHandler.throwUniversalConnectionPoolException(366, e3);
        }
        return jdbcPoolMBeanInfo;
    }

    private static ModelMBeanConstructorInfo[] getConstructorsInfo() throws UniversalConnectionPoolException {
        ModelMBeanConstructorInfo[] jdbcPoolConstructorsInfo = new ModelMBeanConstructorInfo[1];
        ClioSupport.ilogFinest(null, null, null, null, "constructing ConstructorsInfo");
        try {
            Class<JDBCUniversalConnectionPoolMBeanImpl> mBeanClass = JDBCUniversalConnectionPoolMBeanImpl.class;
            Constructor<?>[] constructors = mBeanClass.getConstructors();
            DescriptorSupport jdbcPoolConstructor = new DescriptorSupport();
            jdbcPoolConstructor.setField("name", "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl");
            jdbcPoolConstructor.setField("descriptorType", "operation");
            jdbcPoolConstructor.setField("role", "constructor");
            jdbcPoolConstructorsInfo[0] = new ModelMBeanConstructorInfo(UCPErrorHandler.findMessage("JDBCMBeanConstructorDescription"), constructors[0], (Descriptor)jdbcPoolConstructor);
        }
        catch (RuntimeOperationsException ex) {
            UCPErrorHandler.throwUniversalConnectionPoolException(368, ex);
        }
        return jdbcPoolConstructorsInfo;
    }

    private ModelMBeanAttributeInfo[] getJDBCPoolAttributesInfo() throws UniversalConnectionPoolException {
        ArrayList<ModelMBeanAttributeInfo> attributes = new ArrayList<ModelMBeanAttributeInfo>();
        ClioSupport.ilogFinest(null, null, null, null, "constructing AttributesInfo");
        try {
            attributes.addAll(Arrays.asList(this.getUCPMBeanAttributes()));
            DescriptorSupport desc = new DescriptorSupport();
            desc.setField("name", "SQLForValidateConnection");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("SQLForValidateConnectionAttrDisplayName"));
            desc.setField("getMethod", "getSQLForValidateConnection");
            desc.setField("setMethod", "setSQLForValidateConnection");
            attributes.add(new ModelMBeanAttributeInfo("SQLForValidateConnection", "java.lang.String", UCPErrorHandler.findMessage("SQLForValidateConnectionAttrDescription"), true, true, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "maxStatements");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("MaxStatementsAttrDisplayName"));
            desc.setField("getMethod", "getMaxStatements");
            desc.setField("setMethod", "setMaxStatements");
            attributes.add(new ModelMBeanAttributeInfo("maxStatements", "int", UCPErrorHandler.findMessage("MaxStatementsAttrDescription"), true, true, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "maxIdleTime");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("MaxIdleTimeAttrDisplayName"));
            desc.setField("getMethod", "getMaxIdleTime");
            desc.setField("setMethod", "setMaxIdleTime");
            attributes.add(new ModelMBeanAttributeInfo("maxIdleTime", "int", UCPErrorHandler.findMessage("MaxIdleTimeAttrDescription"), true, true, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "propertyCycle");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("PropertyCycleAttrDisplayName"));
            desc.setField("getMethod", "getPropertyCycle");
            desc.setField("setMethod", "setPropertyCycle");
            attributes.add(new ModelMBeanAttributeInfo("propertyCycle", "int", UCPErrorHandler.findMessage("PropertyCycleAttrDescription"), true, true, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "failoverEnabled");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("FailoverEnabledAttrDisplayName"));
            desc.setField("getMethod", "getFastConnectionFailoverEnabled");
            desc.setField("setMethod", "setFastConnectionFailoverEnabled");
            attributes.add(new ModelMBeanAttributeInfo("failoverEnabled", "boolean", UCPErrorHandler.findMessage("FailoverEnabledAttrDescription"), true, true, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "onsConfiguration");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("ONSConfigurationAttrDisplayName"));
            desc.setField("getMethod", "getONSConfiguration");
            desc.setField("setMethod", "setONSConfiguration");
            attributes.add(new ModelMBeanAttributeInfo("onsConfiguration", "java.lang.String", UCPErrorHandler.findMessage("ONSConfigurationAttrDescription"), true, true, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "maxConnectionsPerService");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("MaxConnectionsPerServiceAttrDisplayName"));
            desc.setField("getMethod", "getMaxConnectionsPerService");
            desc.setField("setMethod", "setMaxConnectionsPerService");
            attributes.add(new ModelMBeanAttributeInfo("maxConnectionsPerService", "int", UCPErrorHandler.findMessage("MaxConnectionsPerServiceAttrDescription"), true, true, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "successfulAffinityBasedBorrowCount");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("SuccessfulAffinityBasedBorrowCountAttrDisplayName"));
            desc.setField("getMethod", "getSuccessfulAffinityBasedBorrowCount");
            attributes.add(new ModelMBeanAttributeInfo("successfulAffinityBasedBorrowCount", "long", UCPErrorHandler.findMessage("SuccessfulAffinityBasedBorrowCountAttrDescription"), true, false, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "failedAffinityBasedBorrowCount");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("FailedAffinityBasedBorrowCountAttrDisplayName"));
            desc.setField("getMethod", "getFailedAffinityBasedBorrowCount");
            attributes.add(new ModelMBeanAttributeInfo("failedAffinityBasedBorrowCount", "long", UCPErrorHandler.findMessage("FailedAffinityBasedBorrowCountAttrDescription"), true, false, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "successfulRCLBBasedBorrowCount");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("SuccessfulRCLBBasedBorrowCountAttrDisplayName"));
            desc.setField("getMethod", "getSuccessfulRCLBBasedBorrowCount");
            attributes.add(new ModelMBeanAttributeInfo("successfulRCLBBasedBorrowCount", "long", UCPErrorHandler.findMessage("SuccessfulRCLBBasedBorrowCountAttrDescription"), true, false, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "failedRCLBBasedBorrowCount");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("FailedRCLBBasedBorrowCountAttrDisplayName"));
            desc.setField("getMethod", "getFailedRCLBBasedBorrowCount");
            attributes.add(new ModelMBeanAttributeInfo("failedRCLBBasedBorrowCount", "long", UCPErrorHandler.findMessage("FailedRCLBBasedBorrowCountAttrDescription"), true, false, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "fcfProcessingInfo");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("FcfProcessingInfoAttrDisplayName"));
            desc.setField("getMethod", "getFcfProcessingInfo");
            attributes.add(new ModelMBeanAttributeInfo("fcfProcessingInfo", "java.lang.String", UCPErrorHandler.findMessage("FcfProcessingInfoAttrDescription"), true, false, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "fcfProcessingInfoProcessedOnly");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("FcfProcessingInfoProcessedOnlyAttrDisplayName"));
            desc.setField("getMethod", "getFcfProcessingInfoProcessedOnly");
            attributes.add(new ModelMBeanAttributeInfo("fcfProcessingInfoProcessedOnly", "java.lang.String", UCPErrorHandler.findMessage("FcfProcessingInfoProcessedOnlyAttrDescription"), true, false, false, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "connectionRepurposeCount");
            desc.setField("descriptorType", "attribute");
            desc.setField("displayName", UCPErrorHandler.findMessage("ConnectionRepurposeCountAttrDisplayName"));
            desc.setField("getMethod", "getConnectionRepurposeCount");
            attributes.add(new ModelMBeanAttributeInfo("connectionRepurposeCount", "long", UCPErrorHandler.findMessage("ConnectionRepurposeCountAttrDescription"), true, false, false, desc));
        }
        catch (RuntimeOperationsException e2) {
            UCPErrorHandler.throwUniversalConnectionPoolException(369, e2);
        }
        return attributes.toArray(new ModelMBeanAttributeInfo[0]);
    }

    private ModelMBeanOperationInfo[] getJDBCPoolOperationsInfo() throws UniversalConnectionPoolException {
        ArrayList<ModelMBeanOperationInfo> operations = new ArrayList<ModelMBeanOperationInfo>();
        ClioSupport.ilogFinest(null, null, null, null, "constructing OperationsInfo");
        try {
            operations.addAll(Arrays.asList(this.getUCPMBeanOperations()));
            String mBeanName = "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl";
            DescriptorSupport desc = new DescriptorSupport();
            desc.setField("name", "getSQLForValidateConnection");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl");
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getSQLForValidateConnection", UCPErrorHandler.findMessage("GetSQLForValidateConnectionOperationDescription"), null, "String", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "setSQLForValidateConnection");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl");
            desc.setField("role", "setter");
            String sDesc = UCPErrorHandler.findMessage("SetSQLForValidateConnectionOperationDescription");
            MBeanParameterInfo[] params = new MBeanParameterInfo[]{new MBeanParameterInfo("SQLForValidateConnection", "java.lang.String", sDesc)};
            operations.add(new ModelMBeanOperationInfo("setSQLForValidateConnection", sDesc, params, "void", 1, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getMaxStatements");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl");
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getMaxStatements", UCPErrorHandler.findMessage("GetMaxStatementsOperationDescription"), null, "int", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "setMaxStatements");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl");
            desc.setField("role", "setter");
            sDesc = UCPErrorHandler.findMessage("SetMaxStatementsOperationDescription");
            params = new MBeanParameterInfo[]{new MBeanParameterInfo("maxStatements", "java.lang.Integer", sDesc)};
            operations.add(new ModelMBeanOperationInfo("setMaxStatements", sDesc, params, "void", 1, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getMaxIdleTime");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl");
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getMaxIdleTime", UCPErrorHandler.findMessage("GetMaxIdleTimeOperationDescription"), null, "int", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "setMaxIdleTime");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl");
            desc.setField("role", "setter");
            sDesc = UCPErrorHandler.findMessage("SetMaxIdleTimeOperationDescription");
            params = new MBeanParameterInfo[]{new MBeanParameterInfo("maxIdleTime", "java.lang.Integer", sDesc)};
            operations.add(new ModelMBeanOperationInfo("setMaxIdleTime", sDesc, params, "void", 1, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getPropertyCycle");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl");
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getPropertyCycle", UCPErrorHandler.findMessage("GetPropertyCycleOperationDescription"), null, "int", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "setPropertyCycle");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl");
            desc.setField("role", "setter");
            sDesc = UCPErrorHandler.findMessage("SetPropertyCycleOperationDescription");
            params = new MBeanParameterInfo[]{new MBeanParameterInfo("propertyCycle", "java.lang.Integer", sDesc)};
            operations.add(new ModelMBeanOperationInfo("setPropertyCycle", sDesc, params, "void", 1, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getFastConnectionFailoverEnabled");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl");
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getFastConnectionFailoverEnabled", UCPErrorHandler.findMessage("GetFastConnectionFailoverEnabledOperationDescription"), null, "boolean", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "setFastConnectionFailoverEnabled");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl");
            desc.setField("role", "setter");
            sDesc = UCPErrorHandler.findMessage("SetFastConnectionFailoverEnabledOperationDescription");
            params = new MBeanParameterInfo[]{new MBeanParameterInfo("failoverEnabled", "java.lang.Boolean", sDesc)};
            operations.add(new ModelMBeanOperationInfo("setFastConnectionFailoverEnabled", sDesc, params, "void", 1, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getONSConfiguration");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl");
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getONSConfiguration", UCPErrorHandler.findMessage("GetONSConfigurationOperationDescription"), null, "String", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "setONSConfiguration");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl");
            desc.setField("role", "setter");
            sDesc = UCPErrorHandler.findMessage("SetONSConfigurationOperationDescription");
            params = new MBeanParameterInfo[]{new MBeanParameterInfo("onsConfiguration", "java.lang.String", sDesc)};
            operations.add(new ModelMBeanOperationInfo("setONSConfiguration", sDesc, params, "void", 1, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getMaxConnectionsPerService");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl");
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getMaxConnectionsPerService", UCPErrorHandler.findMessage("GetMaxConnectionsPerServiceOperationDescription"), null, "int", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "setMaxConnectionsPerService");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl");
            desc.setField("role", "setter");
            sDesc = UCPErrorHandler.findMessage("SetMaxConnectionsPerServiceOperationDescription");
            params = new MBeanParameterInfo[]{new MBeanParameterInfo("maxConnectionsPerService", "java.lang.Integer", sDesc)};
            operations.add(new ModelMBeanOperationInfo("setMaxConnectionsPerService", sDesc, params, "void", 1, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getSuccessfulAffinityBasedBorrowCount");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl");
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getSuccessfulAffinityBasedBorrowCount", UCPErrorHandler.findMessage("GetSuccessfulAffinityBasedBorrowCountOperationDescription"), null, "long", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getFailedAffinityBasedBorrowCount");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl");
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getFailedAffinityBasedBorrowCount", UCPErrorHandler.findMessage("GetFailedAffinityBasedBorrowCountOperationDescription"), null, "long", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getSuccessfulRCLBBasedBorrowCount");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl");
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getSuccessfulRCLBBasedBorrowCount", UCPErrorHandler.findMessage("GetSuccessfulRCLBBasedBorrowCountOperationDescription"), null, "long", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getFailedRCLBBasedBorrowCount");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl");
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getFailedRCLBBasedBorrowCount", UCPErrorHandler.findMessage("GetFailedRCLBBasedBorrowCountOperationDescription"), null, "long", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getFcfProcessingInfo");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl");
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getFcfProcessingInfo", UCPErrorHandler.findMessage("GetFcfProcessingInfoOperationDescription"), null, "java.lang.String", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getFcfProcessingInfoProcessedOnly");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl");
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getFcfProcessingInfoProcessedOnly", UCPErrorHandler.findMessage("GetFcfProcessingInfoProcessedOnlyOperationDescription"), null, "java.lang.String", 0, desc));
            desc = new DescriptorSupport();
            desc.setField("name", "getConnectionRepurposeCount");
            desc.setField("descriptorType", "operation");
            desc.setField("class", "oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl");
            desc.setField("role", "getter");
            operations.add(new ModelMBeanOperationInfo("getConnectionRepurposeCount", UCPErrorHandler.findMessage("GetConnectionRepurposeCountOperationDescription"), null, "long", 0, desc));
        }
        catch (RuntimeOperationsException e2) {
            UCPErrorHandler.throwUniversalConnectionPoolException(370, e2);
        }
        return operations.toArray(new ModelMBeanOperationInfo[0]);
    }

    private static ModelMBeanNotificationInfo[] getNotificationsInfo() {
        ModelMBeanNotificationInfo[] JDBCPoolNotificationInfo = new ModelMBeanNotificationInfo[]{};
        return JDBCPoolNotificationInfo;
    }

    @Override
    public void useStrictWebSessionAffinity(boolean strict) {
        this.oracleJdbcConnectionPool.useStrictWebSessionAffinity(strict);
    }

    @Override
    public void useStrictXAAffinity(boolean strict) {
        this.oracleJdbcConnectionPool.useStrictXAAffinity(strict);
    }

    @Override
    public long getSuccessfulAffinityBasedBorrowCount() {
        return this.oracleJdbcConnectionPool.getStatistics().getSuccessfulAffinityBasedBorrowCount();
    }

    @Override
    public long getFailedAffinityBasedBorrowCount() {
        return this.oracleJdbcConnectionPool.getStatistics().getFailedAffinityBasedBorrowCount();
    }

    @Override
    public long getSuccessfulRCLBBasedBorrowCount() {
        return this.oracleJdbcConnectionPool.getStatistics().getSuccessfulRCLBBasedBorrowCount();
    }

    @Override
    public long getFailedRCLBBasedBorrowCount() {
        return this.oracleJdbcConnectionPool.getStatistics().getFailedRCLBBasedBorrowCount();
    }

    @Override
    public String getFcfProcessingInfo() {
        return this.oracleJdbcConnectionPool.getStatistics().getFCFProcessingInfo();
    }

    @Override
    public String getFcfProcessingInfoProcessedOnly() {
        return this.oracleJdbcConnectionPool.getStatistics().getFCFProcessingInfoProcessedOnly();
    }

    @Override
    public long getConnectionRepurposeCount() {
        return this.oracleJdbcConnectionPool.getStatistics().getConnectionRepurposeCount();
    }

    static {
        try {
            $$$methodRef$$$28 = JDBCUniversalConnectionPoolMBeanImpl.class.getDeclaredConstructor(UniversalConnectionPool.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$27 = JDBCUniversalConnectionPoolMBeanImpl.class.getDeclaredMethod("getConnectionRepurposeCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$26 = JDBCUniversalConnectionPoolMBeanImpl.class.getDeclaredMethod("getFcfProcessingInfoProcessedOnly", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$25 = JDBCUniversalConnectionPoolMBeanImpl.class.getDeclaredMethod("getFcfProcessingInfo", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$24 = JDBCUniversalConnectionPoolMBeanImpl.class.getDeclaredMethod("getFailedRCLBBasedBorrowCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$23 = JDBCUniversalConnectionPoolMBeanImpl.class.getDeclaredMethod("getSuccessfulRCLBBasedBorrowCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$22 = JDBCUniversalConnectionPoolMBeanImpl.class.getDeclaredMethod("getFailedAffinityBasedBorrowCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$21 = JDBCUniversalConnectionPoolMBeanImpl.class.getDeclaredMethod("getSuccessfulAffinityBasedBorrowCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$20 = JDBCUniversalConnectionPoolMBeanImpl.class.getDeclaredMethod("useStrictXAAffinity", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$19 = JDBCUniversalConnectionPoolMBeanImpl.class.getDeclaredMethod("useStrictWebSessionAffinity", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$18 = JDBCUniversalConnectionPoolMBeanImpl.class.getDeclaredMethod("getNotificationsInfo", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$17 = JDBCUniversalConnectionPoolMBeanImpl.class.getDeclaredMethod("getJDBCPoolOperationsInfo", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$16 = JDBCUniversalConnectionPoolMBeanImpl.class.getDeclaredMethod("getJDBCPoolAttributesInfo", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$15 = JDBCUniversalConnectionPoolMBeanImpl.class.getDeclaredMethod("getConstructorsInfo", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$14 = JDBCUniversalConnectionPoolMBeanImpl.class.getDeclaredMethod("getMBeanInfo", ObjectName.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$13 = JDBCUniversalConnectionPoolMBeanImpl.class.getDeclaredMethod("setMaxConnectionsPerService", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$12 = JDBCUniversalConnectionPoolMBeanImpl.class.getDeclaredMethod("getMaxConnectionsPerService", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$11 = JDBCUniversalConnectionPoolMBeanImpl.class.getDeclaredMethod("getONSConfiguration", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$10 = JDBCUniversalConnectionPoolMBeanImpl.class.getDeclaredMethod("setONSConfiguration", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$9 = JDBCUniversalConnectionPoolMBeanImpl.class.getDeclaredMethod("getFastConnectionFailoverEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$8 = JDBCUniversalConnectionPoolMBeanImpl.class.getDeclaredMethod("setFastConnectionFailoverEnabled", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$7 = JDBCUniversalConnectionPoolMBeanImpl.class.getDeclaredMethod("getPropertyCycle", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$6 = JDBCUniversalConnectionPoolMBeanImpl.class.getDeclaredMethod("setPropertyCycle", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$5 = JDBCUniversalConnectionPoolMBeanImpl.class.getDeclaredMethod("getMaxIdleTime", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$4 = JDBCUniversalConnectionPoolMBeanImpl.class.getDeclaredMethod("setMaxIdleTime", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$3 = JDBCUniversalConnectionPoolMBeanImpl.class.getDeclaredMethod("getMaxStatements", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$2 = JDBCUniversalConnectionPoolMBeanImpl.class.getDeclaredMethod("setMaxStatements", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$1 = JDBCUniversalConnectionPoolMBeanImpl.class.getDeclaredMethod("getSQLForValidateConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$0 = JDBCUniversalConnectionPoolMBeanImpl.class.getDeclaredMethod("setSQLForValidateConnection", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
    }
}

