/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.transform.impl;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.springframework.asm.Type;
import org.springframework.cglib.core.CodeEmitter;
import org.springframework.cglib.core.CodeGenerationException;
import org.springframework.cglib.core.ReflectUtils;
import org.springframework.cglib.core.Signature;
import org.springframework.cglib.core.TypeUtils;
import org.springframework.cglib.transform.ClassEmitterTransformer;

public class AddDelegateTransformer
extends ClassEmitterTransformer {
    private static final String DELEGATE = "$CGLIB_DELEGATE";
    private static final Signature CSTRUCT_OBJECT = TypeUtils.parseSignature("void <init>(Object)");
    private Class[] delegateIf;
    private Class delegateImpl;
    private Type delegateType;

    public AddDelegateTransformer(Class[] delegateIf, Class delegateImpl) {
        try {
            delegateImpl.getConstructor(Object.class);
            this.delegateIf = delegateIf;
            this.delegateImpl = delegateImpl;
            this.delegateType = Type.getType(delegateImpl);
        }
        catch (NoSuchMethodException e2) {
            throw new CodeGenerationException(e2);
        }
    }

    public void begin_class(int version, int access, String className, Type superType, Type[] interfaces, String sourceFile) {
        if (!TypeUtils.isInterface(access)) {
            Type[] all = TypeUtils.add(interfaces, TypeUtils.getTypes(this.delegateIf));
            super.begin_class(version, access, className, superType, all, sourceFile);
            this.declare_field(130, DELEGATE, this.delegateType, null);
            for (int i2 = 0; i2 < this.delegateIf.length; ++i2) {
                Method[] methods = this.delegateIf[i2].getMethods();
                for (int j2 = 0; j2 < methods.length; ++j2) {
                    if (!Modifier.isAbstract(methods[j2].getModifiers())) continue;
                    this.addDelegate(methods[j2]);
                }
            }
        } else {
            super.begin_class(version, access, className, superType, interfaces, sourceFile);
        }
    }

    public CodeEmitter begin_method(int access, Signature sig, Type[] exceptions) {
        CodeEmitter e2 = super.begin_method(access, sig, exceptions);
        if (sig.getName().equals("<init>")) {
            return new CodeEmitter(e2){
                private boolean transformInit;
                {
                    this.transformInit = true;
                }

                public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                    super.visitMethodInsn(opcode, owner, name, desc, itf);
                    if (this.transformInit && opcode == 183) {
                        this.load_this();
                        this.new_instance(AddDelegateTransformer.this.delegateType);
                        this.dup();
                        this.load_this();
                        this.invoke_constructor(AddDelegateTransformer.this.delegateType, CSTRUCT_OBJECT);
                        this.putfield(AddDelegateTransformer.DELEGATE);
                        this.transformInit = false;
                    }
                }
            };
        }
        return e2;
    }

    private void addDelegate(Method m2) {
        try {
            Method delegate = this.delegateImpl.getMethod(m2.getName(), m2.getParameterTypes());
            if (!delegate.getReturnType().getName().equals(m2.getReturnType().getName())) {
                throw new IllegalArgumentException("Invalid delegate signature " + delegate);
            }
        }
        catch (NoSuchMethodException e2) {
            throw new CodeGenerationException(e2);
        }
        Signature sig = ReflectUtils.getSignature(m2);
        Type[] exceptions = TypeUtils.getTypes(m2.getExceptionTypes());
        CodeEmitter e3 = super.begin_method(1, sig, exceptions);
        e3.load_this();
        e3.getfield(DELEGATE);
        e3.load_args();
        e3.invoke_virtual(this.delegateType, sig);
        e3.return_value();
        e3.end_method();
    }
}

