/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.lang.reflect.Executable;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.ucp.logging.ClioSupport;

@DefaultLogger(value="oracle.ucp.common")
@Supports(value={Feature.CHECK_IN, Feature.CHECK_OUT, Feature.CONN_CONSTRUCTION, Feature.CONN_DESTRUCTION})
public class Clock {
    public static final long GRANULARITY = 60L;
    public static final long ACCURACY = 300L;
    public static final long IDLE_TIMEOUT = 1500L;
    private static volatile long clock;
    private static volatile long clockTerm;
    private static volatile boolean stopped;
    private static final ReentrantLock lock;
    private static final Condition cond;
    private static Thread clockThread;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;

    public static long clock() {
        if (stopped) {
            return System.currentTimeMillis();
        }
        long t2 = clock;
        if (0L == t2) {
            lock.lock();
            try {
                t2 = clock = System.currentTimeMillis();
                cond.signal();
            }
            finally {
                lock.unlock();
            }
        }
        clockTerm = t2 + 1500L;
        return t2;
    }

    public static void start() {
        stopped = false;
    }

    public static void stop() {
        stopped = true;
    }

    public static boolean isBefore(long time1, long time2) {
        return time1 < time2 - 300L;
    }

    static {
        try {
            $$$methodRef$$$5 = Clock.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$4 = Clock.class.getDeclaredMethod("lambda$static$0", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$3 = Clock.class.getDeclaredMethod("isBefore", Long.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$2 = Clock.class.getDeclaredMethod("stop", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$1 = Clock.class.getDeclaredMethod("start", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$0 = Clock.class.getDeclaredMethod("clock", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        clock = 0L;
        clockTerm = 0L;
        stopped = true;
        lock = new ReentrantLock();
        cond = lock.newCondition();
        clockThread = new Thread(() -> {
            try {
                while (true) {
                    lock.lock();
                    try {
                        cond.await();
                    }
                    finally {
                        lock.unlock();
                    }
                    while (clock < clockTerm) {
                        long ct = clock + 300L;
                        while (clock < ct) {
                            Thread.sleep(30L);
                            clock += 30L;
                        }
                        clock = System.currentTimeMillis();
                    }
                    clock = 0L;
                }
            }
            catch (InterruptedException e2) {
                ClioSupport.ilogThrowing(null, null, null, null, e2);
                return;
            }
        }, "UCP Clock");
        clockThread.setDaemon(true);
        clockThread.start();
    }
}

