--
-- Kuali Coeus, a comprehensive research administration system for higher education.
--
-- Copyright 2005-2020 Kuali, Inc.
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU Affero General Public License as
-- published by the Free Software Foundation, either version 3 of the
-- License, or (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU Affero General Public License for more details.
--
-- You should have received a copy of the GNU Affero General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.
--


declare
  l_new_seq NUMBER;
begin
    select COALESCE(max(ATTACHMENT_ID), 0) + 1 into l_new_seq from SUBAWARD_TEMPLATE_ATTACHMENTS;

    execute immediate 'drop sequence SEQ_SUBAWARD_TMPL_ATT_ID';
    execute immediate 'Create sequence SEQ_SUBAWARD_TMPL_ATT_ID start with ' || l_new_seq || ' increment by 1';
end;
/
