--
-- Kuali Coeus, a comprehensive research administration system for higher education.
--
-- Copyright 2005-2020 Kuali, Inc.
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU Affero General Public License as
-- published by the Free Software Foundation, either version 3 of the
-- License, or (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU Affero General Public License for more details.
--
-- You should have received a copy of the GNU Affero General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.
--

INSERT INTO SEQ_VALID_NARR_FORMS_ID VALUES (null);
INSERT INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID,FORM_NAME,NARRATIVE_TYPE_CODE,MANDATORY,UPDATE_USER,UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT MAX(ID) FROM SEQ_VALID_NARR_FORMS_ID),'NSF_KeyPersonExpanded_2_0','148','N','admin',NOW(), UUID());

insert into seq_s2s_error_id values (null);
insert into s2s_error (s2s_error_id, message_key, message, fix_link, update_timestamp, update_user, ver_nbr, obj_id)
values ((select max(id) from seq_s2s_error_id),
        '/GrantApplication/Forms/NSF_KeyPersonExpanded_2_0/PDPI/Profile/BioSketchsAttached/BioSketchAttached',
        'Each investigator must have a BioSketch attachment. Upload the PDF on the Personnel Attachments panel, with "Biosketch" as the attachment type.',
        'abstractsAttachments', now(), 'admin', 1, uuid());

insert into seq_s2s_error_id values (null);
insert into s2s_error (s2s_error_id, message_key, message, fix_link, update_timestamp, update_user, ver_nbr, obj_id)
values ((select max(id) from seq_s2s_error_id),
        '/GrantApplication/Forms/NSF_KeyPersonExpanded_2_0/PDPI/Profile/SupportsAttached/SupportAttached',
        'Each investigator must have a Current Pending attachment. Upload the PDF on the Personnel Attachments panel, with "Currentpending" as the attachment type.',
        'abstractsAttachments', now(), 'admin', 1, uuid());

insert into seq_s2s_error_id values (null);
insert into s2s_error (s2s_error_id, message_key, message, fix_link, update_timestamp, update_user, ver_nbr, obj_id)
values ((select max(id) from seq_s2s_error_id),
        '/GrantApplication/Forms/NSF_KeyPersonExpanded_2_0/PDPI/Profile/CollaboratorsAttached/CollaboratorAttached',
        'Each investigator must have an NSF Collaborator attachment. Upload the PDF on the Personnel Attachments panel, with "NSF_Collaborator" as the attachment type.',
        'abstractsAttachments', now(), 'admin', 1, uuid());

insert into seq_s2s_error_id values (null);
insert into s2s_error (s2s_error_id, message_key, message, fix_link, update_timestamp, update_user, ver_nbr, obj_id)
values ((select max(id) from seq_s2s_error_id),
        '/GrantApplication/Forms/NSF_KeyPersonExpanded_2_0/PDPI/Profile',
        'PI needs to be added to proposal', 'keyPersonnel', now(), 'admin', 1, uuid());

insert into seq_s2s_error_id values (null);
insert into s2s_error (s2s_error_id, message_key, message, fix_link, update_timestamp, update_user, ver_nbr, obj_id)
values ((select max(id) from seq_s2s_error_id),
        '/GrantApplication/Forms/NSF_KeyPersonExpanded_2_0/PDPI/Profile/Address',
        'The country code for the investigator address is invalid.', 'keyPersonnel', now(), 'admin', 1, uuid());