--
-- Kuali Coeus, a comprehensive research administration system for higher education.
-- 
-- Copyright 2005-2015 Kuali, Inc.
-- 
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU Affero General Public License as
-- published by the Free Software Foundation, either version 3 of the
-- License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.
--

DELIMITER /

-- foreign key was created before the table was renamed so drop and recreate
ALTER TABLE KRLC_CMP_T DROP FOREIGN KEY SH_CAMPUS_TR1
/
ALTER TABLE KRLC_CMP_T
    ADD CONSTRAINT SH_CAMPUS_TR1
    FOREIGN KEY (CAMPUS_TYP_CD)
    REFERENCES KRLC_CMP_TYP_T (CAMPUS_TYP_CD)
/

INSERT INTO KRLC_CMP_T (CAMPUS_CD,CAMPUS_NM,CAMPUS_SHRT_NM,CAMPUS_TYP_CD,ACTV_IND,OBJ_ID,VER_NBR) 
    VALUES ('BL','BLOOMINGTON','BLOOMINGTON','B','Y',UUID(),1)
/
INSERT INTO KRLC_CMP_T (CAMPUS_CD,CAMPUS_NM,CAMPUS_SHRT_NM,CAMPUS_TYP_CD,ACTV_IND,OBJ_ID,VER_NBR) 
    VALUES ('BX','BLGTN OFF CAMPUS','BLGTN OFF CA','P','Y',UUID(),1)
/
INSERT INTO KRLC_CMP_T (CAMPUS_CD,CAMPUS_NM,CAMPUS_SHRT_NM,CAMPUS_TYP_CD,ACTV_IND,OBJ_ID,VER_NBR) 
    VALUES ('CO','COLUMBUS','COLUMBUS','F','Y',UUID(),1)
/
INSERT INTO KRLC_CMP_T (CAMPUS_CD,CAMPUS_NM,CAMPUS_SHRT_NM,CAMPUS_TYP_CD,ACTV_IND,OBJ_ID,VER_NBR) 
    VALUES ('EA','EAST-RICHMOND','EA-RICHMOND','B','Y',UUID(),1)
/
INSERT INTO KRLC_CMP_T (CAMPUS_CD,CAMPUS_NM,CAMPUS_SHRT_NM,CAMPUS_TYP_CD,ACTV_IND,OBJ_ID,VER_NBR) 
    VALUES ('FW','FORT WAYNE','FORT WAYNE','B','Y',UUID(),1)
/
INSERT INTO KRLC_CMP_T (CAMPUS_CD,CAMPUS_NM,CAMPUS_SHRT_NM,CAMPUS_TYP_CD,ACTV_IND,OBJ_ID,VER_NBR) 
    VALUES ('IN','INDIANAPOLIS','INDIANAPOLIS','B','Y',UUID(),1)
/
INSERT INTO KRLC_CMP_T (CAMPUS_CD,CAMPUS_NM,CAMPUS_SHRT_NM,CAMPUS_TYP_CD,ACTV_IND,OBJ_ID,VER_NBR) 
    VALUES ('KO','KOKOMO','KOKOMO','B','Y',UUID(),1)
/
INSERT INTO KRLC_CMP_T (CAMPUS_CD,CAMPUS_NM,CAMPUS_SHRT_NM,CAMPUS_TYP_CD,ACTV_IND,OBJ_ID,VER_NBR) 
    VALUES ('NW','NORTHWEST-GARY','NW-GARY','B','Y',UUID(),1)
/
INSERT INTO KRLC_CMP_T (CAMPUS_CD,CAMPUS_NM,CAMPUS_SHRT_NM,CAMPUS_TYP_CD,ACTV_IND,OBJ_ID,VER_NBR) 
    VALUES ('OC','OFF CAMPUS','OFF CAMPUS','F','Y',UUID(),1)
/
INSERT INTO KRLC_CMP_T (CAMPUS_CD,CAMPUS_NM,CAMPUS_SHRT_NM,CAMPUS_TYP_CD,ACTV_IND,OBJ_ID,VER_NBR) 
    VALUES ('SB','SOUTH BEND','SOUTH BEND','B','Y',UUID(),1)
/
INSERT INTO KRLC_CMP_T (CAMPUS_CD,CAMPUS_NM,CAMPUS_SHRT_NM,CAMPUS_TYP_CD,ACTV_IND,OBJ_ID,VER_NBR) 
    VALUES ('SE','SOUTHEAST-NEW ALBANY','SE-NEW ALBNY','B','Y',UUID(),1)
/
INSERT INTO KRLC_CMP_T (CAMPUS_CD,CAMPUS_NM,CAMPUS_SHRT_NM,CAMPUS_TYP_CD,ACTV_IND,OBJ_ID,VER_NBR) 
    VALUES ('UA','UNIVERSITY ADMINISTRATION','UNIVER ADMIN','F','Y',UUID(),1)
/
DELIMITER ;
