--
-- Copyright © 2005-2019 Kuali, Inc.
-- All Rights Reserved
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
--
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
--

CREATE TABLE SUBAWARD_NOTIFICATION
(
    NOTIFICATION_ID       DECIMAL(20),
    NOTIFICATION_TYPE_ID  DECIMAL(6)           NOT NULL,
    DOCUMENT_NUMBER       VARCHAR(40)          NOT NULL,
    OWNING_DOCUMENT_ID_FK DECIMAL(12)          NOT NULL,
    SUBAWARD_CODE         VARCHAR(20)          NULL NULL,
    RECIPIENTS            VARCHAR(1000),
    SUBJECT               VARCHAR(1000),
    MESSAGE               VARCHAR(4000),
    UPDATE_USER           VARCHAR(60)          NOT NULL,
    UPDATE_TIMESTAMP      DATETIME             NOT NULL,
    CREATE_TIMESTAMP      DATETIME             NOT NULL,
    VER_NBR               DECIMAL(8) default 1 NOT NULL,
    OBJ_ID                VARCHAR(36)          NOT NULL
);

ALTER TABLE SUBAWARD_NOTIFICATION
    ADD CONSTRAINT SUBAWARD_NOTIFICATIONP1
        PRIMARY KEY (NOTIFICATION_ID);

ALTER TABLE SUBAWARD_NOTIFICATION
    ADD CONSTRAINT FK1_SUBAWARD_NOTIFICATION
        FOREIGN KEY (OWNING_DOCUMENT_ID_FK) REFERENCES SUBAWARD (SUBAWARD_ID);

ALTER TABLE SUBAWARD_NOTIFICATION
    ADD CONSTRAINT FK2_SUBAWARD_NOTIFICATION
        FOREIGN KEY (SUBAWARD_CODE) REFERENCES SUBAWARD (SUBAWARD_CODE);

ALTER TABLE SUBAWARD_NOTIFICATION
    ADD CONSTRAINT FK3_SUBAWARD_NOTIFICATION
        FOREIGN KEY (NOTIFICATION_TYPE_ID) REFERENCES NOTIFICATION_TYPE (NOTIFICATION_TYPE_ID);

UPDATE notification_type
SET module_code = 4
WHERE action_code = 501
  and module_code = 1;

INSERT INTO SEQ_NOTIFICATION_TYPE_ID
VALUES (NULL);

INSERT INTO NOTIFICATION_TYPE (NOTIFICATION_TYPE_ID, MODULE_CODE, ACTION_CODE, DESCRIPTION, SUBJECT, MESSAGE,
                               PROMPT_USER, SEND_NOTIFICATION, UPDATE_USER, UPDATE_TIMESTAMP, VER_NBR, OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_NOTIFICATION_TYPE_ID), 4, '999', 'Ad Hoc Notification for SubAward', '', '', 'N',
        'Y', 'admin', NOW(), 1, UUID());
