--
-- Kuali Coeus, a comprehensive research administration system for higher education.
--
-- Copyright 2005-2016 Kuali, Inc.
--
-- This program is free software: you can redistribute it andor modify
-- it under the terms of the GNU Affero General Public License as
-- published by the Free Software Foundation, either version 3 of the
-- License, or (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU Affero General Public License for more details.
--
-- You should have received a copy of the GNU Affero General Public License
-- along with this program.  If not, see <http:www.gnu.orglicenses>.
--

ALTER TABLE KC_QRTZ_JOB_LISTENERS
  DROP CONSTRAINT FK_KC_QRTZ_JOB_LISTENERS DROP INDEX;
ALTER TABLE KC_QRTZ_TRIGGERS
  DROP CONSTRAINT FK_KC_QRTZ_TRIGGERS DROP INDEX;

--
-- drop columns that are no longer used
--
ALTER TABLE KC_QRTZ_JOB_DETAILS
  DROP COLUMN is_volatile;
ALTER TABLE KC_QRTZ_TRIGGERS
  DROP COLUMN is_volatile;
ALTER TABLE KC_QRTZ_FIRED_TRIGGERS
  DROP COLUMN is_volatile;

--
-- add new columns that replace the 'is_stateful' column
--
ALTER TABLE KC_QRTZ_JOB_DETAILS
  ADD is_nonconcurrent VARCHAR2(1);
ALTER TABLE KC_QRTZ_JOB_DETAILS
  ADD is_update_data VARCHAR2(1);
UPDATE KC_QRTZ_JOB_DETAILS
SET is_nonconcurrent = is_stateful;
UPDATE KC_QRTZ_JOB_DETAILS
SET is_update_data = is_stateful;
ALTER TABLE KC_QRTZ_JOB_DETAILS
  DROP COLUMN is_stateful;
ALTER TABLE KC_QRTZ_FIRED_TRIGGERS
  ADD is_nonconcurrent VARCHAR2(1);
ALTER TABLE KC_QRTZ_FIRED_TRIGGERS
  ADD is_update_data VARCHAR2(1);
UPDATE KC_QRTZ_FIRED_TRIGGERS
SET is_nonconcurrent = is_stateful;
UPDATE KC_QRTZ_FIRED_TRIGGERS
SET is_update_data = is_stateful;
ALTER TABLE KC_QRTZ_FIRED_TRIGGERS
  DROP COLUMN is_stateful;

--
-- add new 'sched_name' column to all tables
--
ALTER TABLE KC_QRTZ_BLOB_TRIGGERS
  ADD sched_name VARCHAR(120) DEFAULT 'kcScheduler' NOT NULL;
ALTER TABLE KC_QRTZ_CALENDARS
  ADD sched_name VARCHAR(120) DEFAULT 'kcScheduler' NOT NULL;
ALTER TABLE KC_QRTZ_CRON_TRIGGERS
  ADD sched_name VARCHAR(120) DEFAULT 'kcScheduler' NOT NULL;
ALTER TABLE KC_QRTZ_FIRED_TRIGGERS
  ADD sched_name VARCHAR(120) DEFAULT 'kcScheduler' NOT NULL;
ALTER TABLE KC_QRTZ_FIRED_TRIGGERS
  ADD sched_time NUMBER(13) NOT NULL;
ALTER TABLE KC_QRTZ_JOB_DETAILS
  ADD sched_name VARCHAR(120) DEFAULT 'kcScheduler' NOT NULL;
ALTER TABLE KC_QRTZ_LOCKS
  ADD sched_name VARCHAR(120) DEFAULT 'kcScheduler' NOT NULL;
ALTER TABLE KC_QRTZ_PAUSED_TRIGGER_GRPS
  ADD sched_name VARCHAR(120) DEFAULT 'kcScheduler' NOT NULL;
ALTER TABLE KC_QRTZ_SCHEDULER_STATE
  ADD sched_name VARCHAR(120) DEFAULT 'kcScheduler' NOT NULL;
ALTER TABLE KC_QRTZ_SIMPLE_TRIGGERS
  ADD sched_name VARCHAR(120) DEFAULT 'kcScheduler' NOT NULL;
ALTER TABLE KC_QRTZ_TRIGGERS
  ADD sched_name VARCHAR(120) DEFAULT 'kcScheduler' NOT NULL;

--
-- drop all primary and foreign key constraints, so that we can define new ones
--
ALTER TABLE KC_QRTZ_BLOB_TRIGGERS
  DROP PRIMARY KEY DROP INDEX;
ALTER TABLE KC_QRTZ_BLOB_TRIGGERS
  DROP CONSTRAINT FK_KC_QRTZ_BLOB_TRIGGERS DROP INDEX;
ALTER TABLE KC_QRTZ_SIMPLE_TRIGGERS
  DROP PRIMARY KEY DROP INDEX;
ALTER TABLE KC_QRTZ_SIMPLE_TRIGGERS
  DROP CONSTRAINT FK_KC_QRTZ_SIMPLE_TRIGGERS DROP INDEX;
ALTER TABLE KC_QRTZ_CRON_TRIGGERS
  DROP PRIMARY KEY DROP INDEX;
ALTER TABLE KC_QRTZ_CRON_TRIGGERS
  DROP CONSTRAINT FK_KC_QRTZ_CRON_TRIGGERS DROP INDEX;
ALTER TABLE KC_QRTZ_JOB_DETAILS
  DROP PRIMARY KEY DROP INDEX;
ALTER TABLE KC_QRTZ_TRIGGER_LISTENERS
  DROP CONSTRAINT FK_KC_QRTZ_TRIGGER_LISTENERS DROP INDEX;
ALTER TABLE KC_QRTZ_TRIGGERS
  DROP PRIMARY KEY DROP INDEX;

--
--
-- add all primary and foreign key constraints, based on new columns
--
ALTER TABLE KC_QRTZ_JOB_DETAILS
  ADD CONSTRAINT KC_QRTZ_JOB_DETAILSP1 PRIMARY KEY (job_name, job_group, sched_name);
ALTER TABLE KC_QRTZ_TRIGGERS
  ADD CONSTRAINT KC_QRTZ_TRIGGERSP1 PRIMARY KEY (trigger_name, trigger_group, sched_name);
ALTER TABLE KC_QRTZ_TRIGGERS
  ADD CONSTRAINT KC_QRTZ_TRIGGERS_TR1 FOREIGN KEY (job_name, job_group, sched_name) REFERENCES KC_QRTZ_JOB_DETAILS (job_name, job_group, sched_name);
ALTER TABLE KC_QRTZ_BLOB_TRIGGERS
  ADD CONSTRAINT KC_QRTZ_BLOB_TRIGGERSP1 PRIMARY KEY (trigger_name, trigger_group, sched_name);
ALTER TABLE KC_QRTZ_BLOB_TRIGGERS
  ADD CONSTRAINT KC_QRTZ_BLOB_TRIGGERS_TR1 FOREIGN KEY (trigger_name, trigger_group, sched_name) REFERENCES KC_QRTZ_TRIGGERS (trigger_name, trigger_group, sched_name);
ALTER TABLE KC_QRTZ_CRON_TRIGGERS
  ADD CONSTRAINT KC_QRTZ_CRON_TRIGGERSP1 PRIMARY KEY (trigger_name, trigger_group, sched_name);
ALTER TABLE KC_QRTZ_CRON_TRIGGERS
  ADD CONSTRAINT KC_QRTZ_CRON_TRIGGERS_TR1 FOREIGN KEY (trigger_name, trigger_group, sched_name) REFERENCES KC_QRTZ_TRIGGERS (trigger_name, trigger_group, sched_name);
ALTER TABLE KC_QRTZ_SIMPLE_TRIGGERS
  ADD CONSTRAINT KC_QRTZ_SIMPLE_TRIGGERSP1 PRIMARY KEY (trigger_name, trigger_group, sched_name);
ALTER TABLE KC_QRTZ_SIMPLE_TRIGGERS
  ADD CONSTRAINT KC_QRTZ_SIMPLE_TRIGGERS_TR1 FOREIGN KEY (trigger_name, trigger_group, sched_name) REFERENCES KC_QRTZ_TRIGGERS (trigger_name, trigger_group, sched_name);
ALTER TABLE KC_QRTZ_FIRED_TRIGGERS
  DROP PRIMARY KEY DROP INDEX;
ALTER TABLE KC_QRTZ_FIRED_TRIGGERS
  ADD CONSTRAINT KC_QRTZ_FIRED_TRIGGERSP1 PRIMARY KEY (entry_id, sched_name);
ALTER TABLE KC_QRTZ_CALENDARS
  DROP PRIMARY KEY DROP INDEX;
ALTER TABLE KC_QRTZ_CALENDARS
  ADD CONSTRAINT KC_QRTZ_CALENDARSP1 PRIMARY KEY (calendar_name, sched_name);
ALTER TABLE KC_QRTZ_LOCKS
  DROP PRIMARY KEY DROP INDEX;
ALTER TABLE KC_QRTZ_LOCKS
  ADD CONSTRAINT KC_QRTZ_LOCKSP1 PRIMARY KEY (lock_name, sched_name);
ALTER TABLE KC_QRTZ_PAUSED_TRIGGER_GRPS
  DROP PRIMARY KEY DROP INDEX;
ALTER TABLE KC_QRTZ_PAUSED_TRIGGER_GRPS
  ADD CONSTRAINT KC_QRTZ_PAUSED_TRIGGER_GRP1 PRIMARY KEY (trigger_group, sched_name);
ALTER TABLE KC_QRTZ_SCHEDULER_STATE
  DROP PRIMARY KEY DROP INDEX;
ALTER TABLE KC_QRTZ_SCHEDULER_STATE
  ADD CONSTRAINT KC_QRTZ_SCHEDULER_STATEP1 PRIMARY KEY (instance_name, sched_name);

--
-- add new simprop_triggers table
--
CREATE TABLE KC_QRTZ_SIMPROP_TRIGGERS
(
  SCHED_NAME VARCHAR2(120) NOT NULL,
  TRIGGER_NAME VARCHAR2(200) NOT NULL,
  TRIGGER_GROUP VARCHAR2(200) NOT NULL,
  STR_PROP_1 VARCHAR2(512) NULL,
  STR_PROP_2 VARCHAR2(512) NULL,
  STR_PROP_3 VARCHAR2(512) NULL,
  INT_PROP_1 NUMBER(10) NULL,
  INT_PROP_2 NUMBER(10) NULL,
  LONG_PROP_1 NUMBER(13) NULL,
  LONG_PROP_2 NUMBER(13) NULL,
  DEC_PROP_1 NUMERIC(13,4) NULL,
  DEC_PROP_2 NUMERIC(13,4) NULL,
  BOOL_PROP_1 VARCHAR2(1) NULL,
  BOOL_PROP_2 VARCHAR2(1) NULL,
  constraint KC_QRTZ_SIMPROP_TRIGGERSP1 primary key (SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP),
  constraint KC_QRTZ_SIMPROP_TRIGGERS_TR1 foreign key (SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP)
  references KC_QRTZ_TRIGGERS(TRIGGER_NAME,TRIGGER_GROUP, SCHED_NAME)
);

