--
-- Kuali Coeus, a comprehensive research administration system for higher education.
-- 
-- Copyright 2005-2015 Kuali, Inc.
-- 
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU Affero General Public License as
-- published by the Free Software Foundation, either version 3 of the
-- License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.
--

delimiter /
TRUNCATE TABLE IACUC_PROTO_CORRESP_TEMPL
/
COMMIT
/
INSERT INTO SEQ_IACUC_PROTO_CORRESP_TEMPL VALUES(NULL)
/
INSERT INTO IACUC_PROTO_CORRESP_TEMPL (COMMITTEE_ID,CORRESPONDENCE_TEMPLATE,FILE_NAME,OBJ_ID,PROTO_CORRESP_TEMPL_ID,PROTO_CORRESP_TYPE_CODE,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR)
  VALUES ('DEFAULT','<?xml version="1.0" encoding="UTF-8"?>
<!--Designed and generated by Altova StyleVision Enterprise Edition 2008 rel. 2 - see http://www.altova.com/stylevision for more information.-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:n1="http://xml.coeus.mit.edu/iacuc" xmlns:xdt="http://www.w3.org/2005/xpath-datatypes" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output version="1.0" method="xml" encoding="UTF-8" indent="no"/>
	<xsl:param name="SV_OutputFormat" select="\'PDF\'"/>
	<xsl:variable name="XML" select="/"/>
	<xsl:variable name="fo:layout-master-set">
		<fo:layout-master-set>
			<fo:simple-page-master master-name="default-page" page-height="11in" page-width="8.5in" margin-left="0.6in" margin-right="1.0in">
				<fo:region-body margin-top="0.79in" margin-bottom="0.79in"/>
				<fo:region-before extent="0.79in"/>
			</fo:simple-page-master>
		</fo:layout-master-set>
	</xsl:variable>
	<xsl:template match="/">
		<fo:root>
			<xsl:copy-of select="$fo:layout-master-set"/>
			<fo:page-sequence master-reference="default-page" initial-page-number="1" format="1">
				<xsl:call-template name="headerall"/>
				<fo:flow flow-name="xsl-region-body">
					<fo:block>
						<xsl:for-each select="$XML">
							<fo:external-graphic>
								<xsl:attribute name="src">
									<xsl:text>url(</xsl:text>
									<xsl:call-template name="double-backslash">
										<xsl:with-param name="text">
											<xsl:value-of select="string(&apos;/export/home/www/https/tomcat5.0.25/webapps/coeus/images/couhes_byline2.gif&apos;)"/>
										</xsl:with-param>
										<xsl:with-param name="text-length">
											<xsl:value-of select="string-length(string(&apos;/export/home/www/https/tomcat5.0.25/webapps/coeus/images/couhes_byline2.gif&apos;))"/>
										</xsl:with-param>
									</xsl:call-template>
									<xsl:text>)</xsl:text>
								</xsl:attribute>
							</fo:external-graphic>
							<fo:block text-align="center">
								<fo:leader leader-pattern="rule" rule-thickness="1" leader-length="100%" color="black"/>
							</fo:block>
							<fo:block/>
							<xsl:for-each select="n1:Correspondence">
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block font-family="Arial" font-size="10pt" margin="0pt">
									<fo:block>
										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x2029;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
											<fo:table-column column-width="25%"/>
											<fo:table-column column-width="75%"/>
											<fo:table-body start-indent="0pt">
												<fo:table-row>
													<fo:table-cell font-family="Arial" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>To:</xsl:text>
															</fo:inline>
															<fo:inline font-size="10pt">
																<xsl:text>&#160;&#160;&#160;&#160;&#160; </xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" padding="2pt" display-align="center">
														<fo:block>
															<xsl:for-each select="n1:Protocol">
																<xsl:for-each select="n1:Investigator">
																	<xsl:if test="n1:PI_flag = &apos;true&apos;">
																		<xsl:for-each select="n1:Person">
																			<xsl:for-each select="n1:Firstname">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																						<fo:block font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:for-each>
																			<fo:inline font-size="10pt">
																				<xsl:text>&#160; </xsl:text>
																			</fo:inline>
																			<xsl:for-each select="n1:LastName">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																						<fo:block font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:for-each>
																			<fo:inline-container>
																				<fo:block>
																					<xsl:text>&#x2029;</xsl:text>
																				</fo:block>
																			</fo:inline-container>
																			<fo:block white-space="pre" white-space-collapse="false" margin="0pt">
																				<fo:block>
																					<xsl:for-each select="n1:OfficeLocation">
																						<xsl:variable name="value-of-template">
																							<xsl:apply-templates/>
																						</xsl:variable>
																						<xsl:choose>
																							<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																								<fo:block font-family="Arial" font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:block>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline font-family="Arial" font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:for-each>
																				</fo:block>
																			</fo:block>
																		</xsl:for-each>
																	</xsl:if>
																</xsl:for-each>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell font-family="Arial" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>From:</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" padding="2pt" display-align="center">
														<fo:block>
															<xsl:for-each select="n1:Protocol">
																<xsl:for-each select="n1:Submissions">
																	<xsl:for-each select="n1:CommitteeMember">
																		<xsl:if test="n1:CommitteeMemberRole/n1:MemberRoleDesc = &apos;Chair&apos;">
																			<xsl:for-each select="n1:Person">
																				<xsl:for-each select="n1:Firstname">
																					<xsl:if test="../../../n1:CurrentSubmissionFlag =&apos;No&apos;">
																						<xsl:variable name="value-of-template">
																							<xsl:apply-templates/>
																						</xsl:variable>
																						<xsl:choose>
																							<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																								<fo:block font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:block>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:if>
																				</xsl:for-each>
																				<fo:inline>
																					<xsl:text>&#160;</xsl:text>
																				</fo:inline>
																				<xsl:for-each select="n1:LastName">
																					<xsl:if test="../../../n1:CurrentSubmissionFlag =&apos;No&apos;">
																						<xsl:variable name="value-of-template">
																							<xsl:apply-templates/>
																						</xsl:variable>
																						<xsl:choose>
																							<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																								<fo:block font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:block>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:if>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:if>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
															<fo:inline font-size="10pt">
																<xsl:text>, Chair </xsl:text>
															</fo:inline>
															<fo:inline-container>
																<fo:block>
																	<xsl:text>&#x2029;</xsl:text>
																</fo:block>
															</fo:inline-container>
															<fo:block white-space="pre" white-space-collapse="false" margin="0pt">
																<fo:block>
																	<xsl:for-each select="n1:Protocol">
																		<xsl:for-each select="n1:Submissions">
																			<xsl:for-each select="n1:CommitteeMasterData">
																				<xsl:for-each select="n1:CommitteeName">
																					<xsl:if test="../../n1:CurrentSubmissionFlag =&apos;No&apos;">
																						<xsl:variable name="value-of-template">
																							<xsl:apply-templates/>
																						</xsl:variable>
																						<xsl:choose>
																							<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																								<fo:block font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:block>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:if>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:block>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell font-family="Arial" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>Date:</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" padding="2pt" display-align="center">
														<fo:block>
															<xsl:for-each select="n1:CurrentDate">
																<fo:inline font-size="10pt">
																	<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																	<xsl:text>/</xsl:text>
																	<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																	<xsl:text>/</xsl:text>
																	<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
																</fo:inline>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell font-family="Arial" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>Committee Action:</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" padding="2pt" display-align="before">
														<fo:block>
															<xsl:choose>
																<xsl:when test="n1:Protocol/n1:Submissions/n1:SubmissionDetails/n1:SubmissionTypeCode = 102">
																	<fo:inline font-size="10pt" font-weight="bold">
																		<xsl:text>Amendment to Approved Protocol</xsl:text>
																	</fo:inline>
																</xsl:when>
																<xsl:when test="n1:Protocol/n1:Submissions/n1:SubmissionDetails/n1:SubmissionTypeCode = 101">
																	<fo:inline font-size="10pt" font-weight="bold">
																		<xsl:text>Renewal</xsl:text>
																	</fo:inline>
																</xsl:when>
																<xsl:otherwise>
																	<fo:inline font-size="10pt" font-weight="bold">
																		<xsl:text>Approval</xsl:text>
																	</fo:inline>
																</xsl:otherwise>
															</xsl:choose>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell font-family="Arial" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>Committee Action Date:</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" padding="2pt" display-align="before">
														<fo:block>
															<xsl:for-each select="n1:Protocol">
																<xsl:for-each select="n1:Submissions">
																	<xsl:for-each select="n1:SubmissionDetails">
																		<xsl:for-each select="n1:ActionType">
																			<xsl:for-each select="n1:ActionDate">
																				<xsl:if test="../../../n1:CurrentSubmissionFlag =&apos;No&apos;">
																					<fo:inline>
																						<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																						<xsl:text>/</xsl:text>
																						<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																						<xsl:text>/</xsl:text>
																						<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
																					</fo:inline>
																				</xsl:if>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x2029;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<fo:table font-family="Arial" table-layout="fixed" width="100%" border-spacing="2pt">
											<fo:table-column column-width="25%"/>
											<fo:table-column column-width="75%"/>
											<fo:table-body font-family="Arial" start-indent="0pt">
												<fo:table-row font-family="Arial">
													<fo:table-cell font-family="Arial" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>IACUC Protocol #: </xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" padding="2pt" display-align="before">
														<fo:block>
															<xsl:for-each select="n1:Protocol">
																<xsl:for-each select="n1:ProtocolMasterData">
																	<xsl:for-each select="n1:ProtocolNumber">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																				<fo:block font-size="10pt">
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline font-size="10pt">
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell font-family="Arial" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>Study Title:</xsl:text>
															</fo:inline>
															<fo:inline font-size="10pt">
																<xsl:text>&#160;&#160;&#160; </xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" padding="2pt" display-align="before">
														<fo:block>
															<xsl:for-each select="n1:Protocol">
																<xsl:for-each select="n1:ProtocolMasterData">
																	<xsl:for-each select="n1:ProtocolTitle">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																				<fo:block font-size="10pt">
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline font-size="10pt">
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell font-family="Arial" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>Expiration Date:</xsl:text>
															</fo:inline>
															<fo:inline font-size="10pt">
																<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" padding="2pt" display-align="before">
														<fo:block>
															<xsl:for-each select="n1:Protocol">
																<xsl:for-each select="n1:ProtocolMasterData">
																	<xsl:for-each select="n1:ExpirationDate">
																		<fo:inline>
																			<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																			<xsl:text>/</xsl:text>
																			<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																			<xsl:text>/</xsl:text>
																			<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
																		</fo:inline>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
									</fo:block>
								</fo:block>
								<xsl:choose>
									<xsl:when test="n1:Protocol/n1:Submissions/n1:CurrentSubmissionFlag = &apos;No&apos; and  n1:Protocol/n1:Submissions/n1:SubmissionDetails/n1:SubmissionTypeCode = 102">
										<fo:inline font-family="Arial" font-size="10pt">
											<xsl:text>The amendment to the above-referenced protocol has been APPROVED following full board review by the IACUC Committee</xsl:text>
										</fo:inline>
										<fo:block/>
										<fo:inline font-family="Arial" font-size="10pt">
											<xsl:text>It is the Principal Investigator???s responsibility to obtain review and continued approval before the expiration date.&#160; Please allow sufficient time for continued approval.&#160; You may not continue any research activity beyond the expiration date without IACUC approval.&#160; Failure to receive approval for continuation before the expiration date will result in the automatic suspension of the approval of this protocol.&#160; Information collected following suspension is unapproved research and cannot be reported or published as research data.&#160; If you do not wish continued approval, please notify the Committee of the study termination.</xsl:text>
										</fo:inline>
									</xsl:when>
									<xsl:when test="n1:Protocol/n1:Submissions/n1:CurrentSubmissionFlag = &apos;No&apos; and  n1:Protocol/n1:Submissions/n1:SubmissionDetails/n1:SubmissionTypeCode = 101">
										<fo:inline font-family="Arial" font-size="10pt">
											<xsl:text>The above-referenced protocol was given renewed approval following full board review by the Committee on the Use of Humans as Experimental Subjects (COUHES).</xsl:text>
										</fo:inline>
										<fo:block>
											<fo:leader leader-pattern="space"/>
										</fo:block>
										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x2029;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<fo:block font-family="Arial" font-size="10pt" margin="0pt">
											<fo:block>
												<fo:inline font-family="Arial" font-size="10pt">
													<xsl:text>If the research involves collaboration with another institution then the research cannot commence until COUHES receives written notification of approval from the collaborating institution&apos;s IRB.</xsl:text>
												</fo:inline>
												<fo:block/>
												<fo:inline font-family="Arial" font-size="10pt">
													<xsl:text>It is the Principal Investigator&apos;s responsibility to obtain review and continued approval before the expiration date.&#160; You may not continue any research activity beyond the expiration date without approval by COUHES.&#160; Failure to renew your study before the expiration date will result in termination of the study and suspension of related research grants.</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:block>
									</xsl:when>
									<xsl:otherwise>
										<fo:inline font-family="Arial" font-size="10pt">
											<xsl:text>The above-referenced protocol has been APPROVED following Full Board Review by the Committee on the Use of Humans as Experimental Subjects (COUHES).&#160; </xsl:text>
										</fo:inline>
										<fo:block/>
										<fo:inline font-family="Arial" font-size="10pt">
											<xsl:text>If the research involves collaboration with another institution then the research cannot commence until COUHES receives written notification of approval from the collaborating institution&apos;s IRB.</xsl:text>
										</fo:inline>
										<fo:block/>
										<fo:inline font-family="Arial" font-size="10pt">
											<xsl:text>It is the Principal Investigator???s responsibility to obtain review and continued approval before the expiration date.&#160; Please allow sufficient time for continued approval.&#160; You may not continue any research activity beyond the expiration date without COUHES approval.&#160; Failure to receive approval for continuation before the expiration date will result in the automatic suspension of the approval of this protocol.&#160; Information</xsl:text>
										</fo:inline>
										<fo:inline font-family="Arial" font-size="10pt" font-weight="bold">
											<xsl:text>&#160;</xsl:text>
										</fo:inline>
										<fo:inline font-family="Arial" font-size="10pt">
											<xsl:text>collected following suspension is unapproved research and cannot be reported or published as research data.&#160; If you do not wish continued approval, please notify the Committee of the study termination.</xsl:text>
										</fo:inline>
									</xsl:otherwise>
								</xsl:choose>
								<fo:block/>
								<fo:inline font-family="Arial" font-size="10pt">
									<xsl:text>Amendments:&#160; Any changes to the protocol that impact human subjects, including changes in experimental design, equipment, personnel or funding, must be approved by IACUC before they can be initiated. </xsl:text>
								</fo:inline>
								<fo:block/>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block margin="0pt">
									<fo:block>
										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x2029;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
											<fo:table-column column-width="31"/>
											<fo:table-column column-width="proportional-column-width(1)"/>
											<fo:table-body start-indent="0pt">
												<fo:table-row>
													<fo:table-cell padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-family="Arial" font-size="10pt">
																<xsl:text>cc:</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-family="Arial" font-size="10pt">
																<xsl:text>Tom Duff</xsl:text>
															</fo:inline>
															<xsl:for-each select="n1:Protocol">
																<xsl:for-each select="n1:Correspondent">
																	<xsl:if test="n1:TypeOfCorrespondent = &apos;CRC&apos;">
																		<xsl:for-each select="n1:Person">
																			<xsl:for-each select="n1:Fullname">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																						<fo:block font-family="Arial" font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline font-family="Arial" font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:if>
																</xsl:for-each>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
									</fo:block>
								</fo:block>
							</xsl:for-each>
						</xsl:for-each>
					</fo:block>
					<fo:block id="SV_RefID_PageTotal"/>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	<xsl:template name="headerall">
		<fo:static-content flow-name="xsl-region-before">
			<fo:block>
				<xsl:for-each select="$XML">
					<fo:inline-container>
						<fo:block>
							<xsl:text>&#x2029;</xsl:text>
						</fo:block>
					</fo:inline-container>
					<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
						<fo:table-column column-width="proportional-column-width(1)"/>
						<fo:table-column column-width="150"/>
						<fo:table-body start-indent="0pt">
							<fo:table-row>
								<fo:table-cell padding="0" number-columns-spanned="2" height="30" display-align="center">
									<fo:block/>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell font-size="smaller" padding="0" text-align="left" display-align="center">
									<fo:block/>
								</fo:table-cell>
								<fo:table-cell font-size="smaller" padding="0" text-align="right" display-align="center">
									<fo:block/>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell padding="0" number-columns-spanned="2" display-align="center">
									<fo:block/>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</xsl:for-each>
			</fo:block>
		</fo:static-content>
	</xsl:template>
	<xsl:template name="double-backslash">
		<xsl:param name="text"/>
		<xsl:param name="text-length"/>
		<xsl:variable name="text-after-bs" select="substring-after($text, \'\\\')"/>
		<xsl:variable name="text-after-bs-length" select="string-length($text-after-bs)"/>
		<xsl:choose>
			<xsl:when test="$text-after-bs-length = 0">
				<xsl:choose>
					<xsl:when test="substring($text, $text-length) = \'\\\'">
						<xsl:value-of select="concat(substring($text,1,$text-length - 1), \'\\\\\')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$text"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="concat(substring($text,1,$text-length - $text-after-bs-length - 1), \'\\\\\')"/>
				<xsl:call-template name="double-backslash">
					<xsl:with-param name="text" select="$text-after-bs"/>
					<xsl:with-param name="text-length" select="$text-after-bs-length"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
','ApprovalLetter.xslt',UUID(),(SELECT (MAX(ID)) FROM SEQ_IACUC_PROTO_CORRESP_TEMPL),'1',NOW(),'admin',1)
/
INSERT INTO SEQ_IACUC_PROTO_CORRESP_TEMPL VALUES(NULL)
/
INSERT INTO IACUC_PROTO_CORRESP_TEMPL (COMMITTEE_ID,CORRESPONDENCE_TEMPLATE,FILE_NAME,OBJ_ID,PROTO_CORRESP_TEMPL_ID,PROTO_CORRESP_TYPE_CODE,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR)
  VALUES ('DEFAULT','<?xml version="1.0" encoding="UTF-8"?>
<!--Designed and generated by Altova StyleVision Enterprise Edition 2008 rel. 2 - see http://www.altova.com/stylevision for more information.-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:n1="http://xml.coeus.mit.edu/iacuc" xmlns:xdt="http://www.w3.org/2005/xpath-datatypes" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output version="1.0" method="xml" encoding="UTF-8" indent="no"/>
	<xsl:param name="SV_OutputFormat" select="\'PDF\'"/>
	<xsl:variable name="XML" select="/"/>
	<xsl:variable name="fo:layout-master-set">
		<fo:layout-master-set>
			<fo:simple-page-master master-name="default-page" page-height="11in" page-width="8.5in" margin-left="0.6in" margin-right="0.6in">
				<fo:region-body margin-top="0.79in" margin-bottom="0.79in"/>
				<fo:region-before extent="0.79in"/>
			</fo:simple-page-master>
		</fo:layout-master-set>
	</xsl:variable>
	<xsl:template match="/">
		<fo:root>
			<xsl:copy-of select="$fo:layout-master-set"/>
			<fo:page-sequence master-reference="default-page" initial-page-number="1" format="1">
				<xsl:call-template name="headerall"/>
				<fo:flow flow-name="xsl-region-body">
					<fo:block>
						<xsl:for-each select="$XML">
							<fo:external-graphic>
								<xsl:attribute name="src">
									<xsl:text>url(</xsl:text>
									<xsl:call-template name="double-backslash">
										<xsl:with-param name="text">
											<xsl:value-of select="string(&apos;/export/home/www/https/tomcat5.0.25/webapps/coeus/images/couhes_byline2.gif&apos;)"/>
										</xsl:with-param>
										<xsl:with-param name="text-length">
											<xsl:value-of select="string-length(string(&apos;/export/home/www/https/tomcat5.0.25/webapps/coeus/images/couhes_byline2.gif&apos;))"/>
										</xsl:with-param>
									</xsl:call-template>
									<xsl:text>)</xsl:text>
								</xsl:attribute>
							</fo:external-graphic>
							<fo:block text-align="center">
								<fo:leader leader-pattern="rule" rule-thickness="1" leader-length="100%" color="black"/>
							</fo:block>
							<fo:block/>
							<xsl:for-each select="n1:Correspondence">
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block margin="0pt">
									<fo:block>
										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x2029;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
											<fo:table-column column-width="25%"/>
											<fo:table-column column-width="75%"/>
											<fo:table-body start-indent="0pt">
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>To:</xsl:text>
															</fo:inline>
															<fo:inline font-size="10pt">
																<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="before">
														<fo:block>
															<xsl:for-each select="n1:Protocol">
																<xsl:for-each select="n1:Investigator">
																	<xsl:if test="n1:PI_flag = &apos;true&apos;">
																		<xsl:for-each select="n1:Person">
																			<xsl:for-each select="n1:Firstname">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																						<fo:block font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:for-each>
																			<fo:inline font-size="10pt">
																				<xsl:text>&#160;</xsl:text>
																			</fo:inline>
																			<xsl:for-each select="n1:LastName">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																						<fo:block font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:for-each>
																			<fo:inline-container>
																				<fo:block>
																					<xsl:text>&#x2029;</xsl:text>
																				</fo:block>
																			</fo:inline-container>
																			<fo:block white-space="pre" white-space-collapse="false" margin="0pt">
																				<fo:block>
																					<xsl:for-each select="n1:OfficeLocation">
																						<xsl:variable name="value-of-template">
																							<xsl:apply-templates/>
																						</xsl:variable>
																						<xsl:choose>
																							<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																								<fo:block font-family="Book Antiqua" font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:block>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline font-family="Book Antiqua" font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:for-each>
																				</fo:block>
																			</fo:block>
																		</xsl:for-each>
																	</xsl:if>
																</xsl:for-each>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>From:</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="before">
														<fo:block>
															<xsl:for-each select="n1:Protocol">
																<xsl:for-each select="n1:Submissions">
																	<xsl:for-each select="n1:CommitteeMember">
																		<xsl:if test="n1:CommitteeMemberRole/n1:MemberRoleDesc = &apos;Chair&apos;">
																			<xsl:for-each select="n1:Person">
																				<xsl:for-each select="n1:Firstname">
																					<xsl:if test="../../../n1:CurrentSubmissionFlag =&apos;No&apos;">
																						<xsl:variable name="value-of-template">
																							<xsl:apply-templates/>
																						</xsl:variable>
																						<xsl:choose>
																							<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																								<fo:block font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:block>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:if>
																				</xsl:for-each>
																				<fo:inline font-size="10pt">
																					<xsl:text>&#160;</xsl:text>
																				</fo:inline>
																				<xsl:for-each select="n1:LastName">
																					<xsl:if test="../../../n1:CurrentSubmissionFlag =&apos;No&apos;">
																						<xsl:variable name="value-of-template">
																							<xsl:apply-templates/>
																						</xsl:variable>
																						<xsl:choose>
																							<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																								<fo:block font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:block>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:if>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:if>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
															<fo:inline font-size="10pt">
																<xsl:text>, Chair </xsl:text>
															</fo:inline>
															<fo:inline-container>
																<fo:block>
																	<xsl:text>&#x2029;</xsl:text>
																</fo:block>
															</fo:inline-container>
															<fo:block white-space="pre" white-space-collapse="false" margin="0pt">
																<fo:block>
																	<xsl:for-each select="n1:Protocol">
																		<xsl:for-each select="n1:Submissions">
																			<xsl:for-each select="n1:CommitteeMasterData">
																				<xsl:for-each select="n1:CommitteeName">
																					<xsl:if test="../../n1:CurrentSubmissionFlag =&apos;No&apos;">
																						<xsl:variable name="value-of-template">
																							<xsl:apply-templates/>
																						</xsl:variable>
																						<xsl:choose>
																							<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																								<fo:block font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:block>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:if>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:block>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>Date:</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="before">
														<fo:block>
															<xsl:for-each select="n1:CurrentDate">
																<fo:inline font-family="Book Antiqua" font-size="10pt">
																	<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																	<xsl:text>/</xsl:text>
																	<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																	<xsl:text>/</xsl:text>
																	<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
																</fo:inline>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>Committee Action:</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>Deactivated</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x2029;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
											<fo:table-column column-width="25%"/>
											<fo:table-column column-width="75%"/>
											<fo:table-body start-indent="0pt">
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>Committee Action Date: </xsl:text>
															</fo:inline>
															<fo:inline font-size="10pt">
																<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="before">
														<fo:block>
															<xsl:for-each select="n1:Protocol">
																<xsl:for-each select="n1:Submissions">
																	<xsl:for-each select="n1:SubmissionDetails">
																		<xsl:for-each select="n1:ActionType">
																			<xsl:for-each select="n1:ActionDate">
																				<xsl:if test="../../../n1:CurrentSubmissionFlag =&apos;No&apos;">
																					<fo:inline font-size="10pt">
																						<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																						<xsl:text>/</xsl:text>
																						<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																						<xsl:text>/</xsl:text>
																						<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
																					</fo:inline>
																				</xsl:if>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>IACUC Protocol #: </xsl:text>
															</fo:inline>
															<fo:inline font-size="10pt">
																<xsl:text>&#160;&#160;&#160;&#160; </xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="before">
														<fo:block>
															<xsl:for-each select="n1:Protocol">
																<xsl:for-each select="n1:ProtocolMasterData">
																	<xsl:for-each select="n1:ProtocolNumber">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																				<fo:block font-size="10pt">
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline font-size="10pt">
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>Study Title:</xsl:text>
															</fo:inline>
															<fo:inline font-size="10pt">
																<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="before">
														<fo:block>
															<xsl:for-each select="n1:Protocol">
																<xsl:for-each select="n1:ProtocolMasterData">
																	<xsl:for-each select="n1:ProtocolTitle">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																				<fo:block font-size="10pt">
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline font-size="10pt">
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
									</fo:block>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block font-family="Arial" font-size="10pt" margin="0pt">
									<fo:block>
										<fo:inline font-size="10pt">
											<xsl:text> Deactivated action has been performed for the above-referenced protocol.</xsl:text>
										</fo:inline>
									</fo:block>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block margin="0pt">
									<fo:block>
										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x2029;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
											<fo:table-column column-width="27"/>
											<fo:table-column column-width="1000"/>
											<fo:table-body start-indent="0pt">
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" height="19" display-align="center">
														<fo:block>
															<fo:inline font-family="Arial" font-size="10pt">
																<xsl:text>cc:&#160;&#160; </xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" height="19" display-align="center">
														<fo:block>
															<fo:inline font-family="Arial" font-size="10pt">
																<xsl:text>Tom Duff </xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="center">
														<fo:block/>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="before">
														<fo:block>
															<xsl:for-each select="n1:Protocol">
																<xsl:for-each select="n1:Correspondent">
																	<xsl:for-each select="n1:Person">
																		<xsl:for-each select="n1:Fullname">
																			<xsl:if test="../../n1:TypeOfCorrespondent = &apos;CRC&apos;">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																						<fo:block font-family="Arial" font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline font-family="Arial" font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:if>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
									</fo:block>
								</fo:block>
							</xsl:for-each>
						</xsl:for-each>
					</fo:block>
					<fo:block id="SV_RefID_PageTotal"/>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	<xsl:template name="headerall">
		<fo:static-content flow-name="xsl-region-before">
			<fo:block>
				<xsl:for-each select="$XML">
					<fo:inline-container>
						<fo:block>
							<xsl:text>&#x2029;</xsl:text>
						</fo:block>
					</fo:inline-container>
					<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
						<fo:table-column column-width="proportional-column-width(1)"/>
						<fo:table-column column-width="150"/>
						<fo:table-body start-indent="0pt">
							<fo:table-row>
								<fo:table-cell padding="0" number-columns-spanned="2" height="30" display-align="center">
									<fo:block/>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell font-size="smaller" padding="0" text-align="left" display-align="center">
									<fo:block/>
								</fo:table-cell>
								<fo:table-cell font-size="smaller" padding="0" text-align="right" display-align="center">
									<fo:block/>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell padding="0" number-columns-spanned="2" display-align="center">
									<fo:block/>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</xsl:for-each>
			</fo:block>
		</fo:static-content>
	</xsl:template>
	<xsl:template name="double-backslash">
		<xsl:param name="text"/>
		<xsl:param name="text-length"/>
		<xsl:variable name="text-after-bs" select="substring-after($text, \'\\\')"/>
		<xsl:variable name="text-after-bs-length" select="string-length($text-after-bs)"/>
		<xsl:choose>
			<xsl:when test="$text-after-bs-length = 0">
				<xsl:choose>
					<xsl:when test="substring($text, $text-length) = \'\\\'">
						<xsl:value-of select="concat(substring($text,1,$text-length - 1), \'\\\\\')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$text"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="concat(substring($text,1,$text-length - $text-after-bs-length - 1), \'\\\\\')"/>
				<xsl:call-template name="double-backslash">
					<xsl:with-param name="text" select="$text-after-bs"/>
					<xsl:with-param name="text-length" select="$text-after-bs-length"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
','DeactivatedLetter.xslt',UUID(),(SELECT (MAX(ID)) FROM SEQ_IACUC_PROTO_CORRESP_TEMPL),'11',NOW(),'admin',1)
/
INSERT INTO SEQ_IACUC_PROTO_CORRESP_TEMPL VALUES(NULL)
/
INSERT INTO IACUC_PROTO_CORRESP_TEMPL (COMMITTEE_ID,CORRESPONDENCE_TEMPLATE,FILE_NAME,OBJ_ID,PROTO_CORRESP_TEMPL_ID,PROTO_CORRESP_TYPE_CODE,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR)
  VALUES ('DEFAULT','<?xml version="1.0" encoding="UTF-8"?>
<!--Designed and generated by Altova StyleVision Enterprise Edition 2008 rel. 2 - see http://www.altova.com/stylevision for more information.-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:n1="http://xml.coeus.mit.edu/iacuc" xmlns:xdt="http://www.w3.org/2005/xpath-datatypes" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output version="1.0" method="xml" encoding="UTF-8" indent="no"/>
	<xsl:param name="SV_OutputFormat" select="\'PDF\'"/>
	<xsl:variable name="XML" select="/"/>
	<xsl:variable name="fo:layout-master-set">
		<fo:layout-master-set>
			<fo:simple-page-master master-name="default-page" page-height="11in" page-width="8.5in" margin-left="0.6in" margin-right="0.6in">
				<fo:region-body margin-top="0.79in" margin-bottom="0.79in"/>
				<fo:region-before extent="0.79in"/>
			</fo:simple-page-master>
		</fo:layout-master-set>
	</xsl:variable>
	<xsl:template match="/">
		<fo:root>
			<xsl:copy-of select="$fo:layout-master-set"/>
			<fo:page-sequence master-reference="default-page" initial-page-number="1" format="1">
				<xsl:call-template name="headerall"/>
				<fo:flow flow-name="xsl-region-body">
					<fo:block>
						<xsl:for-each select="$XML">
							<fo:external-graphic>
								<xsl:attribute name="src">
									<xsl:text>url(</xsl:text>
									<xsl:call-template name="double-backslash">
										<xsl:with-param name="text">
											<xsl:value-of select="string(&apos;/export/home/www/https/tomcat5.0.25/webapps/coeus/images/couhes_byline2.gif&apos;)"/>
										</xsl:with-param>
										<xsl:with-param name="text-length">
											<xsl:value-of select="string-length(string(&apos;/export/home/www/https/tomcat5.0.25/webapps/coeus/images/couhes_byline2.gif&apos;))"/>
										</xsl:with-param>
									</xsl:call-template>
									<xsl:text>)</xsl:text>
								</xsl:attribute>
							</fo:external-graphic>
							<fo:block text-align="center">
								<fo:leader leader-pattern="rule" rule-thickness="1" leader-length="100%" color="black"/>
							</fo:block>
							<fo:block/>
							<xsl:for-each select="n1:Correspondence">
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block margin="0pt">
									<fo:block>
										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x2029;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
											<fo:table-column column-width="25%"/>
											<fo:table-column column-width="75%"/>
											<fo:table-body start-indent="0pt">
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>To:</xsl:text>
															</fo:inline>
															<fo:inline font-size="10pt">
																<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="before">
														<fo:block>
															<xsl:for-each select="n1:Protocol">
																<xsl:for-each select="n1:Investigator">
																	<xsl:if test="n1:PI_flag = &apos;true&apos;">
																		<xsl:for-each select="n1:Person">
																			<xsl:for-each select="n1:Firstname">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																						<fo:block font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:for-each>
																			<fo:inline font-size="10pt">
																				<xsl:text>&#160;</xsl:text>
																			</fo:inline>
																			<xsl:for-each select="n1:LastName">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																						<fo:block font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:for-each>
																			<fo:inline-container>
																				<fo:block>
																					<xsl:text>&#x2029;</xsl:text>
																				</fo:block>
																			</fo:inline-container>
																			<fo:block white-space="pre" white-space-collapse="false" margin="0pt">
																				<fo:block>
																					<xsl:for-each select="n1:OfficeLocation">
																						<xsl:variable name="value-of-template">
																							<xsl:apply-templates/>
																						</xsl:variable>
																						<xsl:choose>
																							<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																								<fo:block font-family="Book Antiqua" font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:block>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline font-family="Book Antiqua" font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:for-each>
																				</fo:block>
																			</fo:block>
																		</xsl:for-each>
																	</xsl:if>
																</xsl:for-each>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>From:</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="before">
														<fo:block>
															<xsl:for-each select="n1:Protocol">
																<xsl:for-each select="n1:Submissions">
																	<xsl:for-each select="n1:CommitteeMember">
																		<xsl:if test="n1:CommitteeMemberRole/n1:MemberRoleDesc = &apos;Chair&apos;">
																			<xsl:for-each select="n1:Person">
																				<xsl:for-each select="n1:Firstname">
																					<xsl:if test="../../../n1:CurrentSubmissionFlag =&apos;No&apos;">
																						<xsl:variable name="value-of-template">
																							<xsl:apply-templates/>
																						</xsl:variable>
																						<xsl:choose>
																							<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																								<fo:block font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:block>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:if>
																				</xsl:for-each>
																				<fo:inline font-size="10pt">
																					<xsl:text>&#160;</xsl:text>
																				</fo:inline>
																				<xsl:for-each select="n1:LastName">
																					<xsl:if test="../../../n1:CurrentSubmissionFlag =&apos;No&apos;">
																						<xsl:variable name="value-of-template">
																							<xsl:apply-templates/>
																						</xsl:variable>
																						<xsl:choose>
																							<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																								<fo:block font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:block>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:if>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:if>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
															<fo:inline font-size="10pt">
																<xsl:text>, Chair </xsl:text>
															</fo:inline>
															<fo:inline-container>
																<fo:block>
																	<xsl:text>&#x2029;</xsl:text>
																</fo:block>
															</fo:inline-container>
															<fo:block white-space="pre" white-space-collapse="false" margin="0pt">
																<fo:block>
																	<xsl:for-each select="n1:Protocol">
																		<xsl:for-each select="n1:Submissions">
																			<xsl:for-each select="n1:CommitteeMasterData">
																				<xsl:for-each select="n1:CommitteeName">
																					<xsl:if test="../../n1:CurrentSubmissionFlag =&apos;No&apos;">
																						<xsl:variable name="value-of-template">
																							<xsl:apply-templates/>
																						</xsl:variable>
																						<xsl:choose>
																							<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																								<fo:block font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:block>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:if>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:block>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>Date:</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="before">
														<fo:block>
															<xsl:for-each select="n1:CurrentDate">
																<fo:inline font-family="Book Antiqua" font-size="10pt">
																	<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																	<xsl:text>/</xsl:text>
																	<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																	<xsl:text>/</xsl:text>
																	<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
																</fo:inline>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>Committee Action:</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>Disapproved&#160; </xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x2029;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
											<fo:table-column column-width="25%"/>
											<fo:table-column column-width="75%"/>
											<fo:table-body start-indent="0pt">
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>Committee Action Date: </xsl:text>
															</fo:inline>
															<fo:inline font-size="10pt">
																<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="before">
														<fo:block>
															<xsl:for-each select="n1:Protocol">
																<xsl:for-each select="n1:Submissions">
																	<xsl:for-each select="n1:SubmissionDetails">
																		<xsl:for-each select="n1:ActionType">
																			<xsl:for-each select="n1:ActionDate">
																				<xsl:if test="../../../n1:CurrentSubmissionFlag =&apos;No&apos;">
																					<fo:inline font-size="10pt">
																						<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																						<xsl:text>/</xsl:text>
																						<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																						<xsl:text>/</xsl:text>
																						<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
																					</fo:inline>
																				</xsl:if>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>IACUC Protocol #: </xsl:text>
															</fo:inline>
															<fo:inline font-size="10pt">
																<xsl:text>&#160;&#160;&#160;&#160; </xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="before">
														<fo:block>
															<xsl:for-each select="n1:Protocol">
																<xsl:for-each select="n1:ProtocolMasterData">
																	<xsl:for-each select="n1:ProtocolNumber">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																				<fo:block font-size="10pt">
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline font-size="10pt">
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>Study Title:</xsl:text>
															</fo:inline>
															<fo:inline font-size="10pt">
																<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="before">
														<fo:block>
															<xsl:for-each select="n1:Protocol">
																<xsl:for-each select="n1:ProtocolMasterData">
																	<xsl:for-each select="n1:ProtocolTitle">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																				<fo:block font-size="10pt">
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline font-size="10pt">
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
									</fo:block>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block font-family="Arial" font-size="10pt" margin="0pt">
									<fo:block>
										<fo:inline font-size="10pt">
											<xsl:text>The above-referenced protocol has been on DISAPPROVED by the IACUC Committee.&#160;&#160; </xsl:text>
										</fo:inline>
									</fo:block>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block margin="0pt">
									<fo:block>
										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x2029;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
											<fo:table-column column-width="27"/>
											<fo:table-column column-width="1000"/>
											<fo:table-body start-indent="0pt">
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" height="19" display-align="center">
														<fo:block>
															<fo:inline font-family="Arial" font-size="10pt">
																<xsl:text>cc:&#160;&#160; </xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" height="19" display-align="center">
														<fo:block>
															<fo:inline font-family="Arial" font-size="10pt">
																<xsl:text>Tom Duff </xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="center">
														<fo:block/>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="before">
														<fo:block>
															<xsl:for-each select="n1:Protocol">
																<xsl:for-each select="n1:Correspondent">
																	<xsl:for-each select="n1:Person">
																		<xsl:for-each select="n1:Fullname">
																			<xsl:if test="../../n1:TypeOfCorrespondent = &apos;CRC&apos;">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																						<fo:block font-family="Arial" font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline font-family="Arial" font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:if>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
									</fo:block>
								</fo:block>
							</xsl:for-each>
						</xsl:for-each>
					</fo:block>
					<fo:block id="SV_RefID_PageTotal"/>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	<xsl:template name="headerall">
		<fo:static-content flow-name="xsl-region-before">
			<fo:block>
				<xsl:for-each select="$XML">
					<fo:inline-container>
						<fo:block>
							<xsl:text>&#x2029;</xsl:text>
						</fo:block>
					</fo:inline-container>
					<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
						<fo:table-column column-width="proportional-column-width(1)"/>
						<fo:table-column column-width="150"/>
						<fo:table-body start-indent="0pt">
							<fo:table-row>
								<fo:table-cell padding="0" number-columns-spanned="2" height="30" display-align="center">
									<fo:block/>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell font-size="smaller" padding="0" text-align="left" display-align="center">
									<fo:block/>
								</fo:table-cell>
								<fo:table-cell font-size="smaller" padding="0" text-align="right" display-align="center">
									<fo:block/>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell padding="0" number-columns-spanned="2" display-align="center">
									<fo:block/>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</xsl:for-each>
			</fo:block>
		</fo:static-content>
	</xsl:template>
	<xsl:template name="double-backslash">
		<xsl:param name="text"/>
		<xsl:param name="text-length"/>
		<xsl:variable name="text-after-bs" select="substring-after($text, \'\\\')"/>
		<xsl:variable name="text-after-bs-length" select="string-length($text-after-bs)"/>
		<xsl:choose>
			<xsl:when test="$text-after-bs-length = 0">
				<xsl:choose>
					<xsl:when test="substring($text, $text-length) = \'\\\'">
						<xsl:value-of select="concat(substring($text,1,$text-length - 1), \'\\\\\')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$text"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="concat(substring($text,1,$text-length - $text-after-bs-length - 1), \'\\\\\')"/>
				<xsl:call-template name="double-backslash">
					<xsl:with-param name="text" select="$text-after-bs"/>
					<xsl:with-param name="text-length" select="$text-after-bs-length"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
','DisapprovedLetter.xslt',UUID(),(SELECT (MAX(ID)) FROM SEQ_IACUC_PROTO_CORRESP_TEMPL),'12',NOW(),'admin',1)
/
INSERT INTO SEQ_IACUC_PROTO_CORRESP_TEMPL VALUES(NULL)
/
INSERT INTO IACUC_PROTO_CORRESP_TEMPL (COMMITTEE_ID,CORRESPONDENCE_TEMPLATE,FILE_NAME,OBJ_ID,PROTO_CORRESP_TEMPL_ID,PROTO_CORRESP_TYPE_CODE,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR)
  VALUES ('DEFAULT','<?xml version="1.0" encoding="UTF-8"?>
<!--Designed and generated by Altova StyleVision Enterprise Edition 2011 - see http://www.altova.com/stylevision for more information.-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:clitype="clitype" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:iso4217="http://www.xbrl.org/2003/iso4217" xmlns:ix="http://www.xbrl.org/2008/inlineXBRL" xmlns:java="java" xmlns:link="http://www.xbrl.org/2003/linkbase" xmlns:n1="http://xml.coeus.mit.edu/iacuc" xmlns:xbrldi="http://xbrl.org/2006/xbrldi" xmlns:xbrli="http://www.xbrl.org/2003/instance" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:altova="http://www.altova.com" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:svg="http://www.w3.org/2000/svg" exclude-result-prefixes="clitype fn iso4217 ix java link n1 xbrldi xbrli xlink xs xsi altova">
	<xsl:output version="1.0" method="xml" encoding="UTF-8" indent="no"/>
	<xsl:param name="SV_OutputFormat" select="\'PDF\'"/>
	<xsl:variable name="XML" select="/"/>
	<xsl:variable name="fo:layout-master-set">
		<fo:layout-master-set>
			<fo:simple-page-master master-name="page-master-164680496" margin-left="0.60in" margin-right="0.60in" page-height="11in" page-width="8.50in">
				<fo:region-body margin-top="0.79in" margin-bottom="0.79in" column-count="1" column-gap="0.50in"/>
			</fo:simple-page-master>
		</fo:layout-master-set>
	</xsl:variable>
	<xsl:variable name="altova:nPxPerIn" select="96"/>
	<xsl:template match="/">
		<fo:root>
			<xsl:copy-of select="$fo:layout-master-set"/>
			<fo:page-sequence force-page-count="no-force" master-reference="page-master-164680496" initial-page-number="auto" format="1">
				<fo:flow flow-name="xsl-region-body">
					<fo:block>
						<fo:inline-container>
							<fo:block>
								<xsl:text>&#x200B;</xsl:text>
							</fo:block>
						</fo:inline-container>
						<fo:table width="100%" table-layout="fixed" border-spacing="2pt">
							<fo:table-column column-width="90%"/>
							<fo:table-column column-width="10%"/>
							<xsl:variable name="altova:CurrContextGrid_09AB8840" select="."/>
							<fo:table-body start-indent="0pt">
								<xsl:variable name="altova:tablerows">
									<fo:table-row>
										<fo:table-cell font-size="10pt" padding="0" display-align="center">
											<fo:block text-align="left">
												<fo:inline>
													<xsl:text>&#160;</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell font-size="10pt" padding="0" display-align="center">
											<fo:block text-align="right">
												<fo:inline>
													<xsl:text>&#160;</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell number-columns-spanned="2" padding="0" display-align="center">
											<fo:block text-align="left">
												<fo:block text-align="center">
													<fo:leader leader-pattern="rule" rule-thickness="2" leader-length="100%" color="black"/>
												</fo:block>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</xsl:variable>
								<xsl:choose>
									<xsl:when test="string($altova:tablerows)">
										<xsl:copy-of select="$altova:tablerows"/>
									</xsl:when>
									<xsl:otherwise>
										<fo:table-row>
											<fo:table-cell>
												<fo:block/>
											</fo:table-cell>
										</fo:table-row>
									</xsl:otherwise>
								</xsl:choose>
							</fo:table-body>
						</fo:table>
						<fo:block>
							<fo:leader leader-pattern="space"/>
						</fo:block>
						<xsl:for-each select="$XML">
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
							<xsl:for-each select="n1:Correspondence">
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x200B;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:table font-family="inherit" table-layout="fixed" width="100%" border-spacing="2pt">
									<fo:table-column column-width="1.600in"/>
									<fo:table-column column-width="0.430in"/>
									<fo:table-column column-width="6.430in"/>
									<xsl:variable name="altova:CurrContextGrid_09AB8BA0" select="."/>
									<fo:table-body start-indent="0pt">
										<xsl:variable name="altova:tablerows">
											<fo:table-row>
												<fo:table-cell font-weight="bold" padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>To:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:Investigator">
																<xsl:for-each select="n1:Person">
																	<xsl:for-each select="n1:Fullname">
																		<xsl:variable name="value-of-template_0BA68530">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template_0BA68530),\'&#x200B;\')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template_0BA68530"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template_0BA68530"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell font-weight="bold" padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>From:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:Submissions">
																<xsl:for-each select="n1:CommitteeMember">
																	<xsl:for-each select="n1:Person">
																		<xsl:for-each select="n1:Fullname">
																			<xsl:variable name="value-of-template_0BA68610">
																				<xsl:apply-templates/>
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when test="contains(string($value-of-template_0BA68610),\'&#x200B;\')">
																					<fo:block>
																						<xsl:copy-of select="$value-of-template_0BA68610"/>
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline>
																						<xsl:copy-of select="$value-of-template_0BA68610"/>
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
														<fo:inline>
															<xsl:text>, Chair</xsl:text>
														</fo:inline>
														<fo:block/>
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:Submissions">
																<xsl:for-each select="n1:CommitteeMasterData">
																	<xsl:for-each select="n1:CommitteeName">
																		<xsl:variable name="value-of-template_0BA686F0">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template_0BA686F0),\'&#x200B;\')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template_0BA686F0"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template_0BA686F0"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell font-weight="bold" padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Date:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:CurrentDate">
															<fo:inline>
																<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																<xsl:text> / </xsl:text>
																<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																<xsl:text> / </xsl:text>
																<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
															</fo:inline>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell font-weight="bold" padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Committee Action:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Expiration Notification Letter</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell font-weight="bold" padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Action Date:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:Submissions">
																<xsl:for-each select="n1:SubmissionDetails">
																	<xsl:for-each select="n1:ActionType">
																		<xsl:for-each select="n1:ActionDate">
																			<fo:inline>
																				<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																				<xsl:text> / </xsl:text>
																				<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																				<xsl:text> / </xsl:text>
																				<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
																			</fo:inline>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row height="0.38in">
												<fo:table-cell font-weight="bold" padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Protocol Number:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:ProtocolMasterData">
																<xsl:for-each select="n1:ProtocolNumber">
																	<xsl:variable name="value-of-template_0BA68990">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template_0BA68990),\'&#x200B;\')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template_0BA68990"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template_0BA68990"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row height="0.20in">
												<fo:table-cell font-weight="bold" padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Study Title:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:ProtocolMasterData">
																<xsl:for-each select="n1:ProtocolTitle">
																	<xsl:variable name="value-of-template_0BA68A70">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template_0BA68A70),\'&#x200B;\')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template_0BA68A70"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template_0BA68A70"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</xsl:for-each>

														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell font-weight="bold" padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Expiration Date:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:ProtocolMasterData">
																<xsl:for-each select="n1:ExpirationDate">
																	<fo:inline>
																		<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																		<xsl:text> / </xsl:text>
																		<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																		<xsl:text> / </xsl:text>
																		<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
																	</fo:inline>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</xsl:variable>
										<xsl:choose>
											<xsl:when test="string($altova:tablerows)">
												<xsl:copy-of select="$altova:tablerows"/>
											</xsl:when>
											<xsl:otherwise>
												<fo:table-row>
													<fo:table-cell>
														<fo:block/>
													</fo:table-cell>
												</fo:table-row>
											</xsl:otherwise>
										</xsl:choose>
									</fo:table-body>
								</fo:table>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
							</xsl:for-each>
							<fo:block/>
							<xsl:for-each select="n1:Correspondence">
								<xsl:for-each select="n1:Protocol">
									<xsl:for-each select="n1:ProtocolMasterData">
										<fo:block>
											<fo:leader leader-pattern="space"/>
										</fo:block>
										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x200B;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<fo:block margin="0pt">
											<fo:inline>
												<xsl:text>Above mentioned protocol will be expiring on </xsl:text>
											</fo:inline>
											<xsl:for-each select="n1:ExpirationDate">
												<fo:inline>
													<xsl:call-template name="DateToMonthName">
														<xsl:with-param name="sDate" select="string(string(.))"/>
														<xsl:with-param name="sFormat" select="\'long\'"/>
													</xsl:call-template>
													<xsl:text> </xsl:text>
													<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
													<xsl:text>, </xsl:text>
													<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
												</fo:inline>
											</xsl:for-each>
											<fo:inline>
												<xsl:text>.&#160; If you would like to continue the activities covered under this protocol beyond </xsl:text>
											</fo:inline>
											<xsl:for-each select="n1:ExpirationDate">
												<fo:inline>
													<xsl:call-template name="DateToMonthName">
														<xsl:with-param name="sDate" select="string(string(.))"/>
														<xsl:with-param name="sFormat" select="\'long\'"/>
													</xsl:call-template>
													<xsl:text> </xsl:text>
													<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
													<xsl:text>, </xsl:text>
													<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
												</fo:inline>
											</xsl:for-each>
											<fo:inline>
												<xsl:text>, you will need to submit a renewal application in sufficient time for the IACUC to review and approve the renewal by the expiration date.</xsl:text>
											</fo:inline>
										</fo:block>
										<fo:block>
											<fo:leader leader-pattern="space"/>
										</fo:block>
										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x200B;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<fo:block margin="0pt">
											<fo:inline>
												<xsl:text>Note: If the protocol is not renewed before the expiration date, IACUC approval for the work under the above referenced protocol after termination will be in direct violation of federal regulations, University policies and IACUC policies. We are required to notify federal regulatory and granting agencies of any violations.</xsl:text>
											</fo:inline>
										</fo:block>
										<fo:block>
											<fo:leader leader-pattern="space"/>
										</fo:block>
										<fo:block>
											<fo:leader leader-pattern="space"/>
										</fo:block>
										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x200B;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<fo:block margin="0pt">
											<fo:inline>
												<xsl:text>Best Regards.</xsl:text>
											</fo:inline>
										</fo:block>
									</xsl:for-each>
								</xsl:for-each>
							</xsl:for-each>
							<fo:block/>
						</xsl:for-each>
					</fo:block>
					<fo:block id="SV_RefID_PageTotal"/>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	<xsl:template name="DateToMonthName">
		<xsl:param name="sDate"/>
		<xsl:param name="sFormat"/>
		<xsl:choose>
			<xsl:when test="$sFormat = \'long\'">
				<xsl:call-template name="DateToMonthNameLong">
					<xsl:with-param name="sDate" select="$sDate"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="DateToMonthNameShort">
					<xsl:with-param name="sDate" select="$sDate"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="DateToMonthNameLong">
		<xsl:param name="sDate"/>
		<xsl:variable name="nMonth">
			<xsl:call-template name="DateToMonthNum">
				<xsl:with-param name="sDate" select="$sDate"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="$nMonth = 1">January</xsl:when>
			<xsl:when test="$nMonth = 2">February</xsl:when>
			<xsl:when test="$nMonth = 3">March</xsl:when>
			<xsl:when test="$nMonth = 4">April</xsl:when>
			<xsl:when test="$nMonth = 5">May</xsl:when>
			<xsl:when test="$nMonth = 6">June</xsl:when>
			<xsl:when test="$nMonth = 7">July</xsl:when>
			<xsl:when test="$nMonth = 8">August</xsl:when>
			<xsl:when test="$nMonth = 9">September</xsl:when>
			<xsl:when test="$nMonth = 10">October</xsl:when>
			<xsl:when test="$nMonth = 11">November</xsl:when>
			<xsl:otherwise>December</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="DateToMonthNum">
		<xsl:param name="sDate"/>
		<xsl:choose>
			<xsl:when test="starts-with($sDate, \'--\')">
				<xsl:value-of select="number(substring($sDate, 3, 2))"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="number(substring($sDate, 6, 2))"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="DateToMonthNameShort">
		<xsl:param name="sDate"/>
		<xsl:variable name="nMonth">
			<xsl:call-template name="DateToMonthNum">
				<xsl:with-param name="sDate" select="$sDate"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="$nMonth = 1">Jan</xsl:when>
			<xsl:when test="$nMonth = 2">Feb</xsl:when>
			<xsl:when test="$nMonth = 3">Mar</xsl:when>
			<xsl:when test="$nMonth = 4">Apr</xsl:when>
			<xsl:when test="$nMonth = 5">May</xsl:when>
			<xsl:when test="$nMonth = 6">Jun</xsl:when>
			<xsl:when test="$nMonth = 7">Jul</xsl:when>
			<xsl:when test="$nMonth = 8">Aug</xsl:when>
			<xsl:when test="$nMonth = 9">Sep</xsl:when>
			<xsl:when test="$nMonth = 10">Oct</xsl:when>
			<xsl:when test="$nMonth = 11">Nov</xsl:when>
			<xsl:otherwise>Dec</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="double-backslash">
		<xsl:param name="text"/>
		<xsl:param name="text-length"/>
		<xsl:variable name="text-after-bs" select="substring-after($text, \'\\\')"/>
		<xsl:variable name="text-after-bs-length" select="string-length($text-after-bs)"/>
		<xsl:choose>
			<xsl:when test="$text-after-bs-length = 0">
				<xsl:choose>
					<xsl:when test="substring($text, $text-length) = \'\\\'">
						<xsl:value-of select="concat(substring($text,1,$text-length - 1), \'\\\\\')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$text"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="concat(substring($text,1,$text-length - $text-after-bs-length - 1), \'\\\\\')"/>
				<xsl:call-template name="double-backslash">
					<xsl:with-param name="text" select="$text-after-bs"/>
					<xsl:with-param name="text-length" select="$text-after-bs-length"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="altova:MakeValueAbsoluteIfPixels">
		<xsl:param name="sValue"/>
		<xsl:variable name="sBeforePx" select="substring-before($sValue, \'px\')"/>
		<xsl:choose>
			<xsl:when test="$sBeforePx">
				<xsl:variable name="nLengthOfInteger">
					<xsl:call-template name="altova:GetCharCountOfIntegerAtEndOfString">
						<xsl:with-param name="sText" select="$sBeforePx"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:variable name="nPosOfInteger" select="string-length($sBeforePx) - $nLengthOfInteger + 1"/>
				<xsl:variable name="nValuePx" select="substring($sBeforePx, $nPosOfInteger)"/>
				<xsl:variable name="nValueIn" select="number($nValuePx) div number($altova:nPxPerIn)"/>
				<xsl:variable name="nLengthBeforeInteger" select="string-length($sBeforePx) - $nLengthOfInteger"/>
				<xsl:variable name="sRest">
					<xsl:call-template name="altova:MakeValueAbsoluteIfPixels">
						<xsl:with-param name="sValue" select="substring-after($sValue, \'px\')"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="concat(substring($sBeforePx, 1, $nLengthBeforeInteger), string($nValueIn), \'in\', $sRest)"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$sValue"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="altova:GetCharCountOfIntegerAtEndOfString">
		<xsl:param name="sText"/>
		<xsl:variable name="sLen" select="string-length($sText)"/>
		<xsl:variable name="cLast" select="substring($sText, $sLen)"/>
		<xsl:choose>
			<xsl:when test="number($cLast) &gt;= 0 and number($cLast) &lt;= 9">
				<xsl:variable name="nResultOfRest">
					<xsl:call-template name="altova:GetCharCountOfIntegerAtEndOfString">
						<xsl:with-param name="sText" select="substring($sText, 1, $sLen - 1)"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="$nResultOfRest + 1"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text>0</xsl:text>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
','ExpirationNotificationLetter.xslt',UUID(),(SELECT (MAX(ID)) FROM SEQ_IACUC_PROTO_CORRESP_TEMPL),'13',NOW(),'admin',1)
/
INSERT INTO SEQ_IACUC_PROTO_CORRESP_TEMPL VALUES(NULL)
/
INSERT INTO IACUC_PROTO_CORRESP_TEMPL (COMMITTEE_ID,CORRESPONDENCE_TEMPLATE,FILE_NAME,OBJ_ID,PROTO_CORRESP_TEMPL_ID,PROTO_CORRESP_TYPE_CODE,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR)
  VALUES ('DEFAULT','<?xml version="1.0" encoding="UTF-8"?>
<!--Designed and generated by Altova StyleVision Enterprise Edition 2008 rel. 2 - see http://www.altova.com/stylevision for more information.-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:n1="http://xml.coeus.mit.edu/iacuc" xmlns:xdt="http://www.w3.org/2005/xpath-datatypes" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output version="1.0" method="xml" encoding="UTF-8" indent="no"/>
	<xsl:param name="SV_OutputFormat" select="\'PDF\'"/>
	<xsl:variable name="XML" select="/"/>
	<xsl:variable name="fo:layout-master-set">
		<fo:layout-master-set>
			<fo:simple-page-master master-name="default-page" page-height="11in" page-width="8.5in" margin-left="0.6in" margin-right="0.6in">
				<fo:region-body margin-top="0.79in" margin-bottom="0.79in"/>
				<fo:region-before extent="0.79in"/>
			</fo:simple-page-master>
		</fo:layout-master-set>
	</xsl:variable>
	<xsl:template match="/">
		<fo:root>
			<xsl:copy-of select="$fo:layout-master-set"/>
			<fo:page-sequence master-reference="default-page" initial-page-number="1" format="1">
				<xsl:call-template name="headerall"/>
				<fo:flow flow-name="xsl-region-body">
					<fo:block>
						<xsl:for-each select="$XML">
							<fo:external-graphic>
								<xsl:attribute name="src">
									<xsl:text>url(</xsl:text>
									<xsl:call-template name="double-backslash">
										<xsl:with-param name="text">
											<xsl:value-of select="string(&apos;/export/home/www/https/tomcat5.0.25/webapps/coeus/images/couhes_byline2.gif&apos;)"/>
										</xsl:with-param>
										<xsl:with-param name="text-length">
											<xsl:value-of select="string-length(string(&apos;/export/home/www/https/tomcat5.0.25/webapps/coeus/images/couhes_byline2.gif&apos;))"/>
										</xsl:with-param>
									</xsl:call-template>
									<xsl:text>)</xsl:text>
								</xsl:attribute>
							</fo:external-graphic>
							<fo:block text-align="center">
								<fo:leader leader-pattern="rule" rule-thickness="1" leader-length="100%" color="black"/>
							</fo:block>
							<fo:block/>
							<xsl:for-each select="n1:Correspondence">
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block margin="0pt">
									<fo:block>
										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x2029;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
											<fo:table-column column-width="25%"/>
											<fo:table-column column-width="75%"/>
											<fo:table-body start-indent="0pt">
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>To:</xsl:text>
															</fo:inline>
															<fo:inline font-size="10pt">
																<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="before">
														<fo:block>
															<xsl:for-each select="n1:Protocol">
																<xsl:for-each select="n1:Investigator">
																	<xsl:if test="n1:PI_flag = &apos;true&apos;">
																		<xsl:for-each select="n1:Person">
																			<xsl:for-each select="n1:Firstname">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																						<fo:block font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:for-each>
																			<fo:inline font-size="10pt">
																				<xsl:text>&#160;</xsl:text>
																			</fo:inline>
																			<xsl:for-each select="n1:LastName">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																						<fo:block font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:for-each>
																			<fo:inline-container>
																				<fo:block>
																					<xsl:text>&#x2029;</xsl:text>
																				</fo:block>
																			</fo:inline-container>
																			<fo:block white-space="pre" white-space-collapse="false" margin="0pt">
																				<fo:block>
																					<xsl:for-each select="n1:OfficeLocation">
																						<xsl:variable name="value-of-template">
																							<xsl:apply-templates/>
																						</xsl:variable>
																						<xsl:choose>
																							<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																								<fo:block font-family="Book Antiqua" font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:block>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline font-family="Book Antiqua" font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:for-each>
																				</fo:block>
																			</fo:block>
																		</xsl:for-each>
																	</xsl:if>
																</xsl:for-each>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>From:</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="before">
														<fo:block>
															<xsl:for-each select="n1:Protocol">
																<xsl:for-each select="n1:Submissions">
																	<xsl:for-each select="n1:CommitteeMember">
																		<xsl:if test="n1:CommitteeMemberRole/n1:MemberRoleDesc = &apos;Chair&apos;">
																			<xsl:for-each select="n1:Person">
																				<xsl:for-each select="n1:Firstname">
																					<xsl:if test="../../../n1:CurrentSubmissionFlag =&apos;No&apos;">
																						<xsl:variable name="value-of-template">
																							<xsl:apply-templates/>
																						</xsl:variable>
																						<xsl:choose>
																							<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																								<fo:block font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:block>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:if>
																				</xsl:for-each>
																				<fo:inline font-size="10pt">
																					<xsl:text>&#160;</xsl:text>
																				</fo:inline>
																				<xsl:for-each select="n1:LastName">
																					<xsl:if test="../../../n1:CurrentSubmissionFlag =&apos;No&apos;">
																						<xsl:variable name="value-of-template">
																							<xsl:apply-templates/>
																						</xsl:variable>
																						<xsl:choose>
																							<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																								<fo:block font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:block>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:if>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:if>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
															<fo:inline font-size="10pt">
																<xsl:text>, Chair </xsl:text>
															</fo:inline>
															<fo:inline-container>
																<fo:block>
																	<xsl:text>&#x2029;</xsl:text>
																</fo:block>
															</fo:inline-container>
															<fo:block white-space="pre" white-space-collapse="false" margin="0pt">
																<fo:block>
																	<xsl:for-each select="n1:Protocol">
																		<xsl:for-each select="n1:Submissions">
																			<xsl:for-each select="n1:CommitteeMasterData">
																				<xsl:for-each select="n1:CommitteeName">
																					<xsl:if test="../../n1:CurrentSubmissionFlag =&apos;No&apos;">
																						<xsl:variable name="value-of-template">
																							<xsl:apply-templates/>
																						</xsl:variable>
																						<xsl:choose>
																							<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																								<fo:block font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:block>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:if>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:block>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>Date:</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="before">
														<fo:block>
															<xsl:for-each select="n1:CurrentDate">
																<fo:inline font-family="Book Antiqua" font-size="10pt">
																	<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																	<xsl:text>/</xsl:text>
																	<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																	<xsl:text>/</xsl:text>
																	<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
																</fo:inline>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>Committee Action:</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>Expired</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x2029;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
											<fo:table-column column-width="25%"/>
											<fo:table-column column-width="75%"/>
											<fo:table-body start-indent="0pt">
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>Committee Action Date: </xsl:text>
															</fo:inline>
															<fo:inline font-size="10pt">
																<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="before">
														<fo:block>
															<xsl:for-each select="n1:Protocol">
																<xsl:for-each select="n1:Submissions">
																	<xsl:for-each select="n1:SubmissionDetails">
																		<xsl:for-each select="n1:ActionType">
																			<xsl:for-each select="n1:ActionDate">
																				<xsl:if test="../../../n1:CurrentSubmissionFlag =&apos;No&apos;">
																					<fo:inline font-size="10pt">
																						<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																						<xsl:text>/</xsl:text>
																						<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																						<xsl:text>/</xsl:text>
																						<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
																					</fo:inline>
																				</xsl:if>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>IACUC Protocol #: </xsl:text>
															</fo:inline>
															<fo:inline font-size="10pt">
																<xsl:text>&#160;&#160;&#160;&#160; </xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="before">
														<fo:block>
															<xsl:for-each select="n1:Protocol">
																<xsl:for-each select="n1:ProtocolMasterData">
																	<xsl:for-each select="n1:ProtocolNumber">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																				<fo:block font-size="10pt">
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline font-size="10pt">
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>Study Title:</xsl:text>
															</fo:inline>
															<fo:inline font-size="10pt">
																<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="before">
														<fo:block>
															<xsl:for-each select="n1:Protocol">
																<xsl:for-each select="n1:ProtocolMasterData">
																	<xsl:for-each select="n1:ProtocolTitle">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																				<fo:block font-size="10pt">
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline font-size="10pt">
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</fo:block>

													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
									</fo:block>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block font-family="Arial" font-size="10pt" margin="0pt">
									<fo:block>
										<fo:inline font-size="10pt">
											<xsl:text> Expired action has been performed for the above-referenced protocol.</xsl:text>
										</fo:inline>
									</fo:block>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block margin="0pt">
									<fo:block>
										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x2029;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
											<fo:table-column column-width="27"/>
											<fo:table-column column-width="1000"/>
											<fo:table-body start-indent="0pt">
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" height="19" display-align="center">
														<fo:block>
															<fo:inline font-family="Arial" font-size="10pt">
																<xsl:text>cc:&#160;&#160; </xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" height="19" display-align="center">
														<fo:block>
															<fo:inline font-family="Arial" font-size="10pt">
																<xsl:text>Tom Duff </xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="center">
														<fo:block/>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="before">
														<fo:block>
															<xsl:for-each select="n1:Protocol">
																<xsl:for-each select="n1:Correspondent">
																	<xsl:for-each select="n1:Person">
																		<xsl:for-each select="n1:Fullname">
																			<xsl:if test="../../n1:TypeOfCorrespondent = &apos;CRC&apos;">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																						<fo:block font-family="Arial" font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline font-family="Arial" font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:if>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
									</fo:block>
								</fo:block>
							</xsl:for-each>
						</xsl:for-each>
					</fo:block>
					<fo:block id="SV_RefID_PageTotal"/>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	<xsl:template name="headerall">
		<fo:static-content flow-name="xsl-region-before">
			<fo:block>
				<xsl:for-each select="$XML">
					<fo:inline-container>
						<fo:block>
							<xsl:text>&#x2029;</xsl:text>
						</fo:block>
					</fo:inline-container>
					<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
						<fo:table-column column-width="proportional-column-width(1)"/>
						<fo:table-column column-width="150"/>
						<fo:table-body start-indent="0pt">
							<fo:table-row>
								<fo:table-cell padding="0" number-columns-spanned="2" height="30" display-align="center">
									<fo:block/>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell font-size="smaller" padding="0" text-align="left" display-align="center">
									<fo:block/>
								</fo:table-cell>
								<fo:table-cell font-size="smaller" padding="0" text-align="right" display-align="center">
									<fo:block/>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell padding="0" number-columns-spanned="2" display-align="center">
									<fo:block/>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</xsl:for-each>
			</fo:block>
		</fo:static-content>
	</xsl:template>
	<xsl:template name="double-backslash">
		<xsl:param name="text"/>
		<xsl:param name="text-length"/>
		<xsl:variable name="text-after-bs" select="substring-after($text, \'\\\')"/>
		<xsl:variable name="text-after-bs-length" select="string-length($text-after-bs)"/>
		<xsl:choose>
			<xsl:when test="$text-after-bs-length = 0">
				<xsl:choose>
					<xsl:when test="substring($text, $text-length) = \'\\\'">
						<xsl:value-of select="concat(substring($text,1,$text-length - 1), \'\\\\\')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$text"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="concat(substring($text,1,$text-length - $text-after-bs-length - 1), \'\\\\\')"/>
				<xsl:call-template name="double-backslash">
					<xsl:with-param name="text" select="$text-after-bs"/>
					<xsl:with-param name="text-length" select="$text-after-bs-length"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
','ExpiredLetter.xslt',UUID(),(SELECT (MAX(ID)) FROM SEQ_IACUC_PROTO_CORRESP_TEMPL),'14',NOW(),'admin',1)
/
INSERT INTO SEQ_IACUC_PROTO_CORRESP_TEMPL VALUES(NULL)
/
INSERT INTO IACUC_PROTO_CORRESP_TEMPL (COMMITTEE_ID,CORRESPONDENCE_TEMPLATE,FILE_NAME,OBJ_ID,PROTO_CORRESP_TEMPL_ID,PROTO_CORRESP_TYPE_CODE,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR)
  VALUES ('DEFAULT','<?xml version="1.0" encoding="UTF-8"?>
<!--Designed and generated by Altova StyleVision Enterprise Edition 2011 - see http://www.altova.com/stylevision for more information.-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:clitype="clitype" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:iso4217="http://www.xbrl.org/2003/iso4217" xmlns:ix="http://www.xbrl.org/2008/inlineXBRL" xmlns:java="java" xmlns:link="http://www.xbrl.org/2003/linkbase" xmlns:n1="http://xml.coeus.mit.edu/iacuc" xmlns:xbrldi="http://xbrl.org/2006/xbrldi" xmlns:xbrli="http://www.xbrl.org/2003/instance" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:altova="http://www.altova.com" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:svg="http://www.w3.org/2000/svg" exclude-result-prefixes="clitype fn iso4217 ix java link n1 xbrldi xbrli xlink xs xsi altova">
	<xsl:output version="1.0" method="xml" encoding="UTF-8" indent="no"/>
	<xsl:param name="SV_OutputFormat" select="\'PDF\'"/>
	<xsl:variable name="XML" select="/"/>
	<xsl:variable name="fo:layout-master-set">
		<fo:layout-master-set>
			<fo:simple-page-master master-name="page-master-288982480" margin-left="0.60in" margin-right="0.60in" page-height="11in" page-width="8.50in">
				<fo:region-body margin-top="0.79in" margin-bottom="0.79in" column-count="1" column-gap="0.50in"/>
			</fo:simple-page-master>
		</fo:layout-master-set>
	</xsl:variable>
	<xsl:variable name="altova:nPxPerIn" select="96"/>
	<xsl:template match="/">
		<fo:root>
			<xsl:copy-of select="$fo:layout-master-set"/>
			<fo:page-sequence force-page-count="no-force" master-reference="page-master-288982480" initial-page-number="auto" format="1">
				<fo:flow flow-name="xsl-region-body">
					<fo:block>
						<fo:inline-container>
							<fo:block>
								<xsl:text>&#x200B;</xsl:text>
							</fo:block>
						</fo:inline-container>
						<fo:table width="100%" table-layout="fixed" border-spacing="2pt">
							<fo:table-column column-width="90%"/>
							<fo:table-column column-width="10%"/>
							<xsl:variable name="altova:CurrContextGrid_12699A70" select="."/>
							<fo:table-body start-indent="0pt">
								<xsl:variable name="altova:tablerows">
									<fo:table-row>
										<fo:table-cell font-size="10pt" padding="0" display-align="center">
											<fo:block text-align="left">
												<fo:inline>
													<xsl:text>&#160;</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell font-size="10pt" padding="0" display-align="center">
											<fo:block text-align="right">
												<fo:inline>
													<xsl:text>&#160;</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell number-columns-spanned="2" padding="0" display-align="center">
											<fo:block text-align="left">
												<fo:block text-align="center">
													<fo:leader leader-pattern="rule" rule-thickness="2" leader-length="100%" color="black"/>
												</fo:block>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</xsl:variable>
								<xsl:choose>
									<xsl:when test="string($altova:tablerows)">
										<xsl:copy-of select="$altova:tablerows"/>
									</xsl:when>
									<xsl:otherwise>
										<fo:table-row>
											<fo:table-cell>
												<fo:block/>
											</fo:table-cell>
										</fo:table-row>
									</xsl:otherwise>
								</xsl:choose>
							</fo:table-body>
						</fo:table>
						<xsl:for-each select="$XML">
							<xsl:for-each select="n1:Correspondence">
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x200B;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:table font-family="inherit" table-layout="fixed" width="100%" border-spacing="2pt">
									<fo:table-column column-width="1.510in"/>
									<fo:table-column column-width="0.430in"/>
									<fo:table-column column-width="6.430in"/>
									<xsl:variable name="altova:CurrContextGrid_128E01C0" select="."/>
									<fo:table-body start-indent="0pt">
										<xsl:variable name="altova:tablerows">
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>To:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:Investigator">
																<xsl:for-each select="n1:Person">
																	<xsl:for-each select="n1:Fullname">
																		<xsl:variable name="value-of-template_112FAF90">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template_112FAF90),\'&#x200B;\')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template_112FAF90"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template_112FAF90"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>From:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:Submissions">
																<xsl:for-each select="n1:CommitteeMember">
																	<xsl:for-each select="n1:Person">
																		<xsl:for-each select="n1:Fullname">
																			<xsl:variable name="value-of-template_112FAEB0">
																				<xsl:apply-templates/>
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when test="contains(string($value-of-template_112FAEB0),\'&#x200B;\')">
																					<fo:block>
																						<xsl:copy-of select="$value-of-template_112FAEB0"/>
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline>
																						<xsl:copy-of select="$value-of-template_112FAEB0"/>
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
														<fo:inline>
															<xsl:text>, Chair</xsl:text>
														</fo:inline>
														<fo:block/>
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:Submissions">
																<xsl:for-each select="n1:CommitteeMasterData">
																	<xsl:for-each select="n1:CommitteeName">
																		<xsl:variable name="value-of-template_112FB150">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template_112FB150),\'&#x200B;\')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template_112FB150"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template_112FB150"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Date:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:CurrentDate">
															<fo:inline>
																<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																<xsl:text> / </xsl:text>
																<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																<xsl:text> / </xsl:text>
																<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
															</fo:inline>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row height="0.33in">
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Committee Action:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Failed Administrative Preview</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Action Date:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:Submissions">
																<xsl:for-each select="n1:SubmissionDetails">
																	<xsl:for-each select="n1:ActionType">
																		<xsl:for-each select="n1:ActionDate">
																			<fo:inline>
																				<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																				<xsl:text> / </xsl:text>
																				<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																				<xsl:text> / </xsl:text>
																				<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
																			</fo:inline>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row height="0.38in">
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Protocol Number:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:ProtocolMasterData">
																<xsl:for-each select="n1:ProtocolNumber">
																	<xsl:variable name="value-of-template_112FB230">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template_112FB230),\'&#x200B;\')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template_112FB230"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template_112FB230"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row height="0.20in">
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Study Title:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:ProtocolMasterData">
																<xsl:for-each select="n1:ProtocolTitle">
																	<xsl:variable name="value-of-template_112FA510">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template_112FA510),\'&#x200B;\')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template_112FA510"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template_112FA510"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Expiration Date:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:ProtocolMasterData">
																<xsl:for-each select="n1:ExpirationDate">
																	<fo:inline>
																		<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																		<xsl:text> / </xsl:text>
																		<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																		<xsl:text> / </xsl:text>
																		<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
																	</fo:inline>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</xsl:variable>
										<xsl:choose>
											<xsl:when test="string($altova:tablerows)">
												<xsl:copy-of select="$altova:tablerows"/>
											</xsl:when>
											<xsl:otherwise>
												<fo:table-row>
													<fo:table-cell>
														<fo:block/>
													</fo:table-cell>
												</fo:table-row>
											</xsl:otherwise>
										</xsl:choose>
									</fo:table-body>
								</fo:table>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
							</xsl:for-each>
							<fo:block/>
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x200B;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:block margin="0pt">
								<fo:inline>
									<xsl:text>The IACUC has returned your protocol to you in &quot;unfinished status&quot;. This means that your protocol probably requires extensive changes and that you can only edit any and all sections of your protocol and can resubmit to the IACUC office.</xsl:text>
								</fo:inline>
							</fo:block>
							<xsl:for-each select="n1:Correspondence">
								<xsl:for-each select="n1:Protocol">
									<xsl:for-each select="n1:ProtocolMasterData">
										<fo:block>
											<fo:leader leader-pattern="space"/>
										</fo:block>
										<fo:inline>
											<xsl:text> Submitted by IACUC&#160;&#160;&#160;&#160;&#160; :&#160; </xsl:text>
										</fo:inline>
										<xsl:for-each select="n1:PrincipleInvestigatorName">
											<xsl:variable name="value-of-template_0A969808">
												<xsl:apply-templates/>
											</xsl:variable>
											<xsl:choose>
												<xsl:when test="contains(string($value-of-template_0A969808),\'&#x200B;\')">
													<fo:block>
														<xsl:copy-of select="$value-of-template_0A969808"/>
													</fo:block>
												</xsl:when>
												<xsl:otherwise>
													<fo:inline>
														<xsl:copy-of select="$value-of-template_0A969808"/>
													</fo:inline>
												</xsl:otherwise>
											</xsl:choose>
										</xsl:for-each>
										<fo:inline>
											<xsl:text>.</xsl:text>
										</fo:inline>
										<fo:block/>
										<fo:inline>
											<xsl:text> Protocol Number&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; :&#160;&#160; </xsl:text>
										</fo:inline>
										<xsl:for-each select="n1:ProtocolNumber">
											<xsl:variable name="value-of-template_113FE568">
												<xsl:apply-templates/>
											</xsl:variable>
											<xsl:choose>
												<xsl:when test="contains(string($value-of-template_113FE568),\'&#x200B;\')">
													<fo:block>
														<xsl:copy-of select="$value-of-template_113FE568"/>
													</fo:block>
												</xsl:when>
												<xsl:otherwise>
													<fo:inline>
														<xsl:copy-of select="$value-of-template_113FE568"/>
													</fo:inline>
												</xsl:otherwise>
											</xsl:choose>
										</xsl:for-each>
										<fo:inline>
											<xsl:text>.</xsl:text>
										</fo:inline>
										<fo:block/>
										<fo:inline>
											<xsl:text> Title&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; :&#160;&#160; </xsl:text>
										</fo:inline>
										<xsl:for-each select="n1:ProtocolTitle">
											<xsl:variable name="value-of-template_113FE648">
												<xsl:apply-templates/>
											</xsl:variable>
											<xsl:choose>
												<xsl:when test="contains(string($value-of-template_113FE648),\'&#x200B;\')">
													<fo:block>
														<xsl:copy-of select="$value-of-template_113FE648"/>
													</fo:block>
												</xsl:when>
												<xsl:otherwise>
													<fo:inline>
														<xsl:copy-of select="$value-of-template_113FE648"/>
													</fo:inline>
												</xsl:otherwise>
											</xsl:choose>
										</xsl:for-each>
										<fo:inline>
											<xsl:text>.</xsl:text>
										</fo:inline>
										<fo:block/>
									</xsl:for-each>
								</xsl:for-each>
							</xsl:for-each>
							<fo:block/>
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x200B;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:block margin="0pt">
								<fo:inline>
									<xsl:text>Thank you.</xsl:text>
								</fo:inline>
							</fo:block>
						</xsl:for-each>
					</fo:block>
					<fo:block id="SV_RefID_PageTotal"/>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	<xsl:template name="double-backslash">
		<xsl:param name="text"/>
		<xsl:param name="text-length"/>
		<xsl:variable name="text-after-bs" select="substring-after($text, \'\\\')"/>
		<xsl:variable name="text-after-bs-length" select="string-length($text-after-bs)"/>
		<xsl:choose>
			<xsl:when test="$text-after-bs-length = 0">
				<xsl:choose>
					<xsl:when test="substring($text, $text-length) = \'\\\'">
						<xsl:value-of select="concat(substring($text,1,$text-length - 1), \'\\\\\')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$text"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="concat(substring($text,1,$text-length - $text-after-bs-length - 1), \'\\\\\')"/>
				<xsl:call-template name="double-backslash">
					<xsl:with-param name="text" select="$text-after-bs"/>
					<xsl:with-param name="text-length" select="$text-after-bs-length"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="altova:MakeValueAbsoluteIfPixels">
		<xsl:param name="sValue"/>
		<xsl:variable name="sBeforePx" select="substring-before($sValue, \'px\')"/>
		<xsl:choose>
			<xsl:when test="$sBeforePx">
				<xsl:variable name="nLengthOfInteger">
					<xsl:call-template name="altova:GetCharCountOfIntegerAtEndOfString">
						<xsl:with-param name="sText" select="$sBeforePx"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:variable name="nPosOfInteger" select="string-length($sBeforePx) - $nLengthOfInteger + 1"/>
				<xsl:variable name="nValuePx" select="substring($sBeforePx, $nPosOfInteger)"/>
				<xsl:variable name="nValueIn" select="number($nValuePx) div number($altova:nPxPerIn)"/>
				<xsl:variable name="nLengthBeforeInteger" select="string-length($sBeforePx) - $nLengthOfInteger"/>
				<xsl:variable name="sRest">
					<xsl:call-template name="altova:MakeValueAbsoluteIfPixels">
						<xsl:with-param name="sValue" select="substring-after($sValue, \'px\')"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="concat(substring($sBeforePx, 1, $nLengthBeforeInteger), string($nValueIn), \'in\', $sRest)"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$sValue"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="altova:GetCharCountOfIntegerAtEndOfString">
		<xsl:param name="sText"/>
		<xsl:variable name="sLen" select="string-length($sText)"/>
		<xsl:variable name="cLast" select="substring($sText, $sLen)"/>
		<xsl:choose>
			<xsl:when test="number($cLast) &gt;= 0 and number($cLast) &lt;= 9">
				<xsl:variable name="nResultOfRest">
					<xsl:call-template name="altova:GetCharCountOfIntegerAtEndOfString">
						<xsl:with-param name="sText" select="substring($sText, 1, $sLen - 1)"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="$nResultOfRest + 1"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text>0</xsl:text>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
','FailedAdministrativePreReview.xslt',UUID(),(SELECT (MAX(ID)) FROM SEQ_IACUC_PROTO_CORRESP_TEMPL),'15',NOW(),'admin',1)
/
INSERT INTO SEQ_IACUC_PROTO_CORRESP_TEMPL VALUES(NULL)
/
INSERT INTO IACUC_PROTO_CORRESP_TEMPL (COMMITTEE_ID,CORRESPONDENCE_TEMPLATE,FILE_NAME,OBJ_ID,PROTO_CORRESP_TEMPL_ID,PROTO_CORRESP_TYPE_CODE,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR)
  VALUES ('DEFAULT','<?xml version="1.0" encoding="UTF-8"?>
<!--Designed and generated by Altova StyleVision Enterprise Edition 2008 rel. 2 - see http://www.altova.com/stylevision for more information.-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:n1="http://xml.coeus.mit.edu/iacuc" xmlns:xdt="http://www.w3.org/2005/xpath-datatypes" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output version="1.0" method="xml" encoding="UTF-8" indent="no"/>
	<xsl:param name="SV_OutputFormat" select="\'PDF\'"/>
	<xsl:variable name="XML" select="/"/>
	<xsl:variable name="fo:layout-master-set">
		<fo:layout-master-set>
			<fo:simple-page-master master-name="default-page" page-height="11in" page-width="8.5in" margin-left="0.6in" margin-right="0.6in">
				<fo:region-body margin-top="0.79in" margin-bottom="0.79in"/>
				<fo:region-before extent="0.79in"/>
			</fo:simple-page-master>
		</fo:layout-master-set>
	</xsl:variable>
	<xsl:template match="/">
		<fo:root>
			<xsl:copy-of select="$fo:layout-master-set"/>
			<fo:page-sequence master-reference="default-page" initial-page-number="1" format="1">
				<xsl:call-template name="headerall"/>
				<fo:flow flow-name="xsl-region-body">
					<fo:block>
						<xsl:for-each select="$XML">
							<fo:external-graphic>
								<xsl:attribute name="src">
									<xsl:text>url(</xsl:text>
									<xsl:call-template name="double-backslash">
										<xsl:with-param name="text">
											<xsl:value-of select="string(&apos;/export/home/www/https/tomcat5.0.25/webapps/coeus/images/couhes_byline2.gif&apos;)"/>
										</xsl:with-param>
										<xsl:with-param name="text-length">
											<xsl:value-of select="string-length(string(&apos;/export/home/www/https/tomcat5.0.25/webapps/coeus/images/couhes_byline2.gif&apos;))"/>
										</xsl:with-param>
									</xsl:call-template>
									<xsl:text>)</xsl:text>
								</xsl:attribute>
							</fo:external-graphic>
							<fo:block text-align="center">
								<fo:leader leader-pattern="rule" rule-thickness="1" leader-length="100%" color="black"/>
							</fo:block>
							<fo:block/>
							<xsl:for-each select="n1:Correspondence">
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block margin="0pt">
									<fo:block>
										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x2029;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
											<fo:table-column column-width="25%"/>
											<fo:table-column column-width="75%"/>
											<fo:table-body start-indent="0pt">
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>To:</xsl:text>
															</fo:inline>
															<fo:inline font-size="10pt">
																<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="before">
														<fo:block>
															<xsl:for-each select="n1:Protocol">
																<xsl:for-each select="n1:Investigator">
																	<xsl:if test="n1:PI_flag = &apos;true&apos;">
																		<xsl:for-each select="n1:Person">
																			<xsl:for-each select="n1:Firstname">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																						<fo:block font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:for-each>
																			<fo:inline font-size="10pt">
																				<xsl:text>&#160;</xsl:text>
																			</fo:inline>
																			<xsl:for-each select="n1:LastName">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																						<fo:block font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:for-each>
																			<fo:inline-container>
																				<fo:block>
																					<xsl:text>&#x2029;</xsl:text>
																				</fo:block>
																			</fo:inline-container>
																			<fo:block white-space="pre" white-space-collapse="false" margin="0pt">
																				<fo:block>
																					<xsl:for-each select="n1:OfficeLocation">
																						<xsl:variable name="value-of-template">
																							<xsl:apply-templates/>
																						</xsl:variable>
																						<xsl:choose>
																							<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																								<fo:block font-family="Book Antiqua" font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:block>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline font-family="Book Antiqua" font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:for-each>
																				</fo:block>
																			</fo:block>
																		</xsl:for-each>
																	</xsl:if>
																</xsl:for-each>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>From:</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="before">
														<fo:block>
															<xsl:for-each select="n1:Protocol">
																<xsl:for-each select="n1:Submissions">
																	<xsl:for-each select="n1:CommitteeMember">
																		<xsl:if test="n1:CommitteeMemberRole/n1:MemberRoleDesc = &apos;Chair&apos;">
																			<xsl:for-each select="n1:Person">
																				<xsl:for-each select="n1:Firstname">
																					<xsl:if test="../../../n1:CurrentSubmissionFlag =&apos;No&apos;">
																						<xsl:variable name="value-of-template">
																							<xsl:apply-templates/>
																						</xsl:variable>
																						<xsl:choose>
																							<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																								<fo:block font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:block>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:if>
																				</xsl:for-each>
																				<fo:inline font-size="10pt">
																					<xsl:text>&#160;</xsl:text>
																				</fo:inline>
																				<xsl:for-each select="n1:LastName">
																					<xsl:if test="../../../n1:CurrentSubmissionFlag =&apos;No&apos;">
																						<xsl:variable name="value-of-template">
																							<xsl:apply-templates/>
																						</xsl:variable>
																						<xsl:choose>
																							<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																								<fo:block font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:block>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:if>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:if>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
															<fo:inline font-size="10pt">
																<xsl:text>, Chair </xsl:text>
															</fo:inline>
															<fo:inline-container>
																<fo:block>
																	<xsl:text>&#x2029;</xsl:text>
																</fo:block>
															</fo:inline-container>
															<fo:block white-space="pre" white-space-collapse="false" margin="0pt">
																<fo:block>
																	<xsl:for-each select="n1:Protocol">
																		<xsl:for-each select="n1:Submissions">
																			<xsl:for-each select="n1:CommitteeMasterData">
																				<xsl:for-each select="n1:CommitteeName">
																					<xsl:if test="../../n1:CurrentSubmissionFlag =&apos;No&apos;">
																						<xsl:variable name="value-of-template">
																							<xsl:apply-templates/>
																						</xsl:variable>
																						<xsl:choose>
																							<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																								<fo:block font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:block>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:if>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:block>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>Date:</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="before">
														<fo:block>
															<xsl:for-each select="n1:CurrentDate">
																<fo:inline font-family="Book Antiqua" font-size="10pt">
																	<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																	<xsl:text>/</xsl:text>
																	<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																	<xsl:text>/</xsl:text>
																	<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
																</fo:inline>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>Committee Action:</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>Hold</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x2029;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
											<fo:table-column column-width="25%"/>
											<fo:table-column column-width="75%"/>
											<fo:table-body start-indent="0pt">
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>Committee Action Date: </xsl:text>
															</fo:inline>
															<fo:inline font-size="10pt">
																<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="before">
														<fo:block>
															<xsl:for-each select="n1:Protocol">
																<xsl:for-each select="n1:Submissions">
																	<xsl:for-each select="n1:SubmissionDetails">
																		<xsl:for-each select="n1:ActionType">
																			<xsl:for-each select="n1:ActionDate">
																				<xsl:if test="../../../n1:CurrentSubmissionFlag =&apos;No&apos;">
																					<fo:inline font-size="10pt">
																						<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																						<xsl:text>/</xsl:text>
																						<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																						<xsl:text>/</xsl:text>
																						<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
																					</fo:inline>
																				</xsl:if>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>IACUC Protocol #: </xsl:text>
															</fo:inline>
															<fo:inline font-size="10pt">
																<xsl:text>&#160;&#160;&#160;&#160; </xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="before">
														<fo:block>
															<xsl:for-each select="n1:Protocol">
																<xsl:for-each select="n1:ProtocolMasterData">
																	<xsl:for-each select="n1:ProtocolNumber">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																				<fo:block font-size="10pt">
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline font-size="10pt">
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>Study Title:</xsl:text>
															</fo:inline>
															<fo:inline font-size="10pt">
																<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="before">
														<fo:block>
															<xsl:for-each select="n1:Protocol">
																<xsl:for-each select="n1:ProtocolMasterData">
																	<xsl:for-each select="n1:ProtocolTitle">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																				<fo:block font-size="10pt">
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline font-size="10pt">
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
									</fo:block>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block font-family="Arial" font-size="10pt" margin="0pt">
									<fo:block>
										<fo:inline font-size="10pt">
											<xsl:text>The above-referenced protocol has been on HOLD by the IACUC Committee.&#160;&#160; </xsl:text>
										</fo:inline>
									</fo:block>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block margin="0pt">
									<fo:block>
										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x2029;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
											<fo:table-column column-width="27"/>
											<fo:table-column column-width="1000"/>
											<fo:table-body start-indent="0pt">
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" height="19" display-align="center">
														<fo:block>
															<fo:inline font-family="Arial" font-size="10pt">
																<xsl:text>cc:&#160;&#160; </xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" height="19" display-align="center">
														<fo:block>
															<fo:inline font-family="Arial" font-size="10pt">
																<xsl:text>Tom Duff </xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="center">
														<fo:block/>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="before">
														<fo:block>
															<xsl:for-each select="n1:Protocol">
																<xsl:for-each select="n1:Correspondent">
																	<xsl:for-each select="n1:Person">
																		<xsl:for-each select="n1:Fullname">
																			<xsl:if test="../../n1:TypeOfCorrespondent = &apos;CRC&apos;">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																						<fo:block font-family="Arial" font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline font-family="Arial" font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:if>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
									</fo:block>
								</fo:block>
							</xsl:for-each>
						</xsl:for-each>
					</fo:block>
					<fo:block id="SV_RefID_PageTotal"/>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	<xsl:template name="headerall">
		<fo:static-content flow-name="xsl-region-before">
			<fo:block>
				<xsl:for-each select="$XML">
					<fo:inline-container>
						<fo:block>
							<xsl:text>&#x2029;</xsl:text>
						</fo:block>
					</fo:inline-container>
					<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
						<fo:table-column column-width="proportional-column-width(1)"/>
						<fo:table-column column-width="150"/>
						<fo:table-body start-indent="0pt">
							<fo:table-row>
								<fo:table-cell padding="0" number-columns-spanned="2" height="30" display-align="center">
									<fo:block/>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell font-size="smaller" padding="0" text-align="left" display-align="center">
									<fo:block/>
								</fo:table-cell>
								<fo:table-cell font-size="smaller" padding="0" text-align="right" display-align="center">
									<fo:block/>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell padding="0" number-columns-spanned="2" display-align="center">
									<fo:block/>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</xsl:for-each>
			</fo:block>
		</fo:static-content>
	</xsl:template>
	<xsl:template name="double-backslash">
		<xsl:param name="text"/>
		<xsl:param name="text-length"/>
		<xsl:variable name="text-after-bs" select="substring-after($text, \'\\\')"/>
		<xsl:variable name="text-after-bs-length" select="string-length($text-after-bs)"/>
		<xsl:choose>
			<xsl:when test="$text-after-bs-length = 0">
				<xsl:choose>
					<xsl:when test="substring($text, $text-length) = \'\\\'">
						<xsl:value-of select="concat(substring($text,1,$text-length - 1), \'\\\\\')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$text"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="concat(substring($text,1,$text-length - $text-after-bs-length - 1), \'\\\\\')"/>
				<xsl:call-template name="double-backslash">
					<xsl:with-param name="text" select="$text-after-bs"/>
					<xsl:with-param name="text-length" select="$text-after-bs-length"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
','HoldLetter.xslt',UUID(),(SELECT (MAX(ID)) FROM SEQ_IACUC_PROTO_CORRESP_TEMPL),'16',NOW(),'admin',1)
/
INSERT INTO SEQ_IACUC_PROTO_CORRESP_TEMPL VALUES(NULL)
/
INSERT INTO IACUC_PROTO_CORRESP_TEMPL (COMMITTEE_ID,CORRESPONDENCE_TEMPLATE,FILE_NAME,OBJ_ID,PROTO_CORRESP_TEMPL_ID,PROTO_CORRESP_TYPE_CODE,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR)
  VALUES ('DEFAULT','<?xml version="1.0" encoding="UTF-8"?>
<!--Designed and generated by Altova StyleVision Enterprise Edition 2008 rel. 2 - see http://www.altova.com/stylevision for more information.-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:n1="http://xml.coeus.mit.edu/iacuc" xmlns:xdt="http://www.w3.org/2005/xpath-datatypes" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output version="1.0" method="xml" encoding="UTF-8" indent="no"/>
	<xsl:param name="SV_OutputFormat" select="\'PDF\'"/>
	<xsl:variable name="XML" select="/"/>
	<xsl:variable name="fo:layout-master-set">
		<fo:layout-master-set>
			<fo:simple-page-master master-name="default-page" page-height="11in" page-width="8.5in" margin-left="0.6in" margin-right="0.6in">
				<fo:region-body margin-top="0.79in" margin-bottom="0.79in"/>
				<fo:region-before extent="0.79in"/>
			</fo:simple-page-master>
		</fo:layout-master-set>
	</xsl:variable>
	<xsl:template match="/">
		<fo:root>
			<xsl:copy-of select="$fo:layout-master-set"/>
			<fo:page-sequence master-reference="default-page" initial-page-number="1" format="1">
				<xsl:call-template name="headerall"/>
				<fo:flow flow-name="xsl-region-body">
					<fo:block>
						<xsl:for-each select="$XML">
							<fo:external-graphic>
								<xsl:attribute name="src">
									<xsl:text>url(</xsl:text>
									<xsl:call-template name="double-backslash">
										<xsl:with-param name="text">
											<xsl:value-of select="string(&apos;/export/home/www/https/tomcat5.0.25/webapps/coeus/images/couhes_byline2.gif&apos;)"/>
										</xsl:with-param>
										<xsl:with-param name="text-length">
											<xsl:value-of select="string-length(string(&apos;/export/home/www/https/tomcat5.0.25/webapps/coeus/images/couhes_byline2.gif&apos;))"/>
										</xsl:with-param>
									</xsl:call-template>
									<xsl:text>)</xsl:text>
								</xsl:attribute>
							</fo:external-graphic>
							<fo:block text-align="center">
								<fo:leader leader-pattern="rule" rule-thickness="1" leader-length="100%" color="black"/>
							</fo:block>
							<fo:block/>
							<xsl:for-each select="n1:Correspondence">
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block margin="0pt">
									<fo:block>
										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x2029;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
											<fo:table-column column-width="25%"/>
											<fo:table-column column-width="75%"/>
											<fo:table-body start-indent="0pt">
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>To:</xsl:text>
															</fo:inline>
															<fo:inline font-size="10pt">
																<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="before">
														<fo:block>
															<xsl:for-each select="n1:Protocol">
																<xsl:for-each select="n1:Investigator">
																	<xsl:if test="n1:PI_flag = &apos;true&apos;">
																		<xsl:for-each select="n1:Person">
																			<xsl:for-each select="n1:Firstname">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																						<fo:block font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:for-each>
																			<fo:inline font-size="10pt">
																				<xsl:text>&#160;</xsl:text>
																			</fo:inline>
																			<xsl:for-each select="n1:LastName">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																						<fo:block font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:for-each>
																			<fo:inline-container>
																				<fo:block>
																					<xsl:text>&#x2029;</xsl:text>
																				</fo:block>
																			</fo:inline-container>
																			<fo:block white-space="pre" white-space-collapse="false" margin="0pt">
																				<fo:block>
																					<xsl:for-each select="n1:OfficeLocation">
																						<xsl:variable name="value-of-template">
																							<xsl:apply-templates/>
																						</xsl:variable>
																						<xsl:choose>
																							<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																								<fo:block font-family="Book Antiqua" font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:block>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline font-family="Book Antiqua" font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:for-each>
																				</fo:block>
																			</fo:block>
																		</xsl:for-each>
																	</xsl:if>
																</xsl:for-each>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>From:</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="before">
														<fo:block>
															<xsl:for-each select="n1:Protocol">
																<xsl:for-each select="n1:Submissions">
																	<xsl:for-each select="n1:CommitteeMember">
																		<xsl:if test="n1:CommitteeMemberRole/n1:MemberRoleDesc = &apos;Chair&apos;">
																			<xsl:for-each select="n1:Person">
																				<xsl:for-each select="n1:Firstname">
																					<xsl:if test="../../../n1:CurrentSubmissionFlag =&apos;No&apos;">
																						<xsl:variable name="value-of-template">
																							<xsl:apply-templates/>
																						</xsl:variable>
																						<xsl:choose>
																							<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																								<fo:block font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:block>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:if>
																				</xsl:for-each>
																				<fo:inline font-size="10pt">
																					<xsl:text>&#160;</xsl:text>
																				</fo:inline>
																				<xsl:for-each select="n1:LastName">
																					<xsl:if test="../../../n1:CurrentSubmissionFlag =&apos;No&apos;">
																						<xsl:variable name="value-of-template">
																							<xsl:apply-templates/>
																						</xsl:variable>
																						<xsl:choose>
																							<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																								<fo:block font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:block>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:if>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:if>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
															<fo:inline font-size="10pt">
																<xsl:text>, Chair </xsl:text>
															</fo:inline>
															<fo:inline-container>
																<fo:block>
																	<xsl:text>&#x2029;</xsl:text>
																</fo:block>
															</fo:inline-container>
															<fo:block white-space="pre" white-space-collapse="false" margin="0pt">
																<fo:block>
																	<xsl:for-each select="n1:Protocol">
																		<xsl:for-each select="n1:Submissions">
																			<xsl:for-each select="n1:CommitteeMasterData">
																				<xsl:for-each select="n1:CommitteeName">
																					<xsl:if test="../../n1:CurrentSubmissionFlag =&apos;No&apos;">
																						<xsl:variable name="value-of-template">
																							<xsl:apply-templates/>
																						</xsl:variable>
																						<xsl:choose>
																							<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																								<fo:block font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:block>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:if>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:block>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>Date:</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="before">
														<fo:block>
															<xsl:for-each select="n1:CurrentDate">
																<fo:inline font-family="Book Antiqua" font-size="10pt">
																	<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																	<xsl:text>/</xsl:text>
																	<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																	<xsl:text>/</xsl:text>
																	<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
																</fo:inline>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>Committee Action:</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>Lift Hold</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x2029;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
											<fo:table-column column-width="25%"/>
											<fo:table-column column-width="75%"/>
											<fo:table-body start-indent="0pt">
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>Committee Action Date: </xsl:text>
															</fo:inline>
															<fo:inline font-size="10pt">
																<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="before">
														<fo:block>
															<xsl:for-each select="n1:Protocol">
																<xsl:for-each select="n1:Submissions">
																	<xsl:for-each select="n1:SubmissionDetails">
																		<xsl:for-each select="n1:ActionType">
																			<xsl:for-each select="n1:ActionDate">
																				<xsl:if test="../../../n1:CurrentSubmissionFlag =&apos;No&apos;">
																					<fo:inline font-size="10pt">
																						<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																						<xsl:text>/</xsl:text>
																						<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																						<xsl:text>/</xsl:text>
																						<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
																					</fo:inline>
																				</xsl:if>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>IACUC Protocol #: </xsl:text>
															</fo:inline>
															<fo:inline font-size="10pt">
																<xsl:text>&#160;&#160;&#160;&#160; </xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="before">
														<fo:block>
															<xsl:for-each select="n1:Protocol">
																<xsl:for-each select="n1:ProtocolMasterData">
																	<xsl:for-each select="n1:ProtocolNumber">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																				<fo:block font-size="10pt">
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline font-size="10pt">
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>Study Title:</xsl:text>
															</fo:inline>
															<fo:inline font-size="10pt">
																<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="before">
														<fo:block>
															<xsl:for-each select="n1:Protocol">
																<xsl:for-each select="n1:ProtocolMasterData">
																	<xsl:for-each select="n1:ProtocolTitle">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																				<fo:block font-size="10pt">
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline font-size="10pt">
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
									</fo:block>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block font-family="Arial" font-size="10pt" margin="0pt">
									<fo:block>
										<fo:inline font-size="10pt">
											<xsl:text>The above-referenced protocol has been LIFT HOLD by the IACUC Committee.&#160;&#160; </xsl:text>
										</fo:inline>
									</fo:block>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block margin="0pt">
									<fo:block>
										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x2029;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
											<fo:table-column column-width="27"/>
											<fo:table-column column-width="1000"/>
											<fo:table-body start-indent="0pt">
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" height="19" display-align="center">
														<fo:block>
															<fo:inline font-family="Arial" font-size="10pt">
																<xsl:text>cc:&#160;&#160; </xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" height="19" display-align="center">
														<fo:block>
															<fo:inline font-family="Arial" font-size="10pt">
																<xsl:text>Tom Duff </xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="center">
														<fo:block/>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="before">
														<fo:block>
															<xsl:for-each select="n1:Protocol">
																<xsl:for-each select="n1:Correspondent">
																	<xsl:for-each select="n1:Person">
																		<xsl:for-each select="n1:Fullname">
																			<xsl:if test="../../n1:TypeOfCorrespondent = &apos;CRC&apos;">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																						<fo:block font-family="Arial" font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline font-family="Arial" font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:if>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
									</fo:block>
								</fo:block>
							</xsl:for-each>
						</xsl:for-each>
					</fo:block>
					<fo:block id="SV_RefID_PageTotal"/>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	<xsl:template name="headerall">
		<fo:static-content flow-name="xsl-region-before">
			<fo:block>
				<xsl:for-each select="$XML">
					<fo:inline-container>
						<fo:block>
							<xsl:text>&#x2029;</xsl:text>
						</fo:block>
					</fo:inline-container>
					<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
						<fo:table-column column-width="proportional-column-width(1)"/>
						<fo:table-column column-width="150"/>
						<fo:table-body start-indent="0pt">
							<fo:table-row>
								<fo:table-cell padding="0" number-columns-spanned="2" height="30" display-align="center">
									<fo:block/>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell font-size="smaller" padding="0" text-align="left" display-align="center">
									<fo:block/>
								</fo:table-cell>
								<fo:table-cell font-size="smaller" padding="0" text-align="right" display-align="center">
									<fo:block/>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell padding="0" number-columns-spanned="2" display-align="center">
									<fo:block/>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</xsl:for-each>
			</fo:block>
		</fo:static-content>
	</xsl:template>
	<xsl:template name="double-backslash">
		<xsl:param name="text"/>
		<xsl:param name="text-length"/>
		<xsl:variable name="text-after-bs" select="substring-after($text, \'\\\')"/>
		<xsl:variable name="text-after-bs-length" select="string-length($text-after-bs)"/>
		<xsl:choose>
			<xsl:when test="$text-after-bs-length = 0">
				<xsl:choose>
					<xsl:when test="substring($text, $text-length) = \'\\\'">
						<xsl:value-of select="concat(substring($text,1,$text-length - 1), \'\\\\\')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$text"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="concat(substring($text,1,$text-length - $text-after-bs-length - 1), \'\\\\\')"/>
				<xsl:call-template name="double-backslash">
					<xsl:with-param name="text" select="$text-after-bs"/>
					<xsl:with-param name="text-length" select="$text-after-bs-length"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
','LiftHoldLetter.xslt',UUID(),(SELECT (MAX(ID)) FROM SEQ_IACUC_PROTO_CORRESP_TEMPL),'17',NOW(),'admin',1)
/
INSERT INTO SEQ_IACUC_PROTO_CORRESP_TEMPL VALUES(NULL)
/
INSERT INTO IACUC_PROTO_CORRESP_TEMPL (COMMITTEE_ID,CORRESPONDENCE_TEMPLATE,FILE_NAME,OBJ_ID,PROTO_CORRESP_TEMPL_ID,PROTO_CORRESP_TYPE_CODE,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR)
  VALUES ('DEFAULT','<?xml version="1.0" encoding="UTF-8"?>
<!--Designed and generated by Altova StyleVision Enterprise Edition 2011 - see http://www.altova.com/stylevision for more information.-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:clitype="clitype" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:iso4217="http://www.xbrl.org/2003/iso4217" xmlns:ix="http://www.xbrl.org/2008/inlineXBRL" xmlns:java="java" xmlns:link="http://www.xbrl.org/2003/linkbase" xmlns:n1="http://xml.coeus.mit.edu/iacuc" xmlns:xbrldi="http://xbrl.org/2006/xbrldi" xmlns:xbrli="http://www.xbrl.org/2003/instance" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:altova="http://www.altova.com" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:svg="http://www.w3.org/2000/svg" exclude-result-prefixes="clitype fn iso4217 ix java link n1 xbrldi xbrli xlink xs xsi altova">
	<xsl:output version="1.0" method="xml" encoding="UTF-8" indent="no"/>
	<xsl:param name="SV_OutputFormat" select="\'PDF\'"/>
	<xsl:variable name="XML" select="/"/>
	<xsl:variable name="fo:layout-master-set">
		<fo:layout-master-set>
			<fo:simple-page-master master-name="page-master-336725272" margin-left="0.60in" margin-right="0.60in" page-height="11in" page-width="8.50in">
				<fo:region-body margin-top="0.79in" margin-bottom="0.79in" column-count="1" column-gap="0.50in"/>
			</fo:simple-page-master>
		</fo:layout-master-set>
	</xsl:variable>
	<xsl:variable name="altova:nPxPerIn" select="96"/>
	<xsl:template match="/">
		<fo:root>
			<xsl:copy-of select="$fo:layout-master-set"/>
			<fo:page-sequence force-page-count="no-force" master-reference="page-master-336725272" initial-page-number="auto" format="1">
				<fo:flow flow-name="xsl-region-body">
					<fo:block>
						<fo:inline-container>
							<fo:block>
								<xsl:text>&#x200B;</xsl:text>
							</fo:block>
						</fo:inline-container>
						<fo:table width="100%" table-layout="fixed" border-spacing="2pt">
							<fo:table-column column-width="90%"/>
							<fo:table-column column-width="10%"/>
							<xsl:variable name="altova:CurrContextGrid_14126598" select="."/>
							<fo:table-body start-indent="0pt">
								<xsl:variable name="altova:tablerows">
									<fo:table-row>
										<fo:table-cell font-size="10pt" padding="0" display-align="center">
											<fo:block text-align="left">
												<fo:inline>
													<xsl:text>&#160;</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell font-size="10pt" padding="0" display-align="center">
											<fo:block text-align="right">
												<fo:inline>
													<xsl:text>&#160;</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell number-columns-spanned="2" padding="0" display-align="center">
											<fo:block text-align="left">
												<fo:block text-align="center">
													<fo:leader leader-pattern="rule" rule-thickness="2" leader-length="100%" color="black"/>
												</fo:block>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</xsl:variable>
								<xsl:choose>
									<xsl:when test="string($altova:tablerows)">
										<xsl:copy-of select="$altova:tablerows"/>
									</xsl:when>
									<xsl:otherwise>
										<fo:table-row>
											<fo:table-cell>
												<fo:block/>
											</fo:table-cell>
										</fo:table-row>
									</xsl:otherwise>
								</xsl:choose>
							</fo:table-body>
						</fo:table>
						<fo:block>
							<fo:leader leader-pattern="space"/>
						</fo:block>
						<xsl:for-each select="$XML">
							<xsl:for-each select="n1:Correspondence">
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x200B;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
									<fo:table-column column-width="1.590in"/>
									<fo:table-column column-width="0.430in"/>
									<fo:table-column column-width="6.430in"/>
									<xsl:variable name="altova:CurrContextGrid_14126FB8" select="."/>
									<fo:table-body start-indent="0pt">
										<xsl:variable name="altova:tablerows">
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>To:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:Investigator">
																<xsl:for-each select="n1:Person">
																	<xsl:for-each select="n1:Fullname">
																		<xsl:variable name="value-of-template_0A833FB0">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template_0A833FB0),\'&#x200B;\')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template_0A833FB0"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template_0A833FB0"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>From:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:Submissions">
																<xsl:for-each select="n1:CommitteeMember">
																	<xsl:for-each select="n1:Person">
																		<xsl:for-each select="n1:Fullname">
																			<xsl:variable name="value-of-template_0A835590">
																				<xsl:apply-templates/>
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when test="contains(string($value-of-template_0A835590),\'&#x200B;\')">
																					<fo:block>
																						<xsl:copy-of select="$value-of-template_0A835590"/>
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline>
																						<xsl:copy-of select="$value-of-template_0A835590"/>
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
														<fo:inline>
															<xsl:text>, Chair</xsl:text>
														</fo:inline>
														<fo:block/>
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:Submissions">
																<xsl:for-each select="n1:CommitteeMasterData">
																	<xsl:for-each select="n1:CommitteeName">
																		<xsl:variable name="value-of-template_0A8337D0">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template_0A8337D0),\'&#x200B;\')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template_0A8337D0"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template_0A8337D0"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Date:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:CurrentDate">
															<fo:inline>
																<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																<xsl:text> / </xsl:text>
																<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																<xsl:text> / </xsl:text>
																<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
															</fo:inline>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Committee Action:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Notification Of Administrative Correction</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Action Date:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:Submissions">
																<xsl:for-each select="n1:SubmissionDetails">
																	<xsl:for-each select="n1:ActionType">
																		<xsl:for-each select="n1:ActionDate">
																			<fo:inline>
																				<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																				<xsl:text> / </xsl:text>
																				<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																				<xsl:text> / </xsl:text>
																				<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
																			</fo:inline>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Protocol Number:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:ProtocolMasterData">
																<xsl:for-each select="n1:ProtocolNumber">
																	<xsl:variable name="value-of-template_11F32528">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template_11F32528),\'&#x200B;\')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template_11F32528"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template_11F32528"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Study Title:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:ProtocolMasterData">
																<xsl:for-each select="n1:ProtocolTitle">
																	<xsl:variable name="value-of-template_11F32368">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template_11F32368),\'&#x200B;\')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template_11F32368"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template_11F32368"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Expiration Date:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:ProtocolMasterData">
																<xsl:for-each select="n1:ExpirationDate">
																	<fo:inline>
																		<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																		<xsl:text> / </xsl:text>
																		<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																		<xsl:text> / </xsl:text>
																		<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
																	</fo:inline>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</xsl:variable>
										<xsl:choose>
											<xsl:when test="string($altova:tablerows)">
												<xsl:copy-of select="$altova:tablerows"/>
											</xsl:when>
											<xsl:otherwise>
												<fo:table-row>
													<fo:table-cell>
														<fo:block/>
													</fo:table-cell>
												</fo:table-row>
											</xsl:otherwise>
										</xsl:choose>
									</fo:table-body>
								</fo:table>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
							</xsl:for-each>
							<fo:block/>
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
							<fo:inline>
								<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; This is to inform that the above mentioned protocol had go through minor administrative correction.</xsl:text>
							</fo:inline>
							<fo:block/>
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
							<fo:inline>
								<xsl:text>Best Regards.</xsl:text>
							</fo:inline>
							<fo:block/>
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
						</xsl:for-each>
					</fo:block>
					<fo:block id="SV_RefID_PageTotal"/>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	<xsl:template name="double-backslash">
		<xsl:param name="text"/>
		<xsl:param name="text-length"/>
		<xsl:variable name="text-after-bs" select="substring-after($text, \'\\\')"/>
		<xsl:variable name="text-after-bs-length" select="string-length($text-after-bs)"/>
		<xsl:choose>
			<xsl:when test="$text-after-bs-length = 0">
				<xsl:choose>
					<xsl:when test="substring($text, $text-length) = \'\\\'">
						<xsl:value-of select="concat(substring($text,1,$text-length - 1), \'\\\\\')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$text"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="concat(substring($text,1,$text-length - $text-after-bs-length - 1), \'\\\\\')"/>
				<xsl:call-template name="double-backslash">
					<xsl:with-param name="text" select="$text-after-bs"/>
					<xsl:with-param name="text-length" select="$text-after-bs-length"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="altova:MakeValueAbsoluteIfPixels">
		<xsl:param name="sValue"/>
		<xsl:variable name="sBeforePx" select="substring-before($sValue, \'px\')"/>
		<xsl:choose>
			<xsl:when test="$sBeforePx">
				<xsl:variable name="nLengthOfInteger">
					<xsl:call-template name="altova:GetCharCountOfIntegerAtEndOfString">
						<xsl:with-param name="sText" select="$sBeforePx"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:variable name="nPosOfInteger" select="string-length($sBeforePx) - $nLengthOfInteger + 1"/>
				<xsl:variable name="nValuePx" select="substring($sBeforePx, $nPosOfInteger)"/>
				<xsl:variable name="nValueIn" select="number($nValuePx) div number($altova:nPxPerIn)"/>
				<xsl:variable name="nLengthBeforeInteger" select="string-length($sBeforePx) - $nLengthOfInteger"/>
				<xsl:variable name="sRest">
					<xsl:call-template name="altova:MakeValueAbsoluteIfPixels">
						<xsl:with-param name="sValue" select="substring-after($sValue, \'px\')"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="concat(substring($sBeforePx, 1, $nLengthBeforeInteger), string($nValueIn), \'in\', $sRest)"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$sValue"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="altova:GetCharCountOfIntegerAtEndOfString">
		<xsl:param name="sText"/>
		<xsl:variable name="sLen" select="string-length($sText)"/>
		<xsl:variable name="cLast" select="substring($sText, $sLen)"/>
		<xsl:choose>
			<xsl:when test="number($cLast) &gt;= 0 and number($cLast) &lt;= 9">
				<xsl:variable name="nResultOfRest">
					<xsl:call-template name="altova:GetCharCountOfIntegerAtEndOfString">
						<xsl:with-param name="sText" select="substring($sText, 1, $sLen - 1)"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="$nResultOfRest + 1"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text>0</xsl:text>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
','NotificationofAdministrativeCorrection.xslt',UUID(),(SELECT (MAX(ID)) FROM SEQ_IACUC_PROTO_CORRESP_TEMPL),'18',NOW(),'admin',1)
/
INSERT INTO SEQ_IACUC_PROTO_CORRESP_TEMPL VALUES(NULL)
/
INSERT INTO IACUC_PROTO_CORRESP_TEMPL (COMMITTEE_ID,CORRESPONDENCE_TEMPLATE,FILE_NAME,OBJ_ID,PROTO_CORRESP_TEMPL_ID,PROTO_CORRESP_TYPE_CODE,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR)
  VALUES ('DEFAULT','<?xml version="1.0" encoding="UTF-8"?>
<!--Designed and generated by Altova StyleVision Enterprise Edition 2011 - see http://www.altova.com/stylevision for more information.-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:clitype="clitype" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:iso4217="http://www.xbrl.org/2003/iso4217" xmlns:ix="http://www.xbrl.org/2008/inlineXBRL" xmlns:java="java" xmlns:link="http://www.xbrl.org/2003/linkbase" xmlns:n1="http://xml.coeus.mit.edu/iacuc" xmlns:xbrldi="http://xbrl.org/2006/xbrldi" xmlns:xbrli="http://www.xbrl.org/2003/instance" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:altova="http://www.altova.com" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:svg="http://www.w3.org/2000/svg" exclude-result-prefixes="clitype fn iso4217 ix java link n1 xbrldi xbrli xlink xs xsi altova">
	<xsl:output version="1.0" method="xml" encoding="UTF-8" indent="no"/>
	<xsl:param name="SV_OutputFormat" select="\'PDF\'"/>
	<xsl:variable name="XML" select="/"/>
	<xsl:variable name="fo:layout-master-set">
		<fo:layout-master-set>
			<fo:simple-page-master master-name="page-master-318599560" margin-left="0.60in" margin-right="0.60in" page-height="11in" page-width="8.50in">
				<fo:region-body margin-top="0.79in" margin-bottom="0.79in" column-count="1" column-gap="0.50in"/>
			</fo:simple-page-master>
		</fo:layout-master-set>
	</xsl:variable>
	<xsl:variable name="altova:nPxPerIn" select="96"/>
	<xsl:template match="/">
		<fo:root>
			<xsl:copy-of select="$fo:layout-master-set"/>
			<fo:page-sequence force-page-count="no-force" master-reference="page-master-318599560" initial-page-number="auto" format="1">
				<fo:flow flow-name="xsl-region-body">
					<fo:block>
						<fo:inline-container>
							<fo:block>
								<xsl:text>&#x200B;</xsl:text>
							</fo:block>
						</fo:inline-container>
						<fo:table width="100%" table-layout="fixed" border-spacing="2pt">
							<fo:table-column column-width="90%"/>
							<fo:table-column column-width="10%"/>
							<xsl:variable name="altova:CurrContextGrid_135624A0" select="."/>
							<fo:table-body start-indent="0pt">
								<xsl:variable name="altova:tablerows">
									<fo:table-row>
										<fo:table-cell font-size="10pt" padding="0" display-align="center">
											<fo:block text-align="left">
												<fo:inline>
													<xsl:text>&#160;</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell font-size="10pt" padding="0" display-align="center">
											<fo:block text-align="right">
												<fo:inline>
													<xsl:text>&#160;</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell number-columns-spanned="2" padding="0" display-align="center">
											<fo:block text-align="left">
												<fo:block text-align="center">
													<fo:leader leader-pattern="rule" rule-thickness="2" leader-length="100%" color="black"/>
												</fo:block>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</xsl:variable>
								<xsl:choose>
									<xsl:when test="string($altova:tablerows)">
										<xsl:copy-of select="$altova:tablerows"/>
									</xsl:when>
									<xsl:otherwise>
										<fo:table-row>
											<fo:table-cell>
												<fo:block/>
											</fo:table-cell>
										</fo:table-row>
									</xsl:otherwise>
								</xsl:choose>
							</fo:table-body>
						</fo:table>
						<fo:block>
							<fo:leader leader-pattern="space"/>
						</fo:block>
						<xsl:for-each select="$XML">
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
							<xsl:for-each select="n1:Correspondence">
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x200B;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:table font-family="inherit" table-layout="fixed" width="100%" border-spacing="2pt">
									<fo:table-column column-width="1.520in"/>
									<fo:table-column column-width="0.430in"/>
									<fo:table-column column-width="6.430in"/>
									<xsl:variable name="altova:CurrContextGrid_13EAC000" select="."/>
									<fo:table-body start-indent="0pt">
										<xsl:variable name="altova:tablerows">
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>To:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:Investigator">
																<xsl:for-each select="n1:Person">
																	<xsl:for-each select="n1:Fullname">
																		<xsl:variable name="value-of-template_123CDA68">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template_123CDA68),\'&#x200B;\')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template_123CDA68"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template_123CDA68"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>From:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:Submissions">
																<xsl:for-each select="n1:CommitteeMember">
																	<xsl:for-each select="n1:Person">
																		<xsl:for-each select="n1:Fullname">
																			<xsl:variable name="value-of-template_123CD988">
																				<xsl:apply-templates/>
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when test="contains(string($value-of-template_123CD988),\'&#x200B;\')">
																					<fo:block>
																						<xsl:copy-of select="$value-of-template_123CD988"/>
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline>
																						<xsl:copy-of select="$value-of-template_123CD988"/>
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
														<fo:inline>
															<xsl:text>, Chair</xsl:text>
														</fo:inline>
														<fo:block/>
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:Submissions">
																<xsl:for-each select="n1:CommitteeMasterData">
																	<xsl:for-each select="n1:CommitteeName">
																		<xsl:variable name="value-of-template_123CD8A8">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template_123CD8A8),\'&#x200B;\')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template_123CD8A8"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template_123CD8A8"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Date:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:CurrentDate">
															<fo:inline>
																<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																<xsl:text> / </xsl:text>
																<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																<xsl:text> / </xsl:text>
																<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
															</fo:inline>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Committee Action:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Deactivation</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Action Date:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:Submissions">
																<xsl:for-each select="n1:SubmissionDetails">
																	<xsl:for-each select="n1:ActionType">
																		<xsl:for-each select="n1:ActionDate">
																			<fo:inline>
																				<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																				<xsl:text> / </xsl:text>
																				<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																				<xsl:text> / </xsl:text>
																				<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
																			</fo:inline>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row height="0.38in">
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Protocol Number:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:ProtocolMasterData">
																<xsl:for-each select="n1:ProtocolNumber">
																	<xsl:variable name="value-of-template_123CDC28">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template_123CDC28),\'&#x200B;\')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template_123CDC28"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template_123CDC28"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row height="0.20in">
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Study Title:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:ProtocolMasterData">
																<xsl:for-each select="n1:ProtocolTitle">
																	<xsl:variable name="value-of-template_123CDD08">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template_123CDD08),\'&#x200B;\')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template_123CDD08"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template_123CDD08"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row height="0.18in">
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Expiration Date:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:ProtocolMasterData">
																<xsl:for-each select="n1:ExpirationDate">
																	<fo:inline>
																		<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																		<xsl:text> / </xsl:text>
																		<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																		<xsl:text> / </xsl:text>
																		<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
																	</fo:inline>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</xsl:variable>
										<xsl:choose>
											<xsl:when test="string($altova:tablerows)">
												<xsl:copy-of select="$altova:tablerows"/>
											</xsl:when>
											<xsl:otherwise>
												<fo:table-row>
													<fo:table-cell>
														<fo:block/>
													</fo:table-cell>
												</fo:table-row>
											</xsl:otherwise>
										</xsl:choose>
									</fo:table-body>
								</fo:table>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
							</xsl:for-each>
							<fo:block/>
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x200B;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:block margin="0pt">
								<fo:inline>
									<xsl:text>The above mentioned protocol</xsl:text>
								</fo:inline>
								<xsl:for-each select="n1:Correspondence">
									<xsl:for-each select="n1:Protocol">
										<fo:inline>
											<xsl:text> has deactivated as of </xsl:text>
										</fo:inline>
										<xsl:for-each select="n1:Submissions">
											<xsl:for-each select="n1:ScheduleMasterData">
												<xsl:for-each select="n1:MeetingDate">
													<fo:inline>
														<xsl:call-template name="DateToMonthName">
															<xsl:with-param name="sDate" select="string(string(.))"/>
															<xsl:with-param name="sFormat" select="\'long\'"/>
														</xsl:call-template>
														<xsl:text> </xsl:text>
														<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
														<xsl:text>, </xsl:text>
														<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
													</fo:inline>
												</xsl:for-each>
											</xsl:for-each>
										</xsl:for-each>
										<fo:inline>
											<xsl:text> . Studies being conducted on expired protocols shall be immediately deactivated and animals involved in these studies removed from </xsl:text>
										</fo:inline>
										<xsl:for-each select="n1:SchoolInfo">
											<xsl:for-each select="n1:SchoolName">
												<xsl:variable name="value-of-template_123CDFA8">
													<xsl:apply-templates/>
												</xsl:variable>
												<xsl:choose>
													<xsl:when test="contains(string($value-of-template_123CDFA8),\'&#x200B;\')">
														<fo:block>
															<xsl:copy-of select="$value-of-template_123CDFA8"/>
														</fo:block>
													</xsl:when>
													<xsl:otherwise>
														<fo:inline>
															<xsl:copy-of select="$value-of-template_123CDFA8"/>
														</fo:inline>
													</xsl:otherwise>
												</xsl:choose>
											</xsl:for-each>
										</xsl:for-each>
									</xsl:for-each>
									<fo:inline>
										<xsl:text>&#160;</xsl:text>
									</fo:inline>
								</xsl:for-each>
								<fo:inline>
									<xsl:text> Housing. This decision is based on federal law which requires that all vertebrate animals housed for research and teaching be identified with an approved protocol. During unannounced inspection federal agents identifying animals housed under expired protocols may levy substantial fines against the University.</xsl:text>
								</fo:inline>
							</fo:block>
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x200B;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:block margin="0pt">
								<fo:inline>
									<xsl:text>Thank you.</xsl:text>
								</fo:inline>
							</fo:block>
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
						</xsl:for-each>
					</fo:block>
					<fo:block id="SV_RefID_PageTotal"/>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	<xsl:template name="DateToMonthName">
		<xsl:param name="sDate"/>
		<xsl:param name="sFormat"/>
		<xsl:choose>
			<xsl:when test="$sFormat = \'long\'">
				<xsl:call-template name="DateToMonthNameLong">
					<xsl:with-param name="sDate" select="$sDate"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="DateToMonthNameShort">
					<xsl:with-param name="sDate" select="$sDate"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="DateToMonthNameLong">
		<xsl:param name="sDate"/>
		<xsl:variable name="nMonth">
			<xsl:call-template name="DateToMonthNum">
				<xsl:with-param name="sDate" select="$sDate"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="$nMonth = 1">January</xsl:when>
			<xsl:when test="$nMonth = 2">February</xsl:when>
			<xsl:when test="$nMonth = 3">March</xsl:when>
			<xsl:when test="$nMonth = 4">April</xsl:when>
			<xsl:when test="$nMonth = 5">May</xsl:when>
			<xsl:when test="$nMonth = 6">June</xsl:when>
			<xsl:when test="$nMonth = 7">July</xsl:when>
			<xsl:when test="$nMonth = 8">August</xsl:when>
			<xsl:when test="$nMonth = 9">September</xsl:when>
			<xsl:when test="$nMonth = 10">October</xsl:when>
			<xsl:when test="$nMonth = 11">November</xsl:when>
			<xsl:otherwise>December</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="DateToMonthNum">
		<xsl:param name="sDate"/>
		<xsl:choose>
			<xsl:when test="starts-with($sDate, \'--\')">
				<xsl:value-of select="number(substring($sDate, 3, 2))"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="number(substring($sDate, 6, 2))"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="DateToMonthNameShort">
		<xsl:param name="sDate"/>
		<xsl:variable name="nMonth">
			<xsl:call-template name="DateToMonthNum">
				<xsl:with-param name="sDate" select="$sDate"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="$nMonth = 1">Jan</xsl:when>
			<xsl:when test="$nMonth = 2">Feb</xsl:when>
			<xsl:when test="$nMonth = 3">Mar</xsl:when>
			<xsl:when test="$nMonth = 4">Apr</xsl:when>
			<xsl:when test="$nMonth = 5">May</xsl:when>
			<xsl:when test="$nMonth = 6">Jun</xsl:when>
			<xsl:when test="$nMonth = 7">Jul</xsl:when>
			<xsl:when test="$nMonth = 8">Aug</xsl:when>
			<xsl:when test="$nMonth = 9">Sep</xsl:when>
			<xsl:when test="$nMonth = 10">Oct</xsl:when>
			<xsl:when test="$nMonth = 11">Nov</xsl:when>
			<xsl:otherwise>Dec</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="double-backslash">
		<xsl:param name="text"/>
		<xsl:param name="text-length"/>
		<xsl:variable name="text-after-bs" select="substring-after($text, \'\\\')"/>
		<xsl:variable name="text-after-bs-length" select="string-length($text-after-bs)"/>
		<xsl:choose>
			<xsl:when test="$text-after-bs-length = 0">
				<xsl:choose>
					<xsl:when test="substring($text, $text-length) = \'\\\'">
						<xsl:value-of select="concat(substring($text,1,$text-length - 1), \'\\\\\')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$text"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="concat(substring($text,1,$text-length - $text-after-bs-length - 1), \'\\\\\')"/>
				<xsl:call-template name="double-backslash">
					<xsl:with-param name="text" select="$text-after-bs"/>
					<xsl:with-param name="text-length" select="$text-after-bs-length"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="altova:MakeValueAbsoluteIfPixels">
		<xsl:param name="sValue"/>
		<xsl:variable name="sBeforePx" select="substring-before($sValue, \'px\')"/>
		<xsl:choose>
			<xsl:when test="$sBeforePx">
				<xsl:variable name="nLengthOfInteger">
					<xsl:call-template name="altova:GetCharCountOfIntegerAtEndOfString">
						<xsl:with-param name="sText" select="$sBeforePx"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:variable name="nPosOfInteger" select="string-length($sBeforePx) - $nLengthOfInteger + 1"/>
				<xsl:variable name="nValuePx" select="substring($sBeforePx, $nPosOfInteger)"/>
				<xsl:variable name="nValueIn" select="number($nValuePx) div number($altova:nPxPerIn)"/>
				<xsl:variable name="nLengthBeforeInteger" select="string-length($sBeforePx) - $nLengthOfInteger"/>
				<xsl:variable name="sRest">
					<xsl:call-template name="altova:MakeValueAbsoluteIfPixels">
						<xsl:with-param name="sValue" select="substring-after($sValue, \'px\')"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="concat(substring($sBeforePx, 1, $nLengthBeforeInteger), string($nValueIn), \'in\', $sRest)"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$sValue"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="altova:GetCharCountOfIntegerAtEndOfString">
		<xsl:param name="sText"/>
		<xsl:variable name="sLen" select="string-length($sText)"/>
		<xsl:variable name="cLast" select="substring($sText, $sLen)"/>
		<xsl:choose>
			<xsl:when test="number($cLast) &gt;= 0 and number($cLast) &lt;= 9">
				<xsl:variable name="nResultOfRest">
					<xsl:call-template name="altova:GetCharCountOfIntegerAtEndOfString">
						<xsl:with-param name="sText" select="substring($sText, 1, $sLen - 1)"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="$nResultOfRest + 1"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text>0</xsl:text>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
','NotificationofDeactivation.xslt',UUID(),(SELECT (MAX(ID)) FROM SEQ_IACUC_PROTO_CORRESP_TEMPL),'19',NOW(),'admin',1)
/
INSERT INTO SEQ_IACUC_PROTO_CORRESP_TEMPL VALUES(NULL)
/
INSERT INTO IACUC_PROTO_CORRESP_TEMPL (COMMITTEE_ID,CORRESPONDENCE_TEMPLATE,FILE_NAME,OBJ_ID,PROTO_CORRESP_TEMPL_ID,PROTO_CORRESP_TYPE_CODE,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR)
  VALUES ('DEFAULT','<?xml version="1.0" encoding="UTF-8"?>
<!--Designed and generated by Altova StyleVision Enterprise Edition 2011 - see http://www.altova.com/stylevision for more information.-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:clitype="clitype" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:iso4217="http://www.xbrl.org/2003/iso4217" xmlns:ix="http://www.xbrl.org/2008/inlineXBRL" xmlns:java="java" xmlns:link="http://www.xbrl.org/2003/linkbase" xmlns:n1="http://xml.coeus.mit.edu/iacuc" xmlns:xbrldi="http://xbrl.org/2006/xbrldi" xmlns:xbrli="http://www.xbrl.org/2003/instance" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:altova="http://www.altova.com" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:svg="http://www.w3.org/2000/svg" exclude-result-prefixes="clitype fn iso4217 ix java link n1 xbrldi xbrli xlink xs xsi altova">
	<xsl:output version="1.0" method="xml" encoding="UTF-8" indent="no"/>
	<xsl:param name="SV_OutputFormat" select="\'PDF\'"/>
	<xsl:variable name="XML" select="/"/>
	<xsl:variable name="fo:layout-master-set">
		<fo:layout-master-set>
			<fo:simple-page-master master-name="page-master-163957544" margin-left="0.60in" margin-right="0.60in" page-height="11in" page-width="8.50in">
				<fo:region-body margin-top="0.79in" margin-bottom="0.79in" column-count="1" column-gap="0.50in"/>
			</fo:simple-page-master>
		</fo:layout-master-set>
	</xsl:variable>
	<xsl:variable name="altova:nPxPerIn" select="96"/>
	<xsl:template match="/">
		<fo:root>
			<xsl:copy-of select="$fo:layout-master-set"/>
			<fo:page-sequence force-page-count="no-force" master-reference="page-master-163957544" initial-page-number="auto" format="1">
				<fo:flow flow-name="xsl-region-body">
					<fo:block>
						<fo:inline-container>
							<fo:block>
								<xsl:text>&#x200B;</xsl:text>
							</fo:block>
						</fo:inline-container>
						<fo:table width="100%" table-layout="fixed" border-spacing="2pt">
							<fo:table-column column-width="90%"/>
							<fo:table-column column-width="10%"/>
							<xsl:variable name="altova:CurrContextGrid_09C445A8" select="."/>
							<fo:table-body start-indent="0pt">
								<xsl:variable name="altova:tablerows">
									<fo:table-row>
										<fo:table-cell font-size="10pt" padding="0" display-align="center">
											<fo:block text-align="left">
												<fo:inline>
													<xsl:text>&#160;</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell font-size="10pt" padding="0" display-align="center">
											<fo:block text-align="right">
												<fo:inline>
													<xsl:text>&#160;</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell number-columns-spanned="2" padding="0" display-align="center">
											<fo:block text-align="left">
												<fo:block text-align="center">
													<fo:leader leader-pattern="rule" rule-thickness="2" leader-length="100%" color="black"/>
												</fo:block>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</xsl:variable>
								<xsl:choose>
									<xsl:when test="string($altova:tablerows)">
										<xsl:copy-of select="$altova:tablerows"/>
									</xsl:when>
									<xsl:otherwise>
										<fo:table-row>
											<fo:table-cell>
												<fo:block/>
											</fo:table-cell>
										</fo:table-row>
									</xsl:otherwise>
								</xsl:choose>
							</fo:table-body>
						</fo:table>
						<fo:block>
							<fo:leader leader-pattern="space"/>
						</fo:block>
						<xsl:for-each select="$XML">
							<xsl:for-each select="n1:Correspondence">
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x200B;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
									<fo:table-column column-width="1.150in"/>
									<fo:table-column column-width="0.430in"/>
									<fo:table-column column-width="6.430in"/>
									<xsl:variable name="altova:CurrContextGrid_09C44908" select="."/>
									<fo:table-body start-indent="0pt">
										<xsl:variable name="altova:tablerows">
											<fo:table-row>
												<fo:table-cell font-weight="bold" padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>To:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:Investigator">
																<xsl:for-each select="n1:Person">
																	<xsl:for-each select="n1:Fullname">
																		<xsl:variable name="value-of-template_0BA68ED0">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template_0BA68ED0),\'&#x200B;\')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template_0BA68ED0"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template_0BA68ED0"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell font-weight="bold" padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>From:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:Submissions">
																<xsl:for-each select="n1:CommitteeMember">
																	<xsl:for-each select="n1:Person">
																		<xsl:for-each select="n1:Fullname">
																			<xsl:variable name="value-of-template_0BA68FB0">
																				<xsl:apply-templates/>
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when test="contains(string($value-of-template_0BA68FB0),\'&#x200B;\')">
																					<fo:block>
																						<xsl:copy-of select="$value-of-template_0BA68FB0"/>
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline>
																						<xsl:copy-of select="$value-of-template_0BA68FB0"/>
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>

														</xsl:for-each>
														<fo:inline>
															<xsl:text>, Chair</xsl:text>
														</fo:inline>
														<fo:block/>
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:Submissions">
																<xsl:for-each select="n1:CommitteeMasterData">
																	<xsl:for-each select="n1:CommitteeName">
																		<xsl:variable name="value-of-template_09535C58">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template_09535C58),\'&#x200B;\')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template_09535C58"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template_09535C58"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell font-weight="bold" padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Date:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:CurrentDate">
															<fo:inline>
																<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																<xsl:text> / </xsl:text>
																<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																<xsl:text> / </xsl:text>
																<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
															</fo:inline>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell font-weight="bold" padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Committee Action:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Notification of IACUC that review is complete</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell font-weight="bold" padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Action Date:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:Submissions">
																<xsl:for-each select="n1:SubmissionDetails">
																	<xsl:for-each select="n1:ActionType">
																		<xsl:for-each select="n1:ActionDate">
																			<fo:inline>
																				<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																				<xsl:text> / </xsl:text>
																				<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																				<xsl:text> / </xsl:text>
																				<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
																			</fo:inline>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row height="0.38in">
												<fo:table-cell font-weight="bold" padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Protocol Number:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:ProtocolMasterData">
																<xsl:for-each select="n1:ProtocolNumber">
																	<xsl:variable name="value-of-template_095359B8">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template_095359B8),\'&#x200B;\')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template_095359B8"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template_095359B8"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row height="0.20in">
												<fo:table-cell font-weight="bold" padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Study Title:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:ProtocolMasterData">
																<xsl:for-each select="n1:ProtocolTitle">
																	<xsl:variable name="value-of-template_095358D8">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template_095358D8),\'&#x200B;\')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template_095358D8"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template_095358D8"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell font-weight="bold" padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Expiration Date:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:ProtocolMasterData">
																<xsl:for-each select="n1:ExpirationDate">
																	<xsl:variable name="value-of-template_095357F8">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template_095357F8),\'&#x200B;\')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template_095357F8"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template_095357F8"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</xsl:variable>
										<xsl:choose>
											<xsl:when test="string($altova:tablerows)">
												<xsl:copy-of select="$altova:tablerows"/>
											</xsl:when>
											<xsl:otherwise>
												<fo:table-row>
													<fo:table-cell>
														<fo:block/>
													</fo:table-cell>
												</fo:table-row>
											</xsl:otherwise>
										</xsl:choose>
									</fo:table-body>
								</fo:table>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
							</xsl:for-each>
							<fo:block/>
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x200B;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:block margin="0pt">
								<fo:inline>
									<xsl:text>&#160; Reviewer </xsl:text>
								</fo:inline>
								<xsl:for-each select="n1:Correspondence">
									<xsl:for-each select="n1:Protocol">
										<xsl:for-each select="n1:ProtocolMasterData">
											<xsl:for-each select="n1:PrincipleInvestigatorName">
												<xsl:variable name="value-of-template_09535718">
													<xsl:apply-templates/>
												</xsl:variable>
												<xsl:choose>
													<xsl:when test="contains(string($value-of-template_09535718),\'&#x200B;\')">
														<fo:block>
															<xsl:copy-of select="$value-of-template_09535718"/>
														</fo:block>
													</xsl:when>
													<xsl:otherwise>
														<fo:inline>
															<xsl:copy-of select="$value-of-template_09535718"/>
														</fo:inline>
													</xsl:otherwise>
												</xsl:choose>
											</xsl:for-each>
											<fo:inline>
												<xsl:text> has submitted recommendations for the above mentioned protocol. </xsl:text>
											</fo:inline>
										</xsl:for-each>
									</xsl:for-each>
								</xsl:for-each>
								<fo:block/>
								<fo:inline>
									<xsl:text>&#160;</xsl:text>
								</fo:inline>
							</fo:block>
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x200B;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:block margin="0pt">
								<fo:inline>
									<xsl:text>Best Regards.</xsl:text>
								</fo:inline>
							</fo:block>
						</xsl:for-each>
					</fo:block>
					<fo:block id="SV_RefID_PageTotal"/>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	<xsl:template name="double-backslash">
		<xsl:param name="text"/>
		<xsl:param name="text-length"/>
		<xsl:variable name="text-after-bs" select="substring-after($text, \'\\\')"/>
		<xsl:variable name="text-after-bs-length" select="string-length($text-after-bs)"/>
		<xsl:choose>
			<xsl:when test="$text-after-bs-length = 0">
				<xsl:choose>
					<xsl:when test="substring($text, $text-length) = \'\\\'">
						<xsl:value-of select="concat(substring($text,1,$text-length - 1), \'\\\\\')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$text"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="concat(substring($text,1,$text-length - $text-after-bs-length - 1), \'\\\\\')"/>
				<xsl:call-template name="double-backslash">
					<xsl:with-param name="text" select="$text-after-bs"/>
					<xsl:with-param name="text-length" select="$text-after-bs-length"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="altova:MakeValueAbsoluteIfPixels">
		<xsl:param name="sValue"/>
		<xsl:variable name="sBeforePx" select="substring-before($sValue, \'px\')"/>
		<xsl:choose>
			<xsl:when test="$sBeforePx">
				<xsl:variable name="nLengthOfInteger">
					<xsl:call-template name="altova:GetCharCountOfIntegerAtEndOfString">
						<xsl:with-param name="sText" select="$sBeforePx"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:variable name="nPosOfInteger" select="string-length($sBeforePx) - $nLengthOfInteger + 1"/>
				<xsl:variable name="nValuePx" select="substring($sBeforePx, $nPosOfInteger)"/>
				<xsl:variable name="nValueIn" select="number($nValuePx) div number($altova:nPxPerIn)"/>
				<xsl:variable name="nLengthBeforeInteger" select="string-length($sBeforePx) - $nLengthOfInteger"/>
				<xsl:variable name="sRest">
					<xsl:call-template name="altova:MakeValueAbsoluteIfPixels">
						<xsl:with-param name="sValue" select="substring-after($sValue, \'px\')"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="concat(substring($sBeforePx, 1, $nLengthBeforeInteger), string($nValueIn), \'in\', $sRest)"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$sValue"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="altova:GetCharCountOfIntegerAtEndOfString">
		<xsl:param name="sText"/>
		<xsl:variable name="sLen" select="string-length($sText)"/>
		<xsl:variable name="cLast" select="substring($sText, $sLen)"/>
		<xsl:choose>
			<xsl:when test="number($cLast) &gt;= 0 and number($cLast) &lt;= 9">
				<xsl:variable name="nResultOfRest">
					<xsl:call-template name="altova:GetCharCountOfIntegerAtEndOfString">
						<xsl:with-param name="sText" select="substring($sText, 1, $sLen - 1)"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="$nResultOfRest + 1"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text>0</xsl:text>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
','NotificationOfIacucReviewComp.xslt',UUID(),(SELECT (MAX(ID)) FROM SEQ_IACUC_PROTO_CORRESP_TEMPL),'20',NOW(),'admin',1)
/
INSERT INTO SEQ_IACUC_PROTO_CORRESP_TEMPL VALUES(NULL)
/
INSERT INTO IACUC_PROTO_CORRESP_TEMPL (COMMITTEE_ID,CORRESPONDENCE_TEMPLATE,FILE_NAME,OBJ_ID,PROTO_CORRESP_TEMPL_ID,PROTO_CORRESP_TYPE_CODE,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR)
  VALUES ('DEFAULT','<?xml version="1.0" encoding="UTF-8"?>
<!--Designed and generated by Altova StyleVision Enterprise Edition 2011 - see http://www.altova.com/stylevision for more information.-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:clitype="clitype" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:iso4217="http://www.xbrl.org/2003/iso4217" xmlns:ix="http://www.xbrl.org/2008/inlineXBRL" xmlns:java="java" xmlns:link="http://www.xbrl.org/2003/linkbase" xmlns:n1="http://xml.coeus.mit.edu/iacuc" xmlns:xbrldi="http://xbrl.org/2006/xbrldi" xmlns:xbrli="http://www.xbrl.org/2003/instance" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:altova="http://www.altova.com" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:svg="http://www.w3.org/2000/svg" exclude-result-prefixes="clitype fn iso4217 ix java link n1 xbrldi xbrli xlink xs xsi altova">
	<xsl:output version="1.0" method="xml" encoding="UTF-8" indent="no"/>
	<xsl:param name="SV_OutputFormat" select="\'PDF\'"/>
	<xsl:variable name="XML" select="/"/>
	<xsl:variable name="fo:layout-master-set">
		<fo:layout-master-set>
			<fo:simple-page-master master-name="page-master-170638744" margin-left="0.60in" margin-right="0.60in" page-height="11in" page-width="8.50in">
				<fo:region-body margin-top="0.79in" margin-bottom="0.79in" column-count="1" column-gap="0.50in"/>
			</fo:simple-page-master>
		</fo:layout-master-set>
	</xsl:variable>
	<xsl:variable name="altova:nPxPerIn" select="96"/>
	<xsl:template match="/">
		<fo:root>
			<xsl:copy-of select="$fo:layout-master-set"/>
			<fo:page-sequence force-page-count="no-force" master-reference="page-master-170638744" initial-page-number="auto" format="1">
				<fo:flow flow-name="xsl-region-body">
					<fo:block>
						<xsl:for-each select="$XML">
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
							<xsl:for-each select="n1:Correspondence">
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x200B;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
									<fo:table-column column-width="1.590in"/>
									<fo:table-column column-width="0.430in"/>
									<fo:table-column column-width="4.930in"/>
									<xsl:variable name="altova:CurrContextGrid_0A2BD4E0" select="."/>
									<fo:table-body start-indent="0pt">
										<xsl:variable name="altova:tablerows">
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>To:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:Organization">
																<xsl:for-each select="n1:OrgName">
																	<xsl:variable name="value-of-template_06C47700">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template_06C47700),\'&#x200B;\')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template_06C47700"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template_06C47700"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:Organization">
																<xsl:for-each select="n1:Address">
																	<xsl:variable name="value-of-template_06C478C0">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template_06C478C0),\'&#x200B;\')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template_06C478C0"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template_06C478C0"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>From:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:Submissions">
																<xsl:for-each select="n1:CommitteeMember">
																	<xsl:for-each select="n1:Person">
																		<xsl:for-each select="n1:Fullname">
																			<xsl:variable name="value-of-template_06C479A0">
																				<xsl:apply-templates/>
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when test="contains(string($value-of-template_06C479A0),\'&#x200B;\')">
																					<fo:block>
																						<xsl:copy-of select="$value-of-template_06C479A0"/>
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline>
																						<xsl:copy-of select="$value-of-template_06C479A0"/>
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
														<fo:inline>
															<xsl:text>, Chair</xsl:text>
														</fo:inline>
														<fo:block/>
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:Submissions">
																<xsl:for-each select="n1:CommitteeMasterData">
																	<xsl:for-each select="n1:CommitteeName">
																		<xsl:variable name="value-of-template_06C47A80">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template_06C47A80),\'&#x200B;\')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template_06C47A80"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template_06C47A80"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Date:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:CurrentDate">
															<fo:inline>
																<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																<xsl:text> / </xsl:text>
																<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																<xsl:text> / </xsl:text>
																<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
															</fo:inline>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Committee Action:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Adverse Event Notification</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Action Date:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:Submissions">
																<xsl:for-each select="n1:SubmissionDetails">
																	<xsl:for-each select="n1:ActionType">
																		<xsl:for-each select="n1:ActionDate">
																			<fo:inline>
																				<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																				<xsl:text> / </xsl:text>
																				<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																				<xsl:text> / </xsl:text>
																				<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
																			</fo:inline>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Protocol Number:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:ProtocolMasterData">
																<xsl:for-each select="n1:ProtocolNumber">
																	<xsl:variable name="value-of-template_06C47D20">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template_06C47D20),\'&#x200B;\')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template_06C47D20"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template_06C47D20"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Study Title:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:ProtocolMasterData">
																<xsl:for-each select="n1:ProtocolTitle">
																	<xsl:variable name="value-of-template_06C47E00">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template_06C47E00),\'&#x200B;\')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template_06C47E00"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template_06C47E00"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Expiration Date:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:ProtocolMasterData">
																<xsl:for-each select="n1:ExpirationDate">
																	<fo:inline>
																		<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																		<xsl:text> / </xsl:text>
																		<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																		<xsl:text> / </xsl:text>
																		<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
																	</fo:inline>

																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</xsl:variable>
										<xsl:choose>
											<xsl:when test="string($altova:tablerows)">
												<xsl:copy-of select="$altova:tablerows"/>
											</xsl:when>
											<xsl:otherwise>
												<fo:table-row>
													<fo:table-cell>
														<fo:block/>
													</fo:table-cell>
												</fo:table-row>
											</xsl:otherwise>
										</xsl:choose>
									</fo:table-body>
								</fo:table>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:inline>
									<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; This is to inform that this committee has reviewed&#160; an unexpected adverse event that has reported by </xsl:text>
								</fo:inline>
								<xsl:for-each select="n1:Protocol">
									<xsl:for-each select="n1:ProtocolMasterData">
										<xsl:for-each select="n1:PrincipleInvestigatorName">
											<xsl:variable name="value-of-template_06C47FC0">
												<xsl:apply-templates/>
											</xsl:variable>
											<xsl:choose>
												<xsl:when test="contains(string($value-of-template_06C47FC0),\'&#x200B;\')">
													<fo:block>
														<xsl:copy-of select="$value-of-template_06C47FC0"/>
													</fo:block>
												</xsl:when>
												<xsl:otherwise>
													<fo:inline>
														<xsl:copy-of select="$value-of-template_06C47FC0"/>
													</fo:inline>
												</xsl:otherwise>
											</xsl:choose>
										</xsl:for-each>
									</xsl:for-each>
								</xsl:for-each>
								<fo:inline>
									<xsl:text>.&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
								</fo:inline>
								<fo:block/>
								<fo:inline>
									<xsl:text>&#160;</xsl:text>
								</fo:inline>
							</xsl:for-each>
							<fo:block/>
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
							<fo:inline>
								<xsl:text>Thank you.</xsl:text>
							</fo:inline>
							<fo:block/>
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
						</xsl:for-each>
					</fo:block>
					<fo:block id="SV_RefID_PageTotal"/>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	<xsl:template name="double-backslash">
		<xsl:param name="text"/>
		<xsl:param name="text-length"/>
		<xsl:variable name="text-after-bs" select="substring-after($text, \'\\\')"/>
		<xsl:variable name="text-after-bs-length" select="string-length($text-after-bs)"/>
		<xsl:choose>
			<xsl:when test="$text-after-bs-length = 0">
				<xsl:choose>
					<xsl:when test="substring($text, $text-length) = \'\\\'">
						<xsl:value-of select="concat(substring($text,1,$text-length - 1), \'\\\\\')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$text"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="concat(substring($text,1,$text-length - $text-after-bs-length - 1), \'\\\\\')"/>
				<xsl:call-template name="double-backslash">
					<xsl:with-param name="text" select="$text-after-bs"/>
					<xsl:with-param name="text-length" select="$text-after-bs-length"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="altova:MakeValueAbsoluteIfPixels">
		<xsl:param name="sValue"/>
		<xsl:variable name="sBeforePx" select="substring-before($sValue, \'px\')"/>
		<xsl:choose>
			<xsl:when test="$sBeforePx">
				<xsl:variable name="nLengthOfInteger">
					<xsl:call-template name="altova:GetCharCountOfIntegerAtEndOfString">
						<xsl:with-param name="sText" select="$sBeforePx"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:variable name="nPosOfInteger" select="string-length($sBeforePx) - $nLengthOfInteger + 1"/>
				<xsl:variable name="nValuePx" select="substring($sBeforePx, $nPosOfInteger)"/>
				<xsl:variable name="nValueIn" select="number($nValuePx) div number($altova:nPxPerIn)"/>
				<xsl:variable name="nLengthBeforeInteger" select="string-length($sBeforePx) - $nLengthOfInteger"/>
				<xsl:variable name="sRest">
					<xsl:call-template name="altova:MakeValueAbsoluteIfPixels">
						<xsl:with-param name="sValue" select="substring-after($sValue, \'px\')"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="concat(substring($sBeforePx, 1, $nLengthBeforeInteger), string($nValueIn), \'in\', $sRest)"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$sValue"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="altova:GetCharCountOfIntegerAtEndOfString">
		<xsl:param name="sText"/>
		<xsl:variable name="sLen" select="string-length($sText)"/>
		<xsl:variable name="cLast" select="substring($sText, $sLen)"/>
		<xsl:choose>
			<xsl:when test="number($cLast) &gt;= 0 and number($cLast) &lt;= 9">
				<xsl:variable name="nResultOfRest">
					<xsl:call-template name="altova:GetCharCountOfIntegerAtEndOfString">
						<xsl:with-param name="sText" select="substring($sText, 1, $sLen - 1)"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="$nResultOfRest + 1"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text>0</xsl:text>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
','AdverseEventNotificationLetter.xslt',UUID(),(SELECT (MAX(ID)) FROM SEQ_IACUC_PROTO_CORRESP_TEMPL),'2',NOW(),'admin',1)
/
INSERT INTO SEQ_IACUC_PROTO_CORRESP_TEMPL VALUES(NULL)
/
INSERT INTO IACUC_PROTO_CORRESP_TEMPL (COMMITTEE_ID,CORRESPONDENCE_TEMPLATE,FILE_NAME,OBJ_ID,PROTO_CORRESP_TEMPL_ID,PROTO_CORRESP_TYPE_CODE,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR)
  VALUES ('DEFAULT','<?xml version="1.0" encoding="UTF-8"?>
<!--Designed and generated by Altova StyleVision Enterprise Edition 2008 rel. 2 - see http://www.altova.com/stylevision for more information.-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:n1="http://xml.coeus.mit.edu/iacuc" xmlns:xdt="http://www.w3.org/2005/xpath-datatypes" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output version="1.0" method="xml" encoding="UTF-8" indent="no"/>
	<xsl:param name="SV_OutputFormat" select="\'PDF\'"/>
	<xsl:variable name="XML" select="/"/>
	<xsl:variable name="fo:layout-master-set">
		<fo:layout-master-set>
			<fo:simple-page-master master-name="default-page" page-height="11in" page-width="8.5in" margin-left="0.6in" margin-right="0.6in">
				<fo:region-body margin-top="0.79in" margin-bottom="0.79in"/>
				<fo:region-before extent="0.79in"/>
			</fo:simple-page-master>
		</fo:layout-master-set>
	</xsl:variable>
	<xsl:template match="/">
		<fo:root>
			<xsl:copy-of select="$fo:layout-master-set"/>
			<fo:page-sequence master-reference="default-page" initial-page-number="1" format="1">
				<xsl:call-template name="headerall"/>
				<fo:flow flow-name="xsl-region-body">
					<fo:block>
						<xsl:for-each select="$XML">
							<fo:external-graphic>
								<xsl:attribute name="src">
									<xsl:text>url(</xsl:text>
									<xsl:call-template name="double-backslash">
										<xsl:with-param name="text">
											<xsl:value-of select="string(&apos;/export/home/www/https/tomcat5.0.25/webapps/coeus/images/couhes_byline2.gif&apos;)"/>
										</xsl:with-param>
										<xsl:with-param name="text-length">
											<xsl:value-of select="string-length(string(&apos;/export/home/www/https/tomcat5.0.25/webapps/coeus/images/couhes_byline2.gif&apos;))"/>
										</xsl:with-param>
									</xsl:call-template>
									<xsl:text>)</xsl:text>
								</xsl:attribute>
							</fo:external-graphic>
							<fo:block text-align="center">
								<fo:leader leader-pattern="rule" rule-thickness="1" leader-length="100%" color="black"/>
							</fo:block>
							<fo:block/>
							<xsl:for-each select="n1:Correspondence">
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block margin="0pt">
									<fo:block>
										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x2029;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
											<fo:table-column column-width="25%"/>
											<fo:table-column column-width="75%"/>
											<fo:table-body start-indent="0pt">
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>To:</xsl:text>
															</fo:inline>
															<fo:inline font-size="10pt">
																<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="before">
														<fo:block>
															<xsl:for-each select="n1:Protocol">
																<xsl:for-each select="n1:Investigator">
																	<xsl:if test="n1:PI_flag = &apos;true&apos;">
																		<xsl:for-each select="n1:Person">
																			<xsl:for-each select="n1:Firstname">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																						<fo:block font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:for-each>
																			<fo:inline font-size="10pt">
																				<xsl:text>&#160;</xsl:text>
																			</fo:inline>
																			<xsl:for-each select="n1:LastName">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																						<fo:block font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:for-each>
																			<fo:inline-container>
																				<fo:block>
																					<xsl:text>&#x2029;</xsl:text>
																				</fo:block>
																			</fo:inline-container>
																			<fo:block white-space="pre" white-space-collapse="false" margin="0pt">
																				<fo:block>
																					<xsl:for-each select="n1:OfficeLocation">
																						<xsl:variable name="value-of-template">
																							<xsl:apply-templates/>
																						</xsl:variable>
																						<xsl:choose>
																							<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																								<fo:block font-family="Book Antiqua" font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:block>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline font-family="Book Antiqua" font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:for-each>
																				</fo:block>
																			</fo:block>
																		</xsl:for-each>
																	</xsl:if>
																</xsl:for-each>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>From:</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="before">
														<fo:block>
															<xsl:for-each select="n1:Protocol">
																<xsl:for-each select="n1:Submissions">
																	<xsl:for-each select="n1:CommitteeMember">
																		<xsl:if test="n1:CommitteeMemberRole/n1:MemberRoleDesc = &apos;Chair&apos;">
																			<xsl:for-each select="n1:Person">
																				<xsl:for-each select="n1:Firstname">
																					<xsl:if test="../../../n1:CurrentSubmissionFlag =&apos;No&apos;">
																						<xsl:variable name="value-of-template">
																							<xsl:apply-templates/>
																						</xsl:variable>
																						<xsl:choose>
																							<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																								<fo:block font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:block>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:if>
																				</xsl:for-each>
																				<fo:inline font-size="10pt">
																					<xsl:text>&#160;</xsl:text>
																				</fo:inline>
																				<xsl:for-each select="n1:LastName">
																					<xsl:if test="../../../n1:CurrentSubmissionFlag =&apos;No&apos;">
																						<xsl:variable name="value-of-template">
																							<xsl:apply-templates/>
																						</xsl:variable>
																						<xsl:choose>
																							<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																								<fo:block font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:block>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:if>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:if>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
															<fo:inline font-size="10pt">
																<xsl:text>, Chair </xsl:text>
															</fo:inline>
															<fo:inline-container>
																<fo:block>
																	<xsl:text>&#x2029;</xsl:text>
																</fo:block>
															</fo:inline-container>
															<fo:block white-space="pre" white-space-collapse="false" margin="0pt">
																<fo:block>
																	<xsl:for-each select="n1:Protocol">
																		<xsl:for-each select="n1:Submissions">
																			<xsl:for-each select="n1:CommitteeMasterData">
																				<xsl:for-each select="n1:CommitteeName">
																					<xsl:if test="../../n1:CurrentSubmissionFlag =&apos;No&apos;">
																						<xsl:variable name="value-of-template">
																							<xsl:apply-templates/>
																						</xsl:variable>
																						<xsl:choose>
																							<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																								<fo:block font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:block>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:if>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:block>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>Date:</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="before">
														<fo:block>
															<xsl:for-each select="n1:CurrentDate">
																<fo:inline font-family="Book Antiqua" font-size="10pt">
																	<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																	<xsl:text>/</xsl:text>
																	<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																	<xsl:text>/</xsl:text>
																	<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
																</fo:inline>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>Committee Action:</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>Notified Committee</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x2029;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
											<fo:table-column column-width="25%"/>
											<fo:table-column column-width="75%"/>
											<fo:table-body start-indent="0pt">
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>Committee Action Date: </xsl:text>
															</fo:inline>
															<fo:inline font-size="10pt">
																<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="before">
														<fo:block>
															<xsl:for-each select="n1:Protocol">
																<xsl:for-each select="n1:Submissions">
																	<xsl:for-each select="n1:SubmissionDetails">
																		<xsl:for-each select="n1:ActionType">
																			<xsl:for-each select="n1:ActionDate">
																				<xsl:if test="../../../n1:CurrentSubmissionFlag =&apos;No&apos;">
																					<fo:inline font-size="10pt">
																						<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																						<xsl:text>/</xsl:text>
																						<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																						<xsl:text>/</xsl:text>
																						<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
																					</fo:inline>
																				</xsl:if>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>IACUC Protocol #: </xsl:text>
															</fo:inline>
															<fo:inline font-size="10pt">
																<xsl:text>&#160;&#160;&#160;&#160; </xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="before">
														<fo:block>
															<xsl:for-each select="n1:Protocol">
																<xsl:for-each select="n1:ProtocolMasterData">
																	<xsl:for-each select="n1:ProtocolNumber">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																				<fo:block font-size="10pt">
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline font-size="10pt">
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>Study Title:</xsl:text>
															</fo:inline>
															<fo:inline font-size="10pt">
																<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="before">
														<fo:block>
															<xsl:for-each select="n1:Protocol">
																<xsl:for-each select="n1:ProtocolMasterData">
																	<xsl:for-each select="n1:ProtocolTitle">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																				<fo:block font-size="10pt">
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline font-size="10pt">
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
									</fo:block>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block font-family="Arial" font-size="10pt" margin="0pt">
									<fo:block>
										<fo:inline font-size="10pt">
											<xsl:text> Notified Committee action has been performed for the above-referenced protocol.</xsl:text>
										</fo:inline>
									</fo:block>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block margin="0pt">
									<fo:block>
										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x2029;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
											<fo:table-column column-width="27"/>
											<fo:table-column column-width="1000"/>
											<fo:table-body start-indent="0pt">
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" height="19" display-align="center">
														<fo:block>
															<fo:inline font-family="Arial" font-size="10pt">
																<xsl:text>cc:&#160;&#160; </xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" height="19" display-align="center">
														<fo:block>
															<fo:inline font-family="Arial" font-size="10pt">
																<xsl:text>Tom Duff </xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="center">
														<fo:block/>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="before">
														<fo:block>
															<xsl:for-each select="n1:Protocol">
																<xsl:for-each select="n1:Correspondent">
																	<xsl:for-each select="n1:Person">
																		<xsl:for-each select="n1:Fullname">
																			<xsl:if test="../../n1:TypeOfCorrespondent = &apos;CRC&apos;">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																						<fo:block font-family="Arial" font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline font-family="Arial" font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:if>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
									</fo:block>
								</fo:block>
							</xsl:for-each>
						</xsl:for-each>
					</fo:block>
					<fo:block id="SV_RefID_PageTotal"/>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	<xsl:template name="headerall">
		<fo:static-content flow-name="xsl-region-before">
			<fo:block>
				<xsl:for-each select="$XML">
					<fo:inline-container>
						<fo:block>
							<xsl:text>&#x2029;</xsl:text>
						</fo:block>
					</fo:inline-container>
					<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
						<fo:table-column column-width="proportional-column-width(1)"/>
						<fo:table-column column-width="150"/>
						<fo:table-body start-indent="0pt">
							<fo:table-row>
								<fo:table-cell padding="0" number-columns-spanned="2" height="30" display-align="center">
									<fo:block/>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell font-size="smaller" padding="0" text-align="left" display-align="center">
									<fo:block/>
								</fo:table-cell>
								<fo:table-cell font-size="smaller" padding="0" text-align="right" display-align="center">
									<fo:block/>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell padding="0" number-columns-spanned="2" display-align="center">
									<fo:block/>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</xsl:for-each>
			</fo:block>
		</fo:static-content>
	</xsl:template>
	<xsl:template name="double-backslash">
		<xsl:param name="text"/>
		<xsl:param name="text-length"/>
		<xsl:variable name="text-after-bs" select="substring-after($text, \'\\\')"/>
		<xsl:variable name="text-after-bs-length" select="string-length($text-after-bs)"/>
		<xsl:choose>
			<xsl:when test="$text-after-bs-length = 0">
				<xsl:choose>
					<xsl:when test="substring($text, $text-length) = \'\\\'">
						<xsl:value-of select="concat(substring($text,1,$text-length - 1), \'\\\\\')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$text"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="concat(substring($text,1,$text-length - $text-after-bs-length - 1), \'\\\\\')"/>
				<xsl:call-template name="double-backslash">
					<xsl:with-param name="text" select="$text-after-bs"/>
					<xsl:with-param name="text-length" select="$text-after-bs-length"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
','NotifiedCommitteeLetter.xslt',UUID(),(SELECT (MAX(ID)) FROM SEQ_IACUC_PROTO_CORRESP_TEMPL),'21',NOW(),'admin',1)
/
INSERT INTO SEQ_IACUC_PROTO_CORRESP_TEMPL VALUES(NULL)
/
INSERT INTO IACUC_PROTO_CORRESP_TEMPL (COMMITTEE_ID,CORRESPONDENCE_TEMPLATE,FILE_NAME,OBJ_ID,PROTO_CORRESP_TEMPL_ID,PROTO_CORRESP_TYPE_CODE,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR)
  VALUES ('DEFAULT','<?xml version="1.0" encoding="UTF-8"?>
<!--Designed and generated by Altova StyleVision Enterprise Edition 2008 rel. 2 - see http://www.altova.com/stylevision for more information.-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:n1="http://xml.coeus.mit.edu/iacuc" xmlns:xdt="http://www.w3.org/2005/xpath-datatypes" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output version="1.0" method="xml" encoding="UTF-8" indent="no"/>
	<xsl:param name="SV_OutputFormat" select="\'PDF\'"/>
	<xsl:variable name="XML" select="/"/>
	<xsl:variable name="fo:layout-master-set">
		<fo:layout-master-set>
			<fo:simple-page-master master-name="default-page" page-height="11in" page-width="8.5in" margin-left="0.6in" margin-right="0.6in">
				<fo:region-body margin-top="0.79in" margin-bottom="0.79in"/>
				<fo:region-before extent="0.79in"/>
			</fo:simple-page-master>
		</fo:layout-master-set>
	</xsl:variable>
	<xsl:template match="/">
		<fo:root>
			<xsl:copy-of select="$fo:layout-master-set"/>
			<fo:page-sequence master-reference="default-page" initial-page-number="1" format="1">
				<xsl:call-template name="headerall"/>
				<fo:flow flow-name="xsl-region-body">
					<fo:block>
						<xsl:for-each select="$XML">
							<fo:external-graphic>
								<xsl:attribute name="src">
									<xsl:text>url(</xsl:text>
									<xsl:call-template name="double-backslash">
										<xsl:with-param name="text">
											<xsl:value-of select="string(&apos;/export/home/www/https/tomcat5.0.25/webapps/coeus/images/couhes_byline2.gif&apos;)"/>
										</xsl:with-param>
										<xsl:with-param name="text-length">
											<xsl:value-of select="string-length(string(&apos;/export/home/www/https/tomcat5.0.25/webapps/coeus/images/couhes_byline2.gif&apos;))"/>
										</xsl:with-param>
									</xsl:call-template>
									<xsl:text>)</xsl:text>
								</xsl:attribute>
							</fo:external-graphic>
							<fo:block text-align="center">
								<fo:leader leader-pattern="rule" rule-thickness="1" leader-length="100%" color="black"/>
							</fo:block>
							<fo:block/>
							<xsl:for-each select="n1:Correspondence">
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block margin="0pt">
									<fo:block>
										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x2029;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
											<fo:table-column column-width="25%"/>
											<fo:table-column column-width="75%"/>
											<fo:table-body start-indent="0pt">
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>To:</xsl:text>
															</fo:inline>
															<fo:inline font-size="10pt">
																<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="before">
														<fo:block>
															<xsl:for-each select="n1:Protocol">
																<xsl:for-each select="n1:Investigator">
																	<xsl:if test="n1:PI_flag = &apos;true&apos;">
																		<xsl:for-each select="n1:Person">
																			<xsl:for-each select="n1:Firstname">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																						<fo:block font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:for-each>
																			<fo:inline font-size="10pt">
																				<xsl:text>&#160;</xsl:text>
																			</fo:inline>
																			<xsl:for-each select="n1:LastName">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																						<fo:block font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:for-each>
																			<fo:inline-container>
																				<fo:block>
																					<xsl:text>&#x2029;</xsl:text>
																				</fo:block>
																			</fo:inline-container>
																			<fo:block white-space="pre" white-space-collapse="false" margin="0pt">
																				<fo:block>
																					<xsl:for-each select="n1:OfficeLocation">
																						<xsl:variable name="value-of-template">
																							<xsl:apply-templates/>
																						</xsl:variable>
																						<xsl:choose>
																							<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																								<fo:block font-family="Book Antiqua" font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:block>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline font-family="Book Antiqua" font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:for-each>
																				</fo:block>
																			</fo:block>
																		</xsl:for-each>
																	</xsl:if>
																</xsl:for-each>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>From:</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="before">
														<fo:block>
															<xsl:for-each select="n1:Protocol">
																<xsl:for-each select="n1:Submissions">
																	<xsl:for-each select="n1:CommitteeMember">
																		<xsl:if test="n1:CommitteeMemberRole/n1:MemberRoleDesc = &apos;Chair&apos;">
																			<xsl:for-each select="n1:Person">
																				<xsl:for-each select="n1:Firstname">
																					<xsl:if test="../../../n1:CurrentSubmissionFlag =&apos;No&apos;">
																						<xsl:variable name="value-of-template">
																							<xsl:apply-templates/>
																						</xsl:variable>
																						<xsl:choose>
																							<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																								<fo:block font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:block>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:if>
																				</xsl:for-each>
																				<fo:inline font-size="10pt">
																					<xsl:text>&#160;</xsl:text>
																				</fo:inline>
																				<xsl:for-each select="n1:LastName">
																					<xsl:if test="../../../n1:CurrentSubmissionFlag =&apos;No&apos;">
																						<xsl:variable name="value-of-template">
																							<xsl:apply-templates/>
																						</xsl:variable>
																						<xsl:choose>
																							<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																								<fo:block font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:block>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:if>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:if>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
															<fo:inline font-size="10pt">
																<xsl:text>, Chair </xsl:text>
															</fo:inline>
															<fo:inline-container>
																<fo:block>
																	<xsl:text>&#x2029;</xsl:text>
																</fo:block>
															</fo:inline-container>
															<fo:block white-space="pre" white-space-collapse="false" margin="0pt">
																<fo:block>
																	<xsl:for-each select="n1:Protocol">
																		<xsl:for-each select="n1:Submissions">
																			<xsl:for-each select="n1:CommitteeMasterData">
																				<xsl:for-each select="n1:CommitteeName">
																					<xsl:if test="../../n1:CurrentSubmissionFlag =&apos;No&apos;">
																						<xsl:variable name="value-of-template">
																							<xsl:apply-templates/>
																						</xsl:variable>
																						<xsl:choose>
																							<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																								<fo:block font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:block>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:if>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:block>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>Date:</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="before">
														<fo:block>
															<xsl:for-each select="n1:CurrentDate">
																<fo:inline font-family="Book Antiqua" font-size="10pt">
																	<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																	<xsl:text>/</xsl:text>
																	<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																	<xsl:text>/</xsl:text>
																	<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
																</fo:inline>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>Committee Action:</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>Notify IACUC </xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x2029;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
											<fo:table-column column-width="25%"/>
											<fo:table-column column-width="75%"/>
											<fo:table-body start-indent="0pt">
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>Committee Action Date: </xsl:text>
															</fo:inline>
															<fo:inline font-size="10pt">
																<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="before">
														<fo:block>
															<xsl:for-each select="n1:Protocol">
																<xsl:for-each select="n1:Submissions">
																	<xsl:for-each select="n1:SubmissionDetails">
																		<xsl:for-each select="n1:ActionType">
																			<xsl:for-each select="n1:ActionDate">
																				<xsl:if test="../../../n1:CurrentSubmissionFlag =&apos;No&apos;">
																					<fo:inline font-size="10pt">
																						<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																						<xsl:text>/</xsl:text>
																						<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																						<xsl:text>/</xsl:text>
																						<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
																					</fo:inline>
																				</xsl:if>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>IACUC Protocol #: </xsl:text>
															</fo:inline>
															<fo:inline font-size="10pt">
																<xsl:text>&#160;&#160;&#160;&#160; </xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="before">
														<fo:block>
															<xsl:for-each select="n1:Protocol">
																<xsl:for-each select="n1:ProtocolMasterData">
																	<xsl:for-each select="n1:ProtocolNumber">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																				<fo:block font-size="10pt">
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline font-size="10pt">
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>Study Title:</xsl:text>
															</fo:inline>
															<fo:inline font-size="10pt">
																<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="before">
														<fo:block>
															<xsl:for-each select="n1:Protocol">
																<xsl:for-each select="n1:ProtocolMasterData">
																	<xsl:for-each select="n1:ProtocolTitle">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																				<fo:block font-size="10pt">
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline font-size="10pt">
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
									</fo:block>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block font-family="Arial" font-size="10pt" margin="0pt">
									<fo:block>
										<fo:inline font-size="10pt">
											<xsl:text> Notify IACUC action has been performed for the above-referenced protocol.</xsl:text>
										</fo:inline>
									</fo:block>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block margin="0pt">
									<fo:block>
										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x2029;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
											<fo:table-column column-width="27"/>
											<fo:table-column column-width="1000"/>
											<fo:table-body start-indent="0pt">
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" height="19" display-align="center">
														<fo:block>
															<fo:inline font-family="Arial" font-size="10pt">
																<xsl:text>cc:&#160;&#160; </xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" height="19" display-align="center">
														<fo:block>
															<fo:inline font-family="Arial" font-size="10pt">
																<xsl:text>Tom Duff </xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="center">
														<fo:block/>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="before">
														<fo:block>
															<xsl:for-each select="n1:Protocol">
																<xsl:for-each select="n1:Correspondent">
																	<xsl:for-each select="n1:Person">
																		<xsl:for-each select="n1:Fullname">
																			<xsl:if test="../../n1:TypeOfCorrespondent = &apos;CRC&apos;">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																						<fo:block font-family="Arial" font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline font-family="Arial" font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:if>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
									</fo:block>
								</fo:block>
							</xsl:for-each>
						</xsl:for-each>
					</fo:block>
					<fo:block id="SV_RefID_PageTotal"/>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	<xsl:template name="headerall">
		<fo:static-content flow-name="xsl-region-before">
			<fo:block>
				<xsl:for-each select="$XML">
					<fo:inline-container>
						<fo:block>
							<xsl:text>&#x2029;</xsl:text>
						</fo:block>
					</fo:inline-container>
					<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
						<fo:table-column column-width="proportional-column-width(1)"/>
						<fo:table-column column-width="150"/>
						<fo:table-body start-indent="0pt">
							<fo:table-row>
								<fo:table-cell padding="0" number-columns-spanned="2" height="30" display-align="center">
									<fo:block/>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell font-size="smaller" padding="0" text-align="left" display-align="center">
									<fo:block/>
								</fo:table-cell>
								<fo:table-cell font-size="smaller" padding="0" text-align="right" display-align="center">
									<fo:block/>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell padding="0" number-columns-spanned="2" display-align="center">
									<fo:block/>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</xsl:for-each>
			</fo:block>
		</fo:static-content>
	</xsl:template>
	<xsl:template name="double-backslash">
		<xsl:param name="text"/>
		<xsl:param name="text-length"/>
		<xsl:variable name="text-after-bs" select="substring-after($text, \'\\\')"/>
		<xsl:variable name="text-after-bs-length" select="string-length($text-after-bs)"/>
		<xsl:choose>
			<xsl:when test="$text-after-bs-length = 0">
				<xsl:choose>
					<xsl:when test="substring($text, $text-length) = \'\\\'">
						<xsl:value-of select="concat(substring($text,1,$text-length - 1), \'\\\\\')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$text"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="concat(substring($text,1,$text-length - $text-after-bs-length - 1), \'\\\\\')"/>
				<xsl:call-template name="double-backslash">
					<xsl:with-param name="text" select="$text-after-bs"/>
					<xsl:with-param name="text-length" select="$text-after-bs-length"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
','NotifyIACUCLetter.xslt',UUID(),(SELECT (MAX(ID)) FROM SEQ_IACUC_PROTO_CORRESP_TEMPL),'22',NOW(),'admin',1)
/
INSERT INTO SEQ_IACUC_PROTO_CORRESP_TEMPL VALUES(NULL)
/
INSERT INTO IACUC_PROTO_CORRESP_TEMPL (COMMITTEE_ID,CORRESPONDENCE_TEMPLATE,FILE_NAME,OBJ_ID,PROTO_CORRESP_TEMPL_ID,PROTO_CORRESP_TYPE_CODE,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR)
  VALUES ('DEFAULT','<?xml version="1.0" encoding="UTF-8"?>
<!--Designed and generated by Altova StyleVision Enterprise Edition 2011 - see http://www.altova.com/stylevision for more information.-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:clitype="clitype" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:iso4217="http://www.xbrl.org/2003/iso4217" xmlns:ix="http://www.xbrl.org/2008/inlineXBRL" xmlns:java="java" xmlns:link="http://www.xbrl.org/2003/linkbase" xmlns:n1="http://xml.coeus.mit.edu/iacuc" xmlns:xbrldi="http://xbrl.org/2006/xbrldi" xmlns:xbrli="http://www.xbrl.org/2003/instance" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:altova="http://www.altova.com" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:svg="http://www.w3.org/2000/svg" exclude-result-prefixes="clitype fn iso4217 ix java link n1 xbrldi xbrli xlink xs xsi altova">
	<xsl:output version="1.0" method="xml" encoding="UTF-8" indent="no"/>
	<xsl:param name="SV_OutputFormat" select="\'PDF\'"/>
	<xsl:variable name="XML" select="/"/>
	<xsl:variable name="fo:layout-master-set">
		<fo:layout-master-set>
			<fo:simple-page-master master-name="page-master-336727208-even" margin-left="0.60in" margin-right="0.60in" page-height="11in" page-width="8.50in">
				<fo:region-body margin-top="0.99in" margin-bottom="0.79in" column-count="1" column-gap="0.50in"/>
				<fo:region-before region-name="even-page-header" overflow="hidden" extent="0.69in"/>
			</fo:simple-page-master>
			<fo:simple-page-master master-name="page-master-336727208-odd" margin-left="0.60in" margin-right="0.60in" page-height="11in" page-width="8.50in">
				<fo:region-body margin-top="0.99in" margin-bottom="0.79in" column-count="1" column-gap="0.50in"/>
				<fo:region-before region-name="odd-page-header" overflow="hidden" extent="0.69in"/>
			</fo:simple-page-master>
			<fo:page-sequence-master master-name="page-master-336727208">
				<fo:repeatable-page-master-alternatives>
					<fo:conditional-page-master-reference master-reference="page-master-336727208-even" odd-or-even="even"/>
					<fo:conditional-page-master-reference master-reference="page-master-336727208-odd" odd-or-even="odd"/>
				</fo:repeatable-page-master-alternatives>
			</fo:page-sequence-master>
		</fo:layout-master-set>
	</xsl:variable>
	<xsl:variable name="altova:nPxPerIn" select="96"/>
	<xsl:template match="/">
		<fo:root>
			<xsl:copy-of select="$fo:layout-master-set"/>
			<fo:page-sequence force-page-count="no-force" master-reference="page-master-336727208" initial-page-number="auto" format="1">
				<fo:static-content flow-name="odd-page-header">
					<fo:block-container margin-top="0.30in">
						<fo:block>
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x200B;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:table width="100%" table-layout="fixed" border-spacing="2pt">
								<fo:table-column column-width="90%"/>
								<fo:table-column column-width="10%"/>
								<xsl:variable name="altova:CurrContextGrid_14126838" select="."/>
								<fo:table-body start-indent="0pt">
									<xsl:variable name="altova:tablerows">
										<fo:table-row>
											<fo:table-cell font-size="10pt" padding="0" display-align="center">
												<fo:block text-align="left">
													<fo:inline>
														<xsl:text>&#160;</xsl:text>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell font-size="10pt" padding="0" display-align="center">
												<fo:block text-align="right"/>
											</fo:table-cell>
										</fo:table-row>
										<fo:table-row>
											<fo:table-cell number-columns-spanned="2" padding="0" display-align="center">
												<fo:block text-align="left">
													<fo:block text-align="center">
														<fo:leader leader-pattern="rule" rule-thickness="1" leader-length="100%" color="black"/>
													</fo:block>
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
									</xsl:variable>
									<xsl:choose>
										<xsl:when test="string($altova:tablerows)">
											<xsl:copy-of select="$altova:tablerows"/>
										</xsl:when>
										<xsl:otherwise>
											<fo:table-row>
												<fo:table-cell>
													<fo:block/>
												</fo:table-cell>
											</fo:table-row>
										</xsl:otherwise>
									</xsl:choose>
								</fo:table-body>
							</fo:table>
						</fo:block>
					</fo:block-container>
				</fo:static-content>
				<fo:static-content flow-name="even-page-header">
					<fo:block-container margin-top="0.30in">
						<fo:block>
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x200B;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:table width="100%" table-layout="fixed" border-spacing="2pt">
								<fo:table-column column-width="90%"/>
								<fo:table-column column-width="10%"/>
								<xsl:variable name="altova:CurrContextGrid_14126838" select="."/>
								<fo:table-body start-indent="0pt">
									<xsl:variable name="altova:tablerows">
										<fo:table-row>
											<fo:table-cell font-size="10pt" padding="0" display-align="center">
												<fo:block text-align="left">
													<fo:inline>
														<xsl:text>&#160;</xsl:text>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell font-size="10pt" padding="0" display-align="center">
												<fo:block text-align="right"/>
											</fo:table-cell>
										</fo:table-row>
										<fo:table-row>
											<fo:table-cell number-columns-spanned="2" padding="0" display-align="center">
												<fo:block text-align="left">
													<fo:block text-align="center">
														<fo:leader leader-pattern="rule" rule-thickness="1" leader-length="100%" color="black"/>
													</fo:block>
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
									</xsl:variable>
									<xsl:choose>
										<xsl:when test="string($altova:tablerows)">
											<xsl:copy-of select="$altova:tablerows"/>
										</xsl:when>
										<xsl:otherwise>
											<fo:table-row>
												<fo:table-cell>
													<fo:block/>
												</fo:table-cell>
											</fo:table-row>
										</xsl:otherwise>
									</xsl:choose>
								</fo:table-body>
							</fo:table>
						</fo:block>
					</fo:block-container>
				</fo:static-content>
				<fo:flow flow-name="xsl-region-body">
					<fo:block>
						<xsl:for-each select="$XML">
							<xsl:for-each select="n1:Correspondence">
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x200B;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:table font-family="inherit" table-layout="fixed" width="100%" border-spacing="2pt">
									<fo:table-column column-width="1.520in"/>
									<fo:table-column column-width="0.430in"/>
									<fo:table-column column-width="6.430in"/>
									<xsl:variable name="altova:CurrContextGrid_14126058" select="."/>
									<fo:table-body start-indent="0pt">
										<xsl:variable name="altova:tablerows">
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>To:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:Investigator">
																<xsl:for-each select="n1:Person">
																	<xsl:for-each select="n1:Fullname">
																		<xsl:variable name="value-of-template_11F320C8">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template_11F320C8),\'&#x200B;\')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template_11F320C8"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template_11F320C8"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>From:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:Submissions">
																<xsl:for-each select="n1:CommitteeMember">
																	<xsl:for-each select="n1:Person">
																		<xsl:for-each select="n1:Fullname">
																			<xsl:variable name="value-of-template_11F321A8">
																				<xsl:apply-templates/>
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when test="contains(string($value-of-template_11F321A8),\'&#x200B;\')">
																					<fo:block>
																						<xsl:copy-of select="$value-of-template_11F321A8"/>
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline>
																						<xsl:copy-of select="$value-of-template_11F321A8"/>
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
														<fo:inline>
															<xsl:text>, Chair</xsl:text>
														</fo:inline>
														<fo:block/>
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:Submissions">
																<xsl:for-each select="n1:CommitteeMasterData">
																	<xsl:for-each select="n1:CommitteeName">
																		<xsl:variable name="value-of-template_11F31FE8">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template_11F31FE8),\'&#x200B;\')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template_11F31FE8"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template_11F31FE8"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Date:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:CurrentDate">
															<fo:inline>
																<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																<xsl:text> / </xsl:text>
																<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																<xsl:text> / </xsl:text>
																<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
															</fo:inline>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Committee Action:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>About the over usage of animals.</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Action Date:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:Submissions">
																<xsl:for-each select="n1:SubmissionDetails">
																	<xsl:for-each select="n1:ActionType">
																		<xsl:for-each select="n1:ActionDate">
																			<fo:inline>
																				<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																				<xsl:text> / </xsl:text>
																				<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																				<xsl:text> / </xsl:text>
																				<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
																			</fo:inline>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row height="0.38in">
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Protocol Number:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:ProtocolMasterData">
																<xsl:for-each select="n1:ProtocolNumber">
																	<xsl:variable name="value-of-template_11F32C28">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template_11F32C28),\'&#x200B;\')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template_11F32C28"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template_11F32C28"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row height="0.20in">
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Study Title:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:ProtocolMasterData">
																<xsl:for-each select="n1:ProtocolTitle">
																	<xsl:variable name="value-of-template_0A8346B0">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template_0A8346B0),\'&#x200B;\')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template_0A8346B0"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template_0A8346B0"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Expiration Date:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:ProtocolMasterData">
																<xsl:for-each select="n1:ExpirationDate">
																	<fo:inline>
																		<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																		<xsl:text> / </xsl:text>
																		<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																		<xsl:text> / </xsl:text>
																		<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
																	</fo:inline>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</xsl:variable>
										<xsl:choose>
											<xsl:when test="string($altova:tablerows)">
												<xsl:copy-of select="$altova:tablerows"/>
											</xsl:when>
											<xsl:otherwise>
												<fo:table-row>
													<fo:table-cell>
														<fo:block/>
													</fo:table-cell>
												</fo:table-row>
											</xsl:otherwise>
										</xsl:choose>
									</fo:table-body>
								</fo:table>
							</xsl:for-each>
							<fo:block/>
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x200B;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:block margin="0pt">
								<fo:inline>
									<xsl:text>The committee found the over usage of animals for above mentioned protocol. The protocol must cover at least these points: </xsl:text>
								</fo:inline>
							</fo:block>
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x200B;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:block margin="0pt">
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x200B;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:list-block provisional-distance-between-starts="7mm" provisional-label-separation="2mm">
									<fo:list-item>
										<fo:list-item-label end-indent="label-end()" text-align="right">
											<fo:block font-family="Courier">&#x2022;</fo:block>
										</fo:list-item-label>
										<fo:list-item-body start-indent="body-start()">
											<fo:block>
												<fo:inline>
													<xsl:text>Identification of the species and approximate number of animals to be used.</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:list-item-body>
									</fo:list-item>
									<fo:list-item>
										<fo:list-item-label end-indent="label-end()" text-align="right">
											<fo:block font-family="Courier">&#x2022;</fo:block>
										</fo:list-item-label>
										<fo:list-item-body start-indent="body-start()">
											<fo:block>
												<fo:inline>
													<xsl:text>Rationale for involving animals, and for the appropriateness of the species and numbers used.</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:list-item-body>
									</fo:list-item>
									<fo:list-item>
										<fo:list-item-label end-indent="label-end()" text-align="right">
											<fo:block font-family="Courier">&#x2022;</fo:block>
										</fo:list-item-label>
										<fo:list-item-body start-indent="body-start()">
											<fo:block>
												<fo:inline>
													<xsl:text>A complete description of the proposed use of the animals.</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:list-item-body>
									</fo:list-item>
									<fo:list-item>
										<fo:list-item-label end-indent="label-end()" text-align="right">
											<fo:block font-family="Courier">&#x2022;</fo:block>
										</fo:list-item-label>
										<fo:list-item-body start-indent="body-start()">
											<fo:block>
												<fo:inline>
													<xsl:text>A description of procedures designed to assure that discomfort and injury to animals will be limited to that which is unavoidable in the conduct of scientifically valuable research, and that analgesic, anesthetic, and tranquilizing drugs will be used where indicated and appropriate to minimize discomfort and pain to animals.</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:list-item-body>
									</fo:list-item>
									<fo:list-item>
										<fo:list-item-label end-indent="label-end()" text-align="right">
											<fo:block font-family="Courier">&#x2022;</fo:block>
										</fo:list-item-label>
										<fo:list-item-body start-indent="body-start()">
											<fo:block>
												<fo:inline>
													<xsl:text>A description of any euthanasia method to be used. </xsl:text>
												</fo:inline>
											</fo:block>
										</fo:list-item-body>
									</fo:list-item>
								</fo:list-block>
							</fo:block>
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x200B;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:block margin="0pt">
								<fo:inline>
									<xsl:text>Kindly do the needful.</xsl:text>
								</fo:inline>
							</fo:block>
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x200B;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:block margin="0pt">
								<fo:inline>
									<xsl:text>Thank you.</xsl:text>
								</fo:inline>
							</fo:block>
						</xsl:for-each>
					</fo:block>
					<fo:block id="SV_RefID_PageTotal"/>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	<xsl:template name="double-backslash">
		<xsl:param name="text"/>
		<xsl:param name="text-length"/>
		<xsl:variable name="text-after-bs" select="substring-after($text, \'\\\')"/>
		<xsl:variable name="text-after-bs-length" select="string-length($text-after-bs)"/>
		<xsl:choose>
			<xsl:when test="$text-after-bs-length = 0">
				<xsl:choose>
					<xsl:when test="substring($text, $text-length) = \'\\\'">
						<xsl:value-of select="concat(substring($text,1,$text-length - 1), \'\\\\\')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$text"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="concat(substring($text,1,$text-length - $text-after-bs-length - 1), \'\\\\\')"/>
				<xsl:call-template name="double-backslash">
					<xsl:with-param name="text" select="$text-after-bs"/>
					<xsl:with-param name="text-length" select="$text-after-bs-length"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="altova:MakeValueAbsoluteIfPixels">
		<xsl:param name="sValue"/>
		<xsl:variable name="sBeforePx" select="substring-before($sValue, \'px\')"/>
		<xsl:choose>
			<xsl:when test="$sBeforePx">
				<xsl:variable name="nLengthOfInteger">
					<xsl:call-template name="altova:GetCharCountOfIntegerAtEndOfString">
						<xsl:with-param name="sText" select="$sBeforePx"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:variable name="nPosOfInteger" select="string-length($sBeforePx) - $nLengthOfInteger + 1"/>
				<xsl:variable name="nValuePx" select="substring($sBeforePx, $nPosOfInteger)"/>
				<xsl:variable name="nValueIn" select="number($nValuePx) div number($altova:nPxPerIn)"/>
				<xsl:variable name="nLengthBeforeInteger" select="string-length($sBeforePx) - $nLengthOfInteger"/>
				<xsl:variable name="sRest">
					<xsl:call-template name="altova:MakeValueAbsoluteIfPixels">
						<xsl:with-param name="sValue" select="substring-after($sValue, \'px\')"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="concat(substring($sBeforePx, 1, $nLengthBeforeInteger), string($nValueIn), \'in\', $sRest)"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$sValue"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="altova:GetCharCountOfIntegerAtEndOfString">
		<xsl:param name="sText"/>
		<xsl:variable name="sLen" select="string-length($sText)"/>
		<xsl:variable name="cLast" select="substring($sText, $sLen)"/>
		<xsl:choose>
			<xsl:when test="number($cLast) &gt;= 0 and number($cLast) &lt;= 9">
				<xsl:variable name="nResultOfRest">
					<xsl:call-template name="altova:GetCharCountOfIntegerAtEndOfString">
						<xsl:with-param name="sText" select="substring($sText, 1, $sLen - 1)"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="$nResultOfRest + 1"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text>0</xsl:text>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
','OverUsageOfAnimals.xslt',UUID(),(SELECT (MAX(ID)) FROM SEQ_IACUC_PROTO_CORRESP_TEMPL),'23',NOW(),'admin',1)
/
INSERT INTO SEQ_IACUC_PROTO_CORRESP_TEMPL VALUES(NULL)
/
INSERT INTO IACUC_PROTO_CORRESP_TEMPL (COMMITTEE_ID,CORRESPONDENCE_TEMPLATE,FILE_NAME,OBJ_ID,PROTO_CORRESP_TEMPL_ID,PROTO_CORRESP_TYPE_CODE,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR)
  VALUES ('DEFAULT','<?xml version="1.0" encoding="UTF-8"?>
<!--Designed and generated by Altova StyleVision Enterprise Edition 2011 - see http://www.altova.com/stylevision for more information.-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:clitype="clitype" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:iso4217="http://www.xbrl.org/2003/iso4217" xmlns:ix="http://www.xbrl.org/2008/inlineXBRL" xmlns:java="java" xmlns:link="http://www.xbrl.org/2003/linkbase" xmlns:n1="http://xml.coeus.mit.edu/iacuc" xmlns:xbrldi="http://xbrl.org/2006/xbrldi" xmlns:xbrli="http://www.xbrl.org/2003/instance" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:altova="http://www.altova.com" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:svg="http://www.w3.org/2000/svg" exclude-result-prefixes="clitype fn iso4217 ix java link n1 xbrldi xbrli xlink xs xsi altova">
	<xsl:output version="1.0" method="xml" encoding="UTF-8" indent="no"/>
	<xsl:param name="SV_OutputFormat" select="\'PDF\'"/>
	<xsl:variable name="XML" select="/"/>
	<xsl:variable name="fo:layout-master-set">
		<fo:layout-master-set>
			<fo:simple-page-master master-name="page-master-318600176" margin-left="0.60in" margin-right="0.60in" page-height="11in" page-width="8.50in">
				<fo:region-body margin-top="0.79in" margin-bottom="0.79in" column-count="1" column-gap="0.50in"/>
			</fo:simple-page-master>
		</fo:layout-master-set>
	</xsl:variable>
	<xsl:variable name="altova:nPxPerIn" select="96"/>
	<xsl:template match="/">
		<fo:root>
			<xsl:copy-of select="$fo:layout-master-set"/>
			<fo:page-sequence force-page-count="no-force" master-reference="page-master-318600176" initial-page-number="auto" format="1">
				<fo:flow flow-name="xsl-region-body">
					<fo:block>
						<fo:inline-container>
							<fo:block>
								<xsl:text>&#x200B;</xsl:text>
							</fo:block>
						</fo:inline-container>
						<fo:table width="100%" table-layout="fixed" border-spacing="2pt">
							<fo:table-column column-width="90%"/>
							<fo:table-column column-width="10%"/>
							<xsl:variable name="altova:CurrContextGrid_159C7880" select="."/>
							<fo:table-body start-indent="0pt">
								<xsl:variable name="altova:tablerows">
									<fo:table-row>
										<fo:table-cell font-size="10pt" padding="0" display-align="center">
											<fo:block text-align="left">
												<fo:inline>
													<xsl:text>&#160;</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell font-size="10pt" padding="0" display-align="center">
											<fo:block text-align="right">
												<fo:inline>
													<xsl:text>&#160;</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell number-columns-spanned="2" padding="0" display-align="center">
											<fo:block text-align="left">
												<fo:block text-align="center">
													<fo:leader leader-pattern="rule" rule-thickness="2" leader-length="100%" color="black"/>
												</fo:block>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</xsl:variable>
								<xsl:choose>
									<xsl:when test="string($altova:tablerows)">
										<xsl:copy-of select="$altova:tablerows"/>
									</xsl:when>
									<xsl:otherwise>
										<fo:table-row>
											<fo:table-cell>
												<fo:block/>
											</fo:table-cell>
										</fo:table-row>
									</xsl:otherwise>
								</xsl:choose>
							</fo:table-body>
						</fo:table>
						<fo:block>
							<fo:leader leader-pattern="space"/>
						</fo:block>
						<xsl:for-each select="$XML">
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
							<xsl:for-each select="n1:Correspondence">
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x200B;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:table font-family="inherit" table-layout="fixed" width="100%" border-spacing="2pt">
									<fo:table-column column-width="1.580in"/>
									<fo:table-column column-width="0.430in"/>
									<fo:table-column column-width="6.430in"/>
									<xsl:variable name="altova:CurrContextGrid_15F21588" select="."/>
									<fo:table-body start-indent="0pt">
										<xsl:variable name="altova:tablerows">
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>To:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:Investigator">
																<xsl:for-each select="n1:Person">
																	<xsl:for-each select="n1:Fullname">
																		<xsl:variable name="value-of-template_123CDB48">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template_123CDB48),\'&#x200B;\')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template_123CDB48"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template_123CDB48"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>From:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:Submissions">
																<xsl:for-each select="n1:CommitteeMember">
																	<xsl:for-each select="n1:Person">
																		<xsl:for-each select="n1:Fullname">
																			<xsl:variable name="value-of-template_123CE5C8">
																				<xsl:apply-templates/>
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when test="contains(string($value-of-template_123CE5C8),\'&#x200B;\')">
																					<fo:block>
																						<xsl:copy-of select="$value-of-template_123CE5C8"/>
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline>
																						<xsl:copy-of select="$value-of-template_123CE5C8"/>
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
														<fo:inline>
															<xsl:text>, Chair</xsl:text>
														</fo:inline>
														<fo:block/>
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:Submissions">
																<xsl:for-each select="n1:CommitteeMasterData">
																	<xsl:for-each select="n1:CommitteeName">
																		<xsl:variable name="value-of-template_123CE4E8">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template_123CE4E8),\'&#x200B;\')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template_123CE4E8"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template_123CE4E8"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Date:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:CurrentDate">
															<fo:inline>
																<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																<xsl:text> / </xsl:text>
																<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																<xsl:text> / </xsl:text>
																<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
															</fo:inline>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row height="0.31in">
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Committee Action:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Renewal Reminder Notification</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Action Date:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:Submissions">
																<xsl:for-each select="n1:SubmissionDetails">
																	<xsl:for-each select="n1:ActionType">
																		<xsl:for-each select="n1:ActionDate">
																			<fo:inline>
																				<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																				<xsl:text> / </xsl:text>
																				<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																				<xsl:text> / </xsl:text>
																				<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
																			</fo:inline>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row height="0.38in">
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Protocol Number:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:ProtocolMasterData">
																<xsl:for-each select="n1:ProtocolNumber">
																	<xsl:variable name="value-of-template_123CE328">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template_123CE328),\'&#x200B;\')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template_123CE328"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template_123CE328"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row height="0.20in">
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Study Title:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:ProtocolMasterData">
																<xsl:for-each select="n1:ProtocolTitle">
																	<xsl:variable name="value-of-template_123CE088">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template_123CE088),\'&#x200B;\')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template_123CE088"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template_123CE088"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Expiration Date:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:ProtocolMasterData">
																<xsl:for-each select="n1:ExpirationDate">
																	<fo:inline>
																		<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																		<xsl:text> / </xsl:text>
																		<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																		<xsl:text> / </xsl:text>
																		<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
																	</fo:inline>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</xsl:variable>
										<xsl:choose>
											<xsl:when test="string($altova:tablerows)">
												<xsl:copy-of select="$altova:tablerows"/>
											</xsl:when>
											<xsl:otherwise>
												<fo:table-row>
													<fo:table-cell>
														<fo:block/>
													</fo:table-cell>
												</fo:table-row>
											</xsl:otherwise>
										</xsl:choose>
									</fo:table-body>
								</fo:table>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
							</xsl:for-each>
							<fo:block/>
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x200B;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:block margin="0pt">
								<fo:inline>
									<xsl:text>Above mentioned protocol will be due for an Annual Review on ???ANNUAL REVIEW DATE-. Please submit an annual report in sufficient time for the IACUC to review and approve the continuation by ???ANNUAL REVIEW DATE-. The IACUC must suspend your approval to use animals if the annual report is not submitted and approved before ???ANNUAL REVIEW DATE-.</xsl:text>
								</fo:inline>
							</fo:block>
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x200B;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:block margin="0pt">
								<fo:inline>
									<xsl:text>Please Note: Annual reviews cannot be approved unless all personnel named on the protocol are up to date with Module 1 training requirements.</xsl:text>
								</fo:inline>
							</fo:block>
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x200B;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:block margin="0pt">
								<fo:inline>
									<xsl:text>Thank you.</xsl:text>
								</fo:inline>
							</fo:block>
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
						</xsl:for-each>
					</fo:block>
					<fo:block id="SV_RefID_PageTotal"/>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	<xsl:template name="double-backslash">
		<xsl:param name="text"/>
		<xsl:param name="text-length"/>
		<xsl:variable name="text-after-bs" select="substring-after($text, \'\\\')"/>
		<xsl:variable name="text-after-bs-length" select="string-length($text-after-bs)"/>
		<xsl:choose>
			<xsl:when test="$text-after-bs-length = 0">
				<xsl:choose>
					<xsl:when test="substring($text, $text-length) = \'\\\'">
						<xsl:value-of select="concat(substring($text,1,$text-length - 1), \'\\\\\')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$text"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="concat(substring($text,1,$text-length - $text-after-bs-length - 1), \'\\\\\')"/>
				<xsl:call-template name="double-backslash">
					<xsl:with-param name="text" select="$text-after-bs"/>
					<xsl:with-param name="text-length" select="$text-after-bs-length"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="altova:MakeValueAbsoluteIfPixels">
		<xsl:param name="sValue"/>
		<xsl:variable name="sBeforePx" select="substring-before($sValue, \'px\')"/>
		<xsl:choose>
			<xsl:when test="$sBeforePx">
				<xsl:variable name="nLengthOfInteger">
					<xsl:call-template name="altova:GetCharCountOfIntegerAtEndOfString">
						<xsl:with-param name="sText" select="$sBeforePx"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:variable name="nPosOfInteger" select="string-length($sBeforePx) - $nLengthOfInteger + 1"/>
				<xsl:variable name="nValuePx" select="substring($sBeforePx, $nPosOfInteger)"/>
				<xsl:variable name="nValueIn" select="number($nValuePx) div number($altova:nPxPerIn)"/>
				<xsl:variable name="nLengthBeforeInteger" select="string-length($sBeforePx) - $nLengthOfInteger"/>
				<xsl:variable name="sRest">
					<xsl:call-template name="altova:MakeValueAbsoluteIfPixels">
						<xsl:with-param name="sValue" select="substring-after($sValue, \'px\')"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="concat(substring($sBeforePx, 1, $nLengthBeforeInteger), string($nValueIn), \'in\', $sRest)"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$sValue"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="altova:GetCharCountOfIntegerAtEndOfString">
		<xsl:param name="sText"/>
		<xsl:variable name="sLen" select="string-length($sText)"/>
		<xsl:variable name="cLast" select="substring($sText, $sLen)"/>
		<xsl:choose>
			<xsl:when test="number($cLast) &gt;= 0 and number($cLast) &lt;= 9">
				<xsl:variable name="nResultOfRest">
					<xsl:call-template name="altova:GetCharCountOfIntegerAtEndOfString">
						<xsl:with-param name="sText" select="substring($sText, 1, $sLen - 1)"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="$nResultOfRest + 1"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text>0</xsl:text>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
','RenewalReminderNotification.xslt',UUID(),(SELECT (MAX(ID)) FROM SEQ_IACUC_PROTO_CORRESP_TEMPL),'24',NOW(),'admin',1)
/
INSERT INTO SEQ_IACUC_PROTO_CORRESP_TEMPL VALUES(NULL)
/
INSERT INTO IACUC_PROTO_CORRESP_TEMPL (COMMITTEE_ID,CORRESPONDENCE_TEMPLATE,FILE_NAME,OBJ_ID,PROTO_CORRESP_TEMPL_ID,PROTO_CORRESP_TYPE_CODE,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR)
  VALUES ('DEFAULT','<?xml version="1.0" encoding="UTF-8"?>
<!--Designed and generated by Altova StyleVision Enterprise Edition 2008 rel. 2 - see http://www.altova.com/stylevision for more information.-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:n1="http://xml.coeus.mit.edu/iacuc" xmlns:xdt="http://www.w3.org/2005/xpath-datatypes" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output version="1.0" method="xml" encoding="UTF-8" indent="no"/>
	<xsl:param name="SV_OutputFormat" select="\'PDF\'"/>
	<xsl:variable name="XML" select="/"/>
	<xsl:variable name="fo:layout-master-set">
		<fo:layout-master-set>
			<fo:simple-page-master master-name="default-page" page-height="11in" page-width="8.5in" margin-left="0.6in" margin-right="0.6in">
				<fo:region-body margin-top="0.79in" margin-bottom="0.79in"/>
				<fo:region-before extent="0.79in"/>
			</fo:simple-page-master>
		</fo:layout-master-set>
	</xsl:variable>
	<xsl:template match="/">
		<fo:root>
			<xsl:copy-of select="$fo:layout-master-set"/>
			<fo:page-sequence master-reference="default-page" initial-page-number="1" format="1">
				<xsl:call-template name="headerall"/>
				<fo:flow flow-name="xsl-region-body">
					<fo:block>
						<xsl:for-each select="$XML">
							<fo:external-graphic>
								<xsl:attribute name="src">
									<xsl:text>url(</xsl:text>
									<xsl:call-template name="double-backslash">
										<xsl:with-param name="text">
											<xsl:value-of select="string(&apos;/export/home/www/https/tomcat5.0.25/webapps/coeus/images/couhes_byline2.gif&apos;)"/>
										</xsl:with-param>
										<xsl:with-param name="text-length">
											<xsl:value-of select="string-length(string(&apos;/export/home/www/https/tomcat5.0.25/webapps/coeus/images/couhes_byline2.gif&apos;))"/>
										</xsl:with-param>
									</xsl:call-template>
									<xsl:text>)</xsl:text>
								</xsl:attribute>
							</fo:external-graphic>
							<fo:block text-align="center">
								<fo:leader leader-pattern="rule" rule-thickness="1" leader-length="100%" color="black"/>
							</fo:block>
							<fo:block/>
							<xsl:for-each select="n1:Correspondence">
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block margin="0pt">
									<fo:block>
										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x2029;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
											<fo:table-column column-width="25%"/>
											<fo:table-column column-width="75%"/>
											<fo:table-body start-indent="0pt">
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>To:</xsl:text>
															</fo:inline>
															<fo:inline font-size="10pt">
																<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="before">
														<fo:block>
															<xsl:for-each select="n1:Protocol">
																<xsl:for-each select="n1:Investigator">
																	<xsl:if test="n1:PI_flag = &apos;true&apos;">
																		<xsl:for-each select="n1:Person">
																			<xsl:for-each select="n1:Firstname">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																						<fo:block font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:for-each>
																			<fo:inline font-size="10pt">
																				<xsl:text>&#160;</xsl:text>
																			</fo:inline>
																			<xsl:for-each select="n1:LastName">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																						<fo:block font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:for-each>
																			<fo:inline-container>
																				<fo:block>
																					<xsl:text>&#x2029;</xsl:text>
																				</fo:block>
																			</fo:inline-container>
																			<fo:block white-space="pre" white-space-collapse="false" margin="0pt">
																				<fo:block>
																					<xsl:for-each select="n1:OfficeLocation">
																						<xsl:variable name="value-of-template">
																							<xsl:apply-templates/>
																						</xsl:variable>
																						<xsl:choose>
																							<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																								<fo:block font-family="Book Antiqua" font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:block>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline font-family="Book Antiqua" font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:for-each>
																				</fo:block>
																			</fo:block>
																		</xsl:for-each>
																	</xsl:if>
																</xsl:for-each>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>From:</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="before">
														<fo:block>
															<xsl:for-each select="n1:Protocol">
																<xsl:for-each select="n1:Submissions">
																	<xsl:for-each select="n1:CommitteeMember">
																		<xsl:if test="n1:CommitteeMemberRole/n1:MemberRoleDesc = &apos;Chair&apos;">
																			<xsl:for-each select="n1:Person">
																				<xsl:for-each select="n1:Firstname">
																					<xsl:if test="../../../n1:CurrentSubmissionFlag =&apos;No&apos;">
																						<xsl:variable name="value-of-template">
																							<xsl:apply-templates/>
																						</xsl:variable>
																						<xsl:choose>
																							<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																								<fo:block font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:block>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:if>
																				</xsl:for-each>
																				<fo:inline font-size="10pt">
																					<xsl:text>&#160;</xsl:text>
																				</fo:inline>
																				<xsl:for-each select="n1:LastName">
																					<xsl:if test="../../../n1:CurrentSubmissionFlag =&apos;No&apos;">
																						<xsl:variable name="value-of-template">
																							<xsl:apply-templates/>
																						</xsl:variable>
																						<xsl:choose>
																							<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																								<fo:block font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:block>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:if>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:if>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
															<fo:inline font-size="10pt">
																<xsl:text>, Chair </xsl:text>
															</fo:inline>
															<fo:inline-container>
																<fo:block>
																	<xsl:text>&#x2029;</xsl:text>
																</fo:block>
															</fo:inline-container>
															<fo:block white-space="pre" white-space-collapse="false" margin="0pt">
																<fo:block>
																	<xsl:for-each select="n1:Protocol">
																		<xsl:for-each select="n1:Submissions">
																			<xsl:for-each select="n1:CommitteeMasterData">
																				<xsl:for-each select="n1:CommitteeName">
																					<xsl:if test="../../n1:CurrentSubmissionFlag =&apos;No&apos;">
																						<xsl:variable name="value-of-template">
																							<xsl:apply-templates/>
																						</xsl:variable>
																						<xsl:choose>
																							<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																								<fo:block font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:block>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:if>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:block>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>Date:</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="before">
														<fo:block>
															<xsl:for-each select="n1:CurrentDate">
																<fo:inline font-family="Book Antiqua" font-size="10pt">
																	<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																	<xsl:text>/</xsl:text>
																	<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																	<xsl:text>/</xsl:text>
																	<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
																</fo:inline>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>Committee Action:</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>Request to Deactivate</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x2029;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
											<fo:table-column column-width="25%"/>
											<fo:table-column column-width="75%"/>
											<fo:table-body start-indent="0pt">
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>Committee Action Date: </xsl:text>
															</fo:inline>
															<fo:inline font-size="10pt">
																<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="before">
														<fo:block>
															<xsl:for-each select="n1:Protocol">
																<xsl:for-each select="n1:Submissions">
																	<xsl:for-each select="n1:SubmissionDetails">
																		<xsl:for-each select="n1:ActionType">
																			<xsl:for-each select="n1:ActionDate">
																				<xsl:if test="../../../n1:CurrentSubmissionFlag =&apos;No&apos;">
																					<fo:inline font-size="10pt">
																						<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																						<xsl:text>/</xsl:text>
																						<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																						<xsl:text>/</xsl:text>
																						<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
																					</fo:inline>
																				</xsl:if>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>IACUC Protocol #: </xsl:text>
															</fo:inline>
															<fo:inline font-size="10pt">
																<xsl:text>&#160;&#160;&#160;&#160; </xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="before">
														<fo:block>
															<xsl:for-each select="n1:Protocol">
																<xsl:for-each select="n1:ProtocolMasterData">
																	<xsl:for-each select="n1:ProtocolNumber">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																				<fo:block font-size="10pt">
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline font-size="10pt">
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" font-weight="bold" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>Study Title:</xsl:text>
															</fo:inline>
															<fo:inline font-size="10pt">
																<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="before">
														<fo:block>
															<xsl:for-each select="n1:Protocol">
																<xsl:for-each select="n1:ProtocolMasterData">
																	<xsl:for-each select="n1:ProtocolTitle">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																				<fo:block font-size="10pt">
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline font-size="10pt">
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
									</fo:block>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block font-family="Arial" font-size="10pt" margin="0pt">
									<fo:block>
										<fo:inline font-size="10pt">
											<xsl:text> Request to Deactivate action has been performed for the above-referenced protocol.</xsl:text>
										</fo:inline>
									</fo:block>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block margin="0pt">
									<fo:block>
										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x2029;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
											<fo:table-column column-width="27"/>
											<fo:table-column column-width="1000"/>
											<fo:table-body start-indent="0pt">
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" height="19" display-align="center">
														<fo:block>
															<fo:inline font-family="Arial" font-size="10pt">
																<xsl:text>cc:&#160;&#160; </xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" height="19" display-align="center">
														<fo:block>
															<fo:inline font-family="Arial" font-size="10pt">
																<xsl:text>Tom Duff </xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="center">
														<fo:block/>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="before">
														<fo:block>
															<xsl:for-each select="n1:Protocol">
																<xsl:for-each select="n1:Correspondent">
																	<xsl:for-each select="n1:Person">
																		<xsl:for-each select="n1:Fullname">
																			<xsl:if test="../../n1:TypeOfCorrespondent = &apos;CRC&apos;">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																						<fo:block font-family="Arial" font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline font-family="Arial" font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:if>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
									</fo:block>
								</fo:block>
							</xsl:for-each>
						</xsl:for-each>
					</fo:block>
					<fo:block id="SV_RefID_PageTotal"/>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	<xsl:template name="headerall">
		<fo:static-content flow-name="xsl-region-before">
			<fo:block>
				<xsl:for-each select="$XML">
					<fo:inline-container>
						<fo:block>
							<xsl:text>&#x2029;</xsl:text>
						</fo:block>
					</fo:inline-container>
					<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
						<fo:table-column column-width="proportional-column-width(1)"/>
						<fo:table-column column-width="150"/>
						<fo:table-body start-indent="0pt">
							<fo:table-row>
								<fo:table-cell padding="0" number-columns-spanned="2" height="30" display-align="center">
									<fo:block/>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell font-size="smaller" padding="0" text-align="left" display-align="center">
									<fo:block/>
								</fo:table-cell>
								<fo:table-cell font-size="smaller" padding="0" text-align="right" display-align="center">
									<fo:block/>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell padding="0" number-columns-spanned="2" display-align="center">
									<fo:block/>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</xsl:for-each>
			</fo:block>
		</fo:static-content>
	</xsl:template>
	<xsl:template name="double-backslash">
		<xsl:param name="text"/>
		<xsl:param name="text-length"/>
		<xsl:variable name="text-after-bs" select="substring-after($text, \'\\\')"/>
		<xsl:variable name="text-after-bs-length" select="string-length($text-after-bs)"/>
		<xsl:choose>
			<xsl:when test="$text-after-bs-length = 0">
				<xsl:choose>
					<xsl:when test="substring($text, $text-length) = \'\\\'">
						<xsl:value-of select="concat(substring($text,1,$text-length - 1), \'\\\\\')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$text"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="concat(substring($text,1,$text-length - $text-after-bs-length - 1), \'\\\\\')"/>
				<xsl:call-template name="double-backslash">
					<xsl:with-param name="text" select="$text-after-bs"/>
					<xsl:with-param name="text-length" select="$text-after-bs-length"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
','RequestToDeactivateLetter.xslt',UUID(),(SELECT (MAX(ID)) FROM SEQ_IACUC_PROTO_CORRESP_TEMPL),'25',NOW(),'admin',1)
/
INSERT INTO SEQ_IACUC_PROTO_CORRESP_TEMPL VALUES(NULL)
/
INSERT INTO IACUC_PROTO_CORRESP_TEMPL (COMMITTEE_ID,CORRESPONDENCE_TEMPLATE,FILE_NAME,OBJ_ID,PROTO_CORRESP_TEMPL_ID,PROTO_CORRESP_TYPE_CODE,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR)
  VALUES ('DEFAULT','<?xml version="1.0" encoding="UTF-8"?>
<!--Designed and generated by Altova StyleVision Enterprise Edition 2011 - see http://www.altova.com/stylevision for more information.-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:clitype="clitype" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:iso4217="http://www.xbrl.org/2003/iso4217" xmlns:ix="http://www.xbrl.org/2008/inlineXBRL" xmlns:java="java" xmlns:link="http://www.xbrl.org/2003/linkbase" xmlns:n1="http://xml.coeus.mit.edu/iacuc" xmlns:xbrldi="http://xbrl.org/2006/xbrldi" xmlns:xbrli="http://www.xbrl.org/2003/instance" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:altova="http://www.altova.com" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:svg="http://www.w3.org/2000/svg" exclude-result-prefixes="clitype fn iso4217 ix java link n1 xbrldi xbrli xlink xs xsi altova">
	<xsl:output version="1.0" method="xml" encoding="UTF-8" indent="no"/>
	<xsl:param name="SV_OutputFormat" select="\'PDF\'"/>
	<xsl:param name="PARAM"/>
	<xsl:variable name="XML" select="/"/>
	<xsl:variable name="fo:layout-master-set">
		<fo:layout-master-set>
			<fo:simple-page-master master-name="page-master-162640432" margin-left="0.60in" margin-right="0.60in" page-height="11in" page-width="8.50in">
				<fo:region-body margin-top="0.79in" margin-bottom="0.79in" column-count="1" column-gap="0.50in"/>
			</fo:simple-page-master>
		</fo:layout-master-set>
	</xsl:variable>
	<xsl:variable name="altova:nPxPerIn" select="96"/>
	<xsl:template match="/">
		<fo:root>
			<xsl:copy-of select="$fo:layout-master-set"/>
			<fo:page-sequence force-page-count="no-force" master-reference="page-master-162640432" initial-page-number="auto" format="1">
				<fo:flow flow-name="xsl-region-body">
					<fo:block>
						<fo:inline-container>
							<fo:block>
								<xsl:text>&#x200B;</xsl:text>
							</fo:block>
						</fo:inline-container>
						<fo:table width="100%" table-layout="fixed" border-spacing="2pt">
							<fo:table-column column-width="90%"/>
							<fo:table-column column-width="10%"/>
							<xsl:variable name="altova:CurrContextGrid_09B4F318" select="."/>
							<fo:table-body start-indent="0pt">
								<xsl:variable name="altova:tablerows">
									<fo:table-row>
										<fo:table-cell font-size="10pt" padding="0" display-align="center">
											<fo:block text-align="left">
												<fo:inline>
													<xsl:text>&#160;</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell font-size="10pt" padding="0" display-align="center">
											<fo:block text-align="right">
												<fo:inline>
													<xsl:text>&#160;</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell number-columns-spanned="2" padding="0" display-align="center">
											<fo:block text-align="left">
												<fo:block text-align="center">
													<fo:leader leader-pattern="rule" rule-thickness="2" leader-length="100%" color="black"/>
												</fo:block>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</xsl:variable>
								<xsl:choose>
									<xsl:when test="string($altova:tablerows)">
										<xsl:copy-of select="$altova:tablerows"/>
									</xsl:when>
									<xsl:otherwise>
										<fo:table-row>
											<fo:table-cell>
												<fo:block/>
											</fo:table-cell>
										</fo:table-row>
									</xsl:otherwise>
								</xsl:choose>
							</fo:table-body>
						</fo:table>
						<fo:block>
							<fo:leader leader-pattern="space"/>
						</fo:block>
						<xsl:for-each select="$XML">
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
							<xsl:for-each select="n1:Correspondence">
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x200B;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:table font-family="inherit" table-layout="fixed" width="100%" border-spacing="2pt">
									<fo:table-column column-width="1.790in"/>
									<fo:table-column column-width="0.430in"/>
									<fo:table-column column-width="6.430in"/>
									<xsl:variable name="altova:CurrContextGrid_09B4F678" select="."/>
									<fo:table-body start-indent="0pt">
										<xsl:variable name="altova:tablerows">
											<fo:table-row>
												<fo:table-cell font-weight="bold" padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>To:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:Investigator">
																<xsl:for-each select="n1:Person">
																	<xsl:for-each select="n1:Fullname">
																		<xsl:variable name="value-of-template_09535558">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template_09535558),\'&#x200B;\')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template_09535558"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template_09535558"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell font-weight="bold" padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>From:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:Submissions">
																<xsl:for-each select="n1:CommitteeMember">
																	<xsl:for-each select="n1:Person">
																		<xsl:for-each select="n1:Fullname">
																			<xsl:variable name="value-of-template_09535478">
																				<xsl:apply-templates/>
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when test="contains(string($value-of-template_09535478),\'&#x200B;\')">
																					<fo:block>
																						<xsl:copy-of select="$value-of-template_09535478"/>
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline>
																						<xsl:copy-of select="$value-of-template_09535478"/>
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
														<fo:inline>
															<xsl:text>, Chair</xsl:text>
														</fo:inline>
														<fo:block/>
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:Submissions">
																<xsl:for-each select="n1:CommitteeMasterData">
																	<xsl:for-each select="n1:CommitteeName">
																		<xsl:variable name="value-of-template_09535398">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template_09535398),\'&#x200B;\')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template_09535398"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template_09535398"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell font-weight="bold" padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Date:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:CurrentDate">
															<fo:inline>
																<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																<xsl:text> / </xsl:text>
																<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																<xsl:text> / </xsl:text>
																<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
															</fo:inline>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell font-weight="bold" padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Committee Action:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Suspension Letter</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell font-weight="bold" padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Action Date:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:Submissions">
																<xsl:for-each select="n1:SubmissionDetails">
																	<xsl:for-each select="n1:ActionType">
																		<xsl:for-each select="n1:ActionDate">
																			<fo:inline>
																				<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																				<xsl:text> / </xsl:text>
																				<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																				<xsl:text> / </xsl:text>
																				<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
																			</fo:inline>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row height="0.38in">
												<fo:table-cell font-weight="bold" padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Protocol Number:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:ProtocolMasterData">
																<xsl:for-each select="n1:ProtocolNumber">
																	<xsl:variable name="value-of-template_0C971578">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template_0C971578),\'&#x200B;\')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template_0C971578"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template_0C971578"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row height="0.20in">
												<fo:table-cell font-weight="bold" padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Study Title:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:ProtocolMasterData">
																<xsl:for-each select="n1:ProtocolTitle">
																	<xsl:variable name="value-of-template_0C971658">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template_0C971658),\'&#x200B;\')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template_0C971658"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template_0C971658"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell font-weight="bold" padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Expiration Date:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:ProtocolMasterData">
																<xsl:for-each select="n1:ExpirationDate">
																	<fo:inline>
																		<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																		<xsl:text> / </xsl:text>
																		<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																		<xsl:text> / </xsl:text>
																		<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
																	</fo:inline>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</xsl:variable>
										<xsl:choose>
											<xsl:when test="string($altova:tablerows)">
												<xsl:copy-of select="$altova:tablerows"/>
											</xsl:when>
											<xsl:otherwise>
												<fo:table-row>
													<fo:table-cell>
														<fo:block/>
													</fo:table-cell>
												</fo:table-row>
											</xsl:otherwise>
										</xsl:choose>
									</fo:table-body>
								</fo:table>
							</xsl:for-each>
							<fo:block/>
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x200B;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:block margin="0pt">
								<fo:inline>
									<xsl:text>The above mentioned protocol</xsl:text>
								</fo:inline>
								<xsl:for-each select="n1:Correspondence">
									<xsl:for-each select="n1:Protocol">
										<fo:inline>
											<xsl:text> has suspended as of </xsl:text>
										</fo:inline>
										<xsl:for-each select="n1:Submissions">
											<xsl:for-each select="n1:ScheduleMasterData">
												<xsl:for-each select="n1:MeetingDate">
													<fo:inline>
														<xsl:call-template name="DateToMonthName">
															<xsl:with-param name="sDate" select="string(string(.))"/>
															<xsl:with-param name="sFormat" select="\'long\'"/>
														</xsl:call-template>
														<xsl:text> </xsl:text>
														<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
														<xsl:text>, </xsl:text>
														<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
													</fo:inline>
												</xsl:for-each>
											</xsl:for-each>
										</xsl:for-each>
										<fo:inline>
											<xsl:text>. Studies being conducted on expired protocols shall be immediately suspended and animals involved in these studies removed from </xsl:text>
										</fo:inline>
										<xsl:for-each select="n1:SchoolInfo">
											<xsl:for-each select="n1:SchoolName">
												<xsl:variable name="value-of-template_0C9718F8">
													<xsl:apply-templates/>
												</xsl:variable>
												<xsl:choose>
													<xsl:when test="contains(string($value-of-template_0C9718F8),\'&#x200B;\')">
														<fo:block>
															<xsl:copy-of select="$value-of-template_0C9718F8"/>
														</fo:block>
													</xsl:when>
													<xsl:otherwise>
														<fo:inline>
															<xsl:copy-of select="$value-of-template_0C9718F8"/>
														</fo:inline>
													</xsl:otherwise>
												</xsl:choose>
											</xsl:for-each>
										</xsl:for-each>
									</xsl:for-each>
									<fo:inline>
										<xsl:text>&#160;</xsl:text>
									</fo:inline>
								</xsl:for-each>
								<fo:inline>
									<xsl:text> Housing. This decision is based on federal law which requires that all vertebrate animals housed for research and teaching be identified with an approved protocol. During unannounced inspection federal agents identifying animals housed under expired protocols may levy substantial fines against the University.</xsl:text>
								</fo:inline>
							</fo:block>
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x200B;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:block margin="0pt">
								<fo:inline>
									<xsl:text>Thank you.</xsl:text>
								</fo:inline>
							</fo:block>
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
						</xsl:for-each>
					</fo:block>
					<fo:block id="SV_RefID_PageTotal"/>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	<xsl:template name="DateToMonthName">
		<xsl:param name="sDate"/>
		<xsl:param name="sFormat"/>
		<xsl:choose>
			<xsl:when test="$sFormat = \'long\'">
				<xsl:call-template name="DateToMonthNameLong">
					<xsl:with-param name="sDate" select="$sDate"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="DateToMonthNameShort">
					<xsl:with-param name="sDate" select="$sDate"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="DateToMonthNameLong">
		<xsl:param name="sDate"/>
		<xsl:variable name="nMonth">
			<xsl:call-template name="DateToMonthNum">
				<xsl:with-param name="sDate" select="$sDate"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="$nMonth = 1">January</xsl:when>
			<xsl:when test="$nMonth = 2">February</xsl:when>
			<xsl:when test="$nMonth = 3">March</xsl:when>
			<xsl:when test="$nMonth = 4">April</xsl:when>
			<xsl:when test="$nMonth = 5">May</xsl:when>
			<xsl:when test="$nMonth = 6">June</xsl:when>
			<xsl:when test="$nMonth = 7">July</xsl:when>
			<xsl:when test="$nMonth = 8">August</xsl:when>
			<xsl:when test="$nMonth = 9">September</xsl:when>
			<xsl:when test="$nMonth = 10">October</xsl:when>
			<xsl:when test="$nMonth = 11">November</xsl:when>
			<xsl:otherwise>December</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="DateToMonthNum">
		<xsl:param name="sDate"/>
		<xsl:choose>
			<xsl:when test="starts-with($sDate, \'--\')">
				<xsl:value-of select="number(substring($sDate, 3, 2))"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="number(substring($sDate, 6, 2))"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="DateToMonthNameShort">
		<xsl:param name="sDate"/>
		<xsl:variable name="nMonth">
			<xsl:call-template name="DateToMonthNum">
				<xsl:with-param name="sDate" select="$sDate"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="$nMonth = 1">Jan</xsl:when>
			<xsl:when test="$nMonth = 2">Feb</xsl:when>
			<xsl:when test="$nMonth = 3">Mar</xsl:when>
			<xsl:when test="$nMonth = 4">Apr</xsl:when>
			<xsl:when test="$nMonth = 5">May</xsl:when>
			<xsl:when test="$nMonth = 6">Jun</xsl:when>
			<xsl:when test="$nMonth = 7">Jul</xsl:when>
			<xsl:when test="$nMonth = 8">Aug</xsl:when>
			<xsl:when test="$nMonth = 9">Sep</xsl:when>
			<xsl:when test="$nMonth = 10">Oct</xsl:when>
			<xsl:when test="$nMonth = 11">Nov</xsl:when>
			<xsl:otherwise>Dec</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="double-backslash">
		<xsl:param name="text"/>
		<xsl:param name="text-length"/>
		<xsl:variable name="text-after-bs" select="substring-after($text, \'\\\')"/>
		<xsl:variable name="text-after-bs-length" select="string-length($text-after-bs)"/>
		<xsl:choose>
			<xsl:when test="$text-after-bs-length = 0">
				<xsl:choose>
					<xsl:when test="substring($text, $text-length) = \'\\\'">
						<xsl:value-of select="concat(substring($text,1,$text-length - 1), \'\\\\\')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$text"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="concat(substring($text,1,$text-length - $text-after-bs-length - 1), \'\\\\\')"/>
				<xsl:call-template name="double-backslash">
					<xsl:with-param name="text" select="$text-after-bs"/>
					<xsl:with-param name="text-length" select="$text-after-bs-length"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="altova:MakeValueAbsoluteIfPixels">
		<xsl:param name="sValue"/>
		<xsl:variable name="sBeforePx" select="substring-before($sValue, \'px\')"/>
		<xsl:choose>
			<xsl:when test="$sBeforePx">
				<xsl:variable name="nLengthOfInteger">
					<xsl:call-template name="altova:GetCharCountOfIntegerAtEndOfString">
						<xsl:with-param name="sText" select="$sBeforePx"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:variable name="nPosOfInteger" select="string-length($sBeforePx) - $nLengthOfInteger + 1"/>
				<xsl:variable name="nValuePx" select="substring($sBeforePx, $nPosOfInteger)"/>
				<xsl:variable name="nValueIn" select="number($nValuePx) div number($altova:nPxPerIn)"/>
				<xsl:variable name="nLengthBeforeInteger" select="string-length($sBeforePx) - $nLengthOfInteger"/>
				<xsl:variable name="sRest">
					<xsl:call-template name="altova:MakeValueAbsoluteIfPixels">
						<xsl:with-param name="sValue" select="substring-after($sValue, \'px\')"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="concat(substring($sBeforePx, 1, $nLengthBeforeInteger), string($nValueIn), \'in\', $sRest)"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$sValue"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="altova:GetCharCountOfIntegerAtEndOfString">
		<xsl:param name="sText"/>
		<xsl:variable name="sLen" select="string-length($sText)"/>
		<xsl:variable name="cLast" select="substring($sText, $sLen)"/>
		<xsl:choose>
			<xsl:when test="number($cLast) &gt;= 0 and number($cLast) &lt;= 9">
				<xsl:variable name="nResultOfRest">
					<xsl:call-template name="altova:GetCharCountOfIntegerAtEndOfString">
						<xsl:with-param name="sText" select="substring($sText, 1, $sLen - 1)"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="$nResultOfRest + 1"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text>0</xsl:text>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
','SuspensionLetter.xslt',UUID(),(SELECT (MAX(ID)) FROM SEQ_IACUC_PROTO_CORRESP_TEMPL),'26',NOW(),'admin',1)
/
INSERT INTO SEQ_IACUC_PROTO_CORRESP_TEMPL VALUES(NULL)
/
INSERT INTO IACUC_PROTO_CORRESP_TEMPL (COMMITTEE_ID,CORRESPONDENCE_TEMPLATE,FILE_NAME,OBJ_ID,PROTO_CORRESP_TEMPL_ID,PROTO_CORRESP_TYPE_CODE,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR)
  VALUES ('DEFAULT','<?xml version="1.0" encoding="UTF-8"?>
<!--Designed and generated by Altova StyleVision Enterprise Edition 2011 - see http://www.altova.com/stylevision for more information.-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:clitype="clitype" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:iso4217="http://www.xbrl.org/2003/iso4217" xmlns:ix="http://www.xbrl.org/2008/inlineXBRL" xmlns:java="java" xmlns:link="http://www.xbrl.org/2003/linkbase" xmlns:n1="http://xml.coeus.mit.edu/iacuc" xmlns:xbrldi="http://xbrl.org/2006/xbrldi" xmlns:xbrli="http://www.xbrl.org/2003/instance" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:altova="http://www.altova.com" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:svg="http://www.w3.org/2000/svg" exclude-result-prefixes="clitype fn iso4217 ix java link n1 xbrldi xbrli xlink xs xsi altova">
	<xsl:output version="1.0" method="xml" encoding="UTF-8" indent="no"/>
	<xsl:param name="SV_OutputFormat" select="\'PDF\'"/>
	<xsl:variable name="XML" select="/"/>
	<xsl:variable name="fo:layout-master-set">
		<fo:layout-master-set>
			<fo:simple-page-master master-name="page-master-309772856" margin-left="0.60in" margin-right="0.60in" page-height="11in" page-width="8.50in">
				<fo:region-body margin-top="0.79in" margin-bottom="0.79in" column-count="1" column-gap="0.50in"/>
			</fo:simple-page-master>
		</fo:layout-master-set>
	</xsl:variable>
	<xsl:variable name="altova:nPxPerIn" select="96"/>
	<xsl:template match="/">
		<fo:root>
			<xsl:copy-of select="$fo:layout-master-set"/>
			<fo:page-sequence force-page-count="no-force" master-reference="page-master-309772856" initial-page-number="auto" format="1">
				<fo:flow flow-name="xsl-region-body">
					<fo:block>
						<xsl:for-each select="$XML">
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x200B;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:block text-align="right" margin="0pt">
								<fo:inline font-weight="bold">
									<xsl:text>International Animal Care and Use Committee</xsl:text>
								</fo:inline>
							</fo:block>
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
							<xsl:for-each select="n1:Correspondence">
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x200B;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
									<fo:table-column column-width="1.590in"/>
									<fo:table-column column-width="0.430in"/>
									<fo:table-column column-width="6.430in"/>
									<xsl:variable name="altova:CurrContextGrid_125C5F00" select="."/>
									<fo:table-body start-indent="0pt">
										<xsl:variable name="altova:tablerows">
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>To:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:Investigator">
																<xsl:for-each select="n1:Person">
																	<xsl:for-each select="n1:Fullname">
																		<xsl:variable name="value-of-template_126F0D48">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template_126F0D48),\'&#x200B;\')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template_126F0D48"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template_126F0D48"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>From:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:Submissions">
																<xsl:for-each select="n1:CommitteeMember">
																	<xsl:for-each select="n1:Person">
																		<xsl:for-each select="n1:Fullname">
																			<xsl:variable name="value-of-template_126F0F08">
																				<xsl:apply-templates/>
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when test="contains(string($value-of-template_126F0F08),\'&#x200B;\')">
																					<fo:block>
																						<xsl:copy-of select="$value-of-template_126F0F08"/>
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline>
																						<xsl:copy-of select="$value-of-template_126F0F08"/>
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
														<fo:inline>
															<xsl:text>, Chair</xsl:text>
														</fo:inline>
														<fo:block/>
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:Submissions">
																<xsl:for-each select="n1:CommitteeMasterData">
																	<xsl:for-each select="n1:CommitteeName">
																		<xsl:variable name="value-of-template_126F10C8">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template_126F10C8),\'&#x200B;\')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template_126F10C8"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template_126F10C8"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Date:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:CurrentDate">
															<fo:inline>
																<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																<xsl:text> / </xsl:text>
																<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																<xsl:text> / </xsl:text>
																<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
															</fo:inline>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Committee Action:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Review of the protocol</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Action Date:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:Submissions">
																<xsl:for-each select="n1:SubmissionDetails">
																	<xsl:for-each select="n1:ActionType">
																		<xsl:for-each select="n1:ActionDate">
																			<fo:inline>
																				<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																				<xsl:text> / </xsl:text>
																				<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																				<xsl:text> / </xsl:text>
																				<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
																			</fo:inline>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Protocol Number:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:ProtocolMasterData">
																<xsl:for-each select="n1:ProtocolNumber">
																	<xsl:variable name="value-of-template_126F0E28">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template_126F0E28),\'&#x200B;\')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template_126F0E28"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template_126F0E28"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Study Title:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:ProtocolMasterData">
																<xsl:for-each select="n1:ProtocolTitle">
																	<xsl:variable name="value-of-template_126F1988">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template_126F1988),\'&#x200B;\')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template_126F1988"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template_126F1988"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Expiration Date:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:ProtocolMasterData">
																<xsl:for-each select="n1:ExpirationDate">
																	<fo:inline>
																		<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																		<xsl:text> / </xsl:text>
																		<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																		<xsl:text> / </xsl:text>
																		<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
																	</fo:inline>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</xsl:variable>
										<xsl:choose>
											<xsl:when test="string($altova:tablerows)">
												<xsl:copy-of select="$altova:tablerows"/>
											</xsl:when>
											<xsl:otherwise>
												<fo:table-row>
													<fo:table-cell>
														<fo:block/>
													</fo:table-cell>
												</fo:table-row>
											</xsl:otherwise>
										</xsl:choose>
									</fo:table-body>
								</fo:table>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:inline>
									<xsl:text>At its meeting of </xsl:text>
								</fo:inline>
								<xsl:for-each select="n1:Protocol">
									<xsl:for-each select="n1:Submissions">
										<xsl:for-each select="n1:ScheduleMasterData">
											<xsl:for-each select="n1:MeetingDate">
												<fo:inline>
													<xsl:call-template name="DateToMonthName">
														<xsl:with-param name="sDate" select="string(string(.))"/>
														<xsl:with-param name="sFormat" select="\'long\'"/>
													</xsl:call-template>
													<xsl:text> </xsl:text>
													<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
													<xsl:text>, </xsl:text>
													<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
												</fo:inline>
											</xsl:for-each>
										</xsl:for-each>
									</xsl:for-each>
								</xsl:for-each>
								<fo:inline>
									<xsl:text>, the IACUC voted to table the above named protocol pending&#160; further communication with you on the following.</xsl:text>
								</fo:inline>
								<fo:block/>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:inline>
									<xsl:text> Please submit your response to the IACUC office no later than </xsl:text>
								</fo:inline>
								<xsl:for-each select="n1:Protocol">
									<xsl:for-each select="n1:Submissions">
										<xsl:for-each select="n1:NextSchedule">
											<xsl:for-each select="n1:ScheduleMasterData">
												<xsl:for-each select="n1:MeetingDate">
													<fo:inline>
														<xsl:call-template name="DateToMonthName">
															<xsl:with-param name="sDate" select="string(string(.))"/>
															<xsl:with-param name="sFormat" select="\'long\'"/>
														</xsl:call-template>
														<xsl:text> </xsl:text>
														<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
														<xsl:text>, </xsl:text>
														<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
													</fo:inline>
												</xsl:for-each>
											</xsl:for-each>
										</xsl:for-each>
									</xsl:for-each>
								</xsl:for-each>
								<fo:inline>
									<xsl:text>, so that the review process can proceed. Thank you for your continued cooperation with the protocol.</xsl:text>
								</fo:inline>
								<fo:block/>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x200B;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block margin="0pt">
									<fo:inline>
										<xsl:text>Best Regards.</xsl:text>
									</fo:inline>
								</fo:block>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
							</xsl:for-each>
							<fo:block/>
						</xsl:for-each>
					</fo:block>
					<fo:block id="SV_RefID_PageTotal"/>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	<xsl:template name="DateToMonthName">
		<xsl:param name="sDate"/>
		<xsl:param name="sFormat"/>
		<xsl:choose>
			<xsl:when test="$sFormat = \'long\'">
				<xsl:call-template name="DateToMonthNameLong">
					<xsl:with-param name="sDate" select="$sDate"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="DateToMonthNameShort">
					<xsl:with-param name="sDate" select="$sDate"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="DateToMonthNameLong">
		<xsl:param name="sDate"/>
		<xsl:variable name="nMonth">
			<xsl:call-template name="DateToMonthNum">
				<xsl:with-param name="sDate" select="$sDate"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="$nMonth = 1">January</xsl:when>
			<xsl:when test="$nMonth = 2">February</xsl:when>
			<xsl:when test="$nMonth = 3">March</xsl:when>
			<xsl:when test="$nMonth = 4">April</xsl:when>
			<xsl:when test="$nMonth = 5">May</xsl:when>
			<xsl:when test="$nMonth = 6">June</xsl:when>
			<xsl:when test="$nMonth = 7">July</xsl:when>
			<xsl:when test="$nMonth = 8">August</xsl:when>
			<xsl:when test="$nMonth = 9">September</xsl:when>
			<xsl:when test="$nMonth = 10">October</xsl:when>
			<xsl:when test="$nMonth = 11">November</xsl:when>
			<xsl:otherwise>December</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="DateToMonthNum">
		<xsl:param name="sDate"/>
		<xsl:choose>
			<xsl:when test="starts-with($sDate, \'--\')">
				<xsl:value-of select="number(substring($sDate, 3, 2))"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="number(substring($sDate, 6, 2))"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="DateToMonthNameShort">
		<xsl:param name="sDate"/>
		<xsl:variable name="nMonth">
			<xsl:call-template name="DateToMonthNum">
				<xsl:with-param name="sDate" select="$sDate"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="$nMonth = 1">Jan</xsl:when>
			<xsl:when test="$nMonth = 2">Feb</xsl:when>
			<xsl:when test="$nMonth = 3">Mar</xsl:when>
			<xsl:when test="$nMonth = 4">Apr</xsl:when>
			<xsl:when test="$nMonth = 5">May</xsl:when>
			<xsl:when test="$nMonth = 6">Jun</xsl:when>
			<xsl:when test="$nMonth = 7">Jul</xsl:when>
			<xsl:when test="$nMonth = 8">Aug</xsl:when>
			<xsl:when test="$nMonth = 9">Sep</xsl:when>
			<xsl:when test="$nMonth = 10">Oct</xsl:when>
			<xsl:when test="$nMonth = 11">Nov</xsl:when>
			<xsl:otherwise>Dec</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="double-backslash">
		<xsl:param name="text"/>
		<xsl:param name="text-length"/>
		<xsl:variable name="text-after-bs" select="substring-after($text, \'\\\')"/>
		<xsl:variable name="text-after-bs-length" select="string-length($text-after-bs)"/>
		<xsl:choose>
			<xsl:when test="$text-after-bs-length = 0">
				<xsl:choose>
					<xsl:when test="substring($text, $text-length) = \'\\\'">
						<xsl:value-of select="concat(substring($text,1,$text-length - 1), \'\\\\\')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$text"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="concat(substring($text,1,$text-length - $text-after-bs-length - 1), \'\\\\\')"/>
				<xsl:call-template name="double-backslash">
					<xsl:with-param name="text" select="$text-after-bs"/>
					<xsl:with-param name="text-length" select="$text-after-bs-length"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="altova:MakeValueAbsoluteIfPixels">
		<xsl:param name="sValue"/>
		<xsl:variable name="sBeforePx" select="substring-before($sValue, \'px\')"/>
		<xsl:choose>
			<xsl:when test="$sBeforePx">
				<xsl:variable name="nLengthOfInteger">
					<xsl:call-template name="altova:GetCharCountOfIntegerAtEndOfString">
						<xsl:with-param name="sText" select="$sBeforePx"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:variable name="nPosOfInteger" select="string-length($sBeforePx) - $nLengthOfInteger + 1"/>
				<xsl:variable name="nValuePx" select="substring($sBeforePx, $nPosOfInteger)"/>
				<xsl:variable name="nValueIn" select="number($nValuePx) div number($altova:nPxPerIn)"/>
				<xsl:variable name="nLengthBeforeInteger" select="string-length($sBeforePx) - $nLengthOfInteger"/>
				<xsl:variable name="sRest">
					<xsl:call-template name="altova:MakeValueAbsoluteIfPixels">
						<xsl:with-param name="sValue" select="substring-after($sValue, \'px\')"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="concat(substring($sBeforePx, 1, $nLengthBeforeInteger), string($nValueIn), \'in\', $sRest)"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$sValue"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="altova:GetCharCountOfIntegerAtEndOfString">
		<xsl:param name="sText"/>
		<xsl:variable name="sLen" select="string-length($sText)"/>
		<xsl:variable name="cLast" select="substring($sText, $sLen)"/>
		<xsl:choose>
			<xsl:when test="number($cLast) &gt;= 0 and number($cLast) &lt;= 9">
				<xsl:variable name="nResultOfRest">
					<xsl:call-template name="altova:GetCharCountOfIntegerAtEndOfString">
						<xsl:with-param name="sText" select="substring($sText, 1, $sLen - 1)"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="$nResultOfRest + 1"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text>0</xsl:text>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
','TabledDeferralNotificationLetter.xslt',UUID(),(SELECT (MAX(ID)) FROM SEQ_IACUC_PROTO_CORRESP_TEMPL),'27',NOW(),'admin',1)
/
INSERT INTO SEQ_IACUC_PROTO_CORRESP_TEMPL VALUES(NULL)
/
INSERT INTO IACUC_PROTO_CORRESP_TEMPL (COMMITTEE_ID,CORRESPONDENCE_TEMPLATE,FILE_NAME,OBJ_ID,PROTO_CORRESP_TEMPL_ID,PROTO_CORRESP_TYPE_CODE,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR)
  VALUES ('DEFAULT','<?xml version="1.0" encoding="UTF-8"?>
<!--Designed and generated by Altova StyleVision Enterprise Edition 2011 - see http://www.altova.com/stylevision for more information.-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:clitype="clitype" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:iso4217="http://www.xbrl.org/2003/iso4217" xmlns:ix="http://www.xbrl.org/2008/inlineXBRL" xmlns:java="java" xmlns:link="http://www.xbrl.org/2003/linkbase" xmlns:n1="http://xml.coeus.mit.edu/iacuc" xmlns:xbrldi="http://xbrl.org/2006/xbrldi" xmlns:xbrli="http://www.xbrl.org/2003/instance" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:altova="http://www.altova.com" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:svg="http://www.w3.org/2000/svg" exclude-result-prefixes="clitype fn iso4217 ix java link n1 xbrldi xbrli xlink xs xsi altova">
	<xsl:output version="1.0" method="xml" encoding="UTF-8" indent="no"/>
	<xsl:param name="SV_OutputFormat" select="\'PDF\'"/>
	<xsl:variable name="XML" select="/"/>
	<xsl:variable name="fo:layout-master-set">
		<fo:layout-master-set>
			<fo:simple-page-master master-name="page-master-162088584" margin-left="0.60in" margin-right="0.60in" page-height="11in" page-width="8.50in">
				<fo:region-body margin-top="0.79in" margin-bottom="0.79in" column-count="1" column-gap="0.50in"/>
			</fo:simple-page-master>
		</fo:layout-master-set>
	</xsl:variable>
	<xsl:variable name="altova:nPxPerIn" select="96"/>
	<xsl:template match="/">
		<fo:root>
			<xsl:copy-of select="$fo:layout-master-set"/>
			<fo:page-sequence force-page-count="no-force" master-reference="page-master-162088584" initial-page-number="auto" format="1">
				<fo:flow flow-name="xsl-region-body">
					<fo:block>
						<fo:inline-container>
							<fo:block>
								<xsl:text>&#x200B;</xsl:text>
							</fo:block>
						</fo:inline-container>
						<fo:table width="100%" table-layout="fixed" border-spacing="2pt">
							<fo:table-column column-width="90%"/>
							<fo:table-column column-width="10%"/>
							<xsl:variable name="altova:CurrContextGrid_0987E880" select="."/>
							<fo:table-body start-indent="0pt">
								<xsl:variable name="altova:tablerows">
									<fo:table-row>
										<fo:table-cell font-size="10pt" padding="0" display-align="center">
											<fo:block text-align="left">
												<fo:inline>
													<xsl:text>&#160;</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell font-size="10pt" padding="0" display-align="center">
											<fo:block text-align="right">
												<fo:inline>
													<xsl:text>&#160;</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell number-columns-spanned="2" padding="0" display-align="center">
											<fo:block text-align="left">
												<fo:block text-align="center">
													<fo:leader leader-pattern="rule" rule-thickness="2" leader-length="100%" color="black"/>
												</fo:block>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</xsl:variable>
								<xsl:choose>
									<xsl:when test="string($altova:tablerows)">
										<xsl:copy-of select="$altova:tablerows"/>
									</xsl:when>
									<xsl:otherwise>
										<fo:table-row>
											<fo:table-cell>
												<fo:block/>
											</fo:table-cell>
										</fo:table-row>
									</xsl:otherwise>
								</xsl:choose>
							</fo:table-body>
						</fo:table>
						<fo:block>
							<fo:leader leader-pattern="space"/>
						</fo:block>
						<xsl:for-each select="$XML">
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
							<xsl:for-each select="n1:Correspondence">
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x200B;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:table font-family="inherit" table-layout="fixed" width="100%" border-spacing="2pt">
									<fo:table-column column-width="1.820in"/>
									<fo:table-column column-width="0.430in"/>
									<fo:table-column column-width="6.430in"/>
									<xsl:variable name="altova:CurrContextGrid_0987EAC0" select="."/>
									<fo:table-body start-indent="0pt">
										<xsl:variable name="altova:tablerows">
											<fo:table-row>
												<fo:table-cell font-weight="bold" padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>To:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:Investigator">
																<xsl:for-each select="n1:Person">
																	<xsl:for-each select="n1:Fullname">
																		<xsl:variable name="value-of-template_0BA679D0">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template_0BA679D0),\'&#x200B;\')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template_0BA679D0"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template_0BA679D0"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell font-weight="bold" padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>From:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:Submissions">
																<xsl:for-each select="n1:CommitteeMember">
																	<xsl:for-each select="n1:Person">
																		<xsl:for-each select="n1:Fullname">
																			<xsl:variable name="value-of-template_0BA678F0">
																				<xsl:apply-templates/>
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when test="contains(string($value-of-template_0BA678F0),\'&#x200B;\')">
																					<fo:block>
																						<xsl:copy-of select="$value-of-template_0BA678F0"/>
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline>
																						<xsl:copy-of select="$value-of-template_0BA678F0"/>
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
														<fo:inline>
															<xsl:text>, Chair</xsl:text>
														</fo:inline>
														<fo:block/>
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:Submissions">
																<xsl:for-each select="n1:CommitteeMasterData">
																	<xsl:for-each select="n1:CommitteeName">
																		<xsl:variable name="value-of-template_0BA67810">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template_0BA67810),\'&#x200B;\')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template_0BA67810"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template_0BA67810"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell font-weight="bold" padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Date:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:CurrentDate">
															<fo:inline>
																<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																<xsl:text> / </xsl:text>
																<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																<xsl:text> / </xsl:text>
																<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
															</fo:inline>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell font-weight="bold" padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Committee Action:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Termination Letter</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell font-weight="bold" padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Action Date:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:Submissions">
																<xsl:for-each select="n1:SubmissionDetails">
																	<xsl:for-each select="n1:ActionType">
																		<xsl:for-each select="n1:ActionDate">
																			<fo:inline>
																				<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																				<xsl:text> / </xsl:text>
																				<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																				<xsl:text> / </xsl:text>
																				<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
																			</fo:inline>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row height="0.38in">
												<fo:table-cell font-weight="bold" padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Protocol Number:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:ProtocolMasterData">
																<xsl:for-each select="n1:ProtocolNumber">
																	<xsl:variable name="value-of-template_0BA67570">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template_0BA67570),\'&#x200B;\')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template_0BA67570"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template_0BA67570"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row height="0.20in">
												<fo:table-cell font-weight="bold" padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Study Title:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:ProtocolMasterData">
																<xsl:for-each select="n1:ProtocolTitle">
																	<xsl:variable name="value-of-template_0BA67490">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template_0BA67490),\'&#x200B;\')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template_0BA67490"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template_0BA67490"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell font-weight="bold" padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Expiration Date:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:ProtocolMasterData">
																<xsl:for-each select="n1:ExpirationDate">
																	<fo:inline>
																		<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																		<xsl:text> / </xsl:text>
																		<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																		<xsl:text> / </xsl:text>
																		<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
																	</fo:inline>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</xsl:variable>
										<xsl:choose>
											<xsl:when test="string($altova:tablerows)">
												<xsl:copy-of select="$altova:tablerows"/>
											</xsl:when>
											<xsl:otherwise>
												<fo:table-row>
													<fo:table-cell>
														<fo:block/>
													</fo:table-cell>
												</fo:table-row>
											</xsl:otherwise>
										</xsl:choose>
									</fo:table-body>
								</fo:table>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
							</xsl:for-each>
							<fo:block/>
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x200B;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:block margin="0pt">
								<fo:inline>
									<xsl:text>The above mentioned protocol</xsl:text>
								</fo:inline>
								<xsl:for-each select="n1:Correspondence">
									<xsl:for-each select="n1:Protocol">
										<fo:inline>
											<xsl:text> has terminated as of </xsl:text>
										</fo:inline>
										<xsl:for-each select="n1:Submissions">
											<xsl:for-each select="n1:ScheduleMasterData">
												<xsl:for-each select="n1:MeetingDate">
													<fo:inline>
														<xsl:call-template name="DateToMonthName">
															<xsl:with-param name="sDate" select="string(string(.))"/>
															<xsl:with-param name="sFormat" select="\'long\'"/>
														</xsl:call-template>
														<xsl:text> </xsl:text>
														<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
														<xsl:text>, </xsl:text>
														<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
													</fo:inline>
												</xsl:for-each>
											</xsl:for-each>
										</xsl:for-each>
										<fo:inline>
											<xsl:text>. Studies being conducted on expired protocols shall be immediately terminated and animals involved in these studies removed from </xsl:text>
										</fo:inline>
										<xsl:for-each select="n1:SchoolInfo">
											<xsl:for-each select="n1:SchoolName">
												<xsl:variable name="value-of-template_0BA671F0">
													<xsl:apply-templates/>
												</xsl:variable>
												<xsl:choose>
													<xsl:when test="contains(string($value-of-template_0BA671F0),\'&#x200B;\')">
														<fo:block>
															<xsl:copy-of select="$value-of-template_0BA671F0"/>
														</fo:block>
													</xsl:when>
													<xsl:otherwise>
														<fo:inline>
															<xsl:copy-of select="$value-of-template_0BA671F0"/>
														</fo:inline>
													</xsl:otherwise>
												</xsl:choose>
											</xsl:for-each>
										</xsl:for-each>
									</xsl:for-each>
									<fo:inline>
										<xsl:text>&#160;</xsl:text>
									</fo:inline>
								</xsl:for-each>
								<fo:inline>
									<xsl:text> Housing. This decision is based on federal law which requires that all vertebrate animals housed for research and teaching be identified with an approved protocol. During unannounced inspection federal agents identifying animals housed under expired protocols may levy substantial fines against the University.</xsl:text>
								</fo:inline>
							</fo:block>
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x200B;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:block margin="0pt">
								<fo:inline>
									<xsl:text>Thank you.</xsl:text>
								</fo:inline>
							</fo:block>
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
						</xsl:for-each>
					</fo:block>
					<fo:block id="SV_RefID_PageTotal"/>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	<xsl:template name="DateToMonthName">
		<xsl:param name="sDate"/>
		<xsl:param name="sFormat"/>
		<xsl:choose>
			<xsl:when test="$sFormat = \'long\'">
				<xsl:call-template name="DateToMonthNameLong">
					<xsl:with-param name="sDate" select="$sDate"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="DateToMonthNameShort">
					<xsl:with-param name="sDate" select="$sDate"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="DateToMonthNameLong">
		<xsl:param name="sDate"/>
		<xsl:variable name="nMonth">
			<xsl:call-template name="DateToMonthNum">
				<xsl:with-param name="sDate" select="$sDate"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="$nMonth = 1">January</xsl:when>
			<xsl:when test="$nMonth = 2">February</xsl:when>
			<xsl:when test="$nMonth = 3">March</xsl:when>
			<xsl:when test="$nMonth = 4">April</xsl:when>
			<xsl:when test="$nMonth = 5">May</xsl:when>
			<xsl:when test="$nMonth = 6">June</xsl:when>
			<xsl:when test="$nMonth = 7">July</xsl:when>
			<xsl:when test="$nMonth = 8">August</xsl:when>
			<xsl:when test="$nMonth = 9">September</xsl:when>
			<xsl:when test="$nMonth = 10">October</xsl:when>
			<xsl:when test="$nMonth = 11">November</xsl:when>
			<xsl:otherwise>December</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="DateToMonthNum">
		<xsl:param name="sDate"/>
		<xsl:choose>
			<xsl:when test="starts-with($sDate, \'--\')">
				<xsl:value-of select="number(substring($sDate, 3, 2))"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="number(substring($sDate, 6, 2))"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="DateToMonthNameShort">
		<xsl:param name="sDate"/>
		<xsl:variable name="nMonth">
			<xsl:call-template name="DateToMonthNum">
				<xsl:with-param name="sDate" select="$sDate"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="$nMonth = 1">Jan</xsl:when>
			<xsl:when test="$nMonth = 2">Feb</xsl:when>
			<xsl:when test="$nMonth = 3">Mar</xsl:when>
			<xsl:when test="$nMonth = 4">Apr</xsl:when>
			<xsl:when test="$nMonth = 5">May</xsl:when>
			<xsl:when test="$nMonth = 6">Jun</xsl:when>
			<xsl:when test="$nMonth = 7">Jul</xsl:when>
			<xsl:when test="$nMonth = 8">Aug</xsl:when>
			<xsl:when test="$nMonth = 9">Sep</xsl:when>
			<xsl:when test="$nMonth = 10">Oct</xsl:when>
			<xsl:when test="$nMonth = 11">Nov</xsl:when>
			<xsl:otherwise>Dec</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="double-backslash">
		<xsl:param name="text"/>
		<xsl:param name="text-length"/>
		<xsl:variable name="text-after-bs" select="substring-after($text, \'\\\')"/>
		<xsl:variable name="text-after-bs-length" select="string-length($text-after-bs)"/>
		<xsl:choose>
			<xsl:when test="$text-after-bs-length = 0">
				<xsl:choose>
					<xsl:when test="substring($text, $text-length) = \'\\\'">
						<xsl:value-of select="concat(substring($text,1,$text-length - 1), \'\\\\\')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$text"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="concat(substring($text,1,$text-length - $text-after-bs-length - 1), \'\\\\\')"/>
				<xsl:call-template name="double-backslash">
					<xsl:with-param name="text" select="$text-after-bs"/>
					<xsl:with-param name="text-length" select="$text-after-bs-length"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="altova:MakeValueAbsoluteIfPixels">
		<xsl:param name="sValue"/>
		<xsl:variable name="sBeforePx" select="substring-before($sValue, \'px\')"/>
		<xsl:choose>
			<xsl:when test="$sBeforePx">
				<xsl:variable name="nLengthOfInteger">
					<xsl:call-template name="altova:GetCharCountOfIntegerAtEndOfString">
						<xsl:with-param name="sText" select="$sBeforePx"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:variable name="nPosOfInteger" select="string-length($sBeforePx) - $nLengthOfInteger + 1"/>
				<xsl:variable name="nValuePx" select="substring($sBeforePx, $nPosOfInteger)"/>
				<xsl:variable name="nValueIn" select="number($nValuePx) div number($altova:nPxPerIn)"/>
				<xsl:variable name="nLengthBeforeInteger" select="string-length($sBeforePx) - $nLengthOfInteger"/>
				<xsl:variable name="sRest">
					<xsl:call-template name="altova:MakeValueAbsoluteIfPixels">
						<xsl:with-param name="sValue" select="substring-after($sValue, \'px\')"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="concat(substring($sBeforePx, 1, $nLengthBeforeInteger), string($nValueIn), \'in\', $sRest)"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$sValue"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="altova:GetCharCountOfIntegerAtEndOfString">
		<xsl:param name="sText"/>
		<xsl:variable name="sLen" select="string-length($sText)"/>
		<xsl:variable name="cLast" select="substring($sText, $sLen)"/>
		<xsl:choose>
			<xsl:when test="number($cLast) &gt;= 0 and number($cLast) &lt;= 9">
				<xsl:variable name="nResultOfRest">
					<xsl:call-template name="altova:GetCharCountOfIntegerAtEndOfString">
						<xsl:with-param name="sText" select="substring($sText, 1, $sLen - 1)"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="$nResultOfRest + 1"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text>0</xsl:text>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
','TerminationLetter.xslt',UUID(),(SELECT (MAX(ID)) FROM SEQ_IACUC_PROTO_CORRESP_TEMPL),'28',NOW(),'admin',1)
/
INSERT INTO SEQ_IACUC_PROTO_CORRESP_TEMPL VALUES(NULL)
/
INSERT INTO IACUC_PROTO_CORRESP_TEMPL (COMMITTEE_ID,CORRESPONDENCE_TEMPLATE,FILE_NAME,OBJ_ID,PROTO_CORRESP_TEMPL_ID,PROTO_CORRESP_TYPE_CODE,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR)
  VALUES ('DEFAULT','<?xml version="1.0" encoding="UTF-8"?>
<!--Designed and generated by Altova StyleVision Enterprise Edition 2011 - see http://www.altova.com/stylevision for more information.-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:clitype="clitype" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:iso4217="http://www.xbrl.org/2003/iso4217" xmlns:ix="http://www.xbrl.org/2008/inlineXBRL" xmlns:java="java" xmlns:link="http://www.xbrl.org/2003/linkbase" xmlns:n1="http://xml.coeus.mit.edu/iacuc" xmlns:xbrldi="http://xbrl.org/2006/xbrldi" xmlns:xbrli="http://www.xbrl.org/2003/instance" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:altova="http://www.altova.com" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:svg="http://www.w3.org/2000/svg" exclude-result-prefixes="clitype fn iso4217 ix java link n1 xbrldi xbrli xlink xs xsi altova">
	<xsl:output version="1.0" method="xml" encoding="UTF-8" indent="no"/>
	<xsl:param name="SV_OutputFormat" select="\'PDF\'"/>
	<xsl:variable name="XML" select="/"/>
	<xsl:variable name="fo:layout-master-set">
		<fo:layout-master-set>
			<fo:simple-page-master master-name="page-master-309467720" margin-left="0.60in" margin-right="0.60in" page-height="11in" page-width="8.50in">
				<fo:region-body margin-top="0.79in" margin-bottom="0.79in" column-count="1" column-gap="0.50in"/>
			</fo:simple-page-master>
		</fo:layout-master-set>
	</xsl:variable>
	<xsl:variable name="altova:nPxPerIn" select="96"/>
	<xsl:template match="/">
		<fo:root>
			<xsl:copy-of select="$fo:layout-master-set"/>
			<fo:page-sequence force-page-count="no-force" master-reference="page-master-309467720" initial-page-number="auto" format="1">
				<fo:flow flow-name="xsl-region-body">
					<fo:block>
						<xsl:for-each select="$XML">
							<fo:block text-align="center">
								<fo:leader leader-pattern="rule" rule-thickness="1" leader-length="100%" color="black"/>
							</fo:block>
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
							<xsl:for-each select="n1:Correspondence">
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x200B;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
									<fo:table-column column-width="1.590in"/>
									<fo:table-column column-width="0.430in"/>
									<fo:table-column column-width="6.430in"/>
									<xsl:variable name="altova:CurrContextGrid_12AB03C8" select="."/>
									<fo:table-body start-indent="0pt">
										<xsl:variable name="altova:tablerows">
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>To:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:Investigator">
																<xsl:for-each select="n1:Person">
																	<xsl:for-each select="n1:Fullname">
																		<xsl:variable name="value-of-template_126F11A8">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template_126F11A8),\'&#x200B;\')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template_126F11A8"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template_126F11A8"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>From:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:Submissions">
																<xsl:for-each select="n1:CommitteeMember">
																	<xsl:for-each select="n1:Person">
																		<xsl:for-each select="n1:Fullname">
																			<xsl:variable name="value-of-template_126F0C68">
																				<xsl:apply-templates/>
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when test="contains(string($value-of-template_126F0C68),\'&#x200B;\')">
																					<fo:block>
																						<xsl:copy-of select="$value-of-template_126F0C68"/>
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline>
																						<xsl:copy-of select="$value-of-template_126F0C68"/>
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
														<fo:inline>
															<xsl:text>, Chair</xsl:text>
														</fo:inline>
														<fo:block/>
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:Submissions">
																<xsl:for-each select="n1:CommitteeMasterData">
																	<xsl:for-each select="n1:CommitteeName">
																		<xsl:variable name="value-of-template_0FF2E218">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template_0FF2E218),\'&#x200B;\')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template_0FF2E218"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template_0FF2E218"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Date:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:CurrentDate">
															<fo:inline>
																<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																<xsl:text> / </xsl:text>
																<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																<xsl:text> / </xsl:text>
																<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
															</fo:inline>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Committee Action:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Withdrawal of protocol</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Action Date:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:Submissions">
																<xsl:for-each select="n1:SubmissionDetails">
																	<xsl:for-each select="n1:ActionType">
																		<xsl:for-each select="n1:ActionDate">
																			<fo:inline>
																				<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																				<xsl:text> / </xsl:text>
																				<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																				<xsl:text> / </xsl:text>
																				<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
																			</fo:inline>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Protocol Number:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:ProtocolMasterData">
																<xsl:for-each select="n1:ProtocolNumber">
																	<xsl:variable name="value-of-template_0FF2DE98">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template_0FF2DE98),\'&#x200B;\')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template_0FF2DE98"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template_0FF2DE98"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Study Title:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:ProtocolMasterData">
																<xsl:for-each select="n1:ProtocolTitle">
																	<xsl:variable name="value-of-template_0FF2DDB8">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template_0FF2DDB8),\'&#x200B;\')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template_0FF2DDB8"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template_0FF2DDB8"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Expiration Date:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:ProtocolMasterData">
																<xsl:for-each select="n1:ExpirationDate">
																	<fo:inline>
																		<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																		<xsl:text> / </xsl:text>
																		<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																		<xsl:text> / </xsl:text>
																		<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
																	</fo:inline>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</xsl:variable>
										<xsl:choose>
											<xsl:when test="string($altova:tablerows)">
												<xsl:copy-of select="$altova:tablerows"/>
											</xsl:when>
											<xsl:otherwise>
												<fo:table-row>
													<fo:table-cell>
														<fo:block/>
													</fo:table-cell>
												</fo:table-row>
											</xsl:otherwise>
										</xsl:choose>
									</fo:table-body>
								</fo:table>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:inline>
									<xsl:text>This message constitutes notice that this protocol has been withdrawn from consideration effective on </xsl:text>
								</fo:inline>
								<xsl:for-each select="n1:CurrentDate">
									<fo:inline>
										<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
										<xsl:text>/</xsl:text>
										<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
										<xsl:text>/</xsl:text>
										<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
									</fo:inline>
								</xsl:for-each>
								<fo:inline font-family="Arial" font-size="10pt">
									<xsl:text>. </xsl:text>
								</fo:inline>
								<fo:block/>
							</xsl:for-each>
							<fo:block/>
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x200B;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:block margin="0pt">
								<fo:inline>
									<xsl:text>Thank you.</xsl:text>
								</fo:inline>
							</fo:block>
						</xsl:for-each>
						<fo:inline>
							<xsl:text>&#160;&#160; </xsl:text>
						</fo:inline>
					</fo:block>
					<fo:block id="SV_RefID_PageTotal"/>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	<xsl:template name="double-backslash">
		<xsl:param name="text"/>
		<xsl:param name="text-length"/>
		<xsl:variable name="text-after-bs" select="substring-after($text, \'\\\')"/>
		<xsl:variable name="text-after-bs-length" select="string-length($text-after-bs)"/>
		<xsl:choose>
			<xsl:when test="$text-after-bs-length = 0">
				<xsl:choose>
					<xsl:when test="substring($text, $text-length) = \'\\\'">
						<xsl:value-of select="concat(substring($text,1,$text-length - 1), \'\\\\\')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$text"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="concat(substring($text,1,$text-length - $text-after-bs-length - 1), \'\\\\\')"/>
				<xsl:call-template name="double-backslash">
					<xsl:with-param name="text" select="$text-after-bs"/>
					<xsl:with-param name="text-length" select="$text-after-bs-length"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="altova:MakeValueAbsoluteIfPixels">
		<xsl:param name="sValue"/>
		<xsl:variable name="sBeforePx" select="substring-before($sValue, \'px\')"/>
		<xsl:choose>
			<xsl:when test="$sBeforePx">
				<xsl:variable name="nLengthOfInteger">
					<xsl:call-template name="altova:GetCharCountOfIntegerAtEndOfString">
						<xsl:with-param name="sText" select="$sBeforePx"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:variable name="nPosOfInteger" select="string-length($sBeforePx) - $nLengthOfInteger + 1"/>
				<xsl:variable name="nValuePx" select="substring($sBeforePx, $nPosOfInteger)"/>
				<xsl:variable name="nValueIn" select="number($nValuePx) div number($altova:nPxPerIn)"/>
				<xsl:variable name="nLengthBeforeInteger" select="string-length($sBeforePx) - $nLengthOfInteger"/>
				<xsl:variable name="sRest">
					<xsl:call-template name="altova:MakeValueAbsoluteIfPixels">
						<xsl:with-param name="sValue" select="substring-after($sValue, \'px\')"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="concat(substring($sBeforePx, 1, $nLengthBeforeInteger), string($nValueIn), \'in\', $sRest)"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$sValue"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="altova:GetCharCountOfIntegerAtEndOfString">
		<xsl:param name="sText"/>
		<xsl:variable name="sLen" select="string-length($sText)"/>
		<xsl:variable name="cLast" select="substring($sText, $sLen)"/>
		<xsl:choose>
			<xsl:when test="number($cLast) &gt;= 0 and number($cLast) &lt;= 9">
				<xsl:variable name="nResultOfRest">
					<xsl:call-template name="altova:GetCharCountOfIntegerAtEndOfString">
						<xsl:with-param name="sText" select="substring($sText, 1, $sLen - 1)"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="$nResultOfRest + 1"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text>0</xsl:text>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
','WithdrawalConfirmationNotification.xslt',UUID(),(SELECT (MAX(ID)) FROM SEQ_IACUC_PROTO_CORRESP_TEMPL),'29',NOW(),'admin',1)
/
INSERT INTO SEQ_IACUC_PROTO_CORRESP_TEMPL VALUES(NULL)
/
INSERT INTO IACUC_PROTO_CORRESP_TEMPL (COMMITTEE_ID,CORRESPONDENCE_TEMPLATE,FILE_NAME,OBJ_ID,PROTO_CORRESP_TEMPL_ID,PROTO_CORRESP_TYPE_CODE,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR)
  VALUES ('DEFAULT','<?xml version="1.0" encoding="UTF-8"?>
<!--Designed and generated by Altova StyleVision Enterprise Edition 2011 - see http://www.altova.com/stylevision for more information.-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:clitype="clitype" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:iso4217="http://www.xbrl.org/2003/iso4217" xmlns:ix="http://www.xbrl.org/2008/inlineXBRL" xmlns:java="java" xmlns:link="http://www.xbrl.org/2003/linkbase" xmlns:n1="http://xml.coeus.mit.edu/iacuc" xmlns:xbrldi="http://xbrl.org/2006/xbrldi" xmlns:xbrli="http://www.xbrl.org/2003/instance" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:altova="http://www.altova.com" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:svg="http://www.w3.org/2000/svg" exclude-result-prefixes="clitype fn iso4217 ix java link n1 xbrldi xbrli xlink xs xsi altova">
	<xsl:output version="1.0" method="xml" encoding="UTF-8" indent="no"/>
	<xsl:param name="SV_OutputFormat" select="\'PDF\'"/>
	<xsl:variable name="XML" select="/"/>
	<xsl:variable name="fo:layout-master-set">
		<fo:layout-master-set>
			<fo:simple-page-master master-name="page-master-180440160-even" margin-left="0.60in" margin-right="0.60in" page-height="11in" page-width="8.50in">
				<fo:region-body margin-top="1.00in" margin-bottom="0.79in" column-count="1" column-gap="0.50in"/>
				<fo:region-before region-name="even-page-header" overflow="hidden" extent="0.70in"/>
			</fo:simple-page-master>
			<fo:simple-page-master master-name="page-master-180440160-odd" margin-left="0.60in" margin-right="0.60in" page-height="11in" page-width="8.50in">
				<fo:region-body margin-top="1.00in" margin-bottom="0.79in" column-count="1" column-gap="0.50in"/>
				<fo:region-before region-name="odd-page-header" overflow="hidden" extent="0.70in"/>
			</fo:simple-page-master>
			<fo:page-sequence-master master-name="page-master-180440160">
				<fo:repeatable-page-master-alternatives>
					<fo:conditional-page-master-reference master-reference="page-master-180440160-even" odd-or-even="even"/>
					<fo:conditional-page-master-reference master-reference="page-master-180440160-odd" odd-or-even="odd"/>
				</fo:repeatable-page-master-alternatives>
			</fo:page-sequence-master>
		</fo:layout-master-set>
	</xsl:variable>
	<xsl:variable name="altova:nPxPerIn" select="96"/>
	<xsl:template match="/">
		<fo:root>
			<xsl:copy-of select="$fo:layout-master-set"/>
			<fo:page-sequence force-page-count="no-force" master-reference="page-master-180440160" initial-page-number="auto" format="1">
				<fo:static-content flow-name="odd-page-header">
					<fo:block-container margin-top="0.30in">
						<fo:block>
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x200B;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:block text-align="center" margin="0pt">
								<fo:inline font-weight="bold">
									<xsl:text>Meeting Agenda</xsl:text>
								</fo:inline>
							</fo:block>
							<fo:block text-align="center">
								<fo:leader leader-pattern="rule" rule-thickness="2" leader-length="100%"/>
							</fo:block>
						</fo:block>
					</fo:block-container>
				</fo:static-content>
				<fo:static-content flow-name="even-page-header">
					<fo:block-container margin-top="0.30in">
						<fo:block>
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x200B;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:block text-align="center" margin="0pt">
								<fo:inline font-weight="bold">
									<xsl:text>Meeting Agenda</xsl:text>
								</fo:inline>
							</fo:block>
							<fo:block text-align="center">
								<fo:leader leader-pattern="rule" rule-thickness="2" leader-length="100%"/>
							</fo:block>
						</fo:block>
					</fo:block-container>
				</fo:static-content>
				<fo:flow flow-name="xsl-region-body">
					<fo:block>
						<xsl:for-each select="$XML">
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
							<xsl:for-each select="n1:Schedule">
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x200B;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block margin="0pt">
									<fo:inline text-decoration="underline">
										<xsl:text>Meeting Details</xsl:text>
									</fo:inline>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x200B;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:table table-layout="fixed" width="100%" border-spacing="0">
									<fo:table-column column-width="1.340in"/>
									<xsl:for-each select="n1:ScheduleMasterData">
										<fo:table-column column-width="proportional-column-width(1)"/>
									</xsl:for-each>
									<xsl:variable name="altova:CurrContextGrid_0ABE2DF0" select="."/>
									<fo:table-body start-indent="0pt">
										<xsl:variable name="altova:tablerows">
											<fo:table-row>
												<fo:table-cell padding="0" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Committee Name</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<xsl:for-each select="n1:ScheduleMasterData">
													<fo:table-cell padding="0" display-align="center">
														<fo:block text-align="left">
															<fo:inline>
																<xsl:text>: </xsl:text>
															</fo:inline>
															<xsl:for-each select="n1:CommitteeName">
																<xsl:variable name="value-of-template_06C49300">
																	<xsl:apply-templates/>
																</xsl:variable>
																<xsl:choose>
																	<xsl:when test="contains(string($value-of-template_06C49300),\'&#x200B;\')">
																		<fo:block>
																			<xsl:copy-of select="$value-of-template_06C49300"/>
																		</fo:block>
																	</xsl:when>
																	<xsl:otherwise>
																		<fo:inline>
																			<xsl:copy-of select="$value-of-template_06C49300"/>
																		</fo:inline>
																	</xsl:otherwise>
																</xsl:choose>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</xsl:for-each>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="0" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Scheduled Date</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<xsl:for-each select="n1:ScheduleMasterData">
													<fo:table-cell padding="0" display-align="center">
														<fo:block text-align="left">
															<fo:inline>
																<xsl:text>: </xsl:text>
															</fo:inline>
															<xsl:for-each select="n1:ScheduledDate">
																<fo:inline>
																	<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																	<xsl:text> / </xsl:text>
																	<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																	<xsl:text> / </xsl:text>
																	<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
																</fo:inline>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</xsl:for-each>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="0" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Scheduled Time</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<xsl:for-each select="n1:ScheduleMasterData">
													<fo:table-cell padding="0" display-align="center">
														<fo:block text-align="left">
															<fo:inline>
																<xsl:text>: </xsl:text>
															</fo:inline>
															<xsl:for-each select="n1:ScheduledTime">
																<xsl:variable name="value-of-template_06C480A0">
																	<xsl:apply-templates/>
																</xsl:variable>
																<xsl:choose>
																	<xsl:when test="contains(string($value-of-template_06C480A0),\'&#x200B;\')">
																		<fo:block>
																			<xsl:copy-of select="$value-of-template_06C480A0"/>
																		</fo:block>
																	</xsl:when>
																	<xsl:otherwise>
																		<fo:inline>
																			<xsl:copy-of select="$value-of-template_06C480A0"/>
																		</fo:inline>
																	</xsl:otherwise>
																</xsl:choose>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</xsl:for-each>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="0" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Place</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<xsl:for-each select="n1:ScheduleMasterData">
													<fo:table-cell padding="0" display-align="center">
														<fo:block text-align="left">
															<fo:inline>
																<xsl:text>: </xsl:text>
															</fo:inline>
															<xsl:for-each select="n1:Place">
																<xsl:variable name="value-of-template_06C48260">
																	<xsl:apply-templates/>
																</xsl:variable>
																<xsl:choose>
																	<xsl:when test="contains(string($value-of-template_06C48260),\'&#x200B;\')">
																		<fo:block>
																			<xsl:copy-of select="$value-of-template_06C48260"/>
																		</fo:block>
																	</xsl:when>
																	<xsl:otherwise>
																		<fo:inline>
																			<xsl:copy-of select="$value-of-template_06C48260"/>
																		</fo:inline>
																	</xsl:otherwise>
																</xsl:choose>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</xsl:for-each>
											</fo:table-row>
										</xsl:variable>
										<xsl:choose>
											<xsl:when test="string($altova:tablerows)">
												<xsl:copy-of select="$altova:tablerows"/>
											</xsl:when>
											<xsl:otherwise>
												<fo:table-row>
													<fo:table-cell>
														<fo:block/>
													</fo:table-cell>
												</fo:table-row>
											</xsl:otherwise>
										</xsl:choose>
									</fo:table-body>
								</fo:table>
							</xsl:for-each>
							<fo:block/>
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
							<xsl:for-each select="n1:Schedule">
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x200B;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block margin="0pt">
									<fo:inline text-decoration="underline">
										<xsl:text>Agenda Details</xsl:text>
									</fo:inline>
								</fo:block>
								<xsl:if test="string-length(normalize-space(string(n1:ScheduleMasterData/n1:MeetingDate)))&gt;0">
									<fo:inline-container>
										<fo:block>
											<xsl:text>&#x200B;</xsl:text>
										</fo:block>
									</fo:inline-container>
									<fo:list-block provisional-distance-between-starts="7mm" provisional-label-separation="2mm">
										<fo:list-item>
											<fo:list-item-label end-indent="label-end()" text-align="right">
												<fo:block font-family="Courier">&#x2022;</fo:block>
											</fo:list-item-label>
											<fo:list-item-body start-indent="body-start()">
												<fo:block>
													<fo:inline>
														<xsl:text>Review the minutes of the meeting held on </xsl:text>
													</fo:inline>
													<xsl:for-each select="n1:PreviousSchedule">
														<xsl:for-each select="n1:ScheduleMasterData">
															<xsl:for-each select="n1:MeetingDate">
																<fo:inline>
																	<xsl:call-template name="DateToMonthName">
																		<xsl:with-param name="sDate" select="string(string(.))"/>
																		<xsl:with-param name="sFormat" select="\'long\'"/>
																	</xsl:call-template>
																	<xsl:text> </xsl:text>
																	<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																	<xsl:text>, </xsl:text>
																	<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
																</fo:inline>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
													<fo:inline>
														<xsl:text>.</xsl:text>
													</fo:inline>
												</fo:block>
											</fo:list-item-body>
										</fo:list-item>
									</fo:list-block>
								</xsl:if>
								<fo:block/>
								<xsl:if test="string-length(normalize-space(string(n1:NextSchedule/n1:ScheduleMasterData/n1:MeetingDate)))&gt;0">
									<fo:inline-container>
										<fo:block>
											<xsl:text>&#x200B;</xsl:text>
										</fo:block>
									</fo:inline-container>
									<fo:list-block provisional-distance-between-starts="7mm" provisional-label-separation="2mm">
										<fo:list-item>
											<fo:list-item-label end-indent="label-end()" text-align="right">
												<fo:block font-family="Courier">&#x2022;</fo:block>
											</fo:list-item-label>
											<fo:list-item-body start-indent="body-start()">
												<fo:block>
													<fo:inline>
														<xsl:text>The next meeting will be held on </xsl:text>
													</fo:inline>
													<xsl:for-each select="n1:NextSchedule">
														<xsl:for-each select="n1:ScheduleMasterData">
															<xsl:for-each select="n1:MeetingDate">
																<fo:inline>
																	<xsl:call-template name="DateToMonthName">
																		<xsl:with-param name="sDate" select="string(string(.))"/>
																		<xsl:with-param name="sFormat" select="\'long\'"/>
																	</xsl:call-template>
																	<xsl:text> </xsl:text>
																	<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																	<xsl:text>, </xsl:text>
																	<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
																</fo:inline>
															</xsl:for-each>
															<xsl:if test="string-length(normalize-space(n1:NextSchedule/n1:ScheduleMasterData/n1:Place))&gt;0">
																<fo:inline>
																	<xsl:text> at </xsl:text>
																</fo:inline>
																<xsl:for-each select="n1:Place">
																	<xsl:variable name="value-of-template_06C48500">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template_06C48500),\'&#x200B;\')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template_06C48500"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template_06C48500"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</xsl:if>
														</xsl:for-each>
													</xsl:for-each>
													<fo:inline>
														<xsl:text>.</xsl:text>
													</fo:inline>
												</fo:block>
											</fo:list-item-body>
										</fo:list-item>
									</fo:list-block>
								</xsl:if>
								<fo:inline>
									<xsl:text>&#160;</xsl:text>
								</fo:inline>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x200B;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block margin="0pt">
									<fo:inline text-decoration="underline">
										<xsl:text>Protocols Submitted for Review</xsl:text>
									</fo:inline>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x200B;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block margin="0pt">
									<xsl:for-each select="n1:ProtocolSubmission">
										<xsl:for-each select="n1:SubmissionDetails">
											<fo:block>
												<fo:leader leader-pattern="space"/>
											</fo:block>
											<xsl:for-each select="n1:SubmissionTypeDesc">
												<xsl:variable name="value-of-template_06C485E0">
													<xsl:apply-templates/>
												</xsl:variable>
												<xsl:choose>
													<xsl:when test="contains(string($value-of-template_06C485E0),\'&#x200B;\')">
														<fo:block font-weight="bold">
															<xsl:copy-of select="$value-of-template_06C485E0"/>
														</fo:block>
													</xsl:when>
													<xsl:otherwise>
														<fo:inline font-weight="bold">
															<xsl:copy-of select="$value-of-template_06C485E0"/>
														</fo:inline>
													</xsl:otherwise>
												</xsl:choose>
											</xsl:for-each>
										</xsl:for-each>
										<fo:block/>
										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x200B;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<fo:block margin="0pt">
											<xsl:for-each select="n1:ProtocolSummary">
												<fo:inline-container>
													<fo:block>
														<xsl:text>&#x200B;</xsl:text>
													</fo:block>
												</fo:inline-container>
												<fo:block margin="0pt">
													<xsl:for-each select="n1:ProtocolMasterData">
														<fo:inline>
															<xsl:text>&#160;</xsl:text>
														</fo:inline>
														<fo:inline-container>
															<fo:block>
																<xsl:text>&#x200B;</xsl:text>
															</fo:block>
														</fo:inline-container>
														<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
															<fo:table-column column-width="1.948in"/>
															<fo:table-column column-width="1.594in"/>
															<fo:table-column column-width="1.802in"/>
															<fo:table-column column-width="1.135in"/>
															<fo:table-column column-width="1.135in"/>
															<xsl:variable name="altova:CurrContextGrid_10FC3298" select="."/>
															<fo:table-body start-indent="0pt">
																<xsl:variable name="altova:tablerows">
																	<fo:table-row>
																		<fo:table-cell padding="2pt" display-align="before">
																			<fo:block text-align="left">
																				<fo:inline font-weight="bold">
																					<xsl:text>Protocol Number</xsl:text>
																				</fo:inline>
																			</fo:block>
																		</fo:table-cell>
																		<fo:table-cell padding="2pt" display-align="before">
																			<fo:block text-align="left">
																				<fo:inline>
																					<xsl:text>: </xsl:text>
																				</fo:inline>
																				<xsl:for-each select="n1:ProtocolNumber">
																					<xsl:variable name="value-of-template_06C486C0">
																						<xsl:apply-templates/>
																					</xsl:variable>
																					<xsl:choose>
																						<xsl:when test="contains(string($value-of-template_06C486C0),\'&#x200B;\')">
																							<fo:block>
																								<xsl:copy-of select="$value-of-template_06C486C0"/>
																							</fo:block>
																						</xsl:when>
																						<xsl:otherwise>
																							<fo:inline>
																								<xsl:copy-of select="$value-of-template_06C486C0"/>
																							</fo:inline>
																						</xsl:otherwise>
																					</xsl:choose>
																				</xsl:for-each>
																			</fo:block>
																		</fo:table-cell>
																		<fo:table-cell padding="2pt" display-align="before">
																			<fo:block text-align="left">
																				<fo:inline font-weight="bold">
																					<xsl:text>Expiration Date:</xsl:text>
																				</fo:inline>
																			</fo:block>
																		</fo:table-cell>
																		<fo:table-cell padding="2pt" display-align="before">
																			<fo:block text-align="left">
																				<xsl:for-each select="n1:ExpirationDate">
																					<fo:inline>
																						<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																						<xsl:text>/</xsl:text>
																						<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																						<xsl:text>/</xsl:text>
																						<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
																					</fo:inline>
																				</xsl:for-each>
																			</fo:block>
																		</fo:table-cell>
																		<fo:table-cell padding="2pt" display-align="before">
																			<fo:block text-align="left"/>
																		</fo:table-cell>
																	</fo:table-row>
																	<fo:table-row>
																		<fo:table-cell padding="2pt" display-align="before">
																			<fo:block text-align="left">
																				<fo:inline font-weight="bold">
																					<xsl:text>Protocol Title</xsl:text>
																				</fo:inline>
																			</fo:block>
																		</fo:table-cell>
																		<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="before">
																			<fo:block text-align="left">
																				<fo:inline>
																					<xsl:text>: </xsl:text>
																				</fo:inline>
																				<xsl:for-each select="n1:ProtocolTitle">
																					<xsl:variable name="value-of-template_06C48880">
																						<xsl:apply-templates/>
																					</xsl:variable>
																					<xsl:choose>
																						<xsl:when test="contains(string($value-of-template_06C48880),\'&#x200B;\')">
																							<fo:block>
																								<xsl:copy-of select="$value-of-template_06C48880"/>
																							</fo:block>
																						</xsl:when>
																						<xsl:otherwise>
																							<fo:inline>
																								<xsl:copy-of select="$value-of-template_06C48880"/>
																							</fo:inline>
																						</xsl:otherwise>
																					</xsl:choose>
																				</xsl:for-each>
																			</fo:block>
																		</fo:table-cell>
																	</fo:table-row>
																</xsl:variable>
																<xsl:choose>
																	<xsl:when test="string($altova:tablerows)">
																		<xsl:copy-of select="$altova:tablerows"/>
																	</xsl:when>
																	<xsl:otherwise>
																		<fo:table-row>
																			<fo:table-cell>
																				<fo:block/>
																			</fo:table-cell>
																		</fo:table-row>
																	</xsl:otherwise>
																</xsl:choose>
															</fo:table-body>
														</fo:table>
													</xsl:for-each>
												</fo:block>
												<fo:inline-container>
													<fo:block>
														<xsl:text>&#x200B;</xsl:text>
													</fo:block>
												</fo:inline-container>
												<fo:block margin="0pt">
													<fo:inline-container>
														<fo:block>
															<xsl:text>&#x200B;</xsl:text>
														</fo:block>
													</fo:inline-container>
													<fo:table table-layout="fixed" width="100%" border-spacing="0">
														<fo:table-column column-width="1.980in"/>
														<fo:table-column column-width="proportional-column-width(1)"/>
														<xsl:variable name="altova:CurrContextGrid_10FC3A78" select="."/>
														<fo:table-body start-indent="0pt">
															<xsl:variable name="altova:tablerows">
																<fo:table-row>
																	<fo:table-cell padding="0" display-align="center">
																		<fo:block text-align="left">
																			<fo:inline font-weight="bold">
																				<xsl:text>Principal Investigator</xsl:text>
																			</fo:inline>
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell padding="0" display-align="center">
																		<fo:block text-align="left">
																			<fo:inline>
																				<xsl:text>: </xsl:text>
																			</fo:inline>
																			<xsl:for-each select="n1:Investigator">
																				<xsl:for-each select="n1:Person">
																					<xsl:for-each select="n1:Fullname">
																						<xsl:if test="../../n1:PIFlag=true()">
																							<xsl:variable name="value-of-template_06C48960">
																								<xsl:apply-templates/>
																							</xsl:variable>
																							<xsl:choose>
																								<xsl:when test="contains(string($value-of-template_06C48960),\'&#x200B;\')">
																									<fo:block>
																										<xsl:copy-of select="$value-of-template_06C48960"/>
																									</fo:block>
																								</xsl:when>
																								<xsl:otherwise>
																									<fo:inline>
																										<xsl:copy-of select="$value-of-template_06C48960"/>
																									</fo:inline>
																								</xsl:otherwise>
																							</xsl:choose>
																						</xsl:if>
																					</xsl:for-each>
																				</xsl:for-each>
																			</xsl:for-each>
																		</fo:block>
																	</fo:table-cell>
																</fo:table-row>
															</xsl:variable>
															<xsl:choose>
																<xsl:when test="string($altova:tablerows)">
																	<xsl:copy-of select="$altova:tablerows"/>
																</xsl:when>
																<xsl:otherwise>
																	<fo:table-row>
																		<fo:table-cell>
																			<fo:block/>
																		</fo:table-cell>
																	</fo:table-row>
																</xsl:otherwise>
															</xsl:choose>
														</fo:table-body>
													</fo:table>
												</fo:block>
											</xsl:for-each>
											<fo:block>
												<fo:leader leader-pattern="space"/>
											</fo:block>
											<fo:inline-container>
												<fo:block>
													<xsl:text>&#x200B;</xsl:text>
												</fo:block>
											</fo:inline-container>
											<fo:block margin="0pt"/>
											<fo:inline-container>
												<fo:block>
													<xsl:text>&#x200B;</xsl:text>
												</fo:block>
											</fo:inline-container>
											<fo:block margin="0pt">
												<fo:inline-container>
													<fo:block>
														<xsl:text>&#x200B;</xsl:text>
													</fo:block>
												</fo:inline-container>
												<fo:table table-layout="fixed" width="100%" border-spacing="0">
													<fo:table-column column-width="1.950in"/>
													<fo:table-column column-width="proportional-column-width(1)"/>
													<xsl:variable name="altova:CurrContextGrid_10FC3D18" select="."/>
													<fo:table-body start-indent="0pt">
														<xsl:variable name="altova:tablerows">
															<fo:table-row>
																<fo:table-cell padding="0" display-align="center">
																	<fo:block text-align="left">
																		<fo:inline font-weight="bold">
																			<xsl:text>Primary Reviewers</xsl:text>
																		</fo:inline>
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell padding="0" display-align="center">
																	<fo:block text-align="left">
																		<xsl:for-each select="n1:SubmissionDetails">
																			<xsl:for-each select="n1:ProtocolReviewer">
																				<xsl:if test="n1:ReviewerTypeCode=1">
																					<xsl:for-each select="n1:Person">
																						<xsl:for-each select="n1:Fullname">
																							<fo:inline>
																								<xsl:text>: </xsl:text>
																							</fo:inline>
																							<xsl:variable name="value-of-template_06C48A40">
																								<xsl:apply-templates/>
																							</xsl:variable>
																							<xsl:choose>
																								<xsl:when test="contains(string($value-of-template_06C48A40),\'&#x200B;\')">
																									<fo:block>
																										<xsl:copy-of select="$value-of-template_06C48A40"/>
																									</fo:block>
																								</xsl:when>
																								<xsl:otherwise>
																									<fo:inline>
																										<xsl:copy-of select="$value-of-template_06C48A40"/>
																									</fo:inline>
																								</xsl:otherwise>
																							</xsl:choose>
																							<fo:block/>
																						</xsl:for-each>
																					</xsl:for-each>
																				</xsl:if>
																				<fo:block/>
																			</xsl:for-each>
																		</xsl:for-each>
																	</fo:block>
																</fo:table-cell>
															</fo:table-row>
														</xsl:variable>
														<xsl:choose>
															<xsl:when test="string($altova:tablerows)">
																<xsl:copy-of select="$altova:tablerows"/>
															</xsl:when>
															<xsl:otherwise>
																<fo:table-row>
																	<fo:table-cell>
																		<fo:block/>
																	</fo:table-cell>
																</fo:table-row>
															</xsl:otherwise>
														</xsl:choose>
													</fo:table-body>
												</fo:table>
												<fo:inline-container>
													<fo:block>
														<xsl:text>&#x200B;</xsl:text>
													</fo:block>
												</fo:inline-container>
												<fo:table table-layout="fixed" width="100%" border-spacing="0">
													<fo:table-column column-width="1.950in"/>
													<fo:table-column column-width="5.720in"/>
													<xsl:variable name="altova:CurrContextGrid_10FC3FB8" select="."/>
													<fo:table-body start-indent="0pt">
														<xsl:variable name="altova:tablerows">
															<fo:table-row>
																<fo:table-cell padding="0" display-align="center">
																	<fo:block text-align="left">
																		<fo:inline font-weight="bold">
																			<xsl:text>Secondary Reviewers</xsl:text>
																		</fo:inline>
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell padding="0" display-align="center">
																	<fo:block text-align="left">
																		<xsl:for-each select="n1:SubmissionDetails">
																			<xsl:for-each select="n1:ProtocolReviewer">
																				<xsl:if test="n1:ReviewerTypeCode=2">
																					<xsl:for-each select="n1:Person">
																						<xsl:for-each select="n1:Fullname">
																							<fo:inline>
																								<xsl:text>: </xsl:text>
																							</fo:inline>
																							<xsl:variable name="value-of-template_06C48B20">
																								<xsl:apply-templates/>
																							</xsl:variable>
																							<xsl:choose>
																								<xsl:when test="contains(string($value-of-template_06C48B20),\'&#x200B;\')">
																									<fo:block>
																										<xsl:copy-of select="$value-of-template_06C48B20"/>
																									</fo:block>
																								</xsl:when>
																								<xsl:otherwise>
																									<fo:inline>
																										<xsl:copy-of select="$value-of-template_06C48B20"/>
																									</fo:inline>
																								</xsl:otherwise>
																							</xsl:choose>
																						</xsl:for-each>
																					</xsl:for-each>
																				</xsl:if>
																				<fo:block/>
																			</xsl:for-each>
																		</xsl:for-each>
																	</fo:block>
																</fo:table-cell>
															</fo:table-row>
														</xsl:variable>
														<xsl:choose>
															<xsl:when test="string($altova:tablerows)">
																<xsl:copy-of select="$altova:tablerows"/>
															</xsl:when>
															<xsl:otherwise>
																<fo:table-row>
																	<fo:table-cell>
																		<fo:block/>
																	</fo:table-cell>
																</fo:table-row>
															</xsl:otherwise>
														</xsl:choose>
													</fo:table-body>
												</fo:table>
											</fo:block>
										</fo:block>
										<fo:block text-align="center">
											<fo:leader leader-pattern="rule" rule-thickness="1" leader-length="100%"/>
										</fo:block>
										<fo:block>
											<fo:leader leader-pattern="space"/>
										</fo:block>
									</xsl:for-each>
								</fo:block>
							</xsl:for-each>
							<fo:block/>
						</xsl:for-each>
					</fo:block>
					<fo:block id="SV_RefID_PageTotal"/>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	<xsl:template name="DateToMonthName">
		<xsl:param name="sDate"/>
		<xsl:param name="sFormat"/>
		<xsl:choose>
			<xsl:when test="$sFormat = \'long\'">
				<xsl:call-template name="DateToMonthNameLong">
					<xsl:with-param name="sDate" select="$sDate"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="DateToMonthNameShort">
					<xsl:with-param name="sDate" select="$sDate"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="DateToMonthNameLong">
		<xsl:param name="sDate"/>
		<xsl:variable name="nMonth">
			<xsl:call-template name="DateToMonthNum">
				<xsl:with-param name="sDate" select="$sDate"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="$nMonth = 1">January</xsl:when>
			<xsl:when test="$nMonth = 2">February</xsl:when>
			<xsl:when test="$nMonth = 3">March</xsl:when>
			<xsl:when test="$nMonth = 4">April</xsl:when>
			<xsl:when test="$nMonth = 5">May</xsl:when>
			<xsl:when test="$nMonth = 6">June</xsl:when>
			<xsl:when test="$nMonth = 7">July</xsl:when>
			<xsl:when test="$nMonth = 8">August</xsl:when>
			<xsl:when test="$nMonth = 9">September</xsl:when>
			<xsl:when test="$nMonth = 10">October</xsl:when>
			<xsl:when test="$nMonth = 11">November</xsl:when>
			<xsl:otherwise>December</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="DateToMonthNum">
		<xsl:param name="sDate"/>
		<xsl:choose>
			<xsl:when test="starts-with($sDate, \'--\')">
				<xsl:value-of select="number(substring($sDate, 3, 2))"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="number(substring($sDate, 6, 2))"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="DateToMonthNameShort">
		<xsl:param name="sDate"/>
		<xsl:variable name="nMonth">
			<xsl:call-template name="DateToMonthNum">
				<xsl:with-param name="sDate" select="$sDate"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="$nMonth = 1">Jan</xsl:when>
			<xsl:when test="$nMonth = 2">Feb</xsl:when>
			<xsl:when test="$nMonth = 3">Mar</xsl:when>
			<xsl:when test="$nMonth = 4">Apr</xsl:when>
			<xsl:when test="$nMonth = 5">May</xsl:when>
			<xsl:when test="$nMonth = 6">Jun</xsl:when>
			<xsl:when test="$nMonth = 7">Jul</xsl:when>
			<xsl:when test="$nMonth = 8">Aug</xsl:when>
			<xsl:when test="$nMonth = 9">Sep</xsl:when>
			<xsl:when test="$nMonth = 10">Oct</xsl:when>
			<xsl:when test="$nMonth = 11">Nov</xsl:when>
			<xsl:otherwise>Dec</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="double-backslash">
		<xsl:param name="text"/>
		<xsl:param name="text-length"/>
		<xsl:variable name="text-after-bs" select="substring-after($text, \'\\\')"/>
		<xsl:variable name="text-after-bs-length" select="string-length($text-after-bs)"/>
		<xsl:choose>
			<xsl:when test="$text-after-bs-length = 0">
				<xsl:choose>
					<xsl:when test="substring($text, $text-length) = \'\\\'">
						<xsl:value-of select="concat(substring($text,1,$text-length - 1), \'\\\\\')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$text"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="concat(substring($text,1,$text-length - $text-after-bs-length - 1), \'\\\\\')"/>
				<xsl:call-template name="double-backslash">
					<xsl:with-param name="text" select="$text-after-bs"/>
					<xsl:with-param name="text-length" select="$text-after-bs-length"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="altova:MakeValueAbsoluteIfPixels">
		<xsl:param name="sValue"/>
		<xsl:variable name="sBeforePx" select="substring-before($sValue, \'px\')"/>
		<xsl:choose>
			<xsl:when test="$sBeforePx">
				<xsl:variable name="nLengthOfInteger">
					<xsl:call-template name="altova:GetCharCountOfIntegerAtEndOfString">
						<xsl:with-param name="sText" select="$sBeforePx"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:variable name="nPosOfInteger" select="string-length($sBeforePx) - $nLengthOfInteger + 1"/>
				<xsl:variable name="nValuePx" select="substring($sBeforePx, $nPosOfInteger)"/>
				<xsl:variable name="nValueIn" select="number($nValuePx) div number($altova:nPxPerIn)"/>
				<xsl:variable name="nLengthBeforeInteger" select="string-length($sBeforePx) - $nLengthOfInteger"/>
				<xsl:variable name="sRest">
					<xsl:call-template name="altova:MakeValueAbsoluteIfPixels">
						<xsl:with-param name="sValue" select="substring-after($sValue, \'px\')"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="concat(substring($sBeforePx, 1, $nLengthBeforeInteger), string($nValueIn), \'in\', $sRest)"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$sValue"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="altova:GetCharCountOfIntegerAtEndOfString">
		<xsl:param name="sText"/>
		<xsl:variable name="sLen" select="string-length($sText)"/>
		<xsl:variable name="cLast" select="substring($sText, $sLen)"/>
		<xsl:choose>
			<xsl:when test="number($cLast) &gt;= 0 and number($cLast) &lt;= 9">
				<xsl:variable name="nResultOfRest">
					<xsl:call-template name="altova:GetCharCountOfIntegerAtEndOfString">
						<xsl:with-param name="sText" select="substring($sText, 1, $sLen - 1)"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="$nResultOfRest + 1"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text>0</xsl:text>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
','MeetingAgenda.xslt',UUID(),(SELECT (MAX(ID)) FROM SEQ_IACUC_PROTO_CORRESP_TEMPL),'3',NOW(),'admin',1)
/
INSERT INTO SEQ_IACUC_PROTO_CORRESP_TEMPL VALUES(NULL)
/
INSERT INTO IACUC_PROTO_CORRESP_TEMPL (COMMITTEE_ID,CORRESPONDENCE_TEMPLATE,FILE_NAME,OBJ_ID,PROTO_CORRESP_TEMPL_ID,PROTO_CORRESP_TYPE_CODE,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR)
  VALUES ('DEFAULT','<?xml version="1.0" encoding="UTF-8"?>
<!--Designed and generated by Altova StyleVision Enterprise Edition 2011 - see http://www.altova.com/stylevision for more information.-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:clitype="clitype" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:iso4217="http://www.xbrl.org/2003/iso4217" xmlns:ix="http://www.xbrl.org/2008/inlineXBRL" xmlns:java="java" xmlns:link="http://www.xbrl.org/2003/linkbase" xmlns:n1="http://xml.coeus.mit.edu/iacuc" xmlns:xbrldi="http://xbrl.org/2006/xbrldi" xmlns:xbrli="http://www.xbrl.org/2003/instance" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:altova="http://www.altova.com" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:svg="http://www.w3.org/2000/svg" exclude-result-prefixes="clitype fn iso4217 ix java link n1 xbrldi xbrli xlink xs xsi altova">
	<xsl:output version="1.0" method="xml" encoding="UTF-8" indent="no"/>
	<xsl:param name="SV_OutputFormat" select="\'PDF\'"/>
	<xsl:variable name="XML" select="/"/>
	<xsl:variable name="fo:layout-master-set">
		<fo:layout-master-set>
			<fo:simple-page-master master-name="page-master-181280232-even" margin-left="0.60in" margin-right="0.60in" page-height="11in" page-width="8.50in">
				<fo:region-body margin-top="0.99in" margin-bottom="0.79in" column-count="1" column-gap="0.50in"/>
				<fo:region-before region-name="even-page-header" overflow="hidden" extent="0.69in"/>
			</fo:simple-page-master>
			<fo:simple-page-master master-name="page-master-181280232-odd" margin-left="0.60in" margin-right="0.60in" page-height="11in" page-width="8.50in">
				<fo:region-body margin-top="0.99in" margin-bottom="0.79in" column-count="1" column-gap="0.50in"/>
				<fo:region-before region-name="odd-page-header" overflow="hidden" extent="0.69in"/>
			</fo:simple-page-master>
			<fo:page-sequence-master master-name="page-master-181280232">
				<fo:repeatable-page-master-alternatives>
					<fo:conditional-page-master-reference master-reference="page-master-181280232-even" odd-or-even="even"/>
					<fo:conditional-page-master-reference master-reference="page-master-181280232-odd" odd-or-even="odd"/>
				</fo:repeatable-page-master-alternatives>
			</fo:page-sequence-master>
		</fo:layout-master-set>
	</xsl:variable>
	<xsl:variable name="altova:nPxPerIn" select="96"/>
	<xsl:template match="/">
		<fo:root>
			<xsl:copy-of select="$fo:layout-master-set"/>
			<fo:page-sequence force-page-count="no-force" master-reference="page-master-181280232" initial-page-number="auto" format="1">
				<fo:static-content flow-name="odd-page-header">
					<fo:block-container margin-top="0.30in">
						<fo:block>
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x200B;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:block text-align="center" margin="0pt">
								<fo:inline font-weight="bold">
									<xsl:text>Meeting Minutes</xsl:text>
								</fo:inline>
							</fo:block>
							<fo:block text-align="center">
								<fo:leader leader-pattern="rule" rule-thickness="2" leader-length="100%"/>
							</fo:block>
						</fo:block>
					</fo:block-container>
				</fo:static-content>
				<fo:static-content flow-name="even-page-header">
					<fo:block-container margin-top="0.30in">
						<fo:block>
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x200B;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:block text-align="center" margin="0pt">
								<fo:inline font-weight="bold">
									<xsl:text>Meeting Minutes</xsl:text>
								</fo:inline>
							</fo:block>
							<fo:block text-align="center">
								<fo:leader leader-pattern="rule" rule-thickness="2" leader-length="100%"/>
							</fo:block>
						</fo:block>
					</fo:block-container>
				</fo:static-content>
				<fo:flow flow-name="xsl-region-body">
					<fo:block>
						<xsl:for-each select="$XML">
							<xsl:for-each select="n1:Schedule">
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x200B;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:table table-layout="fixed" width="100%" border-spacing="0">
									<fo:table-column column-width="1.340in"/>
									<xsl:for-each select="n1:ScheduleMasterData">
										<fo:table-column column-width="proportional-column-width(1)"/>
									</xsl:for-each>
									<xsl:variable name="altova:CurrContextGrid_10FD47F8" select="."/>
									<fo:table-body start-indent="0pt">
										<xsl:variable name="altova:tablerows">
											<fo:table-row>
												<fo:table-cell padding="0" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Committee Name</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<xsl:for-each select="n1:ScheduleMasterData">
													<fo:table-cell padding="0" display-align="center">
														<fo:block text-align="left">
															<fo:inline>
																<xsl:text>: </xsl:text>
															</fo:inline>
															<xsl:for-each select="n1:CommitteeName">
																<xsl:variable name="value-of-template_06C49060">
																	<xsl:apply-templates/>
																</xsl:variable>
																<xsl:choose>
																	<xsl:when test="contains(string($value-of-template_06C49060),\'&#x200B;\')">
																		<fo:block>
																			<xsl:copy-of select="$value-of-template_06C49060"/>
																		</fo:block>
																	</xsl:when>
																	<xsl:otherwise>
																		<fo:inline>
																			<xsl:copy-of select="$value-of-template_06C49060"/>
																		</fo:inline>
																	</xsl:otherwise>
																</xsl:choose>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</xsl:for-each>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="0" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Scheduled Date</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<xsl:for-each select="n1:ScheduleMasterData">
													<fo:table-cell padding="0" display-align="center">
														<fo:block text-align="left">
															<fo:inline>
																<xsl:text>: </xsl:text>
															</fo:inline>
															<xsl:for-each select="n1:ScheduledDate">
																<fo:inline>
																	<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																	<xsl:text> / </xsl:text>
																	<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																	<xsl:text> / </xsl:text>
																	<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
																</fo:inline>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</xsl:for-each>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="0" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Scheduled Time</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<xsl:for-each select="n1:ScheduleMasterData">
													<fo:table-cell padding="0" display-align="center">
														<fo:block text-align="left">
															<fo:inline>
																<xsl:text>: </xsl:text>
															</fo:inline>
															<xsl:for-each select="n1:ScheduledTime">
																<xsl:variable name="value-of-template_06C48DC0">
																	<xsl:apply-templates/>
																</xsl:variable>
																<xsl:choose>
																	<xsl:when test="contains(string($value-of-template_06C48DC0),\'&#x200B;\')">
																		<fo:block>
																			<xsl:copy-of select="$value-of-template_06C48DC0"/>
																		</fo:block>
																	</xsl:when>
																	<xsl:otherwise>
																		<fo:inline>
																			<xsl:copy-of select="$value-of-template_06C48DC0"/>
																		</fo:inline>
																	</xsl:otherwise>
																</xsl:choose>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</xsl:for-each>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="0" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Place</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<xsl:for-each select="n1:ScheduleMasterData">
													<fo:table-cell padding="0" display-align="center">
														<fo:block text-align="left">
															<fo:inline>
																<xsl:text>: </xsl:text>
															</fo:inline>
															<xsl:for-each select="n1:Place">
																<xsl:variable name="value-of-template_06C48F80">
																	<xsl:apply-templates/>
																</xsl:variable>
																<xsl:choose>
																	<xsl:when test="contains(string($value-of-template_06C48F80),\'&#x200B;\')">
																		<fo:block>
																			<xsl:copy-of select="$value-of-template_06C48F80"/>
																		</fo:block>
																	</xsl:when>
																	<xsl:otherwise>
																		<fo:inline>
																			<xsl:copy-of select="$value-of-template_06C48F80"/>
																		</fo:inline>
																	</xsl:otherwise>
																</xsl:choose>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</xsl:for-each>
											</fo:table-row>
										</xsl:variable>
										<xsl:choose>
											<xsl:when test="string($altova:tablerows)">
												<xsl:copy-of select="$altova:tablerows"/>
											</xsl:when>
											<xsl:otherwise>
												<fo:table-row>
													<fo:table-cell>
														<fo:block/>
													</fo:table-cell>
												</fo:table-row>
											</xsl:otherwise>
										</xsl:choose>
									</fo:table-body>
								</fo:table>
								<xsl:for-each select="n1:ProtocolSubmission">
									<fo:block>
										<fo:leader leader-pattern="space"/>
									</fo:block>
									<fo:inline-container>
										<fo:block>
											<xsl:text>&#x200B;</xsl:text>
										</fo:block>
									</fo:inline-container>
									<fo:block margin="0pt">
										<fo:inline font-weight="bold" text-decoration="underline">
											<xsl:text>Protocol Details</xsl:text>
										</fo:inline>
									</fo:block>
									<xsl:for-each select="n1:ProtocolSummary">
										<xsl:for-each select="n1:ProtocolMasterData">
											<fo:block>
												<fo:leader leader-pattern="space"/>
											</fo:block>
											<fo:inline-container>
												<fo:block>
													<xsl:text>&#x200B;</xsl:text>
												</fo:block>
											</fo:inline-container>
											<fo:table table-layout="fixed" width="100%" border-spacing="0">
												<fo:table-column column-width="1.990in"/>
												<fo:table-column column-width="0.350in"/>
												<fo:table-column column-width="proportional-column-width(1)"/>
												<xsl:variable name="altova:CurrContextGrid_10FD45B8" select="."/>
												<fo:table-body start-indent="0pt">
													<xsl:variable name="altova:tablerows">
														<fo:table-row>
															<fo:table-cell padding="0" display-align="center">
																<fo:block text-align="left">
																	<fo:inline>
																		<xsl:text>Protocol Number</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell padding="0" display-align="center">
																<fo:block text-align="left">
																	<fo:inline>
																		<xsl:text>:</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell padding="0" display-align="center">
																<fo:block text-align="left">
																	<xsl:for-each select="n1:ProtocolNumber">
																		<xsl:variable name="value-of-template_06C49220">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template_06C49220),\'&#x200B;\')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template_06C49220"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template_06C49220"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell padding="0" display-align="center">
																<fo:block text-align="left">
																	<fo:inline>
																		<xsl:text>Protocol Title</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell padding="0" display-align="center">
																<fo:block text-align="left">
																	<fo:inline>
																		<xsl:text>:</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell padding="0" display-align="center">
																<fo:block text-align="left">
																	<xsl:for-each select="n1:ProtocolTitle">
																		<xsl:variable name="value-of-template_06C49140">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template_06C49140),\'&#x200B;\')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template_06C49140"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template_06C49140"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell padding="0" display-align="center">
																<fo:block text-align="left">
																	<fo:inline>
																		<xsl:text>Approval Date</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell padding="0" display-align="center">
																<fo:block text-align="left">
																	<fo:inline>
																		<xsl:text>:</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell padding="0" display-align="center">
																<fo:block text-align="left">
																	<xsl:for-each select="n1:ApprovalDate">
																		<fo:inline>
																			<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																			<xsl:text> / </xsl:text>
																			<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																			<xsl:text> / </xsl:text>
																			<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
																		</fo:inline>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell padding="0" display-align="center">
																<fo:block text-align="left">
																	<fo:inline>
																		<xsl:text>Expiration Date</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell padding="0" display-align="center">
																<fo:block text-align="left">
																	<fo:inline>
																		<xsl:text>:</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell padding="0" display-align="center">
																<fo:block text-align="left">
																	<xsl:for-each select="n1:ExpirationDate">
																		<fo:inline>
																			<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																			<xsl:text> / </xsl:text>
																			<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																			<xsl:text> / </xsl:text>
																			<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
																		</fo:inline>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell padding="0" display-align="center">
																<fo:block text-align="left">
																	<fo:inline>
																		<xsl:text>Principal Investigator</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell padding="0" display-align="center">
																<fo:block text-align="left">
																	<fo:inline>
																		<xsl:text>:</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell padding="0" display-align="center">
																<fo:block text-align="left">
																	<xsl:for-each select="n1:PrincipleInvestigatorName">
																		<xsl:variable name="value-of-template_11F32A68">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template_11F32A68),\'&#x200B;\')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template_11F32A68"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template_11F32A68"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
													</xsl:variable>
													<xsl:choose>
														<xsl:when test="string($altova:tablerows)">
															<xsl:copy-of select="$altova:tablerows"/>
														</xsl:when>
														<xsl:otherwise>
															<fo:table-row>
																<fo:table-cell>
																	<fo:block/>
																</fo:table-cell>
															</fo:table-row>
														</xsl:otherwise>
													</xsl:choose>
												</fo:table-body>
											</fo:table>
										</xsl:for-each>
									</xsl:for-each>
									<fo:block/>
									<fo:block>
										<fo:leader leader-pattern="space"/>
									</fo:block>
									<fo:inline font-weight="bold" text-decoration="underline">
										<xsl:text>Minutes details of the above protocol</xsl:text>
									</fo:inline>
									<fo:inline-container>
										<fo:block>
											<xsl:text>&#x200B;</xsl:text>
										</fo:block>
									</fo:inline-container>
									<xsl:if test="n1:Minutes">
										<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
											<fo:table-column column-width="proportional-column-width(1)"/>
											<fo:table-column column-width="proportional-column-width(1)"/>
											<fo:table-column column-width="proportional-column-width(1)"/>
											<fo:table-column column-width="proportional-column-width(1)"/>
											<xsl:variable name="altova:CurrContextGrid_11F1A108" select="."/>
											<fo:table-header start-indent="0pt">
												<fo:table-row>
													<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
														<fo:block text-align="left">
															<fo:inline>
																<xsl:text>Entry Number</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
														<fo:block text-align="left">
															<fo:inline>
																<xsl:text>Minute Entry</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
														<fo:block text-align="left">
															<fo:inline>
																<xsl:text>Update User</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
														<fo:block text-align="left">
															<fo:inline>
																<xsl:text>Update Timestamp</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-header>
											<fo:table-body start-indent="0pt">
												<xsl:variable name="altova:tablerows">
													<xsl:for-each select="n1:Minutes">
														<fo:table-row>
															<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																<fo:block text-align="left">
																	<xsl:for-each select="n1:EntryNumber">
																		<xsl:variable name="value-of-template_11F32988">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template_11F32988),\'&#x200B;\')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template_11F32988"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template_11F32988"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																<fo:block text-align="left">
																	<xsl:for-each select="n1:MinuteEntry">
																		<xsl:variable name="value-of-template_11F328A8">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template_11F328A8),\'&#x200B;\')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template_11F328A8"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template_11F328A8"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																<fo:block text-align="left">
																	<xsl:for-each select="n1:UpdateUser">
																		<xsl:variable name="value-of-template_11F327C8">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template_11F327C8),\'&#x200B;\')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template_11F327C8"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template_11F327C8"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																<fo:block text-align="left">
																	<xsl:for-each select="n1:UpdateTimestamp">
																		<xsl:variable name="value-of-template_11F326E8">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template_11F326E8),\'&#x200B;\')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template_11F326E8"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template_11F326E8"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
													</xsl:for-each>
												</xsl:variable>
												<xsl:choose>
													<xsl:when test="string($altova:tablerows)">
														<xsl:copy-of select="$altova:tablerows"/>
													</xsl:when>
													<xsl:otherwise>
														<fo:table-row>
															<fo:table-cell>
																<fo:block/>
															</fo:table-cell>
														</fo:table-row>
													</xsl:otherwise>
												</xsl:choose>
											</fo:table-body>
										</fo:table>
									</xsl:if>
									<fo:block>
										<fo:leader leader-pattern="space"/>
									</fo:block>
									<fo:block text-align="center">
										<fo:leader leader-pattern="rule" rule-thickness="1" leader-length="100%"/>
									</fo:block>
								</xsl:for-each>
								<fo:block/>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:inline font-weight="bold" text-decoration="underline">
									<xsl:text>Other Minutes</xsl:text>
								</fo:inline>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x200B;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<xsl:if test="n1:Minutes">
									<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-column column-width="proportional-column-width(1)"/>
										<xsl:variable name="altova:CurrContextGrid_11F1A108" select="."/>
										<fo:table-header start-indent="0pt">
											<fo:table-row>
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Entry Number</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Minute Entry</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Update User</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Update Timestamp</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</fo:table-header>
										<fo:table-body start-indent="0pt">
											<xsl:variable name="altova:tablerows">
												<xsl:for-each select="n1:Minutes">
													<fo:table-row>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block text-align="left">
																<xsl:for-each select="n1:EntryNumber">
																	<xsl:variable name="value-of-template_11F32988">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template_11F32988),\'&#x200B;\')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template_11F32988"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template_11F32988"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block text-align="left">
																<xsl:for-each select="n1:MinuteEntry">
																	<xsl:variable name="value-of-template_11F328A8">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template_11F328A8),\'&#x200B;\')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template_11F328A8"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template_11F328A8"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block text-align="left">
																<xsl:for-each select="n1:UpdateUser">
																	<xsl:variable name="value-of-template_11F327C8">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template_11F327C8),\'&#x200B;\')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template_11F327C8"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template_11F327C8"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
															<fo:block text-align="left">
																<xsl:for-each select="n1:UpdateTimestamp">
																	<xsl:variable name="value-of-template_11F326E8">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template_11F326E8),\'&#x200B;\')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template_11F326E8"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template_11F326E8"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</xsl:for-each>
											</xsl:variable>
											<xsl:choose>
												<xsl:when test="string($altova:tablerows)">
													<xsl:copy-of select="$altova:tablerows"/>
												</xsl:when>
												<xsl:otherwise>
													<fo:table-row>
														<fo:table-cell>
															<fo:block/>
														</fo:table-cell>
													</fo:table-row>
												</xsl:otherwise>
											</xsl:choose>
										</fo:table-body>
									</fo:table>
								</xsl:if>
							</xsl:for-each>
						</xsl:for-each>
					</fo:block>
					<fo:block id="SV_RefID_PageTotal"/>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	<xsl:template name="double-backslash">
		<xsl:param name="text"/>
		<xsl:param name="text-length"/>
		<xsl:variable name="text-after-bs" select="substring-after($text, \'\\\')"/>
		<xsl:variable name="text-after-bs-length" select="string-length($text-after-bs)"/>
		<xsl:choose>
			<xsl:when test="$text-after-bs-length = 0">
				<xsl:choose>
					<xsl:when test="substring($text, $text-length) = \'\\\'">
						<xsl:value-of select="concat(substring($text,1,$text-length - 1), \'\\\\\')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$text"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="concat(substring($text,1,$text-length - $text-after-bs-length - 1), \'\\\\\')"/>
				<xsl:call-template name="double-backslash">
					<xsl:with-param name="text" select="$text-after-bs"/>
					<xsl:with-param name="text-length" select="$text-after-bs-length"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="altova:MakeValueAbsoluteIfPixels">
		<xsl:param name="sValue"/>
		<xsl:variable name="sBeforePx" select="substring-before($sValue, \'px\')"/>
		<xsl:choose>
			<xsl:when test="$sBeforePx">
				<xsl:variable name="nLengthOfInteger">
					<xsl:call-template name="altova:GetCharCountOfIntegerAtEndOfString">
						<xsl:with-param name="sText" select="$sBeforePx"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:variable name="nPosOfInteger" select="string-length($sBeforePx) - $nLengthOfInteger + 1"/>
				<xsl:variable name="nValuePx" select="substring($sBeforePx, $nPosOfInteger)"/>
				<xsl:variable name="nValueIn" select="number($nValuePx) div number($altova:nPxPerIn)"/>
				<xsl:variable name="nLengthBeforeInteger" select="string-length($sBeforePx) - $nLengthOfInteger"/>
				<xsl:variable name="sRest">
					<xsl:call-template name="altova:MakeValueAbsoluteIfPixels">
						<xsl:with-param name="sValue" select="substring-after($sValue, \'px\')"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="concat(substring($sBeforePx, 1, $nLengthBeforeInteger), string($nValueIn), \'in\', $sRest)"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$sValue"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="altova:GetCharCountOfIntegerAtEndOfString">
		<xsl:param name="sText"/>
		<xsl:variable name="sLen" select="string-length($sText)"/>
		<xsl:variable name="cLast" select="substring($sText, $sLen)"/>
		<xsl:choose>
			<xsl:when test="number($cLast) &gt;= 0 and number($cLast) &lt;= 9">
				<xsl:variable name="nResultOfRest">
					<xsl:call-template name="altova:GetCharCountOfIntegerAtEndOfString">
						<xsl:with-param name="sText" select="substring($sText, 1, $sLen - 1)"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="$nResultOfRest + 1"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text>0</xsl:text>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
','MeetingMinutes.xslt',UUID(),(SELECT (MAX(ID)) FROM SEQ_IACUC_PROTO_CORRESP_TEMPL),'4',NOW(),'admin',1)
/
INSERT INTO SEQ_IACUC_PROTO_CORRESP_TEMPL VALUES(NULL)
/
INSERT INTO IACUC_PROTO_CORRESP_TEMPL (COMMITTEE_ID,CORRESPONDENCE_TEMPLATE,FILE_NAME,OBJ_ID,PROTO_CORRESP_TEMPL_ID,PROTO_CORRESP_TYPE_CODE,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR)
  VALUES ('DEFAULT','<?xml version="1.0" encoding="UTF-8"?>
<!--Designed and generated by Altova StyleVision Enterprise Edition 2011 - see http://www.altova.com/stylevision for more information.-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:clitype="clitype" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:iso4217="http://www.xbrl.org/2003/iso4217" xmlns:ix="http://www.xbrl.org/2008/inlineXBRL" xmlns:java="java" xmlns:link="http://www.xbrl.org/2003/linkbase" xmlns:n1="http://xml.coeus.mit.edu/iacuc" xmlns:xbrldi="http://xbrl.org/2006/xbrldi" xmlns:xbrli="http://www.xbrl.org/2003/instance" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:altova="http://www.altova.com" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:svg="http://www.w3.org/2000/svg" exclude-result-prefixes="clitype fn iso4217 ix java link n1 xbrldi xbrli xlink xs xsi altova">
	<xsl:output version="1.0" method="xml" encoding="UTF-8" indent="no"/>
	<xsl:param name="SV_OutputFormat" select="\'PDF\'"/>
	<xsl:variable name="XML" select="/"/>
	<xsl:variable name="fo:layout-master-set">
		<fo:layout-master-set>
			<fo:simple-page-master master-name="page-master-179872648" margin-left="0.60in" margin-right="0.60in" page-height="11in" page-width="8.50in">
				<fo:region-body margin-top="0.79in" margin-bottom="0.79in" column-count="1" column-gap="0.50in"/>
			</fo:simple-page-master>
		</fo:layout-master-set>
	</xsl:variable>
	<xsl:variable name="altova:nPxPerIn" select="96"/>
	<xsl:template match="/">
		<fo:root>
			<xsl:copy-of select="$fo:layout-master-set"/>
			<fo:page-sequence force-page-count="no-force" master-reference="page-master-179872648" initial-page-number="auto" format="1">
				<fo:flow flow-name="xsl-region-body">
					<fo:block>
						<fo:inline-container>
							<fo:block>
								<xsl:text>&#x200B;</xsl:text>
							</fo:block>
						</fo:inline-container>
						<fo:table width="100%" table-layout="fixed" border-spacing="2pt">
							<fo:table-column column-width="90%"/>
							<fo:table-column column-width="10%"/>
							<xsl:variable name="altova:CurrContextGrid_0A769530" select="."/>
							<fo:table-body start-indent="0pt">
								<xsl:variable name="altova:tablerows">
									<fo:table-row>
										<fo:table-cell font-size="10pt" padding="0" display-align="center">
											<fo:block text-align="left">
												<fo:inline>
													<xsl:text>&#160;</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell font-size="10pt" padding="0" display-align="center">
											<fo:block text-align="right">
												<fo:inline>
													<xsl:text>&#160;</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell number-columns-spanned="2" padding="0" display-align="center">
											<fo:block text-align="left">
												<fo:block text-align="center">
													<fo:leader leader-pattern="rule" rule-thickness="2" leader-length="100%" color="black"/>
												</fo:block>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</xsl:variable>
								<xsl:choose>
									<xsl:when test="string($altova:tablerows)">
										<xsl:copy-of select="$altova:tablerows"/>
									</xsl:when>
									<xsl:otherwise>
										<fo:table-row>
											<fo:table-cell>
												<fo:block/>
											</fo:table-cell>
										</fo:table-row>
									</xsl:otherwise>
								</xsl:choose>
							</fo:table-body>
						</fo:table>
						<fo:block>
							<fo:leader leader-pattern="space"/>
						</fo:block>
						<xsl:for-each select="$XML">
							<xsl:for-each select="n1:Correspondence">
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x200B;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
									<fo:table-column column-width="1.590in"/>
									<fo:table-column column-width="0.430in"/>
									<fo:table-column column-width="4.930in"/>
									<xsl:variable name="altova:CurrContextGrid_0A7698F0" select="."/>
									<fo:table-body start-indent="0pt">
										<xsl:variable name="altova:tablerows">
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>To:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:Submissions">
																<xsl:for-each select="n1:CommitteeMember">
																	<xsl:for-each select="n1:Person">
																		<xsl:for-each select="n1:Fullname">
																			<xsl:variable name="value-of-template_0A834170">
																				<xsl:apply-templates/>
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when test="contains(string($value-of-template_0A834170),\'&#x200B;\')">
																					<fo:block>
																						<xsl:copy-of select="$value-of-template_0A834170"/>
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline>
																						<xsl:copy-of select="$value-of-template_0A834170"/>
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
														<fo:inline>
															<xsl:text>,</xsl:text>
														</fo:inline>
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:Submissions">
																<xsl:for-each select="n1:CommitteeMasterData">
																	<xsl:for-each select="n1:CommitteeName">
																		<xsl:variable name="value-of-template_0A8354B0">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template_0A8354B0),\'&#x200B;\')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template_0A8354B0"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template_0A8354B0"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row height="0.77in">
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>From:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:Organization">
																<xsl:for-each select="n1:OrgName">
																	<xsl:variable name="value-of-template_0A8353D0">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template_0A8353D0),\'&#x200B;\')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template_0A8353D0"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template_0A8353D0"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:Organization">
																<xsl:for-each select="n1:Address">
																	<xsl:variable name="value-of-template_0A8352F0">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template_0A8352F0),\'&#x200B;\')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template_0A8352F0"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template_0A8352F0"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Date:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:CurrentDate">
															<fo:inline>
																<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																<xsl:text> / </xsl:text>
																<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																<xsl:text> / </xsl:text>
																<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
															</fo:inline>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Committee Action:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Adverse Event Reporting</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Action Date:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:Submissions">
																<xsl:for-each select="n1:SubmissionDetails">
																	<xsl:for-each select="n1:ActionType">
																		<xsl:for-each select="n1:ActionDate">
																			<fo:inline>
																				<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																				<xsl:text> / </xsl:text>
																				<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																				<xsl:text> / </xsl:text>
																				<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
																			</fo:inline>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Protocol Number:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:ProtocolMasterData">
																<xsl:for-each select="n1:ProtocolNumber">
																	<xsl:variable name="value-of-template_0A835050">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template_0A835050),\'&#x200B;\')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template_0A835050"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template_0A835050"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Study Title:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:ProtocolMasterData">
																<xsl:for-each select="n1:ProtocolTitle">
																	<xsl:variable name="value-of-template_0A834F70">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template_0A834F70),\'&#x200B;\')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template_0A834F70"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template_0A834F70"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Expiration Date:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:ProtocolMasterData">
																<xsl:for-each select="n1:ExpirationDate">
																	<fo:inline>
																		<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																		<xsl:text> / </xsl:text>
																		<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																		<xsl:text> / </xsl:text>
																		<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
																	</fo:inline>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</xsl:variable>
										<xsl:choose>
											<xsl:when test="string($altova:tablerows)">
												<xsl:copy-of select="$altova:tablerows"/>
											</xsl:when>
											<xsl:otherwise>
												<fo:table-row>
													<fo:table-cell>
														<fo:block/>
													</fo:table-cell>
												</fo:table-row>
											</xsl:otherwise>
										</xsl:choose>
									</fo:table-body>
								</fo:table>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
							</xsl:for-each>
							<fo:block/>
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
							<fo:inline>
								<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; This is to inform you about an unexpected adverse event that had occurred in above mentioned protocol.</xsl:text>
							</fo:inline>
							<fo:block/>
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
							<fo:inline>
								<xsl:text>Thank you.</xsl:text>
							</fo:inline>
							<fo:block/>
						</xsl:for-each>
					</fo:block>
					<fo:block id="SV_RefID_PageTotal"/>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	<xsl:template name="double-backslash">
		<xsl:param name="text"/>
		<xsl:param name="text-length"/>
		<xsl:variable name="text-after-bs" select="substring-after($text, \'\\\')"/>
		<xsl:variable name="text-after-bs-length" select="string-length($text-after-bs)"/>
		<xsl:choose>
			<xsl:when test="$text-after-bs-length = 0">
				<xsl:choose>
					<xsl:when test="substring($text, $text-length) = \'\\\'">
						<xsl:value-of select="concat(substring($text,1,$text-length - 1), \'\\\\\')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$text"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="concat(substring($text,1,$text-length - $text-after-bs-length - 1), \'\\\\\')"/>
				<xsl:call-template name="double-backslash">
					<xsl:with-param name="text" select="$text-after-bs"/>
					<xsl:with-param name="text-length" select="$text-after-bs-length"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="altova:MakeValueAbsoluteIfPixels">
		<xsl:param name="sValue"/>
		<xsl:variable name="sBeforePx" select="substring-before($sValue, \'px\')"/>
		<xsl:choose>
			<xsl:when test="$sBeforePx">
				<xsl:variable name="nLengthOfInteger">
					<xsl:call-template name="altova:GetCharCountOfIntegerAtEndOfString">
						<xsl:with-param name="sText" select="$sBeforePx"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:variable name="nPosOfInteger" select="string-length($sBeforePx) - $nLengthOfInteger + 1"/>
				<xsl:variable name="nValuePx" select="substring($sBeforePx, $nPosOfInteger)"/>
				<xsl:variable name="nValueIn" select="number($nValuePx) div number($altova:nPxPerIn)"/>
				<xsl:variable name="nLengthBeforeInteger" select="string-length($sBeforePx) - $nLengthOfInteger"/>
				<xsl:variable name="sRest">
					<xsl:call-template name="altova:MakeValueAbsoluteIfPixels">
						<xsl:with-param name="sValue" select="substring-after($sValue, \'px\')"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="concat(substring($sBeforePx, 1, $nLengthBeforeInteger), string($nValueIn), \'in\', $sRest)"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$sValue"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="altova:GetCharCountOfIntegerAtEndOfString">
		<xsl:param name="sText"/>
		<xsl:variable name="sLen" select="string-length($sText)"/>
		<xsl:variable name="cLast" select="substring($sText, $sLen)"/>
		<xsl:choose>
			<xsl:when test="number($cLast) &gt;= 0 and number($cLast) &lt;= 9">
				<xsl:variable name="nResultOfRest">
					<xsl:call-template name="altova:GetCharCountOfIntegerAtEndOfString">
						<xsl:with-param name="sText" select="substring($sText, 1, $sLen - 1)"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="$nResultOfRest + 1"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text>0</xsl:text>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
','AdverseEventReportingLetter.xslt',UUID(),(SELECT (MAX(ID)) FROM SEQ_IACUC_PROTO_CORRESP_TEMPL),'5',NOW(),'admin',1)
/
INSERT INTO SEQ_IACUC_PROTO_CORRESP_TEMPL VALUES(NULL)
/
INSERT INTO IACUC_PROTO_CORRESP_TEMPL (COMMITTEE_ID,CORRESPONDENCE_TEMPLATE,FILE_NAME,OBJ_ID,PROTO_CORRESP_TEMPL_ID,PROTO_CORRESP_TYPE_CODE,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR)
  VALUES ('DEFAULT','<?xml version="1.0" encoding="UTF-8"?>
<!--Designed and generated by Altova StyleVision Enterprise Edition 2011 - see http://www.altova.com/stylevision for more information.-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:clitype="clitype" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:iso4217="http://www.xbrl.org/2003/iso4217" xmlns:ix="http://www.xbrl.org/2008/inlineXBRL" xmlns:java="java" xmlns:link="http://www.xbrl.org/2003/linkbase" xmlns:n1="http://xml.coeus.mit.edu/iacuc" xmlns:xbrldi="http://xbrl.org/2006/xbrldi" xmlns:xbrli="http://www.xbrl.org/2003/instance" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:altova="http://www.altova.com" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:svg="http://www.w3.org/2000/svg" exclude-result-prefixes="clitype fn iso4217 ix java link n1 xbrldi xbrli xlink xs xsi altova">
	<xsl:output version="1.0" method="xml" encoding="UTF-8" indent="no"/>
	<xsl:param name="SV_OutputFormat" select="\'PDF\'"/>
	<xsl:variable name="XML" select="/"/>
	<xsl:variable name="fo:layout-master-set">
		<fo:layout-master-set>
			<fo:simple-page-master master-name="page-master-127072720-even" margin-left="0.60in" margin-right="0.60in" page-height="11in" page-width="8.50in">
				<fo:region-body margin-top="1.25in" margin-bottom="0.79in" column-count="1" column-gap="0.50in"/>
				<fo:region-before region-name="even-page-header" overflow="hidden" extent="0.85in"/>
			</fo:simple-page-master>
			<fo:simple-page-master master-name="page-master-127072720-odd" margin-left="0.60in" margin-right="0.60in" page-height="11in" page-width="8.50in">
				<fo:region-body margin-top="1.25in" margin-bottom="0.79in" column-count="1" column-gap="0.50in"/>
				<fo:region-before region-name="odd-page-header" overflow="hidden" extent="0.85in"/>
			</fo:simple-page-master>
			<fo:page-sequence-master master-name="page-master-127072720">
				<fo:repeatable-page-master-alternatives>
					<fo:conditional-page-master-reference master-reference="page-master-127072720-even" odd-or-even="even"/>
					<fo:conditional-page-master-reference master-reference="page-master-127072720-odd" odd-or-even="odd"/>
				</fo:repeatable-page-master-alternatives>
			</fo:page-sequence-master>
		</fo:layout-master-set>
	</xsl:variable>
	<xsl:variable name="altova:nPxPerIn" select="96"/>
	<xsl:template match="/">
		<fo:root>
			<xsl:copy-of select="$fo:layout-master-set"/>
			<fo:page-sequence force-page-count="no-force" master-reference="page-master-127072720" initial-page-number="auto" format="1">
				<fo:static-content flow-name="odd-page-header">
					<fo:block-container margin-top="0.40in">
						<fo:block>
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x200B;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:table width="100%" table-layout="fixed" border-spacing="2pt">
								<fo:table-column column-width="90%"/>
								<fo:table-column column-width="10%"/>
								<xsl:variable name="altova:CurrContextGrid_0A1012A0" select="."/>
								<fo:table-body start-indent="0pt">
									<xsl:variable name="altova:tablerows">
										<fo:table-row>
											<fo:table-cell font-size="10pt" padding="0" display-align="center">
												<fo:block text-align="left">
													<fo:inline>
														<xsl:text>&#160;</xsl:text>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell font-size="10pt" padding="0" display-align="center">
												<fo:block text-align="right">
													<fo:inline>
														<xsl:text>&#160;</xsl:text>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
										<fo:table-row>
											<fo:table-cell number-columns-spanned="2" padding="0" display-align="center">
												<fo:block text-align="left">
													<fo:block text-align="center">
														<fo:leader leader-pattern="rule" rule-thickness="2" leader-length="100%" color="black"/>
													</fo:block>
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
									</xsl:variable>
									<xsl:choose>
										<xsl:when test="string($altova:tablerows)">
											<xsl:copy-of select="$altova:tablerows"/>
										</xsl:when>
										<xsl:otherwise>
											<fo:table-row>
												<fo:table-cell>
													<fo:block/>
												</fo:table-cell>
											</fo:table-row>
										</xsl:otherwise>
									</xsl:choose>
								</fo:table-body>
							</fo:table>
						</fo:block>
					</fo:block-container>
				</fo:static-content>
				<fo:static-content flow-name="even-page-header">
					<fo:block-container margin-top="0.40in">
						<fo:block>
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x200B;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:table width="100%" table-layout="fixed" border-spacing="2pt">
								<fo:table-column column-width="90%"/>
								<fo:table-column column-width="10%"/>
								<xsl:variable name="altova:CurrContextGrid_0A1012A0" select="."/>
								<fo:table-body start-indent="0pt">
									<xsl:variable name="altova:tablerows">
										<fo:table-row>
											<fo:table-cell font-size="10pt" padding="0" display-align="center">
												<fo:block text-align="left">
													<fo:inline>
														<xsl:text>&#160;</xsl:text>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell font-size="10pt" padding="0" display-align="center">
												<fo:block text-align="right">
													<fo:inline>
														<xsl:text>&#160;</xsl:text>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
										<fo:table-row>
											<fo:table-cell number-columns-spanned="2" padding="0" display-align="center">
												<fo:block text-align="left">
													<fo:block text-align="center">
														<fo:leader leader-pattern="rule" rule-thickness="2" leader-length="100%" color="black"/>
													</fo:block>
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
									</xsl:variable>
									<xsl:choose>
										<xsl:when test="string($altova:tablerows)">
											<xsl:copy-of select="$altova:tablerows"/>
										</xsl:when>
										<xsl:otherwise>
											<fo:table-row>
												<fo:table-cell>
													<fo:block/>
												</fo:table-cell>
											</fo:table-row>
										</xsl:otherwise>
									</xsl:choose>
								</fo:table-body>
							</fo:table>
						</fo:block>
					</fo:block-container>
				</fo:static-content>
				<fo:flow flow-name="xsl-region-body">
					<fo:block>
						<xsl:for-each select="$XML">
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
							<xsl:for-each select="n1:Correspondence">
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x200B;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
									<fo:table-column column-width="1.590in"/>
									<fo:table-column column-width="0.430in"/>
									<fo:table-column column-width="6.430in"/>
									<xsl:variable name="altova:CurrContextGrid_0A101660" select="."/>
									<fo:table-body start-indent="0pt">
										<xsl:variable name="altova:tablerows">
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>To:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:Investigator">
																<xsl:for-each select="n1:Person">
																	<xsl:for-each select="n1:Fullname">
																		<xsl:variable name="value-of-template_0A0D4ED8">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template_0A0D4ED8),\'&#x200B;\')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template_0A0D4ED8"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template_0A0D4ED8"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row height="0.79in">
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>From:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:Submissions">
																<xsl:for-each select="n1:CommitteeMember">
																	<xsl:for-each select="n1:Person">
																		<xsl:for-each select="n1:Fullname">
																			<xsl:variable name="value-of-template_06BB3B18">
																				<xsl:apply-templates/>
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when test="contains(string($value-of-template_06BB3B18),\'&#x200B;\')">
																					<fo:block>
																						<xsl:copy-of select="$value-of-template_06BB3B18"/>
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline>
																						<xsl:copy-of select="$value-of-template_06BB3B18"/>
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
														<fo:inline>
															<xsl:text>, Chair</xsl:text>
														</fo:inline>
														<fo:block/>
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:Submissions">
																<xsl:for-each select="n1:CommitteeMasterData">
																	<xsl:for-each select="n1:CommitteeName">
																		<xsl:variable name="value-of-template_06BACD30">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template_06BACD30),\'&#x200B;\')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template_06BACD30"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template_06BACD30"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Date:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:CurrentDate">
															<fo:inline>
																<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																<xsl:text> / </xsl:text>
																<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																<xsl:text> / </xsl:text>
																<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
															</fo:inline>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row height="0.04in">
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Committee Action:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Amendment Approval</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row height="0.21in">
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Action Date:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:Submissions">
																<xsl:for-each select="n1:SubmissionDetails">
																	<xsl:for-each select="n1:ActionType">
																		<xsl:for-each select="n1:ActionDate">
																			<fo:inline>
																				<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																				<xsl:text> / </xsl:text>
																				<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																				<xsl:text> / </xsl:text>
																				<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
																			</fo:inline>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Protocol Number:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:ProtocolMasterData">
																<xsl:for-each select="n1:ProtocolNumber">
																	<xsl:variable name="value-of-template_0A113110">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template_0A113110),\'&#x200B;\')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template_0A113110"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template_0A113110"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Study Title:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:ProtocolMasterData">
																<xsl:for-each select="n1:ProtocolTitle">
																	<xsl:variable name="value-of-template_0A1131F0">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template_0A1131F0),\'&#x200B;\')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template_0A1131F0"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template_0A1131F0"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Expiration Date:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:ProtocolMasterData">
																<xsl:for-each select="n1:ExpirationDate">
																	<fo:inline>
																		<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																		<xsl:text> / </xsl:text>
																		<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																		<xsl:text> / </xsl:text>
																		<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
																	</fo:inline>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</xsl:variable>
										<xsl:choose>
											<xsl:when test="string($altova:tablerows)">
												<xsl:copy-of select="$altova:tablerows"/>
											</xsl:when>
											<xsl:otherwise>
												<fo:table-row>
													<fo:table-cell>
														<fo:block/>
													</fo:table-cell>
												</fo:table-row>
											</xsl:otherwise>
										</xsl:choose>
									</fo:table-body>
								</fo:table>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x200B;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block margin="0pt">
									<fo:inline>
										<xsl:text>The above mentioned approval was reviewed and approved by the Institutional Animal Care and Use Committee (IACUC) on&#160; </xsl:text>
									</fo:inline>
									<xsl:for-each select="n1:Protocol">
										<xsl:for-each select="n1:Actions">
											<xsl:for-each select="n1:ActionDate">
												<fo:inline>
													<xsl:call-template name="DateToMonthName">
														<xsl:with-param name="sDate" select="string(string(.))"/>
														<xsl:with-param name="sFormat" select="\'short\'"/>
													</xsl:call-template>
													<xsl:text> </xsl:text>
													<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
													<xsl:text>, </xsl:text>
													<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
												</fo:inline>
											</xsl:for-each>
										</xsl:for-each>
									</xsl:for-each>
									<fo:inline>
										<xsl:text>.The proposal was approved as presented. The IACUC Office will no longer be mailing out copies of approves amendments since they are now available online.</xsl:text>
									</fo:inline>
								</fo:block>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x200B;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block margin="0pt">
									<fo:inline>
										<xsl:text>(This is an automated message; there is no need to respond unless you have a question or problem).</xsl:text>
									</fo:inline>
								</fo:block>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x200B;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block margin="0pt">
									<fo:inline>
										<xsl:text>Best Regards.</xsl:text>
									</fo:inline>
								</fo:block>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
							</xsl:for-each>
							<fo:block/>
						</xsl:for-each>
					</fo:block>
					<fo:block id="SV_RefID_PageTotal"/>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	<xsl:template name="DateToMonthName">
		<xsl:param name="sDate"/>
		<xsl:param name="sFormat"/>
		<xsl:choose>
			<xsl:when test="$sFormat = \'long\'">
				<xsl:call-template name="DateToMonthNameLong">
					<xsl:with-param name="sDate" select="$sDate"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="DateToMonthNameShort">
					<xsl:with-param name="sDate" select="$sDate"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="DateToMonthNameLong">
		<xsl:param name="sDate"/>
		<xsl:variable name="nMonth">
			<xsl:call-template name="DateToMonthNum">
				<xsl:with-param name="sDate" select="$sDate"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="$nMonth = 1">January</xsl:when>
			<xsl:when test="$nMonth = 2">February</xsl:when>
			<xsl:when test="$nMonth = 3">March</xsl:when>
			<xsl:when test="$nMonth = 4">April</xsl:when>
			<xsl:when test="$nMonth = 5">May</xsl:when>
			<xsl:when test="$nMonth = 6">June</xsl:when>
			<xsl:when test="$nMonth = 7">July</xsl:when>
			<xsl:when test="$nMonth = 8">August</xsl:when>
			<xsl:when test="$nMonth = 9">September</xsl:when>
			<xsl:when test="$nMonth = 10">October</xsl:when>
			<xsl:when test="$nMonth = 11">November</xsl:when>
			<xsl:otherwise>December</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="DateToMonthNum">
		<xsl:param name="sDate"/>
		<xsl:choose>
			<xsl:when test="starts-with($sDate, \'--\')">
				<xsl:value-of select="number(substring($sDate, 3, 2))"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="number(substring($sDate, 6, 2))"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="DateToMonthNameShort">
		<xsl:param name="sDate"/>
		<xsl:variable name="nMonth">
			<xsl:call-template name="DateToMonthNum">
				<xsl:with-param name="sDate" select="$sDate"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="$nMonth = 1">Jan</xsl:when>
			<xsl:when test="$nMonth = 2">Feb</xsl:when>
			<xsl:when test="$nMonth = 3">Mar</xsl:when>
			<xsl:when test="$nMonth = 4">Apr</xsl:when>
			<xsl:when test="$nMonth = 5">May</xsl:when>
			<xsl:when test="$nMonth = 6">Jun</xsl:when>
			<xsl:when test="$nMonth = 7">Jul</xsl:when>
			<xsl:when test="$nMonth = 8">Aug</xsl:when>
			<xsl:when test="$nMonth = 9">Sep</xsl:when>
			<xsl:when test="$nMonth = 10">Oct</xsl:when>
			<xsl:when test="$nMonth = 11">Nov</xsl:when>
			<xsl:otherwise>Dec</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="double-backslash">
		<xsl:param name="text"/>
		<xsl:param name="text-length"/>
		<xsl:variable name="text-after-bs" select="substring-after($text, \'\\\')"/>
		<xsl:variable name="text-after-bs-length" select="string-length($text-after-bs)"/>
		<xsl:choose>
			<xsl:when test="$text-after-bs-length = 0">
				<xsl:choose>
					<xsl:when test="substring($text, $text-length) = \'\\\'">
						<xsl:value-of select="concat(substring($text,1,$text-length - 1), \'\\\\\')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$text"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="concat(substring($text,1,$text-length - $text-after-bs-length - 1), \'\\\\\')"/>
				<xsl:call-template name="double-backslash">
					<xsl:with-param name="text" select="$text-after-bs"/>
					<xsl:with-param name="text-length" select="$text-after-bs-length"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="altova:MakeValueAbsoluteIfPixels">
		<xsl:param name="sValue"/>
		<xsl:variable name="sBeforePx" select="substring-before($sValue, \'px\')"/>
		<xsl:choose>
			<xsl:when test="$sBeforePx">
				<xsl:variable name="nLengthOfInteger">
					<xsl:call-template name="altova:GetCharCountOfIntegerAtEndOfString">
						<xsl:with-param name="sText" select="$sBeforePx"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:variable name="nPosOfInteger" select="string-length($sBeforePx) - $nLengthOfInteger + 1"/>
				<xsl:variable name="nValuePx" select="substring($sBeforePx, $nPosOfInteger)"/>
				<xsl:variable name="nValueIn" select="number($nValuePx) div number($altova:nPxPerIn)"/>
				<xsl:variable name="nLengthBeforeInteger" select="string-length($sBeforePx) - $nLengthOfInteger"/>
				<xsl:variable name="sRest">
					<xsl:call-template name="altova:MakeValueAbsoluteIfPixels">
						<xsl:with-param name="sValue" select="substring-after($sValue, \'px\')"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="concat(substring($sBeforePx, 1, $nLengthBeforeInteger), string($nValueIn), \'in\', $sRest)"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$sValue"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="altova:GetCharCountOfIntegerAtEndOfString">
		<xsl:param name="sText"/>
		<xsl:variable name="sLen" select="string-length($sText)"/>
		<xsl:variable name="cLast" select="substring($sText, $sLen)"/>
		<xsl:choose>
			<xsl:when test="number($cLast) &gt;= 0 and number($cLast) &lt;= 9">
				<xsl:variable name="nResultOfRest">
					<xsl:call-template name="altova:GetCharCountOfIntegerAtEndOfString">
						<xsl:with-param name="sText" select="substring($sText, 1, $sLen - 1)"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="$nResultOfRest + 1"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text>0</xsl:text>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
','AmendmentApprovalLetter.xslt',UUID(),(SELECT (MAX(ID)) FROM SEQ_IACUC_PROTO_CORRESP_TEMPL),'6',NOW(),'admin',1)
/
INSERT INTO SEQ_IACUC_PROTO_CORRESP_TEMPL VALUES(NULL)
/
INSERT INTO IACUC_PROTO_CORRESP_TEMPL (COMMITTEE_ID,CORRESPONDENCE_TEMPLATE,FILE_NAME,OBJ_ID,PROTO_CORRESP_TEMPL_ID,PROTO_CORRESP_TYPE_CODE,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR)
  VALUES ('DEFAULT','<?xml version="1.0" encoding="UTF-8"?>
<!--Designed and generated by Altova StyleVision Enterprise Edition 2008 rel. 2 - see http://www.altova.com/stylevision for more information.-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:n1="http://xml.coeus.mit.edu/iacuc" xmlns:xdt="http://www.w3.org/2005/xpath-datatypes" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output version="1.0" method="xml" encoding="UTF-8" indent="no"/>
	<xsl:param name="SV_OutputFormat" select="\'PDF\'"/>
	<xsl:variable name="XML" select="/"/>
	<xsl:variable name="fo:layout-master-set">
		<fo:layout-master-set>
			<fo:simple-page-master master-name="default-page" page-height="11in" page-width="8.5in" margin-left="0.6in" margin-right="0.6in">
				<fo:region-body margin-top="0.79in" margin-bottom="0.79in"/>
				<fo:region-before extent="0.79in"/>
			</fo:simple-page-master>
		</fo:layout-master-set>
	</xsl:variable>
	<xsl:template match="/">
		<fo:root>
			<xsl:copy-of select="$fo:layout-master-set"/>
			<fo:page-sequence master-reference="default-page" initial-page-number="1" format="1">
				<xsl:call-template name="headerall"/>
				<fo:flow flow-name="xsl-region-body">
					<fo:block>
						<xsl:for-each select="$XML">
							<fo:external-graphic>
								<xsl:attribute name="src">
									<xsl:text>url(</xsl:text>
									<xsl:call-template name="double-backslash">
										<xsl:with-param name="text">
											<xsl:value-of select="string(&apos;/export/home/www/https/tomcat5.0.25/webapps/coeus/images/couhes_byline2.gif&apos;)"/>
										</xsl:with-param>
										<xsl:with-param name="text-length">
											<xsl:value-of select="string-length(string(&apos;/export/home/www/https/tomcat5.0.25/webapps/coeus/images/couhes_byline2.gif&apos;))"/>
										</xsl:with-param>
									</xsl:call-template>
									<xsl:text>)</xsl:text>
								</xsl:attribute>
							</fo:external-graphic>
							<fo:block text-align="center">
								<fo:leader leader-pattern="rule" rule-thickness="1" leader-length="100%" color="black"/>
							</fo:block>
							<fo:block/>
							<xsl:for-each select="n1:Correspondence">
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block margin="0pt">
									<fo:block>
										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x2029;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
											<fo:table-column column-width="20%"/>
											<fo:table-column column-width="80%"/>
											<fo:table-body start-indent="0pt">
												<fo:table-row>
													<fo:table-cell font-family="Arial" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>To:</xsl:text>
															</fo:inline>
															<fo:inline font-size="10pt">
																<xsl:text>&#160;&#160;&#160;&#160; </xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" padding="2pt" display-align="center">
														<fo:block>
															<xsl:for-each select="n1:Protocol">
																<xsl:for-each select="n1:Investigator">
																	<xsl:if test="n1:PI_flag = &apos;true&apos;">
																		<xsl:for-each select="n1:Person">
																			<xsl:for-each select="n1:Firstname">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																						<fo:block font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:for-each>
																			<fo:inline font-size="10pt">
																				<xsl:text>&#160;</xsl:text>
																			</fo:inline>
																			<xsl:for-each select="n1:LastName">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																						<fo:block font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:for-each>
																			<fo:inline-container>
																				<fo:block>
																					<xsl:text>&#x2029;</xsl:text>
																				</fo:block>
																			</fo:inline-container>
																			<fo:block white-space="pre" white-space-collapse="false" margin="0pt">
																				<fo:block>
																					<xsl:for-each select="n1:OfficeLocation">
																						<xsl:variable name="value-of-template">
																							<xsl:apply-templates/>
																						</xsl:variable>
																						<xsl:choose>
																							<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																								<fo:block font-family="Book Antiqua" font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:block>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline font-family="Book Antiqua" font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:for-each>
																				</fo:block>
																			</fo:block>
																		</xsl:for-each>
																	</xsl:if>
																</xsl:for-each>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell font-family="Arial" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>From:</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" padding="2pt" display-align="center">
														<fo:block>
															<xsl:for-each select="n1:Protocol">
																<xsl:for-each select="n1:Submissions">
																	<xsl:for-each select="n1:CommitteeMember">
																		<xsl:if test="n1:CommitteeMemberRole/n1:MemberRoleDesc = &apos;Chair&apos;">
																			<xsl:for-each select="n1:Person">
																				<xsl:for-each select="n1:Firstname">
																					<xsl:if test="../../../n1:CurrentSubmissionFlag =&apos;No&apos;">
																						<xsl:variable name="value-of-template">
																							<xsl:apply-templates/>
																						</xsl:variable>
																						<xsl:choose>
																							<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																								<fo:block font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:block>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:if>
																				</xsl:for-each>
																				<fo:inline font-size="10pt">
																					<xsl:text>&#160;</xsl:text>
																				</fo:inline>
																				<xsl:for-each select="n1:LastName">
																					<xsl:if test="../../../n1:CurrentSubmissionFlag =&apos;No&apos;">
																						<xsl:variable name="value-of-template">
																							<xsl:apply-templates/>
																						</xsl:variable>
																						<xsl:choose>
																							<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																								<fo:block font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:block>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:if>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:if>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
															<fo:inline font-size="10pt">
																<xsl:text>, Chair </xsl:text>
															</fo:inline>
															<fo:inline-container>
																<fo:block>
																	<xsl:text>&#x2029;</xsl:text>
																</fo:block>
															</fo:inline-container>
															<fo:block white-space="pre" white-space-collapse="false" margin="0pt">
																<fo:block>
																	<xsl:for-each select="n1:Protocol">
																		<xsl:for-each select="n1:Submissions">
																			<xsl:for-each select="n1:CommitteeMasterData">
																				<xsl:for-each select="n1:CommitteeName">
																					<xsl:if test="../../n1:CurrentSubmissionFlag =&apos;No&apos;">
																						<xsl:variable name="value-of-template">
																							<xsl:apply-templates/>
																						</xsl:variable>
																						<xsl:choose>
																							<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																								<fo:block font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:block>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline font-size="10pt">
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:if>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:block>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell font-family="Arial" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>Date:</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" padding="2pt" display-align="center">
														<fo:block>
															<xsl:for-each select="n1:CurrentDate">
																<fo:inline font-size="10pt">
																	<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																	<xsl:text>/</xsl:text>
																	<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																	<xsl:text>/</xsl:text>
																	<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
																</fo:inline>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell font-family="Arial" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>Committee Action:</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" padding="2pt" display-align="center">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>Approval Withheld Pending Clarification</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x2029;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
											<fo:table-column column-width="20%"/>
											<fo:table-column column-width="80%"/>
											<fo:table-body start-indent="0pt">
												<fo:table-row>
													<fo:table-cell font-family="Arial" padding="2pt" display-align="before">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>IACUC Action Date: </xsl:text>
															</fo:inline>
															<fo:inline font-size="10pt">
																<xsl:text>&#160;&#160;&#160;&#160; </xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" padding="2pt" display-align="before">
														<fo:block>
															<xsl:for-each select="n1:Protocol">
																<xsl:for-each select="n1:Submissions">
																	<xsl:for-each select="n1:SubmissionDetails">
																		<xsl:for-each select="n1:ActionType">
																			<xsl:for-each select="n1:ActionDate">
																				<xsl:if test="../../../n1:CurrentSubmissionFlag =&apos;Yes&apos;">
																					<fo:inline font-size="10pt">
																						<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																						<xsl:text>/</xsl:text>
																						<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																						<xsl:text>/</xsl:text>
																						<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
																					</fo:inline>
																				</xsl:if>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell font-family="Arial" padding="2pt" display-align="center">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>IACUC Protocol #:</xsl:text>
															</fo:inline>
															<fo:inline font-size="10pt">
																<xsl:text>&#160;</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" padding="2pt" display-align="before">
														<fo:block>
															<xsl:for-each select="n1:Protocol">
																<xsl:for-each select="n1:ProtocolMasterData">
																	<xsl:for-each select="n1:ProtocolNumber">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																				<fo:block font-size="10pt">
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline font-size="10pt">
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell font-family="Arial" padding="2pt" display-align="center">
														<fo:block>
															<fo:inline font-size="10pt" font-weight="bold">
																<xsl:text>Study Title: </xsl:text>
															</fo:inline>
															<fo:inline font-size="10pt">
																<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell font-family="Arial" padding="2pt" display-align="before">
														<fo:block>
															<xsl:for-each select="n1:Protocol">
																<xsl:for-each select="n1:ProtocolMasterData">
																	<xsl:for-each select="n1:ProtocolTitle">
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																				<fo:block font-size="10pt">
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline font-size="10pt">
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
									</fo:block>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block font-family="Arial" font-size="10pt" margin="0pt">
									<fo:block>
										<fo:inline font-size="10pt">
											<xsl:text>At its meeting on&#160; </xsl:text>
										</fo:inline>
										<xsl:for-each select="n1:Protocol">
											<xsl:for-each select="n1:Submissions">
												<xsl:for-each select="n1:ScheduleMasterData">
													<xsl:for-each select="n1:MeetingDate">
														<xsl:if test="../../n1:CurrentSubmissionFlag =&apos;Yes&apos;">
															<fo:inline font-size="10pt">
																<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																<xsl:text>/</xsl:text>
																<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																<xsl:text>/</xsl:text>
																<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
															</fo:inline>
														</xsl:if>
													</xsl:for-each>
												</xsl:for-each>
											</xsl:for-each>
										</xsl:for-each>
										<fo:inline font-size="10pt">
											<xsl:text>, the Committee reviewed the above mentioned protocol and decided to withheld the approval. </xsl:text>
										</fo:inline>
									</fo:block>
								</fo:block>
								<fo:block/>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
									<fo:table-column column-width="27"/>
									<fo:table-column column-width="452"/>
									<fo:table-body start-indent="0pt">
										<fo:table-row>
											<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="center">
												<fo:block>
													<fo:inline font-family="Arial" font-size="10pt">
														<xsl:text>cc:</xsl:text>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="before">
												<fo:block>
													<fo:inline font-family="Arial" font-size="10pt">
														<xsl:text>Tom Duff</xsl:text>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
										<fo:table-row>
											<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="center">
												<fo:block/>
											</fo:table-cell>
											<fo:table-cell font-family="Arial" font-size="10pt" padding="2pt" display-align="before">
												<fo:block>
													<xsl:for-each select="n1:Protocol">
														<xsl:for-each select="n1:Correspondent">
															<xsl:for-each select="n1:Person">
																<xsl:for-each select="n1:Fullname">
																	<xsl:if test="../../n1:TypeOfCorrespondent = &apos;CRC&apos;">
																		<fo:block>
																			<fo:leader leader-pattern="space"/>
																		</fo:block>
																		<fo:inline-container>
																			<fo:block>
																				<xsl:text>&#x2029;</xsl:text>
																			</fo:block>
																		</fo:inline-container>
																		<fo:block margin="0pt">
																			<fo:block>
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),\'&#x2029;\')">
																						<fo:block font-family="Arial" font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline font-family="Arial" font-size="10pt">
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</fo:block>
																		</fo:block>
																	</xsl:if>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
									</fo:table-body>
								</fo:table>
							</xsl:for-each>
						</xsl:for-each>
					</fo:block>
					<fo:block id="SV_RefID_PageTotal"/>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	<xsl:template name="headerall">
		<fo:static-content flow-name="xsl-region-before">
			<fo:block>
				<xsl:for-each select="$XML">
					<fo:inline-container>
						<fo:block>
							<xsl:text>&#x2029;</xsl:text>
						</fo:block>
					</fo:inline-container>
					<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
						<fo:table-column column-width="proportional-column-width(1)"/>
						<fo:table-column column-width="150"/>
						<fo:table-body start-indent="0pt">
							<fo:table-row>
								<fo:table-cell padding="0" number-columns-spanned="2" height="30" display-align="center">
									<fo:block/>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell font-size="smaller" padding="0" text-align="left" display-align="center">
									<fo:block/>
								</fo:table-cell>
								<fo:table-cell font-size="smaller" padding="0" text-align="right" display-align="center">
									<fo:block/>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell padding="0" number-columns-spanned="2" display-align="center">
									<fo:block/>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</xsl:for-each>
			</fo:block>
		</fo:static-content>
	</xsl:template>
	<xsl:template name="double-backslash">
		<xsl:param name="text"/>
		<xsl:param name="text-length"/>
		<xsl:variable name="text-after-bs" select="substring-after($text, \'\\\')"/>
		<xsl:variable name="text-after-bs-length" select="string-length($text-after-bs)"/>
		<xsl:choose>
			<xsl:when test="$text-after-bs-length = 0">
				<xsl:choose>
					<xsl:when test="substring($text, $text-length) = \'\\\'">
						<xsl:value-of select="concat(substring($text,1,$text-length - 1), \'\\\\\')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$text"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="concat(substring($text,1,$text-length - $text-after-bs-length - 1), \'\\\\\')"/>
				<xsl:call-template name="double-backslash">
					<xsl:with-param name="text" select="$text-after-bs"/>
					<xsl:with-param name="text-length" select="$text-after-bs-length"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
','ApprovalWithheldPendingClarificationLetter.xslt',UUID(),(SELECT (MAX(ID)) FROM SEQ_IACUC_PROTO_CORRESP_TEMPL),'8',NOW(),'admin',1)
/
INSERT INTO SEQ_IACUC_PROTO_CORRESP_TEMPL VALUES(NULL)
/
INSERT INTO IACUC_PROTO_CORRESP_TEMPL (COMMITTEE_ID,CORRESPONDENCE_TEMPLATE,FILE_NAME,OBJ_ID,PROTO_CORRESP_TEMPL_ID,PROTO_CORRESP_TYPE_CODE,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR)
  VALUES ('DEFAULT','<?xml version="1.0" encoding="UTF-8"?>
<!--Designed and generated by Altova StyleVision Enterprise Edition 2011 - see http://www.altova.com/stylevision for more information.-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:clitype="clitype" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:iso4217="http://www.xbrl.org/2003/iso4217" xmlns:ix="http://www.xbrl.org/2008/inlineXBRL" xmlns:java="java" xmlns:link="http://www.xbrl.org/2003/linkbase" xmlns:n1="http://xml.coeus.mit.edu/iacuc" xmlns:xbrldi="http://xbrl.org/2006/xbrldi" xmlns:xbrli="http://www.xbrl.org/2003/instance" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:altova="http://www.altova.com" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:svg="http://www.w3.org/2000/svg" exclude-result-prefixes="clitype fn iso4217 ix java link n1 xbrldi xbrli xlink xs xsi altova">
	<xsl:output version="1.0" method="xml" encoding="UTF-8" indent="no"/>
	<xsl:param name="SV_OutputFormat" select="\'PDF\'"/>
	<xsl:variable name="XML" select="/"/>
	<xsl:variable name="fo:layout-master-set">
		<fo:layout-master-set>
			<fo:simple-page-master master-name="page-master-162094656" margin-left="0.60in" margin-right="0.60in" page-height="11in" page-width="8.50in">
				<fo:region-body margin-top="0.79in" margin-bottom="0.79in" column-count="1" column-gap="0.50in"/>
			</fo:simple-page-master>
		</fo:layout-master-set>
	</xsl:variable>
	<xsl:variable name="altova:nPxPerIn" select="96"/>
	<xsl:template match="/">
		<fo:root>
			<xsl:copy-of select="$fo:layout-master-set"/>
			<fo:page-sequence force-page-count="no-force" master-reference="page-master-162094656" initial-page-number="auto" format="1">
				<fo:flow flow-name="xsl-region-body">
					<fo:block>
						<fo:inline-container>
							<fo:block>
								<xsl:text>&#x200B;</xsl:text>
							</fo:block>
						</fo:inline-container>
						<fo:table width="100%" table-layout="fixed" border-spacing="2pt">
							<fo:table-column column-width="90%"/>
							<fo:table-column column-width="10%"/>
							<xsl:variable name="altova:CurrContextGrid_09AB6F80" select="."/>
							<fo:table-body start-indent="0pt">
								<xsl:variable name="altova:tablerows">
									<fo:table-row>
										<fo:table-cell font-size="10pt" padding="0" display-align="center">
											<fo:block text-align="left">
												<fo:inline>
													<xsl:text>&#160;</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell font-size="10pt" padding="0" display-align="center">
											<fo:block text-align="right">
												<fo:inline>
													<xsl:text>&#160;</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell number-columns-spanned="2" padding="0" display-align="center">
											<fo:block text-align="left">
												<fo:block text-align="center">
													<fo:leader leader-pattern="rule" rule-thickness="2" leader-length="100%" color="black"/>
												</fo:block>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</xsl:variable>
								<xsl:choose>
									<xsl:when test="string($altova:tablerows)">
										<xsl:copy-of select="$altova:tablerows"/>
									</xsl:when>
									<xsl:otherwise>
										<fo:table-row>
											<fo:table-cell>
												<fo:block/>
											</fo:table-cell>
										</fo:table-row>
									</xsl:otherwise>
								</xsl:choose>
							</fo:table-body>
						</fo:table>
						<fo:block>
							<fo:leader leader-pattern="space"/>
						</fo:block>
						<xsl:for-each select="$XML">
							<xsl:for-each select="n1:Correspondence">
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x200B;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:table font-family="inherit" table-layout="fixed" width="100%" border-spacing="2pt">
									<fo:table-column column-width="1.590in"/>
									<fo:table-column column-width="0.430in"/>
									<fo:table-column column-width="6.430in"/>
									<xsl:variable name="altova:CurrContextGrid_09AB72E0" select="."/>
									<fo:table-body start-indent="0pt">
										<xsl:variable name="altova:tablerows">
											<fo:table-row>
												<fo:table-cell font-weight="bold" padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>To:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:Investigator">
																<xsl:for-each select="n1:Person">
																	<xsl:for-each select="n1:Fullname">
																		<xsl:variable name="value-of-template_0BA67C70">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template_0BA67C70),\'&#x200B;\')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template_0BA67C70"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template_0BA67C70"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell font-weight="bold" padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>From:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:Submissions">
																<xsl:for-each select="n1:CommitteeMember">
																	<xsl:for-each select="n1:Person">
																		<xsl:for-each select="n1:Fullname">
																			<xsl:variable name="value-of-template_0BA67D50">
																				<xsl:apply-templates/>
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when test="contains(string($value-of-template_0BA67D50),\'&#x200B;\')">
																					<fo:block font-size="medium">
																						<xsl:copy-of select="$value-of-template_0BA67D50"/>
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline font-size="medium">
																						<xsl:copy-of select="$value-of-template_0BA67D50"/>
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
														<fo:inline>
															<xsl:text>, Chair</xsl:text>
														</fo:inline>
														<fo:block/>
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:Submissions">
																<xsl:for-each select="n1:CommitteeMasterData">
																	<xsl:for-each select="n1:CommitteeName">
																		<xsl:variable name="value-of-template_0BA67E30">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template_0BA67E30),\'&#x200B;\')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template_0BA67E30"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template_0BA67E30"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell font-weight="bold" padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Date:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:CurrentDate">
															<fo:inline>
																<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																<xsl:text> / </xsl:text>
																<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																<xsl:text> / </xsl:text>
																<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
															</fo:inline>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell font-weight="bold" padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Committee Action:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Continuation Approval (Renewal) Letter,</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell font-weight="bold" padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Action Date:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:Submissions">
																<xsl:for-each select="n1:SubmissionDetails">
																	<xsl:for-each select="n1:ActionType">
																		<xsl:for-each select="n1:ActionDate">
																			<fo:inline>
																				<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																				<xsl:text> / </xsl:text>
																				<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																				<xsl:text> / </xsl:text>
																				<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
																			</fo:inline>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row height="0.38in">
												<fo:table-cell font-weight="bold" padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Protocol Number:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:ProtocolMasterData">
																<xsl:for-each select="n1:ProtocolNumber">
																	<xsl:variable name="value-of-template_0BA680D0">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template_0BA680D0),\'&#x200B;\')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template_0BA680D0"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template_0BA680D0"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row height="0.20in">
												<fo:table-cell font-weight="bold" padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Study Title:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:ProtocolMasterData">
																<xsl:for-each select="n1:ProtocolTitle">
																	<xsl:variable name="value-of-template_0BA681B0">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template_0BA681B0),\'&#x200B;\')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template_0BA681B0"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template_0BA681B0"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell font-weight="bold" padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Expiration Date:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:ProtocolMasterData">
																<xsl:for-each select="n1:ExpirationDate">
																	<fo:inline>
																		<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																		<xsl:text> / </xsl:text>
																		<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																		<xsl:text> / </xsl:text>
																		<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
																	</fo:inline>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</xsl:variable>
										<xsl:choose>
											<xsl:when test="string($altova:tablerows)">
												<xsl:copy-of select="$altova:tablerows"/>
											</xsl:when>
											<xsl:otherwise>
												<fo:table-row>
													<fo:table-cell>
														<fo:block/>
													</fo:table-cell>
												</fo:table-row>
											</xsl:otherwise>
										</xsl:choose>
									</fo:table-body>
								</fo:table>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x200B;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block margin="0pt">
									<fo:inline>
										<xsl:text>Above mentioned protocol has been approved by IACUC as of </xsl:text>
									</fo:inline>
									<xsl:for-each select="n1:Protocol">
										<xsl:for-each select="n1:Submissions">
											<xsl:for-each select="n1:ScheduleMasterData">
												<xsl:for-each select="n1:MeetingDate">
													<fo:inline>
														<xsl:call-template name="DateToMonthName">
															<xsl:with-param name="sDate" select="string(string(.))"/>
															<xsl:with-param name="sFormat" select="\'long\'"/>
														</xsl:call-template>
														<xsl:text> </xsl:text>
														<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
														<xsl:text>, </xsl:text>
														<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
													</fo:inline>
												</xsl:for-each>
											</xsl:for-each>
										</xsl:for-each>
									</xsl:for-each>
									<fo:inline>
										<xsl:text>.</xsl:text>
									</fo:inline>
								</fo:block>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x200B;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block margin="0pt">
									<fo:inline>
										<xsl:text>Best Regards.</xsl:text>
									</fo:inline>
								</fo:block>
							</xsl:for-each>
							<fo:block/>
						</xsl:for-each>
					</fo:block>
					<fo:block id="SV_RefID_PageTotal"/>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	<xsl:template name="DateToMonthName">
		<xsl:param name="sDate"/>
		<xsl:param name="sFormat"/>
		<xsl:choose>
			<xsl:when test="$sFormat = \'long\'">
				<xsl:call-template name="DateToMonthNameLong">
					<xsl:with-param name="sDate" select="$sDate"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="DateToMonthNameShort">
					<xsl:with-param name="sDate" select="$sDate"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="DateToMonthNameLong">
		<xsl:param name="sDate"/>
		<xsl:variable name="nMonth">
			<xsl:call-template name="DateToMonthNum">
				<xsl:with-param name="sDate" select="$sDate"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="$nMonth = 1">January</xsl:when>
			<xsl:when test="$nMonth = 2">February</xsl:when>
			<xsl:when test="$nMonth = 3">March</xsl:when>
			<xsl:when test="$nMonth = 4">April</xsl:when>
			<xsl:when test="$nMonth = 5">May</xsl:when>
			<xsl:when test="$nMonth = 6">June</xsl:when>
			<xsl:when test="$nMonth = 7">July</xsl:when>
			<xsl:when test="$nMonth = 8">August</xsl:when>
			<xsl:when test="$nMonth = 9">September</xsl:when>
			<xsl:when test="$nMonth = 10">October</xsl:when>
			<xsl:when test="$nMonth = 11">November</xsl:when>
			<xsl:otherwise>December</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="DateToMonthNum">
		<xsl:param name="sDate"/>
		<xsl:choose>
			<xsl:when test="starts-with($sDate, \'--\')">
				<xsl:value-of select="number(substring($sDate, 3, 2))"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="number(substring($sDate, 6, 2))"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="DateToMonthNameShort">
		<xsl:param name="sDate"/>
		<xsl:variable name="nMonth">
			<xsl:call-template name="DateToMonthNum">
				<xsl:with-param name="sDate" select="$sDate"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="$nMonth = 1">Jan</xsl:when>
			<xsl:when test="$nMonth = 2">Feb</xsl:when>
			<xsl:when test="$nMonth = 3">Mar</xsl:when>
			<xsl:when test="$nMonth = 4">Apr</xsl:when>
			<xsl:when test="$nMonth = 5">May</xsl:when>
			<xsl:when test="$nMonth = 6">Jun</xsl:when>
			<xsl:when test="$nMonth = 7">Jul</xsl:when>
			<xsl:when test="$nMonth = 8">Aug</xsl:when>
			<xsl:when test="$nMonth = 9">Sep</xsl:when>
			<xsl:when test="$nMonth = 10">Oct</xsl:when>
			<xsl:when test="$nMonth = 11">Nov</xsl:when>
			<xsl:otherwise>Dec</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="double-backslash">
		<xsl:param name="text"/>
		<xsl:param name="text-length"/>
		<xsl:variable name="text-after-bs" select="substring-after($text, \'\\\')"/>
		<xsl:variable name="text-after-bs-length" select="string-length($text-after-bs)"/>
		<xsl:choose>
			<xsl:when test="$text-after-bs-length = 0">
				<xsl:choose>
					<xsl:when test="substring($text, $text-length) = \'\\\'">
						<xsl:value-of select="concat(substring($text,1,$text-length - 1), \'\\\\\')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$text"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="concat(substring($text,1,$text-length - $text-after-bs-length - 1), \'\\\\\')"/>
				<xsl:call-template name="double-backslash">
					<xsl:with-param name="text" select="$text-after-bs"/>
					<xsl:with-param name="text-length" select="$text-after-bs-length"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="altova:MakeValueAbsoluteIfPixels">
		<xsl:param name="sValue"/>
		<xsl:variable name="sBeforePx" select="substring-before($sValue, \'px\')"/>
		<xsl:choose>
			<xsl:when test="$sBeforePx">
				<xsl:variable name="nLengthOfInteger">
					<xsl:call-template name="altova:GetCharCountOfIntegerAtEndOfString">
						<xsl:with-param name="sText" select="$sBeforePx"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:variable name="nPosOfInteger" select="string-length($sBeforePx) - $nLengthOfInteger + 1"/>
				<xsl:variable name="nValuePx" select="substring($sBeforePx, $nPosOfInteger)"/>
				<xsl:variable name="nValueIn" select="number($nValuePx) div number($altova:nPxPerIn)"/>
				<xsl:variable name="nLengthBeforeInteger" select="string-length($sBeforePx) - $nLengthOfInteger"/>
				<xsl:variable name="sRest">
					<xsl:call-template name="altova:MakeValueAbsoluteIfPixels">
						<xsl:with-param name="sValue" select="substring-after($sValue, \'px\')"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="concat(substring($sBeforePx, 1, $nLengthBeforeInteger), string($nValueIn), \'in\', $sRest)"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$sValue"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="altova:GetCharCountOfIntegerAtEndOfString">
		<xsl:param name="sText"/>
		<xsl:variable name="sLen" select="string-length($sText)"/>
		<xsl:variable name="cLast" select="substring($sText, $sLen)"/>
		<xsl:choose>
			<xsl:when test="number($cLast) &gt;= 0 and number($cLast) &lt;= 9">
				<xsl:variable name="nResultOfRest">
					<xsl:call-template name="altova:GetCharCountOfIntegerAtEndOfString">
						<xsl:with-param name="sText" select="substring($sText, 1, $sLen - 1)"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="$nResultOfRest + 1"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text>0</xsl:text>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
','ContinuationApprovalLetter.xslt',UUID(),(SELECT (MAX(ID)) FROM SEQ_IACUC_PROTO_CORRESP_TEMPL),'9',NOW(),'admin',1)
/
INSERT INTO SEQ_IACUC_PROTO_CORRESP_TEMPL VALUES(NULL)
/
INSERT INTO IACUC_PROTO_CORRESP_TEMPL (COMMITTEE_ID,CORRESPONDENCE_TEMPLATE,FILE_NAME,OBJ_ID,PROTO_CORRESP_TEMPL_ID,PROTO_CORRESP_TYPE_CODE,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR)
  VALUES ('DEFAULT','<?xml version="1.0" encoding="UTF-8"?>
<!--Designed and generated by Altova StyleVision Enterprise Edition 2011 - see http://www.altova.com/stylevision for more information.-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:clitype="clitype" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:iso4217="http://www.xbrl.org/2003/iso4217" xmlns:ix="http://www.xbrl.org/2008/inlineXBRL" xmlns:java="java" xmlns:link="http://www.xbrl.org/2003/linkbase" xmlns:n1="http://xml.coeus.mit.edu/iacuc" xmlns:xbrldi="http://xbrl.org/2006/xbrldi" xmlns:xbrli="http://www.xbrl.org/2003/instance" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:altova="http://www.altova.com" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:svg="http://www.w3.org/2000/svg" exclude-result-prefixes="clitype fn iso4217 ix java link n1 xbrldi xbrli xlink xs xsi altova">
	<xsl:output version="1.0" method="xml" encoding="UTF-8" indent="no"/>
	<xsl:param name="SV_OutputFormat" select="\'PDF\'"/>
	<xsl:variable name="XML" select="/"/>
	<xsl:variable name="fo:layout-master-set">
		<fo:layout-master-set>
			<fo:simple-page-master master-name="page-master-300868432" margin-left="0.60in" margin-right="0.60in" page-height="11in" page-width="8.50in">
				<fo:region-body margin-top="0.79in" margin-bottom="0.79in" column-count="1" column-gap="0.50in"/>
			</fo:simple-page-master>
		</fo:layout-master-set>
	</xsl:variable>
	<xsl:variable name="altova:nPxPerIn" select="96"/>
	<xsl:template match="/">
		<fo:root>
			<xsl:copy-of select="$fo:layout-master-set"/>
			<fo:page-sequence force-page-count="no-force" master-reference="page-master-300868432" initial-page-number="auto" format="1">
				<fo:flow flow-name="xsl-region-body">
					<fo:block>
						<fo:inline-container>
							<fo:block>
								<xsl:text>&#x200B;</xsl:text>
							</fo:block>
						</fo:inline-container>
						<fo:table width="100%" table-layout="fixed" border-spacing="2pt">
							<fo:table-column column-width="90%"/>
							<fo:table-column column-width="10%"/>
							<xsl:variable name="altova:CurrContextGrid_11EE6C48" select="."/>
							<fo:table-body start-indent="0pt">
								<xsl:variable name="altova:tablerows">
									<fo:table-row>
										<fo:table-cell font-size="10pt" padding="0" display-align="center">
											<fo:block text-align="left">
												<fo:inline>
													<xsl:text>&#160;</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell font-size="10pt" padding="0" display-align="center">
											<fo:block text-align="right">
												<fo:inline>
													<xsl:text>&#160;</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell number-columns-spanned="2" padding="0" display-align="center">
											<fo:block text-align="left">
												<fo:block text-align="center">
													<fo:leader leader-pattern="rule" rule-thickness="2" leader-length="100%" color="black"/>
												</fo:block>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</xsl:variable>
								<xsl:choose>
									<xsl:when test="string($altova:tablerows)">
										<xsl:copy-of select="$altova:tablerows"/>
									</xsl:when>
									<xsl:otherwise>
										<fo:table-row>
											<fo:table-cell>
												<fo:block/>
											</fo:table-cell>
										</fo:table-row>
									</xsl:otherwise>
								</xsl:choose>
							</fo:table-body>
						</fo:table>
						<xsl:for-each select="$XML">
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
							<xsl:for-each select="n1:Correspondence">
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x200B;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
									<fo:table-column column-width="1.590in"/>
									<fo:table-column column-width="0.430in"/>
									<fo:table-column column-width="6.430in"/>
									<xsl:variable name="altova:CurrContextGrid_11EE7908" select="."/>
									<fo:table-body start-indent="0pt">
										<xsl:variable name="altova:tablerows">
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>To:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:Submissions">
																<xsl:for-each select="n1:CommitteeMember">
																	<xsl:for-each select="n1:Person">
																		<xsl:for-each select="n1:Fullname">
																			<xsl:variable name="value-of-template_0A834090">
																				<xsl:apply-templates/>
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when test="contains(string($value-of-template_0A834090),\'&#x200B;\')">
																					<fo:block>
																						<xsl:copy-of select="$value-of-template_0A834090"/>
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline>
																						<xsl:copy-of select="$value-of-template_0A834090"/>
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
														<fo:inline>
															<xsl:text>, Chair</xsl:text>
														</fo:inline>
														<fo:block/>
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:Submissions">
																<xsl:for-each select="n1:CommitteeMasterData">
																	<xsl:for-each select="n1:CommitteeName">
																		<xsl:variable name="value-of-template_0A833ED0">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template_0A833ED0),\'&#x200B;\')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template_0A833ED0"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template_0A833ED0"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>From:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:Submissions">
																<xsl:for-each select="n1:CommitteeMember">
																	<xsl:for-each select="n1:Person">
																		<xsl:for-each select="n1:Fullname">
																			<xsl:variable name="value-of-template_0A833DF0">
																				<xsl:apply-templates/>
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when test="contains(string($value-of-template_0A833DF0),\'&#x200B;\')">
																					<fo:block>
																						<xsl:copy-of select="$value-of-template_0A833DF0"/>
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline>
																						<xsl:copy-of select="$value-of-template_0A833DF0"/>
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
														<fo:inline>
															<xsl:text>, Chair</xsl:text>
														</fo:inline>
														<fo:block/>
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:Submissions">
																<xsl:for-each select="n1:CommitteeMasterData">
																	<xsl:for-each select="n1:CommitteeName">
																		<xsl:variable name="value-of-template_0A833D10">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template_0A833D10),\'&#x200B;\')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template_0A833D10"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template_0A833D10"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Date:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:CurrentDate">
															<fo:inline>
																<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																<xsl:text> / </xsl:text>
																<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																<xsl:text> / </xsl:text>
																<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
															</fo:inline>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Protocol Number:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:ProtocolMasterData">
																<xsl:for-each select="n1:ProtocolNumber">
																	<xsl:variable name="value-of-template_0A833B50">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template_0A833B50),\'&#x200B;\')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template_0A833B50"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template_0A833B50"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Study Title:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:ProtocolMasterData">
																<xsl:for-each select="n1:ProtocolTitle">
																	<xsl:variable name="value-of-template_0A833A70">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template_0A833A70),\'&#x200B;\')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template_0A833A70"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template_0A833A70"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<fo:inline>
															<xsl:text>Expiration Date:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left"/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block text-align="left">
														<xsl:for-each select="n1:Protocol">
															<xsl:for-each select="n1:ProtocolMasterData">
																<xsl:for-each select="n1:ExpirationDate">
																	<fo:inline>
																		<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																		<xsl:text> / </xsl:text>
																		<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																		<xsl:text> / </xsl:text>
																		<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
																	</fo:inline>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</xsl:variable>
										<xsl:choose>
											<xsl:when test="string($altova:tablerows)">
												<xsl:copy-of select="$altova:tablerows"/>
											</xsl:when>
											<xsl:otherwise>
												<fo:table-row>
													<fo:table-cell>
														<fo:block/>
													</fo:table-cell>
												</fo:table-row>
											</xsl:otherwise>
										</xsl:choose>
									</fo:table-body>
								</fo:table>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
							</xsl:for-each>
							<fo:block/>
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
							<fo:inline>
								<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; This is to notify all committee members about an action that is committed by correspondent. The details of the performed action is shown below.</xsl:text>
							</fo:inline>
							<fo:block/>
							<xsl:for-each select="n1:Correspondence">
								<xsl:for-each select="n1:Protocol">
									<xsl:for-each select="n1:Submissions">
										<xsl:for-each select="n1:SubmissionDetails">
											<xsl:for-each select="n1:ActionType">
												<fo:block>
													<fo:leader leader-pattern="space"/>
												</fo:block>
												<fo:inline font-weight="bold" text-decoration="underline">
													<xsl:text>Action/Response Details</xsl:text>
												</fo:inline>
												<fo:block/>
												<fo:inline-container>
													<fo:block>
														<xsl:text>&#x200B;</xsl:text>
													</fo:block>
												</fo:inline-container>
												<fo:table table-layout="fixed" width="100%" border-spacing="0">
													<fo:table-column column-width="1.890in"/>
													<fo:table-column column-width="0.340in"/>
													<fo:table-column column-width="proportional-column-width(1)"/>
													<xsl:variable name="altova:CurrContextGrid_0ABE31B0" select="."/>
													<fo:table-body start-indent="0pt">
														<xsl:variable name="altova:tablerows">
															<fo:table-row>
																<fo:table-cell padding="0" display-align="center">
																	<fo:block text-align="left">
																		<fo:inline>
																			<xsl:text>Action Id</xsl:text>
																		</fo:inline>
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell padding="0" display-align="center">
																	<fo:block text-align="left">
																		<fo:inline>
																			<xsl:text>:</xsl:text>
																		</fo:inline>
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell padding="0" display-align="center">
																	<fo:block text-align="left">
																		<xsl:for-each select="n1:ActionId">
																			<xsl:variable name="value-of-template_0A8338B0">
																				<xsl:apply-templates/>
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when test="contains(string($value-of-template_0A8338B0),\'&#x200B;\')">
																					<fo:block>
																						<xsl:copy-of select="$value-of-template_0A8338B0"/>
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline>
																						<xsl:copy-of select="$value-of-template_0A8338B0"/>
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:for-each>
																	</fo:block>
																</fo:table-cell>
															</fo:table-row>
															<fo:table-row>
																<fo:table-cell padding="0" display-align="center">
																	<fo:block text-align="left">
																		<fo:inline>
																			<xsl:text>Action Type</xsl:text>
																		</fo:inline>
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell padding="0" display-align="center">
																	<fo:block text-align="left">
																		<fo:inline>
																			<xsl:text>:</xsl:text>
																		</fo:inline>
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell padding="0" display-align="center">
																	<fo:block text-align="left">
																		<xsl:for-each select="n1:ActionTypeCode">
																			<xsl:variable name="value-of-template_0A834410">
																				<xsl:apply-templates/>
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when test="contains(string($value-of-template_0A834410),\'&#x200B;\')">
																					<fo:block>
																						<xsl:copy-of select="$value-of-template_0A834410"/>
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline>
																						<xsl:copy-of select="$value-of-template_0A834410"/>
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:for-each>
																	</fo:block>
																</fo:table-cell>
															</fo:table-row>
															<fo:table-row height="0.17in">
																<fo:table-cell padding="0" display-align="center">
																	<fo:block text-align="left">
																		<fo:inline>
																			<xsl:text>Action Descriptions</xsl:text>
																		</fo:inline>
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell padding="0" display-align="center">
																	<fo:block text-align="left">
																		<fo:inline>
																			<xsl:text>:</xsl:text>
																		</fo:inline>
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell padding="0" display-align="center">
																	<fo:block text-align="left">
																		<xsl:for-each select="n1:ActionTypeDescription">
																			<xsl:variable name="value-of-template_0A8344F0">
																				<xsl:apply-templates/>
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when test="contains(string($value-of-template_0A8344F0),\'&#x200B;\')">
																					<fo:block>
																						<xsl:copy-of select="$value-of-template_0A8344F0"/>
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline>
																						<xsl:copy-of select="$value-of-template_0A8344F0"/>
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:for-each>
																	</fo:block>
																</fo:table-cell>
															</fo:table-row>
															<fo:table-row>
																<fo:table-cell padding="0" display-align="center">
																	<fo:block text-align="left">
																		<fo:inline>
																			<xsl:text>Action Date</xsl:text>
																		</fo:inline>
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell padding="0" display-align="center">
																	<fo:block text-align="left">
																		<fo:inline>
																			<xsl:text>:</xsl:text>
																		</fo:inline>
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell padding="0" display-align="center">
																	<fo:block text-align="left">
																		<xsl:for-each select="n1:ActionDate">
																			<fo:inline>
																				<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), \'00\')"/>
																				<xsl:text> / </xsl:text>
																				<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), \'00\')"/>
																				<xsl:text> / </xsl:text>
																				<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), \'0000\')"/>
																			</fo:inline>
																		</xsl:for-each>
																	</fo:block>
																</fo:table-cell>
															</fo:table-row>
															<fo:table-row>
																<fo:table-cell padding="0" display-align="center">
																	<fo:block text-align="left">
																		<fo:inline>
																			<xsl:text>Action Comments</xsl:text>
																		</fo:inline>
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell padding="0" display-align="center">
																	<fo:block text-align="left">
																		<fo:inline>
																			<xsl:text>:</xsl:text>
																		</fo:inline>
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell padding="0" display-align="center">
																	<fo:block text-align="left">
																		<xsl:for-each select="n1:ActionComments">
																			<xsl:variable name="value-of-template_0A834790">
																				<xsl:apply-templates/>
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when test="contains(string($value-of-template_0A834790),\'&#x200B;\')">
																					<fo:block>
																						<xsl:copy-of select="$value-of-template_0A834790"/>
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline>
																						<xsl:copy-of select="$value-of-template_0A834790"/>
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:for-each>
																	</fo:block>
																</fo:table-cell>
															</fo:table-row>
														</xsl:variable>
														<xsl:choose>
															<xsl:when test="string($altova:tablerows)">
																<xsl:copy-of select="$altova:tablerows"/>
															</xsl:when>
															<xsl:otherwise>
																<fo:table-row>
																	<fo:table-cell>
																		<fo:block/>
																	</fo:table-cell>
																</fo:table-row>
															</xsl:otherwise>
														</xsl:choose>
													</fo:table-body>
												</fo:table>
												<fo:block>
													<fo:leader leader-pattern="space"/>
												</fo:block>
											</xsl:for-each>
										</xsl:for-each>
									</xsl:for-each>
								</xsl:for-each>
							</xsl:for-each>
							<fo:block/>
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
							<fo:inline>
								<xsl:text>Best Regards.</xsl:text>
							</fo:inline>
							<fo:block/>
						</xsl:for-each>
					</fo:block>
					<fo:block id="SV_RefID_PageTotal"/>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	<xsl:template name="double-backslash">
		<xsl:param name="text"/>
		<xsl:param name="text-length"/>
		<xsl:variable name="text-after-bs" select="substring-after($text, \'\\\')"/>
		<xsl:variable name="text-after-bs-length" select="string-length($text-after-bs)"/>
		<xsl:choose>
			<xsl:when test="$text-after-bs-length = 0">
				<xsl:choose>
					<xsl:when test="substring($text, $text-length) = \'\\\'">
						<xsl:value-of select="concat(substring($text,1,$text-length - 1), \'\\\\\')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$text"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>

			<xsl:otherwise>
				<xsl:value-of select="concat(substring($text,1,$text-length - $text-after-bs-length - 1), \'\\\\\')"/>
				<xsl:call-template name="double-backslash">
					<xsl:with-param name="text" select="$text-after-bs"/>
					<xsl:with-param name="text-length" select="$text-after-bs-length"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="altova:MakeValueAbsoluteIfPixels">
		<xsl:param name="sValue"/>
		<xsl:variable name="sBeforePx" select="substring-before($sValue, \'px\')"/>
		<xsl:choose>
			<xsl:when test="$sBeforePx">
				<xsl:variable name="nLengthOfInteger">
					<xsl:call-template name="altova:GetCharCountOfIntegerAtEndOfString">
						<xsl:with-param name="sText" select="$sBeforePx"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:variable name="nPosOfInteger" select="string-length($sBeforePx) - $nLengthOfInteger + 1"/>
				<xsl:variable name="nValuePx" select="substring($sBeforePx, $nPosOfInteger)"/>
				<xsl:variable name="nValueIn" select="number($nValuePx) div number($altova:nPxPerIn)"/>
				<xsl:variable name="nLengthBeforeInteger" select="string-length($sBeforePx) - $nLengthOfInteger"/>
				<xsl:variable name="sRest">
					<xsl:call-template name="altova:MakeValueAbsoluteIfPixels">
						<xsl:with-param name="sValue" select="substring-after($sValue, \'px\')"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="concat(substring($sBeforePx, 1, $nLengthBeforeInteger), string($nValueIn), \'in\', $sRest)"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$sValue"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="altova:GetCharCountOfIntegerAtEndOfString">
		<xsl:param name="sText"/>
		<xsl:variable name="sLen" select="string-length($sText)"/>
		<xsl:variable name="cLast" select="substring($sText, $sLen)"/>
		<xsl:choose>
			<xsl:when test="number($cLast) &gt;= 0 and number($cLast) &lt;= 9">
				<xsl:variable name="nResultOfRest">
					<xsl:call-template name="altova:GetCharCountOfIntegerAtEndOfString">
						<xsl:with-param name="sText" select="substring($sText, 1, $sLen - 1)"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="$nResultOfRest + 1"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text>0</xsl:text>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
','CorrespondentActionNotification.xslt',UUID(),(SELECT (MAX(ID)) FROM SEQ_IACUC_PROTO_CORRESP_TEMPL),'10',NOW(),'admin',1)
/
COMMIT
/
delimiter ;
