/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.framework.ruleengine;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.kuali.coeus.common.framework.ruleengine.KcBusinessRulesEngine;
import org.kuali.coeus.common.framework.ruleengine.KcEventMethod;
import org.kuali.coeus.common.framework.ruleengine.KcEventResult;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.rice.krad.util.AuditCluster;
import org.kuali.rice.krad.util.ErrorMessage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="kcBusinessRulesEngine")
public class KcBusinessRulesEngineImpl
implements KcBusinessRulesEngine {
    private Map<Class<?>, List<RuleMethod>> rules = new ConcurrentHashMap();
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;

    @Override
    public Boolean applyRules(Object event) {
        KcEventResult result = this.runApplicableRules(event);
        this.mergeMapOfLists(this.globalVariableService.getMessageMap().getErrorMessages(), result.getMessageMap().getErrorMessages());
        this.mergeMapOfLists(this.globalVariableService.getMessageMap().getWarningMessages(), result.getMessageMap().getWarningMessages());
        this.mergeMapOfLists(this.globalVariableService.getMessageMap().getInfoMessages(), result.getMessageMap().getInfoMessages());
        this.mergeAuditMap(this.globalVariableService.getAuditErrorMap(), result.getAuditMap());
        return result.getSuccess();
    }

    @Override
    public KcEventResult applyRulesWithResult(Object event) {
        return this.runApplicableRules(event);
    }

    protected KcEventResult runApplicableRules(Object event) {
        ArrayList<KcEventResult> results = new ArrayList<KcEventResult>();
        Boolean result = true;
        List<RuleMethod> applicableRules = this.getApplicableRules(event.getClass());
        if (!applicableRules.isEmpty()) {
            for (RuleMethod ruleMethod : applicableRules) {
                try {
                    if (KcEventResult.class.isAssignableFrom(ruleMethod.method.getReturnType())) {
                        results.add((KcEventResult)ruleMethod.method.invoke(ruleMethod.rule, event));
                        continue;
                    }
                    if (!Boolean.class.isAssignableFrom(ruleMethod.method.getReturnType()) && !Boolean.TYPE.isAssignableFrom(ruleMethod.method.getReturnType())) continue;
                    result = result & (Boolean)ruleMethod.method.invoke(ruleMethod.rule, event);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        } else {
            throw new RuntimeException("Kc business rule event called but no events registered to handle event.");
        }
        return this.mergeResults(result, results);
    }

    protected List<RuleMethod> getApplicableRules(Class<?> eventClass) {
        ArrayList<RuleMethod> applicableRules = new ArrayList<RuleMethod>();
        for (Class<?> currentEventClass = eventClass; currentEventClass != null && currentEventClass != Object.class; currentEventClass = currentEventClass.getSuperclass()) {
            List<RuleMethod> currentClassRules = this.rules.get(currentEventClass);
            if (currentClassRules == null) continue;
            applicableRules.addAll((Collection<RuleMethod>)this.rules.get(currentEventClass));
        }
        return applicableRules;
    }

    protected KcEventResult mergeResults(Boolean result, List<KcEventResult> results) {
        KcEventResult mergedResult = new KcEventResult(result);
        for (KcEventResult curResult : results) {
            this.mergeResult(mergedResult, curResult);
        }
        return mergedResult;
    }

    protected void mergeResult(KcEventResult mergedResult, KcEventResult result) {
        mergedResult.setSuccess(mergedResult.getSuccess() != false && result.getSuccess() != false);
        this.mergeMapOfLists(mergedResult.getMessageMap().getErrorMessages(), result.getMessageMap().getErrorMessages());
        this.mergeMapOfLists(mergedResult.getMessageMap().getWarningMessages(), result.getMessageMap().getWarningMessages());
        this.mergeMapOfLists(mergedResult.getMessageMap().getInfoMessages(), result.getMessageMap().getInfoMessages());
        this.mergeAuditMap(mergedResult.getAuditMap(), result.getAuditMap());
    }

    protected void mergeMapOfLists(Map<String, List<ErrorMessage>> mergedMap, Map<String, List<ErrorMessage>> origMap) {
        for (Map.Entry<String, List<ErrorMessage>> entry : origMap.entrySet()) {
            if (mergedMap.containsKey(entry.getKey())) {
                mergedMap.get(entry.getKey()).addAll((Collection<ErrorMessage>)entry.getValue());
                continue;
            }
            mergedMap.put(entry.getKey(), new ArrayList(entry.getValue()));
        }
    }

    protected void mergeAuditMap(Map<String, AuditCluster> mergedMap, Map<String, AuditCluster> origMap) {
        for (Map.Entry<String, AuditCluster> entry : origMap.entrySet()) {
            if (mergedMap.containsKey(entry.getKey())) {
                mergedMap.get(entry.getKey()).getAuditErrorList().addAll(entry.getValue().getAuditErrorList());
                continue;
            }
            mergedMap.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void registerBusinessRuleClass(String ruleName, Object businessRuleClass) {
        if (businessRuleClass == null) {
            throw new IllegalArgumentException("businessRuleClass is null");
        }
        Class<?> ruleClass = businessRuleClass.getClass();
        for (Method curMethod : ruleClass.getMethods()) {
            KcEventMethod methodAnnotation = curMethod.getAnnotation(KcEventMethod.class);
            if (methodAnnotation == null) continue;
            this.registerEvent(ruleName, businessRuleClass, curMethod);
        }
    }

    @Override
    public void registerEvent(String ruleName, Object rule, Method method) {
        if (rule == null) {
            throw new IllegalArgumentException("rule is null");
        }
        if (method == null) {
            throw new IllegalArgumentException("method is null");
        }
        if (method.getParameterTypes().length != 1) {
            throw new IllegalArgumentException(rule.getClass().getSimpleName() + "." + method.getName() + " cannot be registered with the KcBusinessRulesEngines as it does not take a single argument.");
        }
        if (!(Boolean.class.isAssignableFrom(method.getReturnType()) || Boolean.TYPE.isAssignableFrom(method.getReturnType()) || KcEventResult.class.isAssignableFrom(method.getReturnType()))) {
            throw new IllegalArgumentException(rule.getClass().getSimpleName() + "." + method.getName() + " cannot be registered with the KcBusinessRuleEngine as its return value is not boolean or KcEventResult type.");
        }
        this.registerEvent(method.getParameterTypes()[0], rule, ruleName, method);
    }

    @Override
    public String getRuleInfo() {
        return this.getRules().toString();
    }

    protected void registerEvent(Class<?> event, Object rule, String ruleName, Method method) {
        this.rules.computeIfAbsent(event, k -> new ArrayList());
        this.rules.get(event).add(new RuleMethod(rule, ruleName, method));
    }

    public Map<Class<?>, List<RuleMethod>> getRules() {
        return this.rules;
    }

    public void setRules(Map<Class<?>, List<RuleMethod>> rules) {
        this.rules = rules;
    }

    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }

    static class RuleMethod {
        public Object rule;
        public String ruleName;
        public Method method;

        public RuleMethod(Object rule, String ruleName, Method method) {
            this.rule = rule;
            this.method = method;
            this.ruleName = ruleName;
        }

        public String toString() {
            return "rule name: '" + this.ruleName + "', rule method: '" + this.method.getName() + "(" + this.method.getParameterTypes()[0].getSimpleName() + ")'";
        }
    }
}

