/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.impl.keyvalue;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.sys.framework.keyvalue.KeyValueFinderService;
import org.kuali.coeus.sys.framework.util.ValuesFinderUtils;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="keyValueFinderService")
public class KeyValueFinderServiceImpl
implements KeyValueFinderService {
    private static final Logger LOG = LogManager.getLogger(KeyValueFinderServiceImpl.class);
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;

    @Override
    public List<KeyValue> getKeyValues(Class<? extends BusinessObject> keyValClass, String codePropName, String valPropName) {
        Collection keyVals = this.businessObjectService.findAll(keyValClass);
        ArrayList<KeyValue> keyValueList = new ArrayList<KeyValue>(keyVals.size());
        keyValueList.add(ValuesFinderUtils.getSelectOption());
        for (Object keyValObj : keyVals) {
            try {
                Method getCodeMeth = keyValObj.getClass().getMethod("get" + StringUtils.capitalize((String)codePropName), null);
                Method getValMeth = keyValObj.getClass().getMethod("get" + StringUtils.capitalize((String)valPropName), null);
                Object code = getCodeMeth.invoke(keyValObj, null);
                Object value = getValMeth.invoke(keyValObj, null);
                if (code == null || value == null) continue;
                keyValueList.add((KeyValue)new ConcreteKeyValue(code.toString(), value.toString()));
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        return keyValueList;
    }

    @Override
    public List<KeyValue> getKeyValues(Class<? extends BusinessObject> keyValClass, String codePropName, String valPropName, Map<String, ?> queryMap) {
        Collection keyVals = this.businessObjectService.findMatching(keyValClass, queryMap);
        ArrayList<KeyValue> keyValueList = new ArrayList<KeyValue>(keyVals.size());
        keyValueList.add(ValuesFinderUtils.getSelectOption());
        for (Object keyValObj : keyVals) {
            try {
                Method getCodeMeth = keyValObj.getClass().getMethod("get" + StringUtils.capitalize((String)codePropName), null);
                Method getValMeth = keyValObj.getClass().getMethod("get" + StringUtils.capitalize((String)valPropName), null);
                String code = (String)getCodeMeth.invoke(keyValObj, null);
                String value = (String)getValMeth.invoke(keyValObj, null);
                keyValueList.add((KeyValue)new ConcreteKeyValue(code, value));
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        return keyValueList;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

