/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.permissions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.auth.perm.KcAuthorizationService;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.common.permissions.impl.web.struts.form.PermissionsHelperBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.AwardForm;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.document.authorization.AwardTask;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.infrastructure.AwardRoleConstants;
import org.kuali.kra.award.infrastructure.AwardTaskNames;

public class PermissionsHelper
extends PermissionsHelperBase {
    private static final String AGGREGATOR_NAME = "Aggregator";
    private static final String VIEWER_NAME = "Viewer";
    private static final String UNASSIGNED_NAME = "unassigned";
    private AwardForm form;
    private Map<String, String> displayNameMap = null;

    public PermissionsHelper(AwardForm form) {
        super("KC-AWARD");
        this.form = form;
    }

    private void buildDisplayNameMap() {
        if (this.displayNameMap == null) {
            this.displayNameMap = new HashMap<String, String>();
            this.displayNameMap.put(AwardRoleConstants.AWARD_MODIFIER.getAwardRole(), AGGREGATOR_NAME);
            this.displayNameMap.put(AwardRoleConstants.AWARD_VIEWER.getAwardRole(), VIEWER_NAME);
            this.displayNameMap.put(AwardRoleConstants.AWARD_UNASSIGNED.getAwardRole(), UNASSIGNED_NAME);
        }
    }

    private Award getAward() {
        AwardDocument document = this.form.getAwardDocument();
        if (document == null || document.getAward() == null) {
            throw new IllegalArgumentException("invalid (null) AWARDDocument in AWARDForm");
        }
        return document.getAward();
    }

    @Override
    public String getUnassignedRoleName() {
        return AwardRoleConstants.AWARD_UNASSIGNED.getAwardRole();
    }

    @Override
    protected boolean isStandardRoleName(String roleName) {
        return StringUtils.equals((CharSequence)roleName, (CharSequence)AwardRoleConstants.AWARD_MODIFIER.getAwardRole()) || StringUtils.equals((CharSequence)roleName, (CharSequence)AwardRoleConstants.AWARD_VIEWER.getAwardRole());
    }

    @Override
    protected String getRoleDisplayName(String roleName) {
        this.buildDisplayNameMap();
        String displayName = this.displayNameMap.get(roleName);
        if (displayName == null) {
            displayName = roleName;
        }
        return displayName;
    }

    @Override
    protected List<KcPerson> getPersonsInRole(String roleName) {
        KcAuthorizationService kraAuthService = KcServiceLocator.getService(KcAuthorizationService.class);
        KcPersonService kcPersonService = KcServiceLocator.getService(KcPersonService.class);
        List<String> users = kraAuthService.getPrincipalsInRole(roleName, this.getAward());
        ArrayList<KcPerson> persons = new ArrayList<KcPerson>();
        for (String userId : users) {
            KcPerson person = kcPersonService.getKcPersonByPersonId(userId);
            if (person == null || !person.getActive().booleanValue()) continue;
            persons.add(person);
        }
        return persons;
    }

    @Override
    public boolean canModifyPermissions() {
        AwardTask task = new AwardTask(AwardTaskNames.MODIFY_AWARD_ROLES.getAwardTaskName(), this.getAward());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    public boolean getMaintainAwardReportTracking() {
        AwardTask task = new AwardTask(AwardTaskNames.MAINTAIN_REPORT_TRACKING.getAwardTaskName(), this.getAward());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }
}

