/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.excon.project;

import java.io.Serializable;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.mail.EmailAttachment;
import org.kuali.coeus.common.framework.mail.KcEmailService;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.excon.document.ExconProjectDocument;
import org.kuali.kra.excon.project.ExconProject;
import org.kuali.kra.excon.project.ExconProjectDestination;
import org.kuali.kra.excon.project.ExconProjectEmailContent;
import org.kuali.kra.excon.project.ExconProjectEvent;
import org.kuali.kra.excon.project.ExconProjectForm;
import org.kuali.kra.excon.project.ExconProjectPerson;
import org.kuali.kra.excon.project.ExconProjectTravelerCommunication;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public class ExconProjectEmailBean
implements Serializable {
    private static final long serialVersionUID = 238453457L;
    protected ExconProjectEmailContent newBody;
    protected ExconProjectEmailContent newAttachment;
    protected ExconProjectEmailContent newAgenda;
    protected ExconProjectForm exconProjectForm;
    private transient BusinessObjectService businessObjectService;
    private transient ParameterService parameterService;
    private transient KcEmailService kcEmailService;
    private transient RoleService roleService;
    private transient KcPersonService kcPersonService;
    private transient ConfigurationService configurationService;

    public ExconProjectEmailBean(ExconProjectForm exconProjectForm) {
        this.exconProjectForm = exconProjectForm;
        this.init();
    }

    public ExconProjectEmailContent getNewBody() {
        return this.newBody;
    }

    public ExconProjectEmailContent getNewAttachment() {
        return this.newAttachment;
    }

    public ExconProjectEmailContent getNewAgenda() {
        return this.newAgenda;
    }

    public ExconProjectEmailContent getBodyObj() {
        HashMap<String, String> criteriaMap = new HashMap<String, String>();
        criteriaMap.put("contentCode", this.newBody.getContentCode());
        return (ExconProjectEmailContent)this.getBusinessObjectService().findByPrimaryKey(ExconProjectEmailContent.class, criteriaMap);
    }

    public ExconProjectEmailContent getAttachmentObj() {
        HashMap<String, String> criteriaMap = new HashMap<String, String>();
        criteriaMap.put("contentCode", this.newAttachment.getContentCode());
        return (ExconProjectEmailContent)this.getBusinessObjectService().findByPrimaryKey(ExconProjectEmailContent.class, criteriaMap);
    }

    public ExconProjectEmailContent getAgendaObj() {
        HashMap<String, String> criteriaMap = new HashMap<String, String>();
        criteriaMap.put("contentCode", this.newAgenda.getContentCode());
        return (ExconProjectEmailContent)this.getBusinessObjectService().findByPrimaryKey(ExconProjectEmailContent.class, criteriaMap);
    }

    public void sendTravelerEmail() {
        ExconProject exconProject = this.getExconProject();
        Object destStr = "";
        ArrayList<EmailAttachment> attachments = new ArrayList<EmailAttachment>();
        for (ExconProjectDestination destination : exconProject.getExconProjectDestinations()) {
            if (!StringUtils.isEmpty((CharSequence)destStr)) {
                destStr = (String)destStr + ", ";
            }
            destStr = (String)destStr + destination.getDestinationCountryName();
        }
        String senderEmail = this.getPersonService().getKcPersonByUserName(GlobalVariables.getUserSession().getPrincipalName()).getEmailAddress();
        String recipEmail = "";
        String firstName = "Traveler";
        ExconProjectPerson traveler = exconProject.getTraveler();
        if (traveler != null) {
            recipEmail = traveler.getPerson().getEmailAddress();
            if (!StringUtils.isEmpty((CharSequence)traveler.getPerson().getFirstName())) {
                firstName = traveler.getPerson().getFirstName();
            }
        }
        HashSet<String> recipSet = new HashSet<String>();
        recipSet.add(recipEmail);
        HashSet<String> bccSet = new HashSet<String>();
        bccSet.add(senderEmail);
        Collection memberIds = this.getRoleService().getRoleMemberPrincipalIds("KC-EXCON", "Export Control Project Coordinator", new HashMap());
        for (String memberId : memberIds) {
            KcPerson memberPerson = this.getPersonService().getKcPersonByPersonId(memberId);
            if (!memberPerson.isActive()) continue;
            bccSet.add(memberPerson.getEmailAddress());
        }
        EmailAttachment attachment = new EmailAttachment();
        ExconProjectEmailContent bodyContent = this.getBodyObj();
        ExconProjectEmailContent attachmentContent = this.getAttachmentObj();
        attachment.setContents(attachmentContent.getAttachmentContent());
        attachment.setFileName(attachmentContent.getFileName());
        attachment.setMimeType(attachmentContent.getContentType());
        attachments.add(attachment);
        String bodyStr = new String(bodyContent.getAttachmentContent());
        bodyStr = bodyStr.replace("[firstName]", firstName);
        this.getEmailService().sendEmailWithAttachments(senderEmail, recipSet, "Regarding your upcoming trip to: " + (String)destStr, null, bccSet, bodyStr, true, attachments);
        ExconProjectEvent newEvent = new ExconProjectEvent();
        newEvent.setProjectEventTypeCode("TVA");
        newEvent.setEventDate(new Date(System.currentTimeMillis()));
        exconProject.add(newEvent);
        if (traveler != null) {
            ExconProjectTravelerCommunication newCommunication = new ExconProjectTravelerCommunication();
            newCommunication.setEmailBodyContentCode(bodyContent.getContentCodeBody());
            newCommunication.setEmailAttachmentContentCode(attachmentContent.getContentCodeAttachment());
            newCommunication.setPersonId(traveler.getPersonId());
            newCommunication.setCommunicationDate(new Date(System.currentTimeMillis()));
            exconProject.getTravelerCommunications().add(newCommunication);
        }
        KNSGlobalVariables.getMessageList().add("info.exconProjectTravelerEmail.sent", new String[]{recipEmail});
    }

    protected void init() {
        this.newBody = new ExconProjectEmailContent();
        this.newAttachment = new ExconProjectEmailContent();
        this.newAgenda = new ExconProjectEmailContent();
    }

    protected ExconProject getExconProject() {
        return this.getDocument().getExconProject();
    }

    protected ExconProjectDocument getDocument() {
        return this.exconProjectForm.getExconProjectDocument();
    }

    public void addTravelerMeetingAgenda() {
        ExconProject exconProject = this.getExconProject();
        ExconProjectEvent newEvent = new ExconProjectEvent();
        newEvent.setProjectEventTypeCode("TVA");
        newEvent.setEventDate(new Date(System.currentTimeMillis()));
        exconProject.add(newEvent);
        ExconProjectPerson traveler = exconProject.getTraveler();
        ExconProjectEmailContent agendaContent = this.getAgendaObj();
        if (traveler != null) {
            ExconProjectTravelerCommunication newCommunication = new ExconProjectTravelerCommunication();
            newCommunication.setAgendaContentCode(agendaContent.getContentCodeBody());
            newCommunication.setPersonId(traveler.getPersonId());
            newCommunication.setCommunicationDate(new Date(System.currentTimeMillis()));
            exconProject.getTravelerCommunications().add(newCommunication);
        }
        KNSGlobalVariables.getMessageList().add("info.exconProjectTravelerAgenda.added", new String[0]);
    }

    private ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KcServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    private KcEmailService getEmailService() {
        if (this.kcEmailService == null) {
            this.kcEmailService = KcServiceLocator.getService(KcEmailService.class);
        }
        return this.kcEmailService;
    }

    public KcEmailService getKcEmailService() {
        return this.kcEmailService;
    }

    private RoleService getRoleService() {
        if (this.roleService == null) {
            this.roleService = KcServiceLocator.getService(RoleService.class);
        }
        return this.roleService;
    }

    public void setRoleService(RoleService roleService) {
        this.roleService = roleService;
    }

    private KcPersonService getPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = KcServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    public void setKcEmailService(KcEmailService kcEmailService) {
        this.kcEmailService = kcEmailService;
    }

    private ConfigurationService getConfigurationService() {
        if (this.configurationService == null) {
            this.configurationService = KcServiceLocator.getService(ConfigurationService.class);
        }
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    protected BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KcServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }

    void setBusinessObjectService(BusinessObjectService bos) {
        this.businessObjectService = bos;
    }

    public KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = KcServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }
}

