/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.coi.framework.ProjectRetrievalService;
import org.kuali.coeus.common.framework.custom.DocumentCustomData;
import org.kuali.coeus.common.framework.krms.KcKrmsFactBuilderService;
import org.kuali.coeus.common.notification.impl.bo.KcNotification;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.bo.ResearchAreaBase;
import org.kuali.kra.iacuc.IacucProtocol;
import org.kuali.kra.iacuc.IacucProtocolFinderDao;
import org.kuali.kra.iacuc.IacucProtocolVersionService;
import org.kuali.kra.iacuc.IacucResearchArea;
import org.kuali.kra.iacuc.actions.IacucProtocolAction;
import org.kuali.kra.iacuc.actions.IacucProtocolSubmissionDoc;
import org.kuali.kra.iacuc.actions.genericactions.IacucProtocolGenericActionService;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolActionService;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolSubmission;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolSubmissionBuilder;
import org.kuali.kra.iacuc.notification.IacucProtocolNotification;
import org.kuali.kra.iacuc.notification.IacucProtocolNotificationContext;
import org.kuali.kra.iacuc.notification.IacucProtocolNotificationRenderer;
import org.kuali.kra.iacuc.protocol.location.IacucProtocolLocationService;
import org.kuali.kra.iacuc.protocol.research.IacucProtocolResearchAreaService;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.ProtocolFinderDao;
import org.kuali.kra.protocol.ProtocolSpecialVersion;
import org.kuali.kra.protocol.ProtocolVersionService;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.actions.genericactions.ProtocolGenericActionService;
import org.kuali.kra.protocol.actions.submit.ProtocolActionService;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentProtocolBase;
import org.kuali.kra.protocol.notification.ProtocolNotification;
import org.kuali.kra.protocol.notification.ProtocolNotificationContextBase;
import org.kuali.kra.protocol.protocol.location.ProtocolLocationService;
import org.kuali.kra.protocol.protocol.research.ProtocolResearchAreaService;
import org.kuali.rice.coreservice.framework.parameter.ParameterConstants;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;
import org.kuali.rice.krms.api.engine.Facts;

@ParameterConstants.NAMESPACE(namespace="KC-IACUC")
@ParameterConstants.COMPONENT(component="Document")
public class IacucProtocolDocument
extends ProtocolDocumentBase {
    private static final long serialVersionUID = -1014286912251147390L;
    private static final Logger LOG = LogManager.getLogger(IacucProtocolDocument.class);
    public static final String DOCUMENT_TYPE_CODE = "ICPR";
    private static final String DISAPPROVED_CONTEXT_NAME = "Disapproved";
    private transient ProjectRetrievalService projectRetrievalService;

    @Override
    public IacucProtocol getProtocol() {
        return (IacucProtocol)super.getProtocol();
    }

    @Override
    protected IacucProtocol createNewProtocolInstanceHook() {
        return new IacucProtocol();
    }

    public IacucProtocol getIacucProtocol() {
        return this.getProtocol();
    }

    @Override
    public String getDocumentTypeCode() {
        return DOCUMENT_TYPE_CODE;
    }

    @Override
    public boolean isProcessComplete() {
        boolean isComplete = true;
        if (this.getProtocol().getProtocolStatusCode().equals("101")) {
            if (this.getWorkflowDocumentService().getCurrentRouteNodeNames(this.getDocumentHeader().getWorkflowDocument()).equalsIgnoreCase("Initiated")) {
                isComplete = false;
            }
            this.getProtocol().getProtocolSubmission().refreshReferenceObject("submissionStatus");
            String status = this.getProtocol().getProtocolSubmission().getSubmissionStatusCode();
            if (!this.isNormal() && status.equals("200") && this.getWorkflowDocumentService().getCurrentRouteNodeNames(this.getDocumentHeader().getWorkflowDocument()).equalsIgnoreCase("IACUCReview")) {
                isComplete = false;
            }
        } else {
            if (this.getProtocol().getProtocolStatusCode().equals("400") || this.getProtocol().getProtocolStatusCode().equals("401") || this.getProtocol().getProtocolStatusCode().equals("901") || this.getProtocol().getProtocolStatusCode().equals("402")) {
                String protocolId = this.getNewProtocolDocId();
                if (ObjectUtils.isNull((Object)protocolId)) {
                    isComplete = false;
                } else {
                    String oldLocation = (String)GlobalVariables.getUserSession().retrieveObject("holdingPageReturnLocation");
                    String oldDocNbr = this.getProtocol().getProtocolDocument().getDocumentNumber();
                    String returnLocation = oldLocation.replaceFirst(oldDocNbr, protocolId);
                    GlobalVariables.getUserSession().addObject("holdingPageReturnLocation", (Object)returnLocation);
                }
            }
            if (!this.getDocumentHeader().getWorkflowDocument().isFinal()) {
                isComplete = false;
            }
        }
        return isComplete;
    }

    @Override
    protected Class<? extends ProtocolLocationService> getProtocolLocationServiceClassHook() {
        return IacucProtocolLocationService.class;
    }

    @Override
    protected Class<? extends ProtocolResearchAreaService> getProtocolResearchAreaServiceClassHook() {
        return IacucProtocolResearchAreaService.class;
    }

    @Override
    public void populateContextQualifiers(Map<String, String> qualifiers) {
        qualifiers.put("namespaceCode", "KC-IACUC");
        qualifiers.put("name", "KC IACUC Context");
    }

    @Override
    public void addFacts(Facts.Builder factsBuilder) {
        KcKrmsFactBuilderService fbService = (KcKrmsFactBuilderService)KcServiceLocator.getService("iacucProtocolFactBuilderService");
        fbService.addFacts(factsBuilder, this);
    }

    @Override
    protected ProtocolActionBase getNewProtocolActionInstanceHook(ProtocolBase protocol, ProtocolSubmissionBase protocolSubmission, String protocolStatusCode) {
        String protocolActionTypeCode = "104";
        if (protocolStatusCode.equals("400")) {
            protocolActionTypeCode = "204";
        } else if (protocolStatusCode.equals("402")) {
            protocolActionTypeCode = "103";
        } else if (protocolStatusCode.equals("113")) {
            protocolActionTypeCode = "113";
        }
        return new IacucProtocolAction((IacucProtocol)protocol, (IacucProtocolSubmission)protocolSubmission, protocolActionTypeCode);
    }

    @Override
    protected Class<? extends ProtocolActionService> getProtocolActionServiceClassHook() {
        return IacucProtocolActionService.class;
    }

    @Override
    protected Class<? extends ProtocolBase> getProtocolBOClassHook() {
        return IacucProtocol.class;
    }

    protected ProtocolFinderDao getProtocolFinderDaoHook() {
        return KcServiceLocator.getService(IacucProtocolFinderDao.class);
    }

    protected ProtocolVersionService getProtocolVersionServiceHook() {
        return KcServiceLocator.getService(IacucProtocolVersionService.class);
    }

    protected String getProtocolStatusMergedHook() {
        return "400";
    }

    protected String getProtocolStatusExemptHook() {
        return "203";
    }

    protected String getProtocolStatusOnHoldHook() {
        return "201";
    }

    protected String getProtocolStatusActiveOpenToEnrollmentHook() {
        return "200";
    }

    protected String getListOfStatusEligibleForMergingHook() {
        StringBuilder listOfStatusEligibleForMerging = new StringBuilder();
        listOfStatusEligibleForMerging.append("101");
        listOfStatusEligibleForMerging.append(" ");
        listOfStatusEligibleForMerging.append("104");
        listOfStatusEligibleForMerging.append(" ");
        listOfStatusEligibleForMerging.append("103");
        listOfStatusEligibleForMerging.append(" ");
        listOfStatusEligibleForMerging.append("107");
        listOfStatusEligibleForMerging.append(" ");
        listOfStatusEligibleForMerging.append("205");
        listOfStatusEligibleForMerging.append(" ");
        listOfStatusEligibleForMerging.append("206");
        listOfStatusEligibleForMerging.append(" ");
        listOfStatusEligibleForMerging.append("207");
        listOfStatusEligibleForMerging.append(" ");
        listOfStatusEligibleForMerging.append("304");
        listOfStatusEligibleForMerging.append(" ");
        listOfStatusEligibleForMerging.append("301");
        listOfStatusEligibleForMerging.append(" ");
        listOfStatusEligibleForMerging.append("105");
        return listOfStatusEligibleForMerging.toString();
    }

    public boolean isContinuation() {
        return this.getProtocol().getProtocolNumber().contains(ProtocolSpecialVersion.CONTINUATION.getCode());
    }

    protected String getProtocolMergedStatus() {
        String mergedStatus = "400";
        if (this.isRenewal()) {
            mergedStatus = "401";
        } else if (this.isContinuation()) {
            mergedStatus = "402";
        } else if (this.isFYI()) {
            mergedStatus = "901";
        }
        return mergedStatus;
    }

    @Override
    public boolean isNormal() {
        return !this.isAmendment() && !this.isRenewal() && !this.isContinuation() && !this.isFYI();
    }

    @Override
    protected void mergeProtocolAmendment() {
        if (this.isAmendment()) {
            this.mergeAmendment(this.getProtocolMergedStatus(), ProtocolSpecialVersion.AMENDMENT.getDescription());
        } else if (this.isRenewal()) {
            this.mergeAmendment(this.getProtocolMergedStatus(), ProtocolSpecialVersion.RENEWAL.getDescription());
        } else if (this.isContinuation()) {
            this.mergeAmendment(this.getProtocolMergedStatus(), ProtocolSpecialVersion.CONTINUATION.getDescription());
        } else if (this.isFYI()) {
            this.mergeAmendment(this.getProtocolMergedStatus(), ProtocolSpecialVersion.FYI.getDescription());
            this.mergeFyiAttachments();
            this.getProtocol().reconcileActionsWithSubmissions();
        }
    }

    protected void mergeFyiAttachments() {
        IacucProtocolSubmission fyiSubmission = null;
        ProtocolActionBase createFyiAction = null;
        String fyiNumber = this.getProtocol().getProtocolNumber().substring(this.getProtocol().getProtocolNumber().indexOf(ProtocolSpecialVersion.FYI.getCode()) + 1);
        ProtocolBase originalProtocol = this.getProtocolFinderDaoHook().findCurrentProtocolByNumber(this.getOriginalProtocolNumber());
        for (ProtocolActionBase originalAction : originalProtocol.getProtocolActions()) {
            if (!originalAction.getProtocolActionTypeCode().equals("114") || !originalAction.getComments().contains(ProtocolSpecialVersion.FYI.getDescription() + "-" + fyiNumber + ": Created")) continue;
            createFyiAction = originalAction;
            break;
        }
        if (createFyiAction != null) {
            fyiSubmission = (IacucProtocolSubmission)originalProtocol.getProtocolSubmission();
            if (createFyiAction.getSubmissionIdFk() == null) {
                createFyiAction.setProtocolSubmission(fyiSubmission);
                createFyiAction.setSubmissionIdFk(fyiSubmission.getSubmissionId());
                createFyiAction.setSubmissionNumber(fyiSubmission.getSubmissionNumber());
                this.getBusinessObjectService().save((PersistableBusinessObject)createFyiAction);
            }
        }
        if (fyiSubmission != null) {
            ArrayList<IacucProtocolSubmissionDoc> mergedAttachments = new ArrayList<IacucProtocolSubmissionDoc>();
            for (ProtocolAttachmentProtocolBase attachment : this.getProtocol().getActiveAttachmentProtocols()) {
                IacucProtocolSubmissionDoc fyiAttachment = IacucProtocolSubmissionBuilder.createProtocolSubmissionDoc(fyiSubmission, attachment.getFile().getName(), attachment.getFile().getType(), attachment.getFile().getData(), attachment.getDescription());
                fyiAttachment.setProtocolNumber(createFyiAction.getProtocolNumber());
                fyiAttachment.setProtocolId(createFyiAction.getProtocolId());
                fyiAttachment.setProtocol(originalProtocol);
                mergedAttachments.add(fyiAttachment);
            }
            this.getBusinessObjectService().save(mergedAttachments);
        } else {
            LOG.error("Couldn't merge FYI attachments into parent protocol-- no submission found for FYI #" + this.getProtocol().getProtocolNumber());
        }
    }

    @Override
    protected Class<? extends ResearchAreaBase> getResearchAreaBoClassHook() {
        return IacucResearchArea.class;
    }

    protected void mergeAmendment(String protocolStatusCode, String type) {
        ProtocolDocumentBase newProtocolDocument;
        ProtocolBase currentProtocol = this.getProtocolFinderDaoHook().findCurrentProtocolByNumber(this.getOriginalProtocolNumber());
        try {
            currentProtocol.setProtocolDocument((ProtocolDocumentBase)this.getDocumentService().getByDocumentHeaderId(currentProtocol.getProtocolDocument().getDocumentNumber()));
            currentProtocol.setMergeAmendment(true);
            newProtocolDocument = this.getProtocolVersionServiceHook().versionProtocolDocument(currentProtocol.getProtocolDocument());
        }
        catch (Exception e) {
            throw new ProtocolDocumentBase.ProtocolMergeException(e);
        }
        newProtocolDocument.getProtocol().merge(this.getProtocol());
        this.getProtocol().setProtocolStatusCode(protocolStatusCode);
        ProtocolActionBase action = this.getNewProtocolActionInstanceHook(newProtocolDocument.getProtocol(), null, this.getProtocolStatusMergedHook());
        action.setComments(type + "-" + this.getProtocolNumberIndex() + ": Approved");
        newProtocolDocument.setProtocolWorkflowType(ProtocolDocumentBase.ProtocolWorkflowType.APPROVED);
        newProtocolDocument.getProtocol().getProtocolActions().add(action);
        if (currentProtocol.getProtocolStatusCode().equals(this.getProtocolStatusOnHoldHook())) {
            newProtocolDocument.getProtocol().setProtocolStatusCode(this.getProtocolStatusOnHoldHook());
        } else if (!currentProtocol.getProtocolStatusCode().equals(this.getProtocolStatusExemptHook())) {
            newProtocolDocument.getProtocol().setProtocolStatusCode(this.getProtocolStatusActiveOpenToEnrollmentHook());
        }
        try {
            this.getDocumentService().saveDocument((Document)newProtocolDocument);
            this.setProtocolDocumentToApproveByDefault();
            newProtocolDocument.getDocumentHeader().getWorkflowDocument().route(type + "-" + this.getProtocolNumberIndex() + ": merged");
        }
        catch (WorkflowException e) {
            throw new ProtocolDocumentBase.ProtocolMergeException(e);
        }
        newProtocolDocument.getProtocol().reconcileActionsWithSubmissions();
        this.getBusinessObjectService().save(newProtocolDocument.getProtocol().getProtocolActions());
        this.getProtocol().setActive(false);
        for (ProtocolBase otherProtocol : this.getProtocolFinderDaoHook().findProtocols(this.getOriginalProtocolNumber())) {
            String status = otherProtocol.getProtocolStatus().getProtocolStatusCode();
            if (!this.isEligibleForMerging(status, otherProtocol)) continue;
            otherProtocol.merge((ProtocolBase)this.getProtocol(), false);
            action = this.getNewProtocolActionInstanceHook(otherProtocol, null, protocolStatusCode);
            action.setComments(type + "-" + this.getProtocolNumberIndex() + ": Merged");
            otherProtocol.getProtocolActions().add(action);
            this.getBusinessObjectService().save((PersistableBusinessObject)otherProtocol);
        }
        this.finalizeAttachmentProtocol(this.getProtocol());
        this.mergeProtocolNotifications(newProtocolDocument, this.getProtocol().getLastProtocolAction().getProtocolActionTypeCode());
        this.getBusinessObjectService().save((PersistableBusinessObject)this);
    }

    protected void mergeProtocolNotifications(ProtocolDocumentBase newProtocolDocument, String protocolActionType) {
        KcPersistableBusinessObjectBase getProtocolPaToUse = null;
        for (ProtocolActionBase pa : this.getProtocol().getProtocolActions()) {
            if (!StringUtils.equals((CharSequence)protocolActionType, (CharSequence)pa.getProtocolActionTypeCode()) || getProtocolPaToUse != null && !getProtocolPaToUse.getUpdateTimestamp().before(pa.getUpdateTimestamp())) continue;
            getProtocolPaToUse = (IacucProtocolAction)pa;
        }
        KcPersistableBusinessObjectBase newDocPaToUse = null;
        for (ProtocolActionBase pa2 : newProtocolDocument.getProtocol().getProtocolActions()) {
            if (!this.isProtocolApproved(pa2.getProtocolActionTypeCode()) || newDocPaToUse != null && !newDocPaToUse.getUpdateTimestamp().before(pa2.getUpdateTimestamp())) continue;
            newDocPaToUse = (IacucProtocolAction)pa2;
        }
        if (newDocPaToUse != null && getProtocolPaToUse != null) {
            for (KcNotification notification : ((ProtocolActionBase)getProtocolPaToUse).getProtocolNotifications()) {
                IacucProtocolNotification newNotification = IacucProtocolNotification.copy(notification);
                newNotification.resetPersistenceState();
                newNotification.persistOwningObject(newProtocolDocument.getProtocol());
            }
            this.getBusinessObjectService().save((PersistableBusinessObject)newDocPaToUse);
        }
    }

    private boolean isProtocolApproved(String protocolActionTypeCode) {
        return StringUtils.equals((CharSequence)"204", (CharSequence)protocolActionTypeCode) || StringUtils.equals((CharSequence)"212", (CharSequence)protocolActionTypeCode) || StringUtils.equals((CharSequence)"205", (CharSequence)protocolActionTypeCode) || StringUtils.equals((CharSequence)"215", (CharSequence)protocolActionTypeCode);
    }

    protected boolean isEligibleForMerging(String status, ProtocolBase otherProtocol) {
        return this.getListOfStatusEligibleForMergingHook().contains(status) && !StringUtils.equals((CharSequence)this.getProtocol().getProtocolNumber(), (CharSequence)otherProtocol.getProtocolNumber());
    }

    @Override
    public List<? extends DocumentCustomData> getDocumentCustomData() {
        return this.getIacucProtocol().getIacucProtocolCustomDataList();
    }

    @Override
    protected Class<? extends ProtocolGenericActionService> getProtocolGenericActionServiceClassHook() {
        return IacucProtocolGenericActionService.class;
    }

    @Override
    protected ProtocolNotification getNewProtocolNotificationInstanceHook() {
        return new IacucProtocolNotification();
    }

    @Override
    protected ProtocolNotificationContextBase getDisapproveNotificationContextHook(ProtocolBase protocol) {
        return new IacucProtocolNotificationContext((IacucProtocol)protocol, "301", DISAPPROVED_CONTEXT_NAME, new IacucProtocolNotificationRenderer((IacucProtocol)protocol));
    }

    @Override
    protected String getCommitteeDisapprovedStatusCodeHook() {
        return "303";
    }

    @Override
    public ProjectRetrievalService getProjectRetrievalService() {
        if (this.projectRetrievalService == null) {
            this.projectRetrievalService = (ProjectRetrievalService)KcServiceLocator.getService("iacucProjectRetrievalService");
        }
        return this.projectRetrievalService;
    }

    @Override
    public void setProjectRetrievalService(ProjectRetrievalService projectRetrievalService) {
        this.projectRetrievalService = projectRetrievalService;
    }
}

