/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.kuali.coeus.common.framework.auth.perm.KcAuthorizationService;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.kra.lookup.KraLookupableHelperServiceImpl;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kns.document.authorization.DocumentAuthorizer;
import org.kuali.rice.kns.lookup.HtmlData;
import org.kuali.rice.kns.service.DocumentHelperService;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.lookup.CollectionIncomplete;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.UrlFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="proposalDevelopmentLookupableHelperService")
@Scope(value="prototype")
public class DevelopmentProposalLookupableHelperServiceImpl
extends KraLookupableHelperServiceImpl {
    private static final long serialVersionUID = 8611232870631352662L;
    @Autowired
    @Qualifier(value="kcAuthorizationService")
    private KcAuthorizationService kraAuthorizationService;
    @Autowired
    @Qualifier(value="documentHelperService")
    private DocumentHelperService documentHelperService;

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        List unboundedResults = super.getSearchResults(fieldValues);
        CollectionIncomplete filteredResults = new ArrayList();
        filteredResults = this.filterForPermissions(unboundedResults);
        if (unboundedResults instanceof CollectionIncomplete) {
            filteredResults = new CollectionIncomplete(filteredResults, ((CollectionIncomplete)unboundedResults).getActualSizeIfTruncated());
        }
        return filteredResults;
    }

    @Override
    public List<HtmlData> getCustomActionUrls(BusinessObject businessObject, List pkNames) {
        ProposalDevelopmentDocument document = ((DevelopmentProposal)businessObject).getProposalDocument();
        String currentUser = GlobalVariables.getUserSession().getPrincipalId();
        ArrayList<HtmlData> htmlDataList = new ArrayList<HtmlData>();
        boolean canModifyProposal = this.kraAuthorizationService.hasPermission(currentUser, document, "Modify ProposalDevelopmentDocument");
        boolean canViewProposal = this.kraAuthorizationService.hasPermission(currentUser, document, "View Proposal");
        if (canModifyProposal) {
            HtmlData.AnchorHtmlData editHtmlData = this.getViewLink(document.getDocumentNumber());
            String href = editHtmlData.getHref();
            href = href.replace("viewDocument=true", "viewDocument=false");
            editHtmlData.setHref(href);
            editHtmlData.setDisplayText("edit");
            htmlDataList.add((HtmlData)editHtmlData);
        }
        if (canViewProposal) {
            HtmlData.AnchorHtmlData viewLink = this.getViewLink(document.getDocumentNumber());
            htmlDataList.add((HtmlData)viewLink);
            htmlDataList.add((HtmlData)this.getCustomLink(document.getDocumentNumber(), "actions", "copy", !canModifyProposal));
        }
        if (canModifyProposal) {
            htmlDataList.add((HtmlData)this.getMedusaLink(document.getDocumentNumber(), false));
        } else if (canViewProposal) {
            htmlDataList.add((HtmlData)this.getMedusaLink(document.getDocumentNumber(), true));
        }
        return htmlDataList;
    }

    protected HtmlData.AnchorHtmlData getCustomLink(String documentNumber, String methodToCall, String linkName, Boolean readOnly) {
        HtmlData.AnchorHtmlData htmlData = new HtmlData.AnchorHtmlData();
        htmlData.setDisplayText(linkName);
        Properties parameters = new Properties();
        parameters.put("methodToCall", methodToCall);
        parameters.put("command", "displayDocSearchView");
        parameters.put("docTypeName", this.getDocumentTypeName());
        parameters.put("viewDocument", readOnly.toString());
        parameters.put("docId", documentNumber);
        String href = UrlFactory.parameterizeUrl((String)("../" + this.getHtmlAction()), (Properties)parameters);
        htmlData.setHref(href);
        return htmlData;
    }

    @Override
    protected String getDocumentTypeName() {
        return "ProposalDevelopmentDocument";
    }

    @Override
    protected String getHtmlAction() {
        return "proposalDevelopmentProposal.do";
    }

    @Override
    protected String getKeyFieldName() {
        return "proposalNumber";
    }

    private List<DevelopmentProposal> filterForPermissions(List<DevelopmentProposal> results) {
        Person user = GlobalVariables.getUserSession().getPerson();
        ArrayList<DevelopmentProposal> filteredResults = new ArrayList<DevelopmentProposal>();
        for (DevelopmentProposal developmentProposal : results) {
            DocumentAuthorizer authorizer = this.getDocumentHelperService().getDocumentAuthorizer("ProposalDevelopmentDocument");
            if (!authorizer.canOpen((Document)developmentProposal.getProposalDocument(), user)) continue;
            filteredResults.add(developmentProposal);
        }
        return filteredResults;
    }

    public void setKraAuthorizationService(KcAuthorizationService kraAuthorizationService) {
        this.kraAuthorizationService = kraAuthorizationService;
    }

    public KcAuthorizationService getKraAuthorizationService() {
        return this.kraAuthorizationService;
    }

    public DocumentHelperService getDocumentHelperService() {
        return this.documentHelperService;
    }

    public void setDocumentHelperService(DocumentHelperService documentHelperService) {
        this.documentHelperService = documentHelperService;
    }
}

