/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.impl.rest;

import java.util.Optional;
import org.kuali.coeus.sys.framework.auth.AuthServiceUserLoginFilter;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.rest.AuthServiceRestUtilService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Component;

@Component(value="authServiceRestUtilService")
public class AuthServiceRestUtilServiceImpl
implements AuthServiceRestUtilService {
    private static final String AUTHORIZATION_PREFIX = "Bearer ";
    private static final String AUTHORIZATION_HEADER_NAME = "Authorization";
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;

    @Override
    public HttpHeaders getAuthServiceStyleHttpHeadersForUser() {
        return this.getAuthServiceStyleHttpHeadersForToken(this.getAuthTokenValueForCurrentUser());
    }

    @Override
    public HttpHeaders getAuthServiceStyleHttpHeadersForToken(String authTokenValueForCurrentUser) {
        HttpHeaders headers = new HttpHeaders();
        headers.set(AUTHORIZATION_HEADER_NAME, (String)(authTokenValueForCurrentUser.startsWith(AUTHORIZATION_PREFIX) ? authTokenValueForCurrentUser : AUTHORIZATION_PREFIX + authTokenValueForCurrentUser));
        return headers;
    }

    protected String getAuthTokenValueForCurrentUser() {
        return AuthServiceUserLoginFilter.getAuthToken(this.globalVariableService.getUserSession());
    }

    @Override
    public boolean isServiceUser() {
        return Optional.ofNullable(AuthServiceUserLoginFilter.getIsServiceUser(this.globalVariableService.getUserSession())).orElse(false);
    }

    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }
}

