/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.excon.project;

import java.io.Serializable;
import java.util.List;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.excon.document.ExconProjectDocument;
import org.kuali.kra.excon.project.ExconProject;
import org.kuali.kra.excon.project.ExconProjectDestination;
import org.kuali.kra.excon.project.ExconProjectForm;
import org.kuali.kra.excon.rules.ExconProjectDestinationAddRuleImpl;
import org.kuali.rice.krad.service.BusinessObjectService;

public class ExconProjectDestinationsBean
implements Serializable {
    private static final long serialVersionUID = 234563457L;
    protected ExconProjectDestination newDestination;
    protected ExconProjectForm exconProjectForm;
    private transient BusinessObjectService businessObjectService;

    public ExconProjectDestinationsBean(ExconProjectForm exconProjectForm) {
        this.exconProjectForm = exconProjectForm;
        this.init();
    }

    public void addExconProjectDestination() {
        boolean success = new ExconProjectDestinationAddRuleImpl().processAddExconProjectDestinationBusinessRules(this.getExconProject(), this.getNewDestination());
        if (success) {
            this.getExconProject().add(this.getExconProjectDestination());
            this.init();
        }
    }

    public void deleteExconProjectDestination(int lineToDelete) {
        this.deleteExconProjectDestination(this.getExconProjectDestinations(), lineToDelete);
    }

    public ExconProjectDestination getNewDestination() {
        return this.newDestination;
    }

    public ExconProjectDestination getExconProjectDestination() {
        return this.newDestination;
    }

    public List<ExconProjectDestination> getExconProjectDestinations() {
        return ((ExconProjectDocument)this.exconProjectForm.getDocument()).getExconProject().getExconProjectDestinations();
    }

    public int getExconProjectDestinationsCount() {
        return this.getExconProjectDestinations().size();
    }

    protected void deleteExconProjectDestination(List<ExconProjectDestination> destinations, int lineToDelete) {
        if (destinations.size() > lineToDelete) {
            ExconProjectDestination foundDestination = destinations.get(lineToDelete);
            this.getExconProject().getExconProjectDestinations().remove(foundDestination);
        }
    }

    protected void init() {
        this.newDestination = new ExconProjectDestination();
    }

    protected ExconProject getExconProject() {
        return this.getDocument().getExconProject();
    }

    protected ExconProjectDocument getDocument() {
        return this.exconProjectForm.getExconProjectDocument();
    }

    protected BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KcServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }

    void setBusinessObjectService(BusinessObjectService bos) {
        this.businessObjectService = bos;
    }
}

