/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.submit;

import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.print.watermark.Watermark;
import org.kuali.coeus.sys.framework.rule.KcMaintenanceDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

public class ValidWatermarkStatusMaintenanceDocumentRule
extends KcMaintenanceDocumentRuleBase {
    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        return this.isDocumentValidForSave(document);
    }

    public boolean processCustomSaveDocumentBusinessRules(MaintenanceDocument document) {
        return this.isDocumentValidForSave(document);
    }

    public boolean processCustomApproveDocumentBusinessRules(MaintenanceDocument document) {
        return this.isDocumentValidForSave(document);
    }

    public boolean isDocumentValidForSave(MaintenanceDocument document) {
        boolean result = super.isDocumentValidForSave(document);
        Watermark watermark = (Watermark)document.getNewMaintainableObject().getDataObject();
        if (watermark.getWatermarkType().equalsIgnoreCase("TEXT") && watermark.getWatermarkText() == null) {
            MessageMap errorMap = GlobalVariables.getMessageMap();
            errorMap.putError("document.newMaintainableObject.watermarkText", "error.watermark.text.required", new String[0]);
            result = false;
        }
        if (!document.getNewMaintainableObject().getMaintenanceAction().equals("Delete")) {
            if (document.getNewMaintainableObject().getMaintenanceAction().equals("Edit")) {
                Watermark oldWatermarkDocument = (Watermark)document.getOldMaintainableObject().getDataObject();
                if (watermark.getWatermarkType().equalsIgnoreCase("IMAGE") && watermark.getWatermarkText() == null) {
                    result = true;
                }
                if (!oldWatermarkDocument.getStatusCode().equals(watermark.getStatusCode())) {
                    result &= this.validateWatermarkStatusCode(watermark.getStatusCode(), watermark.getGroupName());
                }
            } else {
                result &= this.validateWatermarkStatusCode(watermark.getStatusCode(), watermark.getGroupName());
            }
        } else {
            result = true;
        }
        return result;
    }

    private boolean validateWatermarkStatusCode(String watermarkStatusCode, String watermarkGroupName) {
        boolean valid = true;
        if (watermarkStatusCode != null && StringUtils.isNotBlank((CharSequence)watermarkStatusCode) && watermarkGroupName != null && StringUtils.isNotBlank((CharSequence)watermarkGroupName)) {
            HashMap<String, String> pkMap = new HashMap<String, String>();
            pkMap.put("statusCode", watermarkStatusCode);
            pkMap.put("groupName", watermarkGroupName);
            int watermarkMatchingCount = KcServiceLocator.getService(BusinessObjectService.class).countMatching(Watermark.class, pkMap);
            if (watermarkMatchingCount > 0) {
                MessageMap errorMap = GlobalVariables.getMessageMap();
                errorMap.putError("document.newMaintainableObject.statusCode", "error.watermark.statuscode.exists", new String[]{watermarkStatusCode});
                valid = false;
            }
        }
        return valid;
    }
}

