/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.framework.version;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.core.BudgetParent;
import org.kuali.coeus.common.budget.framework.version.AddBudgetVersionEvent;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.util.GlobalVariables;
import org.springframework.util.StringUtils;

public abstract class BudgetVersionRule {
    private static final Logger LOG = LogManager.getLogger(BudgetVersionRule.class);

    protected boolean processAddBudgetVersionName(AddBudgetVersionEvent event) {
        boolean retval = true;
        if (!this.isNameValid(event.getVersionName())) {
            retval = false;
            GlobalVariables.getMessageMap().putError("document.parentDocument.budgetDocumentVersion", "error.budgetVersion.documentDescription.required", new String[]{"Name"});
        }
        if (this.containsVersionName(event.getBudgetParent().getBudgets(), event.getVersionName())) {
            retval = false;
            GlobalVariables.getMessageMap().putError("document.parentDocument.budgetDocumentVersion", "error.budgetVersion.exists", new String[0]);
        }
        return retval;
    }

    protected boolean isNameValid(String newBudgetVersionName) {
        return StringUtils.hasText((String)newBudgetVersionName);
    }

    protected boolean containsVersionName(List<? extends Budget> existingBudgets, String versionName) {
        for (Budget budget : existingBudgets) {
            LOG.info("Comparing " + budget.getName() + " to " + versionName);
            if (!budget.getName().equals(versionName)) continue;
            return true;
        }
        return false;
    }

    public boolean processAddBudgetVersion(AddBudgetVersionEvent event) throws WorkflowException {
        BudgetParent budgetParent = event.getBudgetParent();
        boolean success = true;
        if (budgetParent.getRequestedStartDateInitial() == null) {
            GlobalVariables.getMessageMap().putError(event.getErrorPath(), "error.budgetVersion.startDate.required", new String[]{"Name"});
            success &= false;
        }
        if (budgetParent.getRequestedEndDateInitial() == null) {
            GlobalVariables.getMessageMap().putError(event.getErrorPath(), "error.budgetVersion.endDate.required", new String[]{"Name"});
            success &= false;
        }
        return success;
    }
}

