/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.committee.impl.lookup.keyvalue;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.committee.impl.bo.CommitteeBase;
import org.kuali.coeus.common.committee.impl.document.CommitteeDocumentBase;
import org.kuali.coeus.common.framework.auth.UnitAuthorizationService;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.coeus.common.framework.unit.UnitService;
import org.kuali.coeus.sys.framework.keyvalue.KeyValueComparator;
import org.kuali.coeus.sys.framework.keyvalue.PrefixValuesFinder;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.uif.control.UifKeyValuesFinderBase;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class CommitteeIdByUnitValuesFinderBase<CMT extends CommitteeBase<CMT, ?, ?>>
extends UifKeyValuesFinderBase {
    private static final long serialVersionUID = -3005003472800028011L;
    private String protocolLeadUnit;
    private String docRouteStatus;
    private String currentCommitteeId;
    public static final String FINAL_STATUS_CD = "F";
    private Set<String> unitIds = new HashSet<String>();
    private List<KeyValue> keyValues = new ArrayList<KeyValue>();
    private boolean initialized = false;
    private UnitAuthorizationService unitAuthorizationService;
    private UnitService unitService;
    private BusinessObjectService businessObjectService;

    public void initializeKeyValueList() {
        Collection<CMT> candidateCommittees = this.getCandidateCommittees();
        if (CollectionUtils.isNotEmpty(candidateCommittees)) {
            if (this.isSaved()) {
                this.getProtocolUnitIds();
                for (CommitteeBase committee : candidateCommittees) {
                    if (!StringUtils.equalsIgnoreCase((CharSequence)((CommitteeDocumentBase)committee.getCommitteeDocument()).getDocStatusCode(), (CharSequence)FINAL_STATUS_CD) || !this.unitIds.contains(committee.getHomeUnit().getUnitNumber())) continue;
                    this.keyValues.add((KeyValue)new ConcreteKeyValue(committee.getCommitteeId(), committee.getCommitteeName()));
                }
            } else {
                String principalId = GlobalVariables.getUserSession().getPerson().getPrincipalId();
                for (CommitteeBase candidateCommittee : candidateCommittees) {
                    if (!this.isCurrentUserAuthorizedToAssignThisCommittee(principalId, candidateCommittee) && !candidateCommittee.getCommitteeId().equals(this.getCurrentCommitteeId())) continue;
                    this.keyValues.add((KeyValue)new ConcreteKeyValue(candidateCommittee.getCommitteeId(), candidateCommittee.getCommitteeName()));
                }
            }
            Collections.sort(this.keyValues, new KeyValueComparator());
        }
        this.initialized = true;
    }

    private Collection<CMT> getCandidateCommittees() {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("committeeTypeCode", this.getCommitteeTypeCodeHook());
        Collection allCommittees = this.getBusinessObjectService().findMatching(this.getCommitteeBOClassHook(), criteria);
        HashMap<String, CommitteeBase> committeeMap = new HashMap<String, CommitteeBase>();
        CommitteeBase tmpComm = null;
        for (CommitteeBase comm : allCommittees) {
            if (!FINAL_STATUS_CD.equalsIgnoreCase(((CommitteeDocumentBase)comm.getCommitteeDocument()).getDocStatusCode())) continue;
            if (committeeMap.containsKey(comm.getCommitteeId())) {
                tmpComm = (CommitteeBase)committeeMap.get(comm.getCommitteeId());
                if (comm.getSequenceNumber() <= tmpComm.getSequenceNumber()) continue;
                committeeMap.put(comm.getCommitteeId(), comm);
                continue;
            }
            committeeMap.put(comm.getCommitteeId(), comm);
        }
        return committeeMap.values();
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    private BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KcServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }

    protected abstract Class<CMT> getCommitteeBOClassHook();

    protected abstract String getCommitteeTypeCodeHook();

    protected boolean isCurrentUserAuthorizedToAssignThisCommittee(String userId, CMT candidateCommittee) {
        String permissionNamespace = this.getAssignCommitteePermissionNamespaceHook();
        String permissionName = this.getAssignCommitteePermissionNameHook();
        boolean retVal = this.getUnitAuthorizationService().hasPermission(userId, ((CommitteeBase)candidateCommittee).getHomeUnitNumber(), permissionNamespace, permissionName);
        return retVal;
    }

    protected abstract String getAssignCommitteePermissionNamespaceHook();

    protected abstract String getAssignCommitteePermissionNameHook();

    protected UnitAuthorizationService getUnitAuthorizationService() {
        if (this.unitAuthorizationService == null) {
            this.unitAuthorizationService = KcServiceLocator.getService(UnitAuthorizationService.class);
        }
        return this.unitAuthorizationService;
    }

    public void setUnitAuthorizationService(UnitAuthorizationService unitAuthorizationService) {
        this.unitAuthorizationService = unitAuthorizationService;
    }

    private boolean isSaved() {
        return this.getDocRouteStatus().equals("S");
    }

    private void getProtocolUnitIds() {
        if (StringUtils.isNotBlank((CharSequence)this.protocolLeadUnit)) {
            this.unitIds.add(this.protocolLeadUnit);
            List<Unit> subUnits = this.getUnitService().getAllSubUnits(this.protocolLeadUnit);
            for (Unit unit : subUnits) {
                this.unitIds.add(unit.getUnitNumber());
            }
            String topUnitNumber = this.getUnitService().getTopUnit().getUnitNumber();
            this.getParentUnitIds(this.protocolLeadUnit, topUnitNumber);
        }
    }

    private void getParentUnitIds(String currentUnitNumber, String topUnitNumber) {
        if (currentUnitNumber.equals(topUnitNumber)) {
            return;
        }
        String parentUnitNumber = this.getUnitService().getUnit(currentUnitNumber).getParentUnitNumber();
        Unit parentUnit = this.getUnitService().getUnit(parentUnitNumber);
        this.unitIds.add(parentUnit.getUnitNumber());
        this.getParentUnitIds(parentUnit.getUnitNumber(), topUnitNumber);
    }

    protected UnitService getUnitService() {
        if (this.unitService == null) {
            this.unitService = KcServiceLocator.getService(UnitService.class);
        }
        return this.unitService;
    }

    public void setUnitService(UnitService unitService) {
        this.unitService = unitService;
    }

    public String getProtocolLeadUnit() {
        return this.protocolLeadUnit;
    }

    public void setProtocolLeadUnit(String protocolLeadUnit) {
        this.protocolLeadUnit = protocolLeadUnit;
    }

    public String getDocRouteStatus() {
        return this.docRouteStatus;
    }

    public void setDocRouteStatus(String docRouteStatus) {
        this.docRouteStatus = docRouteStatus;
    }

    public String getCurrentCommitteeId() {
        return this.currentCommitteeId;
    }

    public void setCurrentCommitteeId(String currentCommitteeId) {
        this.currentCommitteeId = currentCommitteeId;
    }

    public List<KeyValue> getKeyValues() {
        if (!this.initialized) {
            this.initializeKeyValueList();
        }
        this.keyValues.add(0, (KeyValue)new ConcreteKeyValue(PrefixValuesFinder.getPrefixKey(), PrefixValuesFinder.getDefaultPrefixValue()));
        return this.keyValues;
    }
}

