/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.committee.impl.meeting;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.coeus.common.committee.impl.bo.CommitteeBase;
import org.kuali.coeus.common.committee.impl.bo.CommitteeScheduleBase;
import org.kuali.coeus.common.committee.impl.document.CommitteeDocumentBase;
import org.kuali.coeus.common.committee.impl.meeting.CommScheduleMinuteDocBase;
import org.kuali.coeus.common.committee.impl.meeting.GeneratedMeetingDocBase;
import org.kuali.coeus.common.committee.impl.meeting.MeetingActionBase;
import org.kuali.coeus.common.committee.impl.meeting.MeetingFormBase;
import org.kuali.coeus.common.committee.impl.meeting.MeetingHelperBase;
import org.kuali.coeus.common.committee.impl.meeting.ScheduleAgendaBase;
import org.kuali.coeus.common.committee.impl.print.CommitteeReportType;
import org.kuali.coeus.common.committee.impl.print.service.CommitteePrintingServiceBase;
import org.kuali.coeus.common.committee.impl.rule.event.CommitteeActionPrintCommitteeDocumentEvent;
import org.kuali.coeus.common.committee.impl.service.CommonCommitteeNotificationService;
import org.kuali.coeus.common.framework.print.AbstractPrint;
import org.kuali.coeus.common.framework.print.AttachmentDataSource;
import org.kuali.coeus.common.framework.print.Printable;
import org.kuali.coeus.common.framework.print.util.PrintingUtils;
import org.kuali.coeus.common.questionnaire.framework.print.CorrespondencePrintingService;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.meeting.CommScheduleMinuteDoc;
import org.kuali.kra.meeting.ScheduleAgenda;
import org.kuali.kra.protocol.correspondence.ProtocolCorrespondence;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.event.DocumentEvent;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class MeetingActionsActionBase
extends MeetingActionBase {
    public ActionForward generateAgenda(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward = mapping.findForward("basic");
        MeetingHelperBase meetingHelper = ((MeetingFormBase)form).getMeetingHelper();
        List<Printable> printableArtifactList = this.getPrintableArtifacts(meetingHelper, this.getProtocolCorrespondenceAgendaTypeCodeHook());
        if (printableArtifactList.get(0).getXSLTemplates().isEmpty()) {
            GlobalVariables.getMessageMap().putError("meetingHelper.scheduleAgenda", "error.protocol.correspondence.template.not.set", new String[0]);
        } else {
            AttachmentDataSource dataStream = this.getCommitteePrintingService().print(printableArtifactList);
            if (dataStream.getData() != null && dataStream.getData().length > 0) {
                this.setFileDataProperties(dataStream, meetingHelper.getCommitteeSchedule().getId(), "Agenda");
                ScheduleAgendaBase agenda = this.getNewScheduleAgendaInstanceHook();
                int agendaNumber = meetingHelper.getScheduleAgendas().size() + 1;
                agenda.setAgendaName("Agenda For Schedule #  " + meetingHelper.getCommitteeSchedule().getId() + " Version " + agendaNumber);
                agenda.setAgendaNumber(agendaNumber);
                this.saveGeneratedDoc(meetingHelper.getCommitteeSchedule().getId(), agenda, dataStream.getData());
                meetingHelper.setAgendaGenerationDate(new Date(agenda.getCreateTimestamp().getTime()));
                meetingHelper.getScheduleAgendas().add(agenda);
            }
        }
        return actionForward;
    }

    protected abstract ScheduleAgendaBase getNewScheduleAgendaInstanceHook();

    protected abstract String getProtocolCorrespondenceAgendaTypeCodeHook();

    private List<Printable> getPrintableArtifacts(MeetingHelperBase meetingHelper, String protocolCorrespondenceTypeCode) {
        Object committee = meetingHelper.getCommitteeSchedule().getParentCommittee();
        AbstractPrint printable = this.getCommitteePrintingService().getCommitteePrintable(CommitteeReportType.SCHEDULE_TEMPLATE, ((CommitteeBase)committee).getCommitteeId());
        printable.setPrintableBusinessObject(meetingHelper.getCommitteeSchedule());
        HashMap<String, Object> reportParameters = new HashMap<String, Object>();
        reportParameters.put("committeeId", ((CommitteeBase)committee).getCommitteeId());
        reportParameters.put("scheduleId", meetingHelper.getCommitteeSchedule().getScheduleId());
        reportParameters.put("protoCorrespTypeCode", protocolCorrespondenceTypeCode);
        printable.setReportParameters(reportParameters);
        ArrayList<Printable> printableArtifactList = new ArrayList<Printable>();
        printableArtifactList.add(printable);
        return printableArtifactList;
    }

    private void setFileDataProperties(AttachmentDataSource dataStream, Long scheduleId, String type) {
        String fileName = type + "-For-Schedule-" + scheduleId + ".pdf";
        try {
            dataStream.setName(URLEncoder.encode(fileName, StandardCharsets.UTF_8.name()));
        }
        catch (UnsupportedEncodingException e) {
            dataStream.setName(fileName);
        }
        dataStream.setType("application/pdf");
    }

    public ActionForward generateMinutes(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward = mapping.findForward("basic");
        MeetingHelperBase meetingHelper = ((MeetingFormBase)form).getMeetingHelper();
        List<Printable> printableArtifactList = this.getPrintableArtifacts(meetingHelper, this.getProtocolCorrespondenceMinutesTypeCodeHook());
        if (printableArtifactList.get(0).getXSLTemplates().isEmpty()) {
            GlobalVariables.getMessageMap().putError("meetingHelper.meetingMinute", "error.protocol.correspondence.template.not.set", new String[0]);
        } else {
            AttachmentDataSource dataStream = this.getCommitteePrintingService().print(printableArtifactList);
            if (dataStream.getData() != null && dataStream.getData().length > 0) {
                this.setFileDataProperties(dataStream, meetingHelper.getCommitteeSchedule().getId(), "Minute");
                CommScheduleMinuteDocBase minuteDoc = this.getNewCommScheduleMinuteDocInstanceHook();
                minuteDoc.setMinuteName("Minute For Schedule #  " + meetingHelper.getCommitteeSchedule().getId() + " Version " + (meetingHelper.getMinuteDocs().size() + 1));
                minuteDoc.setMinuteNumber(meetingHelper.getMinuteDocs().size() + 1);
                this.saveGeneratedDoc(meetingHelper.getCommitteeSchedule().getId(), minuteDoc, dataStream.getData());
                meetingHelper.getMinuteDocs().add(minuteDoc);
            }
        }
        return actionForward;
    }

    protected abstract CommScheduleMinuteDocBase getNewCommScheduleMinuteDocInstanceHook();

    protected abstract String getProtocolCorrespondenceMinutesTypeCodeHook();

    private void saveGeneratedDoc(Long scheduleId, GeneratedMeetingDocBase generatedMeetingDoc, byte[] pdfData) {
        generatedMeetingDoc.setScheduleIdFk(scheduleId);
        generatedMeetingDoc.setCreateTimestamp(((DateTimeService)KcServiceLocator.getService("dateTimeService")).getCurrentTimestamp());
        generatedMeetingDoc.setCreateUser(GlobalVariables.getUserSession().getPrincipalName());
        generatedMeetingDoc.setPdfStore(pdfData);
        this.getBusinessObjectService().save((PersistableBusinessObject)generatedMeetingDoc);
    }

    protected abstract CommitteePrintingServiceBase getCommitteePrintingService();

    public ActionForward viewAgenda(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int selection = this.getSelectedLine(request);
        MeetingHelperBase meetingHelper = ((MeetingFormBase)form).getMeetingHelper();
        PrintableAttachment source = new PrintableAttachment();
        String scheduleId = request.getParameter("scheduleId");
        if (scheduleId != null && scheduleId.length() > 0) {
            Long schedule_id = Long.parseLong(scheduleId);
            List<ScheduleAgenda> scheduleAgendas = this.getAgendaDoc(schedule_id);
            String selectedLine = request.getParameter("line");
            if (selectedLine != null && selectedLine.length() > 0) {
                selection = Integer.parseInt(selectedLine);
                source.setData(scheduleAgendas.get(selection).getPdfStore());
            }
        } else {
            source.setData(meetingHelper.getScheduleAgendas().get(selection).getPdfStore());
        }
        source.setType("application/pdf");
        source.setName("ScheduleAgendaBase.pdf");
        if (source.getData() != null) {
            PrintingUtils.streamToResponse(source, response);
            return null;
        }
        return mapping.findForward("basic");
    }

    private List<ScheduleAgenda> getAgendaDoc(Long scheduleId) {
        HashMap<String, Long> fieldValues = new HashMap<String, Long>();
        fieldValues.put("scheduleIdFk", scheduleId);
        return (List)KcServiceLocator.getService(BusinessObjectService.class).findMatchingOrderBy(ScheduleAgenda.class, fieldValues, "createTimestamp", true);
    }

    public ActionForward sendAgendaNotification(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int selection = this.getSelectedLine(request);
        ScheduleAgendaBase agenda = ((MeetingFormBase)form).getMeetingHelper().getScheduleAgendas().get(selection);
        this.getCommitteeNotificationService().generateNotification("213", agenda);
        return mapping.findForward("basic");
    }

    public ActionForward viewMinute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int selection = this.getSelectedLine(request);
        MeetingHelperBase meetingHelper = ((MeetingFormBase)form).getMeetingHelper();
        PrintableAttachment source = new PrintableAttachment();
        String scheduleId = request.getParameter("scheduleId");
        if (scheduleId != null) {
            String selectedLine = request.getParameter("line");
            selection = Integer.parseInt(selectedLine);
            Long schedule_Id = Long.parseLong(scheduleId);
            List<CommScheduleMinuteDoc> commScheduleMinutes = this.getMinuteDoc(schedule_Id);
            source.setData(commScheduleMinutes.get(selection).getPdfStore());
        } else {
            source.setData(meetingHelper.getMinuteDocs().get(selection).getPdfStore());
        }
        source.setType("application/pdf");
        source.setName("MeetingMinute.pdf");
        PrintingUtils.streamToResponse(source, response);
        return null;
    }

    private List<CommScheduleMinuteDoc> getMinuteDoc(Long scheduleId) {
        HashMap<String, Long> fieldValues = new HashMap<String, Long>();
        fieldValues.put("scheduleIdFk", scheduleId);
        return (List)KcServiceLocator.getService(BusinessObjectService.class).findMatchingOrderBy(CommScheduleMinuteDoc.class, fieldValues, "createTimestamp", true);
    }

    public ActionForward sendMinutesNotification(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int selection = this.getSelectedLine(request);
        MeetingHelperBase meetingHelper = ((MeetingFormBase)form).getMeetingHelper();
        CommScheduleMinuteDocBase minuteDoc = meetingHelper.getMinuteDocs().get(selection);
        this.getCommitteeNotificationService().generateNotification("215", minuteDoc);
        return mapping.findForward("basic");
    }

    public ActionForward viewCorrespondence(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int selection = this.getSelectedLine(request);
        MeetingHelperBase meetingHelper = ((MeetingFormBase)form).getMeetingHelper();
        PrintableAttachment source = new PrintableAttachment();
        source.setData(meetingHelper.getCorrespondences().get(selection).getCorrespondence());
        source.setType("application/pdf");
        source.setName("Correspondence-" + meetingHelper.getCorrespondences().get(selection).getProtocolCorrespondenceType().getDescription() + ".pdf");
        PrintingUtils.streamToResponse(source, response);
        return null;
    }

    public ActionForward printRosterFutureSchedule(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward = mapping.findForward("basic");
        MeetingFormBase committeeForm = (MeetingFormBase)form;
        MeetingHelperBase meetingHelper = committeeForm.getMeetingHelper();
        CommitteeScheduleBase<?, ?, ?, ?> committeeSchedule = meetingHelper.getCommitteeSchedule();
        CommitteeDocumentBase document = (CommitteeDocumentBase)this.getDocumentService().getByDocumentHeaderId(((CommitteeBase)committeeSchedule.getParentCommittee()).getCommitteeDocument().getDocumentNumber());
        Boolean printRooster = meetingHelper.getPrintRooster();
        Boolean printFutureScheduledMeeting = meetingHelper.getPrintFutureScheduledMeeting();
        List<Printable> correspondencePrintables = this.getCorrespondencePrintingService().getCorrespondencePrintable(committeeSchedule, meetingHelper.getCorrespondencesToPrint());
        Boolean printCorrespondences = !correspondencePrintables.isEmpty();
        CommitteeActionPrintCommitteeDocumentEvent event = new CommitteeActionPrintCommitteeDocumentEvent("", (Document)document, printRooster, printFutureScheduledMeeting, true);
        event.setPrintCorrespondence(printCorrespondences);
        if (this.applyRules((DocumentEvent)event)) {
            AbstractPrint printable;
            ArrayList<Printable> printableArtifactList = new ArrayList<Printable>();
            if (printRooster.booleanValue()) {
                printable = this.getCommitteePrintingService().getCommitteePrintable(CommitteeReportType.ROSTER, ((CommitteeBase)document.getCommittee()).getCommitteeId());
                printable.setPrintableBusinessObject((KcPersistableBusinessObjectBase)document.getCommittee());
                ((CommitteeBase)document.getCommittee()).setPrintRooster(printRooster);
                printableArtifactList.add(printable);
                meetingHelper.setPrintRooster(false);
            }
            if (printFutureScheduledMeeting.booleanValue()) {
                printable = this.getCommitteePrintingService().getCommitteePrintable(CommitteeReportType.FUTURE_SCHEDULED_MEETINGS, ((CommitteeBase)document.getCommittee()).getCommitteeId());
                printable.setPrintableBusinessObject((KcPersistableBusinessObjectBase)document.getCommittee());
                printableArtifactList.add(printable);
                ((CommitteeBase)document.getCommittee()).setPrintRooster(printFutureScheduledMeeting);
                meetingHelper.setPrintFutureScheduledMeeting(false);
            }
            printableArtifactList.addAll(correspondencePrintables);
            AttachmentDataSource dataStream = this.getCommitteePrintingService().print(printableArtifactList);
            if (dataStream.getData() != null) {
                PrintingUtils.streamToResponse(dataStream, response);
                actionForward = null;
            }
        }
        return actionForward;
    }

    protected abstract CorrespondencePrintingService getCorrespondencePrintingService();

    private CommonCommitteeNotificationService getCommitteeNotificationService() {
        return KcServiceLocator.getService(CommonCommitteeNotificationService.class);
    }

    private DocumentService getDocumentService() {
        return KcServiceLocator.getService(DocumentService.class);
    }

    public abstract ActionForward regenerateCorrespondence(ActionMapping var1, ActionForm var2, HttpServletRequest var3, HttpServletResponse var4) throws Exception;

    public ActionForward viewGeneratedCorrespondence(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int selection = this.getSelectedLine(request);
        MeetingHelperBase meetingHelper = ((MeetingFormBase)form).getMeetingHelper();
        PrintableAttachment source = new PrintableAttachment();
        ProtocolCorrespondence correspondence = meetingHelper.getRegeneratedCorrespondences().get(selection);
        source.setData(correspondence.getCorrespondence());
        source.setType("application/pdf");
        source.setName("Correspondence-" + correspondence.getProtocolCorrespondenceType().getDescription() + ".pdf");
        PrintingUtils.streamToResponse(source, response);
        return null;
    }

    public ActionForward saveCorrespondence(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.correspondenceAction(mapping, form, true);
    }

    public ActionForward closeCorrespondence(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.correspondenceAction(mapping, form, false);
    }

    private ActionForward correspondenceAction(ActionMapping mapping, ActionForm form, boolean saveAction) {
        MeetingFormBase meetingForm = (MeetingFormBase)form;
        MeetingHelperBase meetingHelper = meetingForm.getMeetingHelper();
        List<ProtocolCorrespondence> correspondences = meetingHelper.getRegeneratedCorrespondences();
        if (saveAction) {
            for (ProtocolCorrespondence correspondence : correspondences) {
                if (!correspondence.getFinalFlag()) continue;
                correspondence.setFinalFlagTimestamp(KcServiceLocator.getService(DateTimeService.class).getCurrentTimestamp());
            }
            this.getBusinessObjectService().save(correspondences);
        }
        for (ProtocolCorrespondence protocolCorrespondence : meetingHelper.getCorrespondences()) {
            protocolCorrespondence.setRegenerateFlag(false);
        }
        return mapping.findForward("actions");
    }

    public class PrintableAttachment
    extends AttachmentDataSource {
    }
}

