/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.impl.workflow.action;

import java.util.Collections;
import java.util.List;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.kew.actionrequest.ActionRequestFactory;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.actions.ReturnToPreviousNodeAction;
import org.kuali.rice.kew.api.action.ActionRequestPolicy;
import org.kuali.rice.kew.engine.node.RouteNode;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.identity.principal.PrincipalContract;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.role.RoleService;

public class KcReturnToPreviousNodeAction
extends ReturnToPreviousNodeAction {
    public KcReturnToPreviousNodeAction(DocumentRouteHeaderValue routeHeader, Principal principal, String annotation, String destinationNodeName, boolean b) {
        super(routeHeader, (PrincipalContract)principal, annotation, destinationNodeName, b);
    }

    public void processReturnToInitiator(RouteNodeInstance newNodeInstance) {
        RouteNode initialNode = newNodeInstance.getRouteNode().getDocumentType().getPrimaryProcess().getInitialRouteNode();
        if (initialNode != null && newNodeInstance.getRouteNode().getRouteNodeId().equals(initialNode.getRouteNodeId())) {
            LOG.debug("Document was returned to initiator");
            ActionRequestFactory arFactory = new ActionRequestFactory(this.getRouteHeader(), newNodeInstance);
            String actionRequestCode = this.getReturnToInitiatorActionRequestType().getCode();
            Role aggregatorRole = this.getRoleService().getRoleByNamespaceCodeAndName("KC-PD", "Aggregator Document Level");
            List memberships = this.getRoleService().getRoleMembers(Collections.singletonList(aggregatorRole.getId()), Collections.singletonMap("documentNumber", newNodeInstance.getDocumentId()));
            if (memberships != null && !memberships.isEmpty()) {
                ActionRequestValue roleMemberRequest = arFactory.addKimRoleRequest(actionRequestCode, Integer.valueOf(1), aggregatorRole, memberships, "Aggregators Request for Review", "0", true, ActionRequestPolicy.FIRST.getCode(), null, false);
                roleMemberRequest.setAnnotation("Aggregators Request for Review");
                roleMemberRequest.getChildrenRequests().forEach(actionRequest -> actionRequest.setAnnotation("Aggregators Request for Review"));
                this.getActionRequestService().activateRequest(roleMemberRequest);
            }
        }
    }

    protected RoleService getRoleService() {
        return KcServiceLocator.getService(RoleService.class);
    }
}

