/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.auth;

import java.util.Collections;
import org.kuali.coeus.sys.framework.workflow.KcWorkflowService;
import org.kuali.kra.iacuc.IacucProtocol;
import org.kuali.kra.iacuc.auth.IacucProtocolAuthorizer;
import org.kuali.kra.iacuc.auth.IacucProtocolTask;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.kew.api.action.ActionRequest;
import org.kuali.rice.kew.api.action.RoutingReportCriteria;
import org.kuali.rice.kew.api.action.WorkflowDocumentActionsService;
import org.kuali.rice.kew.api.document.DocumentDetail;
import org.kuali.rice.krad.document.Document;

public class IacucProtocolAssignReviewersCmtSelAuthorizer
extends IacucProtocolAuthorizer {
    private KcWorkflowService kraWorkflowService;

    @Override
    public boolean isAuthorized(String userId, IacucProtocolTask task) {
        IacucProtocol protocol = task.getProtocol();
        return (this.isOnNode(protocol) || this.willBeOnNode(userId, protocol)) && this.hasPermission(userId, protocol, "Perform IACUC Actions on Protocol");
    }

    public boolean isOnNode(IacucProtocol protocol) {
        return this.kraWorkflowService.isDocumentOnNode((Document)protocol.getProtocolDocument(), "IACUCReview");
    }

    public boolean willBeOnNode(String userId, IacucProtocol protocol) {
        boolean results = true;
        RoutingReportCriteria.Builder reportCriteriaBuilder = RoutingReportCriteria.Builder.createByDocumentId((String)protocol.getProtocolDocument().getDocumentNumber());
        reportCriteriaBuilder.setTargetPrincipalIds(Collections.singletonList(userId));
        WorkflowDocumentActionsService info = (WorkflowDocumentActionsService)GlobalResourceLoader.getService((String)"rice.kew.workflowDocumentActionsService");
        try {
            DocumentDetail results1 = info.executeSimulation(reportCriteriaBuilder.build());
            for (ActionRequest actionRequest : results1.getActionRequests()) {
                if (!"DepartmentReview".equals(actionRequest.getNodeName())) continue;
                results = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return results;
    }

    protected KcWorkflowService getKraWorkflowService() {
        return this.kraWorkflowService;
    }

    public void setKraWorkflowService(KcWorkflowService kraWorkflowService) {
        this.kraWorkflowService = kraWorkflowService;
    }
}

