/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.auth;

import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.sys.framework.workflow.KcWorkflowService;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.irb.auth.ProtocolAuthorizer;
import org.kuali.kra.irb.auth.ProtocolTask;
import org.kuali.rice.krad.document.Document;

public class ProtocolAssignReviewersAuthorizer
extends ProtocolAuthorizer {
    private KcWorkflowService kraWorkflowService;

    @Override
    public boolean isAuthorized(String username, ProtocolTask task) {
        Protocol protocol = task.getProtocol();
        ProtocolSubmission submission = this.findSubmission(protocol);
        return this.isOnNode(protocol) && this.isPendingOrSubmittedToCommittee(protocol) && (this.canPerformActionOnExpedited(protocol) || this.isScheduleRequiredForReview(submission) && this.isAssignedToCommitteeAndSchedule(submission) || !this.isScheduleRequiredForReview(submission) && this.isAssignedToCommittee(submission)) && this.hasPermission(username, protocol, "Perform IRB Actions on a Protocol");
    }

    public boolean isOnNode(Protocol protocol) {
        return this.kraWorkflowService.isCurrentNode((Document)protocol.getProtocolDocument(), "IRBReview");
    }

    private boolean isPendingOrSubmittedToCommittee(Protocol protocol) {
        return this.findSubmission(protocol) != null;
    }

    private boolean isAssignedToCommittee(ProtocolSubmission submission) {
        return !StringUtils.isBlank((CharSequence)submission.getCommitteeId());
    }

    private boolean isAssignedToCommitteeAndSchedule(ProtocolSubmission submission) {
        return !StringUtils.isBlank((CharSequence)submission.getCommitteeId()) && !StringUtils.isBlank((CharSequence)submission.getScheduleId());
    }

    private boolean isFullCommitteeReview(ProtocolSubmission submission) {
        return submission != null && "1".equals(submission.getProtocolReviewTypeCode());
    }

    private boolean isScheduleRequiredForReview(ProtocolSubmission submission) {
        return this.isFullCommitteeReview(submission) && StringUtils.isBlank((CharSequence)submission.getScheduleId());
    }

    public KcWorkflowService getKraWorkflowService() {
        return this.kraWorkflowService;
    }

    public void setKraWorkflowService(KcWorkflowService kraWorkflowService) {
        this.kraWorkflowService = kraWorkflowService;
    }
}

