/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.actions.submit;

import java.util.HashMap;
import org.kuali.coeus.common.committee.impl.meeting.CommitteeScheduleMinuteBase;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDao;
import org.kuali.kra.protocol.drools.brms.FactBean;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class ProtocolActionMappingBase
implements FactBean {
    protected static final String PROTOCOL_NUMBER = "protocolNumber";
    protected static final String SEQUENCE_NUMBER = "sequenceNumber";
    protected static final String SUBMISSION_NUMBER = "submissionNumber";
    protected BusinessObjectService businessObjectService;
    protected ProtocolDao<? extends ProtocolBase> dao;
    protected String submissionStatusCode;
    protected String submissionTypeCode;
    protected String protocolReviewTypeCode;
    protected String actionTypeCode;
    protected String protocolStatusCode;
    protected String scheduleId;
    protected ProtocolBase protocol;
    protected Integer submissionNumber;
    protected boolean allowed = false;

    public ProtocolActionMappingBase(String actionTypeCode, String submissionStatusCode, String submissionTypeCode, String protocolReviewTypeCode, String protocolStatusCode, String scheduleId, Integer submissionNumber) {
        this.actionTypeCode = actionTypeCode;
        this.submissionStatusCode = submissionStatusCode;
        this.submissionTypeCode = submissionTypeCode;
        this.protocolReviewTypeCode = protocolReviewTypeCode;
        this.protocolStatusCode = protocolStatusCode;
        this.scheduleId = scheduleId;
        this.submissionNumber = submissionNumber;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setDao(ProtocolDao<? extends ProtocolBase> dao) {
        this.dao = dao;
    }

    public void setProtocol(ProtocolBase protocol) {
        this.protocol = protocol;
    }

    public String getProtocolSubmissionScheduleId() {
        if (this.protocol.getProtocolSubmission() == null) {
            return null;
        }
        return this.protocol.getProtocolSubmission().getScheduleId();
    }

    public boolean getMinutesCount() {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put(PROTOCOL_NUMBER, this.protocol.getProtocolNumber());
        fieldValues.put(SUBMISSION_NUMBER, this.protocol.getProtocolSubmission().getSubmissionNumber());
        return this.businessObjectService.countMatching(this.getCommitteeScheduleMinuteBOClassHook(), fieldValues) > 0;
    }

    protected abstract Class<? extends CommitteeScheduleMinuteBase> getCommitteeScheduleMinuteBOClassHook();

    public abstract boolean getSubmissionCount();

    public abstract boolean getSubmissionCountCond2();

    public boolean getSubmissionCountCond3() {
        return this.dao.getProtocolSubmissionCountFromProtocol(this.protocol.getProtocolNumber());
    }

    public abstract boolean getSubmissionCountCond4();

    public abstract boolean getSubmissionCountCond5();

    public abstract boolean getSubmissionCountForWithdraw();

    public boolean getProtocolReviewerCountCond1() {
        return this.protocol.getProtocolSubmission().getProtocolReviewers().size() > 0;
    }

    public String getActionTypeCode() {
        return this.actionTypeCode;
    }

    public void setActionTypeCode(String actionTypeCode) {
        this.actionTypeCode = actionTypeCode;
    }

    public String getSubmissionStatusCode() {
        return this.submissionStatusCode;
    }

    public void setSubmissionStatusCode(String submissionStatusCode) {
        this.submissionStatusCode = submissionStatusCode;
    }

    public String getSubmissionTypeCode() {
        return this.submissionTypeCode;
    }

    public void setSubmissionTypeCode(String submissionTypeCode) {
        this.submissionTypeCode = submissionTypeCode;
    }

    public String getProtocolReviewTypeCode() {
        return this.protocolReviewTypeCode;
    }

    public void setProtocolReviewTypeCode(String protocolReviewTypeCode) {
        this.protocolReviewTypeCode = protocolReviewTypeCode;
    }

    public String getProtocolStatusCode() {
        return this.protocolStatusCode;
    }

    public void setProtocolStatusCode(String protocolStatusCode) {
        this.protocolStatusCode = protocolStatusCode;
    }

    public String getScheduleId() {
        return this.scheduleId;
    }

    public void setScheduleId(String scheduleId) {
        this.scheduleId = scheduleId;
    }

    public Integer getSubmissionNumber() {
        return this.submissionNumber;
    }

    public void setSubmissionNumber(Integer submissionNumber) {
        this.submissionNumber = submissionNumber;
    }

    public boolean isAllowed() {
        return this.allowed;
    }

    public void setAllowed(boolean allowed) {
        this.allowed = allowed;
    }

    public boolean isPrincipalInvestigator() {
        Person user = GlobalVariables.getUserSession().getPerson();
        boolean isPi = false;
        if (user.getPrincipalId().equals(this.protocol.getPrincipalInvestigator().getPersonId())) {
            isPi = true;
        }
        return isPi;
    }
}

