/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.framework.controller.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.CaseFormat;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import javax.xml.namespace.QName;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.sys.framework.config.KcConfigurer;
import org.kuali.coeus.sys.framework.controller.rest.RestBeanWrapperFactory;
import org.kuali.coeus.sys.framework.controller.rest.RestController;
import org.kuali.coeus.sys.framework.controller.rest.RestSimpleUrlHandlerMapping;
import org.kuali.coeus.sys.framework.controller.rest.audit.RestAuditLogger;
import org.kuali.coeus.sys.framework.controller.rest.audit.RestAuditLoggerFactory;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.persistence.PersistenceVerificationService;
import org.kuali.coeus.sys.framework.rest.DataDictionaryValidationException;
import org.kuali.coeus.sys.framework.rest.NotImplementedException;
import org.kuali.coeus.sys.framework.rest.ResourceNotFoundException;
import org.kuali.coeus.sys.framework.rest.UnauthorizedAccessException;
import org.kuali.coeus.sys.framework.rest.UnprocessableEntityException;
import org.kuali.coeus.sys.framework.validation.ErrorHandlingUtilService;
import org.kuali.rice.core.framework.config.module.ModuleConfigurer;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.data.CompoundKey;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.service.DictionaryValidationService;
import org.kuali.rice.krad.service.LegacyDataAdapter;
import org.kuali.rice.krad.util.MessageMap;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.TypeMismatchException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

public abstract class SimpleCrudRestControllerBase<T, R>
extends RestController
implements InitializingBean,
BeanNameAware {
    private static final Logger LOG = LogManager.getLogger(SimpleCrudRestControllerBase.class);
    private static final Predicate<Class<?>> ALWAYS_TRUE = o -> true;
    private static final String DELIMETER = ":";
    private static final String ALLOW_MULTI_PARM = "_allowMulti";
    private static final String SCHEMA_PARM = "_schema";
    private static final String BLUEPRINT_PARM = "_blueprint";
    protected static final String SYNTHETIC_FIELD_PK = "_primaryKey";
    @Autowired
    @Qualifier(value="legacyDataAdapter")
    private LegacyDataAdapter legacyDataAdapter;
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;
    @Autowired
    @Qualifier(value="permissionService")
    private PermissionService permissionService;
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;
    @Autowired
    @Qualifier(value="dictionaryValidationService")
    private DictionaryValidationService dictionaryValidationService;
    @Autowired
    @Qualifier(value="errorHandlingUtilService")
    private ErrorHandlingUtilService errorHandlingUtilService;
    @Autowired
    @Qualifier(value="persistenceVerificationService")
    private PersistenceVerificationService persistenceVerificationService;
    @Autowired
    @Qualifier(value="restAuditLoggerFactory")
    private RestAuditLoggerFactory restAuditLoggerFactory;
    @Autowired
    @Qualifier(value="autoRegisterMapping")
    private RestSimpleUrlHandlerMapping autoRegisterMapping;
    @Autowired
    @Qualifier(value="dataDictionaryService")
    private DataDictionaryService dataDictionaryService;
    @Autowired
    @Qualifier(value="restBeanWrapperFactory")
    private RestBeanWrapperFactory restBeanWrapperFactory;
    @Value(value="classpath:org/kuali/coeus/sys/framework/controller/rest/SimpleCrudRestControllerBlueprintTemplateGet.md")
    private Resource blueprintTemplateGet;
    @Value(value="classpath:org/kuali/coeus/sys/framework/controller/rest/SimpleCrudRestControllerBlueprintTemplatePut.md")
    private Resource blueprintTemplatePut;
    @Value(value="classpath:org/kuali/coeus/sys/framework/controller/rest/SimpleCrudRestControllerBlueprintTemplatePatch.md")
    private Resource blueprintTemplatePatch;
    @Value(value="classpath:org/kuali/coeus/sys/framework/controller/rest/SimpleCrudRestControllerBlueprintTemplatePost.md")
    private Resource blueprintTemplatePost;
    @Value(value="classpath:org/kuali/coeus/sys/framework/controller/rest/SimpleCrudRestControllerBlueprintTemplateDelete.md")
    private Resource blueprintTemplateDelete;
    @Autowired
    @Qualifier(value="moduleConfigurers")
    private Collection<ModuleConfigurer> moduleConfigurers;
    private String beanName;
    private boolean registerMapping = true;
    private BeanWrapper beanWrapper;
    private Class<T> dataObjectClazz;
    private String primaryKeyColumn;
    private String writePermissionTemplateNamespace;
    private String writePermissionTemplateName;
    private Map<String, String> writePermissionTemplateQualifiers;
    private String readPermissionTemplateNamespace;
    private String readPermissionTemplateName;
    private Map<String, String> readPermissionTemplateQualifiers;
    private String camelCasePluralName;
    private Set<RequestMethod> supportedMethods = Stream.of(RequestMethod.GET, RequestMethod.POST, RequestMethod.PUT, RequestMethod.DELETE, RequestMethod.PATCH).collect(Collectors.toSet());

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public Collection<R> getAll(@RequestParam(required=false) Map<String, String> parameters) {
        this.assertMethodSupported(RequestMethod.GET);
        this.assertUserHasReadAccess();
        return this.translateAllDataObjects(this.doGetAll(parameters));
    }

    @RequestMapping(method={RequestMethod.GET}, params={"_schema"})
    @ResponseBody
    public Map<String, Object> getSchema() {
        this.assertMethodSupported(RequestMethod.GET);
        return this.getSchemaMap();
    }

    public Map<String, Object> getSchemaMap() {
        HashMap<String, Object> schema = new HashMap<String, Object>();
        schema.put("primaryKey", this.getPrimaryKeyColumn());
        schema.put("columns", this.getExposedProperties());
        return schema;
    }

    @RequestMapping(value={"/{code}"}, method={RequestMethod.GET})
    @ResponseBody
    public R get(@PathVariable String code) {
        this.assertMethodSupported(RequestMethod.GET);
        this.assertUserHasReadAccess();
        T dataObject = this.getFromDataStore(code);
        if (dataObject == null) {
            throw new ResourceNotFoundException("not found for key " + code);
        }
        return this.convertDataObjectToDto(dataObject);
    }

    @RequestMapping(method={RequestMethod.GET}, params={"_blueprint"})
    @ResponseBody
    public Resource getBlueprint(HttpServletResponse response) {
        this.assertMethodSupported(RequestMethod.GET);
        response.setContentType("text/markdown");
        response.setHeader("Content-Disposition", "attachment;filename=" + (String)CaseFormat.UPPER_CAMEL.converterTo(CaseFormat.LOWER_HYPHEN).convert((Object)this.getCamelCasePluralName()) + ".md");
        return this.getBlueprintResource();
    }

    public Resource getBlueprintResource() {
        Object templateText = "";
        if (this.isMethodSupported(RequestMethod.GET)) {
            templateText = (String)templateText + this.getTemplateAsString(this.getBlueprintTemplateGet());
        }
        if (this.isMethodSupported(RequestMethod.PUT)) {
            templateText = (String)templateText + this.getTemplateAsString(this.getBlueprintTemplatePut());
        }
        if (this.isMethodSupported(RequestMethod.PATCH)) {
            templateText = (String)templateText + this.getTemplateAsString(this.getBlueprintTemplatePatch());
        }
        if (this.isMethodSupported(RequestMethod.POST)) {
            templateText = (String)templateText + this.getTemplateAsString(this.getBlueprintTemplatePost());
        }
        if (this.isMethodSupported(RequestMethod.DELETE)) {
            templateText = (String)templateText + this.getTemplateAsString(this.getBlueprintTemplateDelete());
        }
        templateText = ((String)templateText).replaceAll("\\$\\{resourceName\\}", WordUtils.capitalizeFully((String)((String)CaseFormat.UPPER_CAMEL.converterTo(CaseFormat.LOWER_HYPHEN).convert((Object)this.getCamelCasePluralName())).replaceAll("-", " ")));
        templateText = ((String)templateText).replaceAll("\\$\\{endpoint\\}", "/" + this.getModuleMapping() + this.getPath());
        templateText = ((String)templateText).replaceAll("\\$\\{sampleKey\\}", "(key)");
        templateText = ((String)templateText).replaceAll("\\$\\{sampleMatchCriteria\\}", this.getListOfTrackedProperties().stream().map(prop -> "+ " + prop + " (optional) - " + this.getPropertyDescription((String)prop)).collect(Collectors.joining("\n    ", "", "\n")));
        templateText = ((String)templateText).replaceAll("\\$\\{sampleResource1\\}", Stream.concat(this.getExposedProperties().stream(), Stream.of(SYNTHETIC_FIELD_PK)).collect(Collectors.joining("\": \"(val)\",\"", "{\"", "\": \"(val)\"}")));
        templateText = ((String)templateText).replaceAll("\\$\\{sampleResource2\\}", Stream.concat(this.getExposedProperties().stream(), Stream.of(SYNTHETIC_FIELD_PK)).collect(Collectors.joining("\": \"(val)\",\"", "{\"", "\": \"(val)\"}")));
        try {
            templateText = ((String)templateText).replaceAll("\\$\\{sampleSchema\\}", new ObjectMapper().writeValueAsString(this.getSchemaMap()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new ByteArrayResource(((String)templateText).getBytes(StandardCharsets.UTF_8));
    }

    protected String getTemplateAsString(Resource source) {
        try {
            return IOUtils.toString((InputStream)source.getInputStream(), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @RequestMapping(value={"/{code}"}, method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void update(@PathVariable String code, @Valid @RequestBody R dto) {
        this.assertMethodSupported(RequestMethod.PUT);
        this.assertUserHasWriteAccess();
        T dataObject = this.getFromDataStore(code);
        if (dataObject == null) {
            throw new ResourceNotFoundException("not found for key " + code);
        }
        RestAuditLogger logger = this.getAuditLogger();
        this.logUpdateToObjectDto(dataObject, dto, logger);
        this.updateDataObjectFromDto(dataObject, dto);
        this.validateBusinessObject(dataObject);
        this.validateUpdateDataObject(dataObject);
        this.save(dataObject);
        logger.saveAuditLog();
    }

    @RequestMapping(value={"/{code}"}, method={RequestMethod.PATCH})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void patch(@PathVariable String code, @Valid @RequestBody R dto) {
        this.assertMethodSupported(RequestMethod.PATCH);
        this.assertUserHasWriteAccess();
        T dataObjectOriginal = this.getFromDataStore(code);
        T dataObjectToModify = this.getFromDataStore(code);
        if (dataObjectOriginal == null) {
            throw new ResourceNotFoundException("not found for key " + code);
        }
        this.mergeDataObjectFromDto(dataObjectToModify, dto);
        this.validateBusinessObject(dataObjectToModify);
        this.validateUpdateDataObject(dataObjectToModify);
        RestAuditLogger logger = this.getAuditLogger();
        this.logUpdateToObjectObject(dataObjectOriginal, dataObjectToModify, logger);
        this.save(dataObjectToModify);
        logger.saveAuditLog();
    }

    @RequestMapping(method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void update(@Valid @RequestBody Object dto) {
        this.assertMethodSupported(RequestMethod.PUT);
        this.assertUserHasWriteAccess();
        if (dto instanceof List) {
            ((List)dto).stream().map(this::convertObjectToDto).forEach(this::doUpdate);
        } else {
            this.doUpdate(this.convertObjectToDto(dto));
        }
    }

    @RequestMapping(method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public Object add(@Valid @RequestBody Object dto) {
        this.assertMethodSupported(RequestMethod.POST);
        this.assertUserHasWriteAccess();
        if (dto instanceof List) {
            return ((List)dto).stream().map(this::convertObjectToDto).map(this::doAdd).collect(Collectors.toList());
        }
        return this.doAdd(this.convertObjectToDto(dto));
    }

    @RequestMapping(value={"/{code}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void delete(@PathVariable String code) {
        this.assertMethodSupported(RequestMethod.DELETE);
        this.assertUserHasWriteAccess();
        this.doDelete(this.getFromDataStore(code));
    }

    @RequestMapping(method={RequestMethod.DELETE}, params={"_allowMulti"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteAll(@RequestParam(required=false) Map<String, String> parameters) {
        this.assertMethodSupported(RequestMethod.DELETE);
        this.assertUserHasWriteAccess();
        this.doGetAll(parameters).forEach(this::doDelete);
    }

    protected void assertMethodSupported(RequestMethod method) {
        if (!this.isMethodSupported(method)) {
            throw new NotImplementedException(method + " not supported");
        }
    }

    protected boolean isMethodSupported(RequestMethod method) {
        return this.supportedMethods.contains(method);
    }

    protected abstract R convertDataObjectToDto(T var1);

    protected abstract R convertObjectToDto(Object var1);

    protected abstract T convertDtoToDataObject(R var1);

    protected abstract Object getPropertyValueFromDto(String var1, R var2);

    protected abstract void updateDataObjectFromDto(T var1, R var2);

    protected abstract void mergeDataObjectFromDto(T var1, R var2);

    protected abstract List<String> getExposedProperties();

    protected abstract List<String> getListOfTrackedProperties();

    protected Map.Entry<String, String> getWritePermission() {
        return org.kuali.coeus.sys.framework.util.CollectionUtils.entry(this.writePermissionTemplateNamespace, this.writePermissionTemplateName);
    }

    protected Map.Entry<String, String> getReadPermission() {
        return org.kuali.coeus.sys.framework.util.CollectionUtils.entry(this.readPermissionTemplateNamespace, this.readPermissionTemplateName);
    }

    protected T getNewDataObject() {
        try {
            return this.getDataObjectClazz().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("cannot create new data object", e);
        }
    }

    protected Object getPrimaryKeyIncomingObject(R dataObject) {
        if (this.isCompoundPrimaryKey()) {
            List<String> pkColumns = Arrays.asList(this.getPrimaryKeyColumn().split(DELIMETER));
            return new CompoundKey(pkColumns.stream().map(pk -> {
                Object val = this.getPropertyValueFromDto((String)pk, dataObject);
                if (val instanceof String && StringUtils.isBlank((CharSequence)((String)val))) {
                    throw new ResourceNotFoundException(pk + " is blank.");
                }
                if (val == null) {
                    throw new ResourceNotFoundException(pk + " is not present.");
                }
                return org.kuali.coeus.sys.framework.util.CollectionUtils.entry(pk, val);
            }).collect(org.kuali.coeus.sys.framework.util.CollectionUtils.entriesToMap()));
        }
        return this.getPropertyValueFromDto(this.getPrimaryKeyColumn(), dataObject);
    }

    protected String getPropertyDescription(String propertyName) {
        if (this.isAttrDefined(propertyName)) {
            String desc = this.dataDictionaryService.getAttributeDescription(this.getDataObjectClazz(), propertyName);
            String summary = this.dataDictionaryService.getAttributeSummary(this.getDataObjectClazz(), propertyName);
            String label = this.dataDictionaryService.getAttributeLabel(this.getDataObjectClazz(), propertyName);
            String shortLabel = this.dataDictionaryService.getAttributeLabel(this.getDataObjectClazz(), propertyName);
            Integer max = this.dataDictionaryService.getAttributeMaxLength(this.getDataObjectClazz().getName(), propertyName);
            Integer min = this.dataDictionaryService.getAttributeMinLength(this.getDataObjectClazz().getName(), propertyName);
            String maxInclusive = this.dataDictionaryService.getAttributeInclusiveMax(this.getDataObjectClazz().getName(), propertyName);
            String minExclusive = this.dataDictionaryService.getAttributeExclusiveMin(this.getDataObjectClazz().getName(), propertyName);
            String description = this.appendPeriod(StringUtils.isNotBlank((CharSequence)desc) ? desc : (StringUtils.isNotBlank((CharSequence)summary) ? summary : (StringUtils.isNotBlank((CharSequence)label) ? label : (StringUtils.isNotBlank((CharSequence)shortLabel) ? shortLabel : ""))));
            String maxLengthDescription = this.appendPeriod((String)(max != null ? "Maximum length is " + max : ""));
            String maxValueDescription = this.appendPeriod((String)(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{maxInclusive}) ? "Maximum inclusive value is " + maxInclusive : ""));
            String minLengthDescription = this.appendPeriod((String)(min != null ? "Minimum length is " + min : ""));
            String minValueDescription = this.appendPeriod((String)(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{minExclusive}) ? "Minimum enclusive value is " + minExclusive : ""));
            return description + this.prependSpace(maxLengthDescription) + this.prependSpace(minLengthDescription) + this.prependSpace(maxValueDescription) + this.prependSpace(minValueDescription);
        }
        return "";
    }

    protected boolean isAttrDefined(String propertyName) {
        try {
            return this.dataDictionaryService.isAttributeDefined(this.getDataObjectClazz(), propertyName);
        }
        catch (RuntimeException e) {
            LOG.info(this.getDataObjectClazz().getName() + "." + propertyName + " not defined in the data dictionary because of an exception.", (Throwable)e);
            return false;
        }
    }

    protected String appendPeriod(String s) {
        if (StringUtils.isNotBlank((CharSequence)s) && !StringUtils.endsWith((CharSequence)StringUtils.trim((String)s), (CharSequence)".")) {
            return StringUtils.trim((String)s) + ".";
        }
        return s;
    }

    protected String prependSpace(String s) {
        if (StringUtils.isNotBlank((CharSequence)s)) {
            return " " + StringUtils.trim((String)s);
        }
        return s;
    }

    protected String primaryKeyToString(Object pkValues) {
        String key;
        if (pkValues instanceof CompoundKey) {
            String keyNamesStr = this.getPrimaryKeyColumn();
            List<String> keyNames = Arrays.asList(keyNamesStr.split(DELIMETER));
            Map keys = ((CompoundKey)pkValues).getKeys();
            if (keyNames.size() != keys.size()) {
                throw new IllegalArgumentException("compoundKey value does not contain the same number key elements in format: " + keyNamesStr);
            }
            key = keyNames.stream().map(name -> keys.get(name).toString()).reduce((t, u) -> t + DELIMETER + u).get();
        } else {
            key = pkValues.toString();
        }
        return key;
    }

    protected boolean isPrimitive(String name) {
        return this.beanWrapper.getPropertyType(name).isPrimitive();
    }

    protected Object translateValue(String name, String value) {
        return this.beanWrapper.convertIfNecessary((Object)value, this.beanWrapper.getPropertyType(name));
    }

    protected Collection<R> translateAllDataObjects(Collection<T> dataObjects) {
        return dataObjects.stream().map(this::convertDataObjectToDto).collect(Collectors.toList());
    }

    protected void doUpdate(R dto) {
        Object pk = this.getPrimaryKeyIncomingObject(dto);
        T dataObject = this.getFromDataStore(pk);
        if (dataObject == null) {
            throw new ResourceNotFoundException("not found for key " + pk);
        }
        RestAuditLogger logger = this.getAuditLogger();
        this.logUpdateToObjectDto(dataObject, dto, logger);
        this.updateDataObjectFromDto(dataObject, dto);
        this.validateBusinessObject(dataObject);
        this.validateUpdateDataObject(dataObject);
        this.save(dataObject);
        logger.saveAuditLog();
    }

    protected RestAuditLogger getAuditLogger() {
        return this.restAuditLoggerFactory.getNewAuditLogger(this.dataObjectClazz, this.getListOfTrackedProperties());
    }

    protected void logUpdateToObjectDto(T currentObject, R newObject, RestAuditLogger logger) {
        T newDataObject = this.convertDtoToDataObject(newObject);
        logger.addModifiedItem(currentObject, newDataObject);
    }

    protected void logUpdateToObjectObject(T currentObject, T newObject, RestAuditLogger logger) {
        logger.addModifiedItem(currentObject, newObject);
    }

    protected R doAdd(R dto) {
        T existingDataObject;
        Object code = this.getPrimaryKeyIncomingObject(dto);
        if (code != null && (existingDataObject = this.getFromDataStore(code)) != null) {
            throw new UnprocessableEntityException("already exists for key " + code);
        }
        RestAuditLogger logger = this.getAuditLogger();
        T newDataObject = this.convertDtoToDataObject(dto);
        this.validateBusinessObject(newDataObject);
        this.validateInsertDataObject(newDataObject);
        T savedDataObject = this.save(newDataObject);
        logger.addNewItem(newDataObject);
        logger.saveAuditLog();
        return this.convertDataObjectToDto(savedDataObject);
    }

    protected void doDelete(T existingDataObject) {
        if (existingDataObject == null) {
            throw new ResourceNotFoundException("not found");
        }
        RestAuditLogger logger = this.getAuditLogger();
        this.validateDeleteDataObject(existingDataObject);
        this.delete(existingDataObject);
        logger.addDeletedItem(existingDataObject);
        logger.saveAuditLog();
    }

    protected Collection<T> doGetAll(Map<String, String> parameters) {
        Map searchCriteria = parameters != null ? parameters.entrySet().stream().filter(e -> this.getExposedProperties().contains(e.getKey())).map(entry -> {
            try {
                Object val = this.translateValue((String)entry.getKey(), (String)entry.getValue());
                return org.kuali.coeus.sys.framework.util.CollectionUtils.entry((String)entry.getKey(), val);
            }
            catch (TypeMismatchException e) {
                throw new ResourceNotFoundException(e.getMessage(), e);
            }
        }).collect(org.kuali.coeus.sys.framework.util.CollectionUtils.entriesToMap()) : Collections.emptyMap();
        Collection<T> dataObjects = !CollectionUtils.isEmpty(searchCriteria) ? this.getMatchingFromDataStore(searchCriteria) : this.getAllFromDataStore();
        if (dataObjects == null || dataObjects.isEmpty()) {
            throw new ResourceNotFoundException("not found" + (String)(searchCriteria.isEmpty() ? "" : " for search criteria " + searchCriteria));
        }
        return dataObjects;
    }

    protected void validateDeleteDataObject(T dataObject) {
        this.throwIfErrorMessages(this.persistenceVerificationService.verifyRelationshipsForDelete(dataObject, Collections.emptyList()));
    }

    protected void validateUpdateDataObject(T dataObject) {
        this.throwIfErrorMessages(this.persistenceVerificationService.verifyRelationshipsForUpdate(dataObject, Collections.emptyList()));
    }

    protected void validateInsertDataObject(T dataObject) {
        this.throwIfErrorMessages(this.persistenceVerificationService.verifyRelationshipsForInsert(dataObject, Collections.emptyList()));
    }

    protected void validateBusinessObject(T dataObject) {
        if (!this.dictionaryValidationService.isBusinessObjectValid(dataObject)) {
            this.throwIfErrorMessages(this.getGlobalVariableService().getMessageMap());
        }
    }

    protected void throwIfErrorMessages(MessageMap messageMap) {
        Map<String, List<String>> errors;
        if (messageMap != null && messageMap.hasErrors() && (errors = this.errorHandlingUtilService.extractErrorMessages(messageMap)) != null && !errors.isEmpty()) {
            throw new DataDictionaryValidationException(errors);
        }
    }

    protected Collection<T> getAllFromDataStore() {
        return this.getLegacyDataAdapter().findAll(this.getDataObjectClazz());
    }

    protected Collection<T> getMatchingFromDataStore(Map<String, ?> criteria) {
        return this.getLegacyDataAdapter().findMatching(this.getDataObjectClazz(), criteria);
    }

    protected T getFromDataStore(Object code) {
        if (this.isCompoundPrimaryKey() && code instanceof CompoundKey) {
            return (T)this.getLegacyDataAdapter().findByPrimaryKey(this.getDataObjectClazz(), ((CompoundKey)code).getKeys());
        }
        if (this.isCompoundPrimaryKey() && code instanceof String) {
            return (T)this.getLegacyDataAdapter().findByPrimaryKey(this.getDataObjectClazz(), this.getCompoundKeyMap((String)code));
        }
        if (code instanceof String) {
            if (StringUtils.isBlank((CharSequence)((String)code))) {
                throw new ResourceNotFoundException(this.getPrimaryKeyColumn() + " is blank.");
            }
            return (T)this.getLegacyDataAdapter().findBySinglePrimaryKey(this.getDataObjectClazz(), this.translateValue(this.getPrimaryKeyColumn(), (String)code));
        }
        if (code == null) {
            throw new ResourceNotFoundException(this.getPrimaryKeyColumn() + " is not present.");
        }
        return (T)this.getLegacyDataAdapter().findBySinglePrimaryKey(this.getDataObjectClazz(), code);
    }

    protected Map<String, Object> getCompoundKeyMap(String compoundKey) {
        if (compoundKey.contains(DELIMETER)) {
            String[] keyValues;
            String[] keyNames = this.getPrimaryKeyColumn().split(DELIMETER);
            if (keyNames.length != (keyValues = compoundKey.split(DELIMETER)).length) {
                throw new ResourceNotFoundException("compoundKey value does not contain the same number key elements in format: " + this.getPrimaryKeyColumn());
            }
            return org.kuali.coeus.sys.framework.util.CollectionUtils.zipMap(keyNames, keyValues).entrySet().stream().map(e -> org.kuali.coeus.sys.framework.util.CollectionUtils.entry((String)e.getKey(), this.translateValue((String)e.getKey(), (String)e.getValue()))).collect(org.kuali.coeus.sys.framework.util.CollectionUtils.entriesToMap());
        }
        throw new ResourceNotFoundException("compoundKey value does not contain the same number key elements in format: " + this.getPrimaryKeyColumn());
    }

    protected T save(T dataObject) {
        if (this.useDataObjectService()) {
            return (T)this.getDataObjectService().save(dataObject, new PersistenceOption[]{PersistenceOption.FLUSH, PersistenceOption.LINK_KEYS});
        }
        return (T)this.getBusinessObjectService().save((PersistableBusinessObject)dataObject);
    }

    protected void delete(T dataObject) {
        this.getLegacyDataAdapter().delete(dataObject);
    }

    protected boolean useDataObjectService() {
        return this.getDataObjectService().supports(this.getDataObjectClazz());
    }

    protected void assertUserHasWriteAccess() {
        if (this.globalVariableService.getUserSession() == null || !this.permissionService.hasPermissionByTemplate(this.globalVariableService.getUserSession().getPrincipalId(), this.getWritePermission().getKey(), this.getWritePermission().getValue(), this.getWritePermissionTemplateQualifiers())) {
            throw new UnauthorizedAccessException();
        }
    }

    protected void assertUserHasReadAccess() {
        if (this.globalVariableService.getUserSession() == null || !this.permissionService.hasPermissionByTemplate(this.globalVariableService.getUserSession().getPrincipalId(), this.getReadPermission().getKey(), this.getReadPermission().getValue(), this.getReadPermissionTemplateQualifiers())) {
            throw new UnauthorizedAccessException();
        }
    }

    String toPlural(String singular) {
        if (singular.endsWith("Bo") || singular.endsWith("BO")) {
            singular = singular.substring(0, singular.length() - 2);
        }
        if (!(!singular.endsWith("y") || singular.endsWith("ay") || singular.endsWith("ey") || singular.endsWith("iy") || singular.endsWith("oy") || singular.endsWith("uy"))) {
            return singular.substring(0, singular.length() - 1) + "ies";
        }
        if (singular.endsWith("s") || singular.endsWith("x") || singular.endsWith("z") || singular.endsWith("ch") || singular.endsWith("sh")) {
            return singular + "es";
        }
        return singular + "s";
    }

    private String getModuleMapping() {
        KcConfigurer configurer = this.getModuleConfigurers().stream().filter(mc -> mc instanceof KcConfigurer).map(mc -> (KcConfigurer)((Object)mc)).filter(mc -> {
            SimpleCrudRestControllerBase controller = (SimpleCrudRestControllerBase)mc.getRootResourceLoader().getService(new QName(this.getBeanName()));
            return controller != null && controller.getDataObjectClazz().equals(this.getDataObjectClazz());
        }).findFirst().get();
        return configurer.getDispatchServletMappings().stream().filter(mapping -> !mapping.contains("krad")).findFirst().get();
    }

    private String getPath() {
        return "/api/v1/" + (String)CaseFormat.UPPER_CAMEL.converterTo(CaseFormat.LOWER_HYPHEN).convert((Object)this.getCamelCasePluralName());
    }

    public void afterPropertiesSet() {
        if (Modifier.isAbstract(this.dataObjectClazz.getModifiers())) {
            throw new IllegalStateException("dataObjectClazz must not be abstract: " + this.dataObjectClazz.getName());
        }
        if (StringUtils.isBlank((CharSequence)this.camelCasePluralName)) {
            this.setCamelCasePluralName(this.toPlural(this.dataObjectClazz.getSimpleName()));
        }
        if (StringUtils.isBlank((CharSequence)this.writePermissionTemplateName)) {
            this.setWritePermissionTemplateName("Write Class");
        }
        if (StringUtils.isBlank((CharSequence)this.writePermissionTemplateNamespace)) {
            this.setWritePermissionTemplateNamespace("KC-SYS");
        }
        if (CollectionUtils.isEmpty(this.writePermissionTemplateQualifiers)) {
            this.setWritePermissionTemplateQualifiers(Collections.singletonMap("className", this.getDataObjectClazz().getName()));
        }
        if (StringUtils.isBlank((CharSequence)this.readPermissionTemplateName)) {
            this.setReadPermissionTemplateName("Read Class");
        }
        if (StringUtils.isBlank((CharSequence)this.readPermissionTemplateNamespace)) {
            this.setReadPermissionTemplateNamespace("KC-SYS");
        }
        if (CollectionUtils.isEmpty(this.readPermissionTemplateQualifiers)) {
            this.setReadPermissionTemplateQualifiers(Collections.singletonMap("className", this.getDataObjectClazz().getName()));
        }
        if (this.isRegisterMapping() && this.autoRegisterMapping != null) {
            this.autoRegisterMapping.setPathPrefixes(Collections.singletonMap(this.getPath(), ALWAYS_TRUE));
            this.autoRegisterMapping.detectHandlerMethods(this);
        }
        this.beanWrapper = this.getRestBeanWrapperFactory().newInstance(this.dataObjectClazz);
    }

    public PermissionService getPermissionService() {
        return this.permissionService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }

    public DictionaryValidationService getDictionaryValidationService() {
        return this.dictionaryValidationService;
    }

    public void setDictionaryValidationService(DictionaryValidationService dictionaryValidationService) {
        this.dictionaryValidationService = dictionaryValidationService;
    }

    public LegacyDataAdapter getLegacyDataAdapter() {
        return this.legacyDataAdapter;
    }

    public void setLegacyDataAdapter(LegacyDataAdapter legacyDataAdapter) {
        this.legacyDataAdapter = legacyDataAdapter;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public PersistenceVerificationService getPersistenceVerificationService() {
        return this.persistenceVerificationService;
    }

    public void setPersistenceVerificationService(PersistenceVerificationService persistenceVerificationService) {
        this.persistenceVerificationService = persistenceVerificationService;
    }

    public Class<T> getDataObjectClazz() {
        return this.dataObjectClazz;
    }

    @Required
    public void setDataObjectClazz(Class<T> dataObjectClazz) {
        this.dataObjectClazz = dataObjectClazz;
    }

    public String getWritePermissionTemplateNamespace() {
        return this.writePermissionTemplateNamespace;
    }

    public void setWritePermissionTemplateNamespace(String writePermissionTemplateNamespace) {
        this.writePermissionTemplateNamespace = writePermissionTemplateNamespace;
    }

    public String getWritePermissionTemplateName() {
        return this.writePermissionTemplateName;
    }

    public void setWritePermissionTemplateName(String writePermissionTemplateName) {
        this.writePermissionTemplateName = writePermissionTemplateName;
    }

    public Map<String, String> getWritePermissionTemplateQualifiers() {
        return this.writePermissionTemplateQualifiers;
    }

    public void setWritePermissionTemplateQualifiers(Map<String, String> writePermissionTemplateQualifiers) {
        this.writePermissionTemplateQualifiers = writePermissionTemplateQualifiers;
    }

    public String getReadPermissionTemplateNamespace() {
        return this.readPermissionTemplateNamespace;
    }

    public void setReadPermissionTemplateNamespace(String readPermissionTemplateNamespace) {
        this.readPermissionTemplateNamespace = readPermissionTemplateNamespace;
    }

    public String getReadPermissionTemplateName() {
        return this.readPermissionTemplateName;
    }

    public void setReadPermissionTemplateName(String readPermissionTemplateName) {
        this.readPermissionTemplateName = readPermissionTemplateName;
    }

    public Map<String, String> getReadPermissionTemplateQualifiers() {
        return this.readPermissionTemplateQualifiers;
    }

    public void setReadPermissionTemplateQualifiers(Map<String, String> readPermissionTemplateQualifiers) {
        this.readPermissionTemplateQualifiers = readPermissionTemplateQualifiers;
    }

    public ErrorHandlingUtilService getErrorHandlingUtilService() {
        return this.errorHandlingUtilService;
    }

    public void setErrorHandlingUtilService(ErrorHandlingUtilService errorHandlingUtilService) {
        this.errorHandlingUtilService = errorHandlingUtilService;
    }

    public String getPrimaryKeyColumn() {
        if (StringUtils.isBlank((CharSequence)this.primaryKeyColumn)) {
            List<String> pks = this.persistenceVerificationService.pkFields(this.dataObjectClazz);
            this.primaryKeyColumn = (String)pks.stream().sorted().reduce((t, u) -> t + DELIMETER + u).get();
        }
        return this.primaryKeyColumn;
    }

    public boolean isCompoundPrimaryKey() {
        return this.getPrimaryKeyColumn().contains(DELIMETER);
    }

    public void setPrimaryKeyColumn(String primaryKeyColumn) {
        this.primaryKeyColumn = primaryKeyColumn;
    }

    public String getCamelCasePluralName() {
        return this.camelCasePluralName;
    }

    public void setCamelCasePluralName(String camelCasePluralName) {
        this.camelCasePluralName = camelCasePluralName;
    }

    public RestAuditLoggerFactory getRestAuditLoggerFactory() {
        return this.restAuditLoggerFactory;
    }

    public void setRestAuditLoggerFactory(RestAuditLoggerFactory restAuditLoggerFactory) {
        this.restAuditLoggerFactory = restAuditLoggerFactory;
    }

    public boolean isRegisterMapping() {
        return this.registerMapping;
    }

    public void setRegisterMapping(boolean registerMapping) {
        this.registerMapping = registerMapping;
    }

    public RestSimpleUrlHandlerMapping getAutoRegisterMapping() {
        return this.autoRegisterMapping;
    }

    public void setAutoRegisterMapping(RestSimpleUrlHandlerMapping autoRegisterMapping) {
        this.autoRegisterMapping = autoRegisterMapping;
    }

    public Collection<ModuleConfigurer> getModuleConfigurers() {
        return this.moduleConfigurers;
    }

    public void setModuleConfigurers(Collection<ModuleConfigurer> moduleConfigurers) {
        this.moduleConfigurers = moduleConfigurers;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public DataDictionaryService getDataDictionaryService() {
        return this.dataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    public RestBeanWrapperFactory getRestBeanWrapperFactory() {
        return this.restBeanWrapperFactory;
    }

    public void setRestBeanWrapperFactory(RestBeanWrapperFactory restBeanWrapperFactory) {
        this.restBeanWrapperFactory = restBeanWrapperFactory;
    }

    public Set<RequestMethod> getSupportedMethods() {
        return this.supportedMethods;
    }

    public void setSupportedMethods(Set<RequestMethod> supportedMethods) {
        this.supportedMethods = supportedMethods;
    }

    public Resource getBlueprintTemplateGet() {
        return this.blueprintTemplateGet;
    }

    public void setBlueprintTemplateGet(Resource blueprintTemplateGet) {
        this.blueprintTemplateGet = blueprintTemplateGet;
    }

    public Resource getBlueprintTemplatePut() {
        return this.blueprintTemplatePut;
    }

    public void setBlueprintTemplatePut(Resource blueprintTemplatePut) {
        this.blueprintTemplatePut = blueprintTemplatePut;
    }

    public Resource getBlueprintTemplatePatch() {
        return this.blueprintTemplatePatch;
    }

    public void setBlueprintTemplatePatch(Resource blueprintTemplatePatch) {
        this.blueprintTemplatePatch = blueprintTemplatePatch;
    }

    public Resource getBlueprintTemplatePost() {
        return this.blueprintTemplatePost;
    }

    public void setBlueprintTemplatePost(Resource blueprintTemplatePost) {
        this.blueprintTemplatePost = blueprintTemplatePost;
    }

    public Resource getBlueprintTemplateDelete() {
        return this.blueprintTemplateDelete;
    }

    public void setBlueprintTemplateDelete(Resource blueprintTemplateDelete) {
        this.blueprintTemplateDelete = blueprintTemplateDelete;
    }
}

