/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.excon.project;

import java.sql.Date;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.excon.project.ExconProject;
import org.kuali.kra.excon.project.ExconProjectAssociate;
import org.kuali.kra.excon.project.ExconProjectSanctionListFinder;
import org.kuali.rice.location.api.country.CountryService;

public class ExconProjectDestination
extends ExconProjectAssociate
implements Comparable<ExconProjectDestination> {
    private static final long serialVersionUID = 1652823456758069217L;
    private Long exconProjectDestId;
    private Long projectId;
    private String destinationCountryCode;
    private Date arrivalDate;
    private Date departureDate;
    private String destinationComment;
    private String sanctionList;
    private transient CountryService countryService;

    public Long getExconProjectDestId() {
        return this.exconProjectDestId;
    }

    public void setExconProjectDestId(Long exconProjectDestId) {
        this.exconProjectDestId = exconProjectDestId;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getDestinationCountryCode() {
        return this.destinationCountryCode;
    }

    public void setDestinationCountryCode(String destinationCountryCode) {
        this.destinationCountryCode = destinationCountryCode;
    }

    public String getDestinationCountryName() {
        String destinationCountryName = "";
        if (!StringUtils.isEmpty((CharSequence)this.destinationCountryCode)) {
            destinationCountryName = this.getCountryService().getCountryByAlternateCode(this.destinationCountryCode).getName();
        }
        return destinationCountryName;
    }

    public Date getArrivalDate() {
        return this.arrivalDate;
    }

    public String getArrivalDateStr() {
        return ExconProject.formattedDate(this.arrivalDate);
    }

    public void setArrivalDate(Date arrivalDate) {
        this.arrivalDate = arrivalDate;
    }

    public Date getDepartureDate() {
        return this.departureDate;
    }

    public String getDepartureDateStr() {
        return ExconProject.formattedDate(this.departureDate);
    }

    public void setDepartureDate(Date departureDate) {
        this.departureDate = departureDate;
    }

    public String getDestinationComment() {
        return this.destinationComment;
    }

    public void setDestinationComment(String destinationComment) {
        this.destinationComment = destinationComment;
    }

    public String getSanctionList() {
        return this.sanctionList;
    }

    public void setSanctionList(String sanctionList) {
        this.sanctionList = sanctionList;
    }

    public String getSanctionListName() {
        String sanctionListName = "";
        if (!StringUtils.isEmpty((CharSequence)this.sanctionList)) {
            sanctionListName = this.getSanctionListFinder().getKeyLabel(this.sanctionList);
        }
        return sanctionListName;
    }

    public ExconProjectSanctionListFinder getSanctionListFinder() {
        return new ExconProjectSanctionListFinder();
    }

    @Override
    public void resetPersistenceState() {
        this.exconProjectDestId = null;
        this.versionNumber = null;
    }

    @Override
    public int compareTo(ExconProjectDestination exconProjectDestinationArg) {
        return exconProjectDestinationArg.getUpdateTimestamp().compareTo(this.getUpdateTimestamp());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.destinationComment == null ? 0 : this.destinationComment.hashCode());
        result = 31 * result + (this.arrivalDate == null ? 0 : this.arrivalDate.hashCode());
        result = 31 * result + (this.exconProjectDestId == null ? 0 : this.exconProjectDestId.hashCode());
        result = 31 * result + (this.destinationCountryCode == null ? 0 : this.destinationCountryCode.hashCode());
        result = 31 * result + (this.projectId == null ? 0 : this.projectId.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExconProjectDestination other = (ExconProjectDestination)obj;
        if (this.arrivalDate == null ? other.arrivalDate != null : !this.arrivalDate.equals(other.arrivalDate)) {
            return false;
        }
        if (this.exconProjectDestId == null ? other.exconProjectDestId != null : !this.exconProjectDestId.equals(other.exconProjectDestId)) {
            return false;
        }
        if (this.destinationCountryCode == null ? other.destinationCountryCode != null : !this.destinationCountryCode.equals(other.destinationCountryCode)) {
            return false;
        }
        return !(this.projectId == null ? other.projectId != null : !this.projectId.equals(other.projectId));
    }

    protected CountryService getCountryService() {
        if (this.countryService == null) {
            this.countryService = KcServiceLocator.getService(CountryService.class);
        }
        return this.countryService;
    }

    public void setCountryService(CountryService countryService) {
        this.countryService = countryService;
    }
}

