/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.auth;

import java.util.HashMap;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kns.document.authorization.MaintenanceDocumentAuthorizerBase;

public class IacucPersonTrainingMaintenanceDocumentAuthorizer
extends MaintenanceDocumentAuthorizerBase {
    private static final long serialVersionUID = -2238428296264361269L;
    public static final String PERMISSION_MAINTAIN_PERSON_TRAINING = "Maintain IACUC Person Training";
    public static final String NAME_SPACE = "KC-IACUC";

    public boolean canInitiate(String documentTypeName, Person user) {
        HashMap<String, String> permissionDetails = new HashMap<String, String>();
        permissionDetails.put("documentTypeName", documentTypeName);
        permissionDetails.put("unitNumber", "*");
        boolean retVal = IacucPersonTrainingMaintenanceDocumentAuthorizer.getPermissionService().isAuthorized(user.getPrincipalId(), NAME_SPACE, PERMISSION_MAINTAIN_PERSON_TRAINING, permissionDetails);
        return retVal;
    }

    public boolean canMaintain(Object dataObject, Person user) {
        HashMap<String, String> permissionDetails = new HashMap<String, String>(2);
        permissionDetails.put("documentTypeName", IacucPersonTrainingMaintenanceDocumentAuthorizer.getDocumentDictionaryService().getMaintenanceDocumentTypeName(dataObject.getClass()));
        permissionDetails.put("maintenanceAction", NAME_SPACE);
        return !this.permissionExistsByTemplate(NAME_SPACE, "Initiate Document", permissionDetails) || this.isAuthorizedByTemplate(dataObject, NAME_SPACE, "Initiate Document", user.getPrincipalId(), permissionDetails, null);
    }
}

