/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.procedures.rule;

import java.util.List;
import org.kuali.coeus.sys.framework.rule.KcBusinessRule;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.iacuc.procedures.IacucProtocolProcedureService;
import org.kuali.kra.iacuc.procedures.IacucProtocolStudyGroup;
import org.kuali.kra.iacuc.procedures.IacucProtocolStudyGroupBean;
import org.kuali.kra.iacuc.procedures.rule.AddProtocolStudyGroupEvent;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;

public class AddProtocolStudyGroupRule
extends KcTransactionalDocumentRuleBase
implements KcBusinessRule<AddProtocolStudyGroupEvent> {
    private static final String PROCEDURE_BEAN_PATH = "iacucProtocolStudyGroupBeans";
    private IacucProtocolProcedureService iacucProtocolProcedureService;

    @Override
    public boolean processRules(AddProtocolStudyGroupEvent event) {
        return this.processAddStudyGroupBusinessRules(event);
    }

    private boolean processAddStudyGroupBusinessRules(AddProtocolStudyGroupEvent event) {
        boolean rulePassed = true;
        if ((rulePassed &= this.isStudyGroupValid(event)) && this.getIacucProtocolProcedureService().isProcedureViewedBySpecies()) {
            rulePassed &= !this.isDuplicateStudyGroup(event);
        }
        return rulePassed;
    }

    private boolean isStudyGroupValid(AddProtocolStudyGroupEvent event) {
        boolean studyGroupValid = true;
        IacucProtocolStudyGroupBean selectedIacucProtocolStudyGroupBean = event.getProcedureBean();
        List<String> protocolSpeciesAndGroups = selectedIacucProtocolStudyGroupBean.getProtocolSpeciesAndGroups();
        if (ObjectUtils.isNull(protocolSpeciesAndGroups)) {
            GlobalVariables.getMessageMap().putError(this.getErrorPath(event), "error.iacuc.validation.studyGroup.valid", new String[0]);
            studyGroupValid = false;
        }
        return studyGroupValid;
    }

    private boolean isDuplicateStudyGroup(AddProtocolStudyGroupEvent event) {
        boolean duplicateStudyGroup = false;
        IacucProtocolStudyGroupBean procedureBean = event.getProcedureBean();
        List<String> protocolSpeciesAndGroups = procedureBean.getProtocolSpeciesAndGroups();
        for (String iacucProtocolSpeciesId : protocolSpeciesAndGroups) {
            Integer newProtocolSpeciesId = Integer.parseInt(iacucProtocolSpeciesId);
            for (IacucProtocolStudyGroup detailBean : procedureBean.getIacucProtocolStudyGroups()) {
                if (!detailBean.getIacucProtocolSpeciesId().equals(newProtocolSpeciesId)) continue;
                GlobalVariables.getMessageMap().putError(this.getErrorPath(event), "error.iacuc.validation.duplicate.studyGroup", new String[0]);
                duplicateStudyGroup = true;
            }
        }
        return duplicateStudyGroup;
    }

    private String getErrorPath(AddProtocolStudyGroupEvent event) {
        StringBuffer errorPath = new StringBuffer();
        errorPath.append(PROCEDURE_BEAN_PATH);
        errorPath.append("[");
        errorPath.append(event.getProcedureBeanIndex());
        errorPath.append("]");
        return errorPath.toString();
    }

    public IacucProtocolProcedureService getIacucProtocolProcedureService() {
        if (ObjectUtils.isNull((Object)this.iacucProtocolProcedureService)) {
            this.iacucProtocolProcedureService = (IacucProtocolProcedureService)KcServiceLocator.getService("iacucProtocolProcedureService");
        }
        return this.iacucProtocolProcedureService;
    }
}

