/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.proposallog.printing;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.print.stream.xml.XmlStream;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.kra.institutionalproposal.proposallog.ProposalLog;
import org.kuali.kra.printing.schema.ProposalLogDocument;
import org.kuali.kra.printing.schema.ProposalLogLeadUnit;
import org.kuali.kra.printing.schema.ProposalLogPrincipalInvestigator;
import org.kuali.kra.printing.schema.ProposalLogProposalType;
import org.kuali.kra.printing.schema.ProposalLogSponsor;
import org.kuali.rice.core.api.datetime.DateTimeService;

public class ProposalLogXmlStream
implements XmlStream<ProposalLogDocument> {
    private DateTimeService dateTimeService;

    @Override
    public Class<ProposalLogDocument> type() {
        return ProposalLogDocument.class;
    }

    @Override
    public Map<String, ProposalLogDocument> generateXmlStream(KcPersistableBusinessObjectBase printableBusinessObject, Map<String, Object> reportParameters) {
        LinkedHashMap<String, ProposalLogDocument> xmlObjectList = new LinkedHashMap<String, ProposalLogDocument>();
        ProposalLog proposalLog = (ProposalLog)reportParameters.get("proposalLogToPrint");
        proposalLog.refreshNonUpdateableReferences();
        ProposalLogDocument proposalLogDocument = ProposalLogDocument.Factory.newInstance();
        ProposalLogDocument.ProposalLog printProposalLog = ProposalLogDocument.ProposalLog.Factory.newInstance();
        printProposalLog.setProposalNumber(proposalLog.getProposalNumber());
        printProposalLog.setProposalTitle(proposalLog.getTitle());
        printProposalLog.setStatus(proposalLog.getProposalLogStatus().getDescription());
        printProposalLog.setComments(proposalLog.getComments());
        printProposalLog.setUpdateUser(proposalLog.getUpdateUser());
        printProposalLog.setUpdateTimeStamp(this.dateTimeService.toDateString((Date)proposalLog.getUpdateTimestamp()));
        printProposalLog.setPI(this.getPrincipalInvestigator(proposalLog));
        ProposalLogLeadUnit unit = ProposalLogLeadUnit.Factory.newInstance();
        unit.setUnitNumber(proposalLog.getLeadUnit());
        if (proposalLog.getUnit() != null) {
            unit.setUnitName(proposalLog.getUnit().getUnitName());
        }
        printProposalLog.setLeadUnit(unit);
        ProposalLogSponsor sponsor = ProposalLogSponsor.Factory.newInstance();
        sponsor.setSponsorCode(proposalLog.getSponsorCode());
        sponsor.setSponsorName(proposalLog.getSponsorName());
        printProposalLog.setSponsor(sponsor);
        ProposalLogProposalType type = ProposalLogProposalType.Factory.newInstance();
        type.setProposalTypeCode(proposalLog.getProposalTypeCode());
        if (proposalLog.getProposalType() != null) {
            type.setProposalTypeDesc(proposalLog.getProposalType().getDescription());
        }
        printProposalLog.setProposalType(type);
        proposalLogDocument.setProposalLog(printProposalLog);
        xmlObjectList.put("proposalLog", proposalLogDocument);
        return xmlObjectList;
    }

    private ProposalLogPrincipalInvestigator getPrincipalInvestigator(ProposalLog proposalLog) {
        ProposalLogPrincipalInvestigator pi = ProposalLogPrincipalInvestigator.Factory.newInstance();
        KcPerson person = proposalLog.getPerson();
        pi.setFirstName(person.getFirstName());
        pi.setMiddleName(person.getMiddleName());
        pi.setLastName(person.getLastName());
        pi.setFullName(person.getFullName());
        pi.setPersonID(person.getPersonId());
        return pi;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }
}

