/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.excon.rules;

import org.apache.commons.lang3.StringUtils;
import org.kuali.kra.excon.project.ExconProject;
import org.kuali.kra.excon.project.ExconProjectUnitPerson;
import org.kuali.rice.krad.util.GlobalVariables;

public class ExconProjectUnitPersonAddRuleImpl {
    private static final String EXCON_PROJECT_UNIT_PERSON_ERROR_KEY = "exconProjectUnitPersonsBean.newUnitPerson";
    private static final String ERROR_EXCON_PROJECT_UNIT_PERSON_ROLE_MISSING = "error.exconProjectUnitPerson.roleMissing";
    private static final String ERROR_EXCON_PROJECT_UNIT_PERSON_INVALID = "error.exconProjectUnitPerson.invalidPerson";

    public boolean processAddExconProjectUnitPersonBusinessRules(ExconProject exconProject, ExconProjectUnitPerson newPerson) {
        boolean valid = this.checkProjectUnitPersonIsValid(exconProject, newPerson);
        if (valid) {
            valid &= this.checkProjectUnitPersonHasRole(exconProject, newPerson);
        }
        return valid;
    }

    public boolean checkProjectUnitPersonIsValid(ExconProject exconProject, ExconProjectUnitPerson newPerson) {
        if (newPerson.getPerson() == null) {
            GlobalVariables.getMessageMap().putError(EXCON_PROJECT_UNIT_PERSON_ERROR_KEY, ERROR_EXCON_PROJECT_UNIT_PERSON_INVALID, new String[0]);
            return false;
        }
        return true;
    }

    public boolean checkProjectUnitPersonHasRole(ExconProject exconProject, ExconProjectUnitPerson newPerson) {
        if (StringUtils.isEmpty((CharSequence)newPerson.getRoleCode())) {
            GlobalVariables.getMessageMap().putError(EXCON_PROJECT_UNIT_PERSON_ERROR_KEY, ERROR_EXCON_PROJECT_UNIT_PERSON_ROLE_MISSING, new String[0]);
            return false;
        }
        return true;
    }
}

