/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.actions.correspondence;

import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.person.signature.PersonSignatureService;
import org.kuali.coeus.common.framework.print.AttachmentDataSource;
import org.kuali.coeus.common.framework.print.PrintableAttachment;
import org.kuali.coeus.common.framework.print.PrintingException;
import org.kuali.coeus.common.framework.print.PrintingService;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.actions.correspondence.ProtocolActionCorrespondenceGenerationService;
import org.kuali.kra.protocol.actions.correspondence.ProtocolActionsCorrespondenceBase;
import org.kuali.kra.protocol.correspondence.ProtocolCorrespondence;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class ProtocolActionCorrespondenceGenerationServiceImplBase
implements ProtocolActionCorrespondenceGenerationService {
    private BusinessObjectService businessObjectService;
    private PrintingService printingService;
    private DateTimeService dateTimeService;
    private static final Logger LOG = LogManager.getLogger(ProtocolActionCorrespondenceGenerationServiceImplBase.class);

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    protected BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setPrintingService(PrintingService printingService) {
        this.printingService = printingService;
    }

    protected PrintingService getPrintingService() {
        return this.printingService;
    }

    protected abstract ProtocolCorrespondence getNewProtocolCorrespondenceHook();

    protected void buildAndAttachProtocolCorrespondence(ProtocolBase protocol, byte[] data, String correspTypeCode) {
        ProtocolCorrespondence protocolCorrespondence = this.getNewProtocolCorrespondenceHook();
        protocolCorrespondence.setProtocol(protocol);
        protocolCorrespondence.setProtocolId(protocol.getProtocolId());
        protocolCorrespondence.setProtocolNumber(protocol.getProtocolNumber());
        protocolCorrespondence.setSequenceNumber(protocol.getSequenceNumber());
        protocolCorrespondence.setProtoCorrespTypeCode(correspTypeCode);
        ProtocolActionBase lastAction = protocol.getLastProtocolAction();
        protocolCorrespondence.setProtocolAction(lastAction);
        protocolCorrespondence.setActionIdFk(lastAction.getProtocolActionId());
        protocolCorrespondence.setCorrespondence(data);
        protocolCorrespondence.setActionId(lastAction.getActionId());
        protocolCorrespondence.setFinalFlag(false);
        protocolCorrespondence.setCreateUser(GlobalVariables.getUserSession().getPrincipalName());
        protocolCorrespondence.setCreateTimestamp(this.dateTimeService.getCurrentTimestamp());
        if (lastAction.getProtocolCorrespondences() == null) {
            ArrayList<ProtocolCorrespondence> correspondences = new ArrayList<ProtocolCorrespondence>();
            correspondences.add(protocolCorrespondence);
            lastAction.setProtocolCorrespondences(correspondences);
            protocol.refreshReferenceObject("protocolSubmissions");
        } else {
            lastAction.getProtocolCorrespondences().add(protocolCorrespondence);
        }
        this.getBusinessObjectService().save((PersistableBusinessObject)protocolCorrespondence);
        this.getBusinessObjectService().save((PersistableBusinessObject)protocol);
    }

    @Override
    public void attachProtocolCorrespondence(ProtocolBase protocol, byte[] data, String correspTypeCode) {
        this.buildAndAttachProtocolCorrespondence(protocol, data, correspTypeCode);
    }

    @Override
    public void generateCorrespondenceDocumentAndAttach(ProtocolActionsCorrespondenceBase printableCorrespondence) throws PrintingException {
        if (printableCorrespondence.getXSLTemplates().size() > 0) {
            ProtocolBase protocol = printableCorrespondence.getProtocol();
            AttachmentDataSource ads = this.printingService.print(printableCorrespondence);
            this.applySignatureInDocument(printableCorrespondence, ads);
            if (ads.getData().length > 0) {
                this.buildAndAttachProtocolCorrespondence(protocol, ads.getData(), printableCorrespondence.getProtoCorrespTypeCode());
            }
        }
    }

    @Override
    public AttachmentDataSource reGenerateCorrespondenceDocument(ProtocolActionsCorrespondenceBase printableCorrespondence) throws PrintingException {
        if (printableCorrespondence.getXSLTemplates().size() > 0) {
            ProtocolBase protocol = printableCorrespondence.getProtocol();
            AttachmentDataSource ads = this.printingService.print(printableCorrespondence);
            this.applySignatureInDocument(printableCorrespondence, ads);
            return ads;
        }
        return null;
    }

    protected void applySignatureInDocument(ProtocolActionsCorrespondenceBase printableCorrespondence, AttachmentDataSource attachmentDataSource) {
        try {
            PrintableAttachment printablePdf = (PrintableAttachment)attachmentDataSource;
            byte[] pdfBytes = printablePdf.getData();
            pdfBytes = this.getPersonSignatureServiceHook().applySignature(pdfBytes);
            printablePdf.setData(pdfBytes);
        }
        catch (Exception e) {
            LOG.error("Exception Occurred in ProtocolActionCorrespondenceGenerationServiceImplBase. Person Signature Exception: ", (Throwable)e);
        }
    }

    protected abstract PersonSignatureService getPersonSignatureServiceHook();

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }
}

