/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.impl.struts;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.core.BudgetException;
import org.kuali.coeus.common.budget.framework.core.BudgetForm;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetJustificationService;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetJustificationWrapper;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItem;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.common.budget.framework.print.BudgetPrintService;
import org.kuali.coeus.common.budget.impl.struts.BudgetAction;
import org.kuali.coeus.common.framework.attachment.KcAttachmentService;
import org.kuali.coeus.common.framework.print.AttachmentDataSource;
import org.kuali.coeus.common.framework.ruleengine.KcBusinessRulesEngine;
import org.kuali.coeus.propdev.impl.budget.subaward.BudgetSubAwardFiles;
import org.kuali.coeus.propdev.impl.budget.subaward.BudgetSubAwardPeriodDetail;
import org.kuali.coeus.propdev.impl.budget.subaward.BudgetSubAwards;
import org.kuali.coeus.propdev.impl.budget.subaward.BudgetSubAwardsEvent;
import org.kuali.coeus.propdev.impl.budget.subaward.PropDevBudgetSubAwardService;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.controller.StrutsConfirmation;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.validation.AuditHelper;
import org.kuali.kra.award.budget.AwardBudgetExt;
import org.kuali.kra.award.budget.AwardBudgetForm;
import org.kuali.kra.award.budget.AwardBudgetService;
import org.kuali.kra.award.budget.document.AwardBudgetDocument;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kns.util.WebUtils;
import org.kuali.rice.kns.web.struts.action.AuditModeAction;
import org.kuali.rice.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.rice.kns.web.struts.form.KualiForm;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.util.ErrorMessage;
import org.kuali.rice.krad.util.GlobalVariables;

public class BudgetActionsAction
extends BudgetAction
implements AuditModeAction {
    private static final String CONTENT_TYPE_XML = "text/xml";
    private static final String XML_FILE_EXTENSION = "xml";
    private static final String CONTENT_TYPE_PDF = "application/pdf";
    private static final String SUBAWARD_BUDGET_EDIT_LINE_STARTER = "document.budget.budgetSubAwards[";
    private static final String SUBAWARD_BUDGET_EDIT_LINE_ENDER = "]";
    private static final String UPDATE_COST_LIMITS_QUESTION = "UpdateCostLimitsQuestion";
    private BudgetJustificationService budgetJustificationService;
    private PropDevBudgetSubAwardService propDevBudgetSubAwardService;
    private static final Logger LOG = LogManager.getLogger(BudgetActionsAction.class);
    private KcBusinessRulesEngine kcBusinessRulesEngine;
    private AwardBudgetService awardBudgetService;

    public ActionForward consolidateExpenseJustifications(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        AwardBudgetExt budget = budgetForm.getBudgetDocument().getBudget();
        try {
            this.getBudgetJustificationService().consolidateExpenseJustifications(budget, this.getBudgetJusticationWrapper(form));
        }
        catch (BudgetException exc) {
            GlobalVariables.getMessageMap().putError("budgetJustificationWrapper.justificationText", "error.custom", new String[]{"There are no line item budget justifications"});
        }
        return mapping.findForward("basic");
    }

    @Override
    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        AwardBudgetExt budget = budgetForm.getBudgetDocument().getBudget();
        this.getBudgetJustificationService().preSave(budget, this.getBudgetJusticationWrapper(form));
        return super.save(mapping, form, request, response);
    }

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        for (BudgetSubAwards subAward : budgetForm.getBudgetDocument().getBudget().getBudgetSubAwards()) {
            subAward.computePeriodDetails();
        }
        return super.execute(mapping, (ActionForm)budgetForm, request, response);
    }

    @Override
    public ActionForward close(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        KualiDocumentFormBase docForm = (KualiDocumentFormBase)form;
        if (docForm.getDocumentActions().containsKey("canSave")) {
            String question = request.getParameter("questionIndex");
            ConfigurationService kualiConfiguration = CoreApiServiceLocator.getKualiConfigurationService();
            if (question == null) {
                return this.performQuestionWithoutInput(mapping, form, request, response, "DocSaveBeforeClose", kualiConfiguration.getPropertyValueAsString("document.question.saveBeforeClose.text"), "confirmationQuestion", "close", "");
            }
            BudgetForm budgetForm = (BudgetForm)form;
            AwardBudgetExt budget = budgetForm.getBudgetDocument().getBudget();
            String buttonClicked = request.getParameter("buttonClicked");
            if ("DocSaveBeforeClose".equals(question) && "0".equals(buttonClicked)) {
                this.getBudgetJustificationService().preSave(budget, this.getBudgetJusticationWrapper(form));
            }
        }
        return super.close(mapping, form, request, response);
    }

    @Override
    public ActionForward reload(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.reload(mapping, form, request, response);
        BudgetForm budgetForm = (BudgetForm)form;
        AwardBudgetExt budget = budgetForm.getBudgetDocument().getBudget();
        this.getPropDevBudgetSubAwardService().populateBudgetSubAwardAttachments(budget);
        return forward;
    }

    public ActionForward addSubAward(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        AwardBudgetDocument awardBudgetDocument = budgetForm.getBudgetDocument();
        BudgetSubAwards newBudgetSubAward = budgetForm.getNewSubAward();
        newBudgetSubAward.setBudgetId(awardBudgetDocument.getBudget().getBudgetId());
        newBudgetSubAward.setSubAwardNumber(this.generateSubAwardNumber(awardBudgetDocument));
        newBudgetSubAward.setBudgetVersionNumber(awardBudgetDocument.getBudget().getBudgetVersionNumber());
        newBudgetSubAward.setSubAwardStatusCode(1);
        newBudgetSubAward.getBudgetSubAwardPeriodDetails().clear();
        for (BudgetPeriod period : awardBudgetDocument.getBudget().getBudgetPeriods()) {
            newBudgetSubAward.getBudgetSubAwardPeriodDetails().add(new BudgetSubAwardPeriodDetail(newBudgetSubAward, period));
        }
        boolean success = true;
        if (newBudgetSubAward.getNewSubAwardFile() != null) {
            String fileName = newBudgetSubAward.getNewSubAwardFile().getOriginalFilename();
            byte[] fileData = newBudgetSubAward.getNewSubAwardFile().getBytes();
            success = this.updateBudgetAttachment(budgetForm.getBudget(), newBudgetSubAward, fileName, fileData, "newSubAward");
        }
        String contentType = newBudgetSubAward.getNewSubAwardFile().getContentType();
        if (success && contentType.equalsIgnoreCase(CONTENT_TYPE_PDF)) {
            budgetForm.setNewSubAward(new BudgetSubAwards());
            awardBudgetDocument.getBudget().getBudgetSubAwards().add(newBudgetSubAward);
        }
        return mapping.findForward("basic");
    }

    public ActionForward viewXFD(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetSubAwards subAward = this.getSelectedBudgetSubAward(form, request);
        subAward.refreshNonUpdateableReferences();
        if (subAward.getBudgetSubAwardFiles().isEmpty()) {
            return mapping.findForward("basic");
        }
        BudgetSubAwardFiles subAwardFiles = subAward.getBudgetSubAwardFiles().get(0);
        this.downloadFile(form, request, response, subAwardFiles.getSubAwardXfdFileData(), subAward.getSubAwardXfdFileName(), CONTENT_TYPE_PDF);
        return null;
    }

    public ActionForward viewXML(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetSubAwards subAward = this.getSelectedBudgetSubAward(form, request);
        subAward.refreshNonUpdateableReferences();
        if (!subAward.getBudgetSubAwardFiles().isEmpty()) {
            BudgetSubAwardFiles subAwardFiles = subAward.getBudgetSubAwardFiles().get(0);
            this.downloadFile(form, request, response, subAwardFiles.getSubAwardXmlFileData().getBytes(), this.createXMLFileName(subAward), CONTENT_TYPE_XML);
        }
        return null;
    }

    public ActionForward delete(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        AwardBudgetDocument awardBudgetDocument = budgetForm.getBudgetDocument();
        int selectedLineNumber = this.getSelectedLine(request);
        BudgetSubAwards subAward = awardBudgetDocument.getBudget().getBudgetSubAwards().get(selectedLineNumber);
        for (BudgetPeriod period : awardBudgetDocument.getBudget().getBudgetPeriods()) {
            Iterator<BudgetLineItem> iter = period.getBudgetLineItems().iterator();
            while (iter.hasNext()) {
                BudgetLineItem item = iter.next();
                if (!Objects.equals(subAward.getSubAwardNumber(), item.getSubAwardNumber())) continue;
                iter.remove();
            }
        }
        awardBudgetDocument.getBudget().getBudgetSubAwards().remove(selectedLineNumber);
        Collections.sort(awardBudgetDocument.getBudget().getBudgetSubAwards());
        return mapping.findForward("basic");
    }

    public ActionForward deleteSubAwardAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        AwardBudgetDocument awardBudgetDocument = budgetForm.getBudgetDocument();
        int selectedLineNumber = this.getSelectedLine(request);
        BudgetSubAwards subAward = awardBudgetDocument.getBudget().getBudgetSubAwards().get(selectedLineNumber);
        this.getPropDevBudgetSubAwardService().removeSubAwardAttachment(subAward);
        return mapping.findForward("basic");
    }

    public ActionForward updateBudgetAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        AwardBudgetDocument awardBudgetDocument = budgetForm.getBudgetDocument();
        BudgetSubAwards subAward = this.getSelectedBudgetSubAward(form, request);
        byte[] subAwardData = subAward.getNewSubAwardFile().getBytes();
        String subAwardFileName = subAward.getNewSubAwardFile().getOriginalFilename();
        this.updateBudgetAttachment(budgetForm.getBudget(), subAward, subAwardFileName, subAwardData, SUBAWARD_BUDGET_EDIT_LINE_STARTER + this.getSelectedLine(request) + SUBAWARD_BUDGET_EDIT_LINE_ENDER);
        Collections.sort(awardBudgetDocument.getBudget().getBudgetSubAwards());
        return mapping.findForward("basic");
    }

    public ActionForward syncFromBudgetAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        AwardBudgetDocument awardBudgetDocument = budgetForm.getBudgetDocument();
        BudgetSubAwards subAward = this.getSelectedBudgetSubAward(form, request);
        String errorPath = SUBAWARD_BUDGET_EDIT_LINE_STARTER + this.getSelectedLine(request) + SUBAWARD_BUDGET_EDIT_LINE_ENDER;
        GlobalVariables.getMessageMap().addToErrorPath(errorPath);
        this.updateSubAwardBudgetDetails(awardBudgetDocument.getBudget(), subAward);
        GlobalVariables.getMessageMap().removeFromErrorPath(errorPath);
        return mapping.findForward("basic");
    }

    protected boolean updateSubAwardBudgetDetails(Budget budget, BudgetSubAwards subAward) throws Exception {
        ArrayList<String[]> errorMessages = new ArrayList<String[]>();
        boolean success = this.getKcBusinessRulesEngine().applyRules(new BudgetSubAwardsEvent(subAward, budget, ""));
        if (subAward.getNewSubAwardFile().getBytes().length == 0) {
            success = false;
        }
        if (success) {
            this.getPropDevBudgetSubAwardService().updateSubAwardBudgetDetails(budget, subAward, errorMessages);
        }
        if (!errorMessages.isEmpty()) {
            for (String[] message : errorMessages) {
                String[] messageParameters = null;
                if (message.length > 1) {
                    messageParameters = Arrays.copyOfRange(message, 1, message.length);
                }
                if (success) {
                    GlobalVariables.getMessageMap().putWarning("newSubAwardFile", message[0], messageParameters);
                    continue;
                }
                GlobalVariables.getMessageMap().putError("newSubAwardFile", message[0], messageParameters);
            }
        }
        if (success && errorMessages.isEmpty()) {
            GlobalVariables.getMessageMap().putInfo("newSubAwardFile", "newSubAward.subAwardFile.detailsUpdated", new String[0]);
        }
        return success;
    }

    protected boolean updateBudgetAttachment(Budget budget, BudgetSubAwards subAward, String fileName, byte[] fileData, String errorPath) throws Exception {
        boolean success;
        GlobalVariables.getMessageMap().addToErrorPath(errorPath);
        subAward.setSubAwardXmlFileData(null);
        subAward.setFormName(null);
        subAward.setNamespace(null);
        if (subAward.getNewSubAwardFile().getContentType().equalsIgnoreCase(CONTENT_TYPE_PDF)) {
            this.getPropDevBudgetSubAwardService().populateBudgetSubAwardFiles(budget, subAward, fileName, fileData);
        }
        if (success = this.updateSubAwardBudgetDetails(budget, subAward)) {
            subAward.getBudgetSubAwardFiles().get(0).setSubAwardXmlFileData(KcServiceLocator.getService(KcAttachmentService.class).checkAndReplaceSpecialCharacters(subAward.getBudgetSubAwardFiles().get(0).getSubAwardXmlFileData().toString()));
            subAward.setSubAwardXmlFileData(subAward.getBudgetSubAwardFiles().get(0).getSubAwardXmlFileData());
        }
        GlobalVariables.getMessageMap().removeFromErrorPath(errorPath);
        return success;
    }

    public ActionForward printBudgetForm(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AttachmentDataSource dataStream;
        String[] forms;
        BudgetForm budgetForm = (BudgetForm)form;
        AwardBudgetExt budget = budgetForm.getBudgetDocument().getBudget();
        Integer selectedLine = this.getSelectedLine(request);
        String budgetFormToPrint = budget.getBudgetPrintForms().get(selectedLine).getBudgetReportId();
        if (budgetForm.getSelectedToPrintComment() != null && budgetFormToPrint != null && (forms = budgetForm.getSelectedToPrintComment())[0].equals(budgetFormToPrint)) {
            budget.setPrintBudgetCommentFlag("true");
        }
        budgetForm.setSelectedToPrintComment(null);
        BudgetPrintService budgetPrintService = KcServiceLocator.getService(BudgetPrintService.class);
        ActionForward forward = mapping.findForward("basic");
        if (budgetFormToPrint != null && (dataStream = budgetPrintService.readBudgetPrintStream(budget, budgetFormToPrint)).getData() != null) {
            this.streamToResponse(dataStream, response);
            forward = null;
        }
        return forward;
    }

    public void setBudgetJustificationService(BudgetJustificationService budgetJustificationService) {
        this.budgetJustificationService = budgetJustificationService;
    }

    private String createXMLFileName(BudgetSubAwards subAward) {
        return subAward.getSubAwardXfdFileName().substring(0, subAward.getSubAwardXfdFileName().lastIndexOf(".") + 1) + XML_FILE_EXTENSION;
    }

    private Integer generateSubAwardNumber(AwardBudgetDocument awardBudgetDocument) {
        return awardBudgetDocument.getHackedDocumentNextValue("subAwardNumber") != null ? awardBudgetDocument.getHackedDocumentNextValue("subAwardNumber") : 1;
    }

    private BudgetJustificationWrapper getBudgetJusticationWrapper(ActionForm form) {
        return ((BudgetForm)form).getBudgetJustification();
    }

    private BudgetSubAwards getSelectedBudgetSubAward(ActionForm form, HttpServletRequest request) {
        BudgetForm budgetForm = (BudgetForm)form;
        AwardBudgetExt budget = budgetForm.getBudgetDocument().getBudget();
        int selectedLineNumber = this.getSelectedLine(request);
        return budget.getBudgetSubAwards().get(selectedLineNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadFile(ActionForm form, HttpServletRequest request, HttpServletResponse response, byte[] bytesToDownload, String fileName, String contentType) throws Exception {
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream(bytesToDownload.length);
            baos.write(bytesToDownload);
            WebUtils.saveMimeOutputStreamAsFile((HttpServletResponse)response, (String)contentType, (ByteArrayOutputStream)baos, (String)fileName);
        }
        finally {
            try {
                if (baos != null) {
                    baos.close();
                    baos = null;
                }
            }
            catch (IOException ioEx) {
                LOG.warn(ioEx.getMessage(), (Throwable)ioEx);
            }
        }
    }

    @Override
    public ActionForward route(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardBudgetDocument awardBudgetDocument = ((AwardBudgetForm)form).getAwardBudgetDocument();
        Award currentAward = this.getAwardBudgetService().getActiveOrNewestAward(((AwardDocument)awardBudgetDocument.getBudget().getBudgetParent().getDocument()).getAward().getAwardNumber());
        ScaleTwoDecimal newCostLimit = this.getAwardBudgetService().getTotalCostLimit(currentAward);
        if (!newCostLimit.equals((Object)awardBudgetDocument.getBudget().getTotalCostLimit()) || !this.getAwardBudgetService().limitsMatch(currentAward.getAwardBudgetLimits(), awardBudgetDocument.getAwardBudget().getAwardBudgetLimits())) {
            String question = request.getParameter("questionIndex");
            String buttonClicked = request.getParameter("buttonClicked");
            String methodToCall = ((KualiForm)form).getMethodToCall();
            if (question == null) {
                ConfigurationService kualiConfiguration = CoreApiServiceLocator.getKualiConfigurationService();
                return this.confirm(this.buildParameterizedConfirmationQuestion(mapping, form, request, response, UPDATE_COST_LIMITS_QUESTION, "document.question.totalCostLimit.changed", new String[0]), methodToCall, methodToCall);
            }
            if (UPDATE_COST_LIMITS_QUESTION.equals(question) && "0".equals(buttonClicked)) {
                this.getAwardBudgetService().setBudgetLimits(awardBudgetDocument, currentAward);
                return mapping.findForward("basic");
            }
        }
        ((AwardBudgetForm)form).setAuditActivated(true);
        AuditHelper.ValidationState state = KcServiceLocator.getService(AuditHelper.class).isValidSubmission((AwardBudgetForm)form, true);
        if (state != AuditHelper.ValidationState.ERROR) {
            this.getAwardBudgetService().processSubmision(awardBudgetDocument);
            return super.route(mapping, form, request, response);
        }
        GlobalVariables.getMessageMap().clearErrorMessages();
        GlobalVariables.getMessageMap().putError("datavalidation", "error.workflow.submission", new String[0]);
        return mapping.findForward("basic");
    }

    public ActionForward approve(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardBudgetDocument awardBudgetDocument = ((AwardBudgetForm)form).getAwardBudgetDocument();
        boolean success = this.isValidForSubmission(awardBudgetDocument);
        ActionForward actionForward = super.approve(mapping, form, request, response);
        this.getAwardBudgetService().processApproval(awardBudgetDocument);
        return actionForward;
    }

    public ActionForward disapprove(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardBudgetDocument awardBudgetDocument = ((AwardBudgetForm)form).getAwardBudgetDocument();
        boolean auditPassed = KcServiceLocator.getService(AuditHelper.class).auditUnconditionally((Document)awardBudgetDocument);
        this.getAwardBudgetService().processDisapproval(awardBudgetDocument);
        return super.disapprove(mapping, form, request, response);
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardBudgetDocument awardBudgetDocument = ((AwardBudgetForm)form).getAwardBudgetDocument();
        WorkflowDocument workflowDoc = awardBudgetDocument.getDocumentHeader().getWorkflowDocument();
        if (workflowDoc.isEnroute() && StringUtils.equals((CharSequence)GlobalVariables.getUserSession().getPrincipalId(), (CharSequence)workflowDoc.getRoutedByPrincipalId())) {
            workflowDoc.superUserCancel("Cancelled by Routed By User");
            return mapping.findForward("basic");
        }
        return super.cancel(mapping, form, request, response);
    }

    private boolean isValidForSubmission(AwardBudgetDocument awardBudgetDocument) {
        return false;
    }

    public ActionForward postAwardBudget(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardBudgetDocument awardBudgetDocument = ((AwardBudgetForm)form).getAwardBudgetDocument();
        if (this.getAwardBudgetService().isFinancialIntegrationOn()) {
            this.getAwardBudgetService().postWithFinancialIntegration(awardBudgetDocument);
            return mapping.findForward("budgetActions");
        }
        this.getAwardBudgetService().post(awardBudgetDocument);
        this.setupDocumentExit();
        return this.returnToSender(request, mapping, (KualiDocumentFormBase)((AwardBudgetForm)form));
    }

    public ActionForward toggleAwardBudgetStatus(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardBudgetDocument awardBudgetDocument = ((AwardBudgetForm)form).getAwardBudgetDocument();
        this.getAwardBudgetService().toggleStatus(awardBudgetDocument);
        return mapping.findForward("basic");
    }

    public ActionForward activate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = form instanceof AwardBudgetForm ? KcServiceLocator.getService(AuditHelper.class).setAuditMode(mapping, (AwardBudgetForm)form, true) : KcServiceLocator.getService(AuditHelper.class).setAuditMode(mapping, (BudgetForm)form, true);
        return forward;
    }

    public ActionForward deactivate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = form instanceof AwardBudgetForm ? KcServiceLocator.getService(AuditHelper.class).setAuditMode(mapping, (AwardBudgetForm)form, false) : KcServiceLocator.getService(AuditHelper.class).setAuditMode(mapping, (BudgetForm)form, false);
        return forward;
    }

    public ActionForward budgetDistributionAndIncome(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return super.distributionAndIncome(mapping, form, request, response);
    }

    public ActionForward summary(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return super.parameters(mapping, form, request, response);
    }

    public ActionForward budgetExpenses(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return super.expenses(mapping, form, request, response);
    }

    @Override
    public ActionForward personnel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return super.personnel(mapping, form, request, response);
    }

    @Override
    public ActionForward parameters(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return super.parameters(mapping, form, request, response);
    }

    public ActionForward budgetRate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return super.rates(mapping, form, request, response);
    }

    private ActionForward doEndDateConfirmation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String questionId, String yesMethodName) throws Exception {
        List errors = GlobalVariables.getMessageMap().getErrorMessagesForProperty("newHierarchyChildProposalNumber");
        ArrayList<String> proposalNumbers = new ArrayList<String>();
        for (ErrorMessage error : errors) {
            if (!error.getErrorKey().equals("question.hierarchy.extendDate.confirm")) continue;
            proposalNumbers.add(error.getMessageParameters()[0]);
        }
        String proposalNumberList = StringUtils.join(proposalNumbers, (char)',');
        StrutsConfirmation question = this.buildParameterizedConfirmationQuestion(mapping, form, request, response, questionId, "question.hierarchy.extendDate.confirm", proposalNumberList);
        GlobalVariables.getMessageMap().getErrorMessages().clear();
        GlobalVariables.getMessageMap().getWarningMessages().clear();
        GlobalVariables.getMessageMap().getInfoMessages().clear();
        return this.confirm(question, yesMethodName, "hierarchyActionCanceled");
    }

    public PropDevBudgetSubAwardService getPropDevBudgetSubAwardService() {
        if (this.propDevBudgetSubAwardService == null) {
            this.propDevBudgetSubAwardService = KcServiceLocator.getService(PropDevBudgetSubAwardService.class);
        }
        return this.propDevBudgetSubAwardService;
    }

    public void setPropDevBudgetSubAwardService(PropDevBudgetSubAwardService propDevBudgetSubAwardService) {
        this.propDevBudgetSubAwardService = propDevBudgetSubAwardService;
    }

    public ActionForward budgetVersions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        BudgetForm budgetForm = (BudgetForm)form;
        String headerTabCall = this.getHeaderTabDispatch(request);
        if (StringUtils.isEmpty((CharSequence)headerTabCall)) {
            budgetForm.getDocument().refreshPessimisticLocks();
        }
        return mapping.findForward("versions");
    }

    public AwardBudgetService getAwardBudgetService() {
        if (this.awardBudgetService == null) {
            this.awardBudgetService = KcServiceLocator.getService(AwardBudgetService.class);
        }
        return this.awardBudgetService;
    }

    @Override
    public KcBusinessRulesEngine getKcBusinessRulesEngine() {
        if (this.kcBusinessRulesEngine == null) {
            this.kcBusinessRulesEngine = KcServiceLocator.getService(KcBusinessRulesEngine.class);
        }
        return this.kcBusinessRulesEngine;
    }

    @Override
    public void setKcBusinessRulesEngine(KcBusinessRulesEngine kcBusinessRulesEngine) {
        this.kcBusinessRulesEngine = kcBusinessRulesEngine;
    }

    protected BudgetJustificationService getBudgetJustificationService() {
        if (this.budgetJustificationService == null) {
            this.budgetJustificationService = KcServiceLocator.getService(BudgetJustificationService.class);
        }
        return this.budgetJustificationService;
    }
}

