/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.service.impl;

import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.impl.krms.KcKrmsJavaFunctionTermServiceBase;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardComment;
import org.kuali.kra.award.service.AwardJavaFunctionKrmsTermService;
import org.kuali.kra.award.specialreview.AwardSpecialReview;

public class AwardJavaFunctionKrmsTermServiceImpl
extends KcKrmsJavaFunctionTermServiceBase
implements AwardJavaFunctionKrmsTermService {
    @Override
    public Boolean checkCommentEntered(Award award, String commentTypeCode) {
        if (commentTypeCode != null && commentTypeCode.equalsIgnoreCase("null")) {
            commentTypeCode = null;
        }
        for (AwardComment comment : award.getAwardComments()) {
            if (!StringUtils.equals((CharSequence)comment.getCommentTypeCode(), (CharSequence)commentTypeCode) || !StringUtils.isNotBlank((CharSequence)comment.getComments())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Boolean hasSpecialReviewOfType(Award award, String specialReviewType) {
        return award.getSpecialReviews().stream().anyMatch(awardReview -> this.doesSpecialReviewMatch((AwardSpecialReview)awardReview, specialReviewType));
    }

    public boolean doesSpecialReviewMatch(AwardSpecialReview specialReview, String specialReviewType) {
        return StringUtils.equals((CharSequence)specialReview.getSpecialReviewTypeCode(), (CharSequence)specialReviewType) || specialReview.getSpecialReviewType() != null && StringUtils.equals((CharSequence)specialReview.getSpecialReviewType().getDescription(), (CharSequence)specialReviewType);
    }

    @Override
    public Boolean awardPersonnelTotalEffort(Award award, String effortToMatch) {
        ScaleTwoDecimal effort = this.convertToScaleTwoDecimal(effortToMatch);
        return award.getProjectPersons().size() == 0 ? Boolean.FALSE.booleanValue() : award.getProjectPersons().stream().anyMatch(person -> Objects.equals(person.getTotalEffort(), effort));
    }

    @Override
    public Boolean awardPersonnelCalendarEffort(Award award, String effortToMatch) {
        ScaleTwoDecimal effort = this.convertToScaleTwoDecimal(effortToMatch);
        return award.getProjectPersons().size() == 0 ? Boolean.FALSE.booleanValue() : award.getProjectPersons().stream().anyMatch(person -> Objects.equals(person.getCalendarYearEffort(), effort));
    }

    @Override
    public Boolean awardCommentsRule(Award award, String comments, String commentTypeCode) {
        String commentOfSameType = this.getCommentOfType(commentTypeCode, award);
        return commentOfSameType == null && comments.equalsIgnoreCase("null") || StringUtils.equalsIgnoreCase((CharSequence)comments, (CharSequence)commentOfSameType);
    }

    private String getCommentOfType(String commentTypeCode, Award award) {
        AwardComment awardComment = award.getAwardComments().stream().filter(comment -> StringUtils.equals((CharSequence)comment.getCommentTypeCode(), (CharSequence)commentTypeCode)).findFirst().orElse(null);
        return awardComment == null ? null : awardComment.getComments();
    }

    protected ScaleTwoDecimal convertToScaleTwoDecimal(String effortToMatch) {
        ScaleTwoDecimal effort = effortToMatch.equalsIgnoreCase("null") || StringUtils.isEmpty((CharSequence)effortToMatch) ? null : new ScaleTwoDecimal(effortToMatch);
        return effort;
    }

    @Override
    public Boolean specialReviewAndApprovalTypeRule(Award award, String specialReviewTypeCode, String approvalTypeCode) {
        List<AwardSpecialReview> specialReviews = award.getSpecialReviews();
        return this.specialReviewTypeCodeAndApprovalTypeCodeMatch(specialReviews, specialReviewTypeCode, approvalTypeCode);
    }
}

