/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.excon.document;

import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kra.excon.document.ExconProjectDocument;
import org.kuali.kra.excon.project.ExconProject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;
import org.kuali.rice.krad.util.AuditCluster;
import org.kuali.rice.krad.util.AuditError;
import org.kuali.rice.krad.util.GlobalVariables;

public class ExconProjectPersonsAuditRule
implements DocumentAuditRule {
    public boolean processRunAuditBusinessRules(Document document) {
        boolean valid = true;
        ExconProjectDocument exconProjectDocument = (ExconProjectDocument)document;
        return valid &= this.projectHasTraveler(exconProjectDocument);
    }

    private boolean projectHasTraveler(ExconProjectDocument exconProjectDocument) {
        ArrayList<AuditError> auditErrors = new ArrayList<AuditError>();
        ExconProject project = exconProjectDocument.getExconProject();
        if (project != null && StringUtils.equals((CharSequence)"International Travel", (CharSequence)project.getProjectType().getDescription()) && project.getTraveler() == null) {
            auditErrors.add(new AuditError("exconProjectPersonsBean.newPerson.personId", "error.exconProjectTraveler.missing", "contacts.projectPersons"));
            GlobalVariables.getAuditErrorMap().put("personsAuditErrors", new AuditCluster("Project Persons", auditErrors, "Error"));
            return false;
        }
        return true;
    }
}

