/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.kim.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kra.iacuc.IacucProtocol;
import org.kuali.kra.iacuc.personnel.IacucProtocolAffiliationType;
import org.kuali.kra.protocol.personnel.ProtocolPersonBase;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.kim.api.role.RoleMembership;
import org.kuali.rice.kns.kim.role.DerivedRoleTypeServiceBase;

public class IacucProtocolAffiliateTypeDerivedRoleTypeServiceImpl
extends DerivedRoleTypeServiceBase {
    protected List<String> requiredAttributes = new ArrayList<String>();

    public IacucProtocolAffiliateTypeDerivedRoleTypeServiceImpl() {
        this.requiredAttributes.add("protocol");
    }

    public List<RoleMembership> getRoleMembersFromDerivedRole(String namespaceCode, String roleName, Map<String, String> qualification) {
        this.validateRequiredAttributesAgainstReceived(qualification);
        ArrayList<RoleMembership> members = new ArrayList<RoleMembership>();
        String protocolNumber = qualification.get("protocol");
        IacucProtocol protocol = this.getProtocol(protocolNumber);
        if (protocol != null && CollectionUtils.isNotEmpty(protocol.getProtocolPersons())) {
            members.addAll(protocol.getProtocolPersons().stream().filter(person -> StringUtils.equals((CharSequence)this.getAffiliationType(person.getAffiliationTypeCode()), (CharSequence)roleName) && StringUtils.isNotBlank((CharSequence)person.getPerson().getPersonId())).map(person -> RoleMembership.Builder.create(null, null, (String)person.getPerson().getPersonId(), (MemberType)MemberType.PRINCIPAL, null).build()).collect(Collectors.toList()));
        }
        return members;
    }

    public boolean hasDerivedRole(String principalId, List<String> groupIds, String namespaceCode, String roleName, Map<String, String> qualification) {
        this.validateRequiredAttributesAgainstReceived(qualification);
        String protocolNumber = qualification.get("protocol");
        IacucProtocol protocol = this.getProtocol(protocolNumber);
        if (protocol != null && CollectionUtils.isNotEmpty(protocol.getProtocolPersons())) {
            for (ProtocolPersonBase person : protocol.getProtocolPersons()) {
                if (!StringUtils.equals((CharSequence)principalId, (CharSequence)person.getPersonId()) || !StringUtils.equals((CharSequence)roleName, (CharSequence)this.getAffiliationType(person.getAffiliationType().getAffiliationTypeCode()))) continue;
                return true;
            }
        }
        return false;
    }

    private IacucProtocol getProtocol(String protocolNumber) {
        return (IacucProtocol)this.getBusinessObjectService().findByPrimaryKey(IacucProtocol.class, Collections.singletonMap("protocolNumber", protocolNumber));
    }

    private String getAffiliationType(Integer affiliationTypeCode) {
        Collection affiliationTypes;
        String result = null;
        if (affiliationTypeCode != null && CollectionUtils.isNotEmpty((Collection)(affiliationTypes = this.getBusinessObjectService().findMatching(IacucProtocolAffiliationType.class, Collections.singletonMap("affiliationTypeCode", affiliationTypeCode.toString()))))) {
            result = ((IacucProtocolAffiliationType)affiliationTypes.iterator().next()).getDescription();
        }
        return result;
    }

    public boolean dynamicRoleMembership(String namespaceCode, String roleName) {
        super.dynamicRoleMembership(namespaceCode, roleName);
        return true;
    }
}

