/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.summary;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kra.iacuc.summary.IacucProcedureSummary;
import org.kuali.kra.iacuc.summary.IacucProtocolExceptionSummary;
import org.kuali.kra.iacuc.summary.IacucProtocolSpeciesSummary;
import org.kuali.kra.iacuc.summary.IacucThreeRsSummary;
import org.kuali.kra.protocol.summary.ProtocolSummary;

public class IacucProtocolSummary
extends ProtocolSummary {
    private static final long serialVersionUID = -8169452881498847762L;
    private String projectType;
    private String layStmt1;
    private String layStmt2;
    private boolean projectTypeChanged;
    private boolean layStmt1Changed = false;
    private boolean layStmt2Changed = false;
    private IacucThreeRsSummary threeRsInfo;
    private List<IacucProtocolSpeciesSummary> speciesSummaries = new ArrayList<IacucProtocolSpeciesSummary>();
    private List<IacucProtocolExceptionSummary> exceptionSummaries = new ArrayList<IacucProtocolExceptionSummary>();
    private String procedureOverviewSummary;
    private boolean procedureOverviewSummaryChanged = false;
    private List<IacucProcedureSummary> procedureSummaries = new ArrayList<IacucProcedureSummary>();

    public void compare(IacucProtocolSummary other) {
        super.compare(other);
        this.projectTypeChanged = !StringUtils.equals((CharSequence)this.projectType, (CharSequence)other.projectType);
        this.layStmt1Changed = !StringUtils.equals((CharSequence)this.layStmt1, (CharSequence)other.layStmt1);
        this.layStmt2Changed = !StringUtils.equals((CharSequence)this.layStmt2, (CharSequence)other.layStmt2);
        this.compareThreeRs(other);
        this.compareSpecies(other);
        this.compareExceptions(other);
        this.compareProcedures(other);
    }

    public String getProjectType() {
        return this.projectType;
    }

    public void setProjectType(String projectType) {
        this.projectType = projectType;
    }

    public String getLayStmt1() {
        return this.layStmt1;
    }

    public void setLayStmt1(String layStmt1) {
        this.layStmt1 = layStmt1;
    }

    public String getLayStmt2() {
        return this.layStmt2;
    }

    public void setLayStmt2(String layStmt2) {
        this.layStmt2 = layStmt2;
    }

    public boolean isProjectTypeChanged() {
        return this.projectTypeChanged;
    }

    public boolean isLayStmt1Changed() {
        return this.layStmt1Changed;
    }

    public boolean isLayStmt2Changed() {
        return this.layStmt2Changed;
    }

    public IacucThreeRsSummary getThreeRsInfo() {
        return this.threeRsInfo;
    }

    public void setThreeRsInfo(IacucThreeRsSummary threeRsInfo) {
        this.threeRsInfo = threeRsInfo;
    }

    public List<IacucProcedureSummary> getProcedureSummaries() {
        return this.procedureSummaries;
    }

    public void setProcedureSummaries(List<IacucProcedureSummary> procedureSummaries) {
        this.procedureSummaries = procedureSummaries;
    }

    public void setProjectTypeChanged(boolean projectTypeChanged) {
        this.projectTypeChanged = projectTypeChanged;
    }

    public void setLayStmt1Changed(boolean layStmt1Changed) {
        this.layStmt1Changed = layStmt1Changed;
    }

    public void setLayStmt2Changed(boolean layStmt2Changed) {
        this.layStmt2Changed = layStmt2Changed;
    }

    public void setSpeciesSummaries(List<IacucProtocolSpeciesSummary> speciesSummaries) {
        this.speciesSummaries = speciesSummaries;
    }

    public void setExceptionSummaries(List<IacucProtocolExceptionSummary> exceptionSummaries) {
        this.exceptionSummaries = exceptionSummaries;
    }

    private void compareThreeRs(IacucProtocolSummary other) {
        this.threeRsInfo.compare(other.getThreeRsInfo());
    }

    private void compareSpecies(IacucProtocolSummary other) {
        for (IacucProtocolSpeciesSummary mySummary : this.speciesSummaries) {
            mySummary.compare(other);
        }
    }

    public IacucProtocolSpeciesSummary findSpeciesSummary(Integer speciesId) {
        for (IacucProtocolSpeciesSummary species : this.speciesSummaries) {
            if (!species.getSpeciesId().equals(speciesId)) continue;
            return species;
        }
        return null;
    }

    public List<IacucProtocolSpeciesSummary> getSpeciesSummaries() {
        return this.speciesSummaries;
    }

    public List<IacucProtocolExceptionSummary> getExceptionSummaries() {
        return this.exceptionSummaries;
    }

    private void compareExceptions(IacucProtocolSummary other) {
        for (IacucProtocolExceptionSummary mySummary : this.exceptionSummaries) {
            mySummary.compare(other);
        }
    }

    private void compareProcedures(IacucProtocolSummary other) {
        this.procedureOverviewSummaryChanged = !StringUtils.equals((CharSequence)this.procedureOverviewSummary, (CharSequence)other.procedureOverviewSummary);
        for (IacucProcedureSummary mySummary : this.procedureSummaries) {
            mySummary.compare(other);
        }
    }

    public IacucProtocolExceptionSummary findExceptionSummary(Integer exceptionId) {
        for (IacucProtocolExceptionSummary exception : this.exceptionSummaries) {
            if (!exception.getIacucProtocolExceptionId().equals(exceptionId)) continue;
            return exception;
        }
        return null;
    }

    public String getProcedureOverviewSummary() {
        return this.procedureOverviewSummary;
    }

    public void setProcedureOverviewSummary(String procedureOverviewSummary) {
        this.procedureOverviewSummary = procedureOverviewSummary;
    }

    public boolean isProcedureOverviewSummaryChanged() {
        return this.procedureOverviewSummaryChanged;
    }

    public void setProcedureOverviewSummaryChanged(boolean procedureOverviewSummaryChanged) {
        this.procedureOverviewSummaryChanged = procedureOverviewSummaryChanged;
    }

    public IacucProcedureSummary findProcedureSummary(Integer procedureCode) {
        for (IacucProcedureSummary procedure : this.procedureSummaries) {
            if (!procedure.getProcedureCode().equals(procedureCode)) continue;
            return procedure;
        }
        return null;
    }
}

