/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.assignreviewers;

import java.sql.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.committee.impl.bo.CommitteeBase;
import org.kuali.coeus.common.committee.impl.bo.CommitteeScheduleBase;
import org.kuali.coeus.common.notification.impl.NotificationRenderer;
import org.kuali.coeus.common.notification.impl.bo.NotificationType;
import org.kuali.coeus.common.notification.impl.service.KcNotificationService;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolOnlineReviewDocument;
import org.kuali.kra.irb.actions.assignreviewers.ProtocolAssignReviewersService;
import org.kuali.kra.irb.actions.notification.AssignReviewerNotificationRenderer;
import org.kuali.kra.irb.actions.notification.ProtocolNotificationRequestBean;
import org.kuali.kra.irb.actions.submit.ProtocolReviewer;
import org.kuali.kra.irb.notification.IRBNotificationContext;
import org.kuali.kra.irb.notification.IRBProtocolNotification;
import org.kuali.kra.irb.onlinereview.ProtocolOnlineReview;
import org.kuali.kra.irb.onlinereview.ProtocolOnlineReviewService;
import org.kuali.kra.irb.personnel.ProtocolPerson;
import org.kuali.kra.protocol.actions.submit.ProtocolReviewerBeanBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public class ProtocolAssignReviewersServiceImpl
implements ProtocolAssignReviewersService {
    private BusinessObjectService businessObjectService;
    private ProtocolOnlineReviewService protocolOnlineReviewService;
    private KcNotificationService kcNotificationService;

    @Override
    public void assignReviewers(ProtocolSubmissionBase protocolSubmission, List<ProtocolReviewerBeanBase> protocolReviewerBeans) {
        if (protocolSubmission != null) {
            for (ProtocolReviewerBeanBase bean : protocolReviewerBeans) {
                if (StringUtils.isNotBlank((CharSequence)bean.getReviewerTypeCode())) {
                    if (!this.protocolOnlineReviewService.isProtocolReviewer(bean.getPersonId(), bean.getNonEmployeeFlag(), protocolSubmission)) {
                        this.createReviewer(protocolSubmission, bean);
                        continue;
                    }
                    this.updateReviewer(protocolSubmission, bean);
                    bean.setActionFlag("update");
                    continue;
                }
                if (!this.protocolOnlineReviewService.isProtocolReviewer(bean.getPersonId(), bean.getNonEmployeeFlag(), protocolSubmission)) continue;
                this.removeReviewer(protocolSubmission, bean, "REVIEW REMOVED FROM ASSIGN REVIEWERS ACTION.");
            }
            this.businessObjectService.save((PersistableBusinessObject)protocolSubmission);
        }
    }

    protected void removeReviewer(ProtocolSubmissionBase protocolSubmission, ProtocolReviewerBeanBase bean, String annotation) {
        ProtocolOnlineReviewDocument onlineReviewDocument = (ProtocolOnlineReviewDocument)this.protocolOnlineReviewService.getProtocolOnlineReviewDocument(bean.getPersonId(), bean.getNonEmployeeFlag(), protocolSubmission);
        if (onlineReviewDocument != null) {
            Protocol protocol = (Protocol)protocolSubmission.getProtocol();
            ProtocolOnlineReview protocolOnlineReview = (ProtocolOnlineReview)onlineReviewDocument.getProtocolOnlineReview();
            bean.setNotificationRequestBean(new ProtocolNotificationRequestBean(protocol, protocolOnlineReview, "901", "Assign Reviewer", null, null));
            bean.setActionFlag("remove");
            AssignReviewerNotificationRenderer renderer = new AssignReviewerNotificationRenderer(protocol, "removed");
            IRBNotificationContext context = new IRBNotificationContext(protocol, protocolOnlineReview, "901", "Assign Reviewer", (NotificationRenderer)renderer);
            if (!this.getPromptUserForNotificationEditor(context)) {
                this.kcNotificationService.sendNotificationAndPersist(context, new IRBProtocolNotification(), protocol);
            }
        }
        this.protocolOnlineReviewService.removeOnlineReviewDocument(bean.getPersonId(), bean.getNonEmployeeFlag(), protocolSubmission, annotation);
    }

    private boolean getPromptUserForNotificationEditor(IRBNotificationContext context) {
        boolean promptUser = false;
        NotificationType notificationType = this.kcNotificationService.getNotificationType(context);
        if (notificationType != null && notificationType.isActive() && notificationType.getPromptUser()) {
            promptUser = true;
        }
        return promptUser;
    }

    protected void createReviewer(ProtocolSubmissionBase protocolSubmission, ProtocolReviewerBeanBase bean) {
        String principalId = bean.getPersonId();
        boolean nonEmployeeFlag = bean.getNonEmployeeFlag();
        String reviewerTypeCode = bean.getReviewerTypeCode();
        ProtocolReviewer reviewer = (ProtocolReviewer)this.protocolOnlineReviewService.createProtocolReviewer(principalId, nonEmployeeFlag, reviewerTypeCode, protocolSubmission);
        ProtocolPerson protocolPerson = (ProtocolPerson)protocolSubmission.getProtocol().getPrincipalInvestigator();
        String protocolNumber = protocolSubmission.getProtocol().getProtocolNumber();
        String description = this.protocolOnlineReviewService.getProtocolOnlineReviewDocumentDescription(protocolNumber, protocolPerson.getLastName());
        String explanation = "";
        String organizationDocumentNumber = "";
        String routeAnnotation = "Online Review Requested by PI during protocol submission.";
        boolean initialApproval = false;
        Date dateRequested = null;
        Date dateDue = this.assignDefaultDueDate(protocolSubmission);
        String sessionPrincipalId = GlobalVariables.getUserSession().getPrincipalId();
        ProtocolOnlineReviewDocument document = (ProtocolOnlineReviewDocument)this.protocolOnlineReviewService.createAndRouteProtocolOnlineReviewDocument(protocolSubmission, reviewer, description, explanation, organizationDocumentNumber, routeAnnotation, initialApproval, dateRequested, dateDue, sessionPrincipalId);
        protocolSubmission.getProtocolOnlineReviews().add(document.getProtocolOnlineReview());
        Protocol protocol = (Protocol)protocolSubmission.getProtocol();
        ProtocolOnlineReview protocolOnlineReview = (ProtocolOnlineReview)document.getProtocolOnlineReview();
        bean.setNotificationRequestBean(new ProtocolNotificationRequestBean(protocol, protocolOnlineReview, "901", "Assign Reviewer", null, null));
        bean.setActionFlag("create");
        AssignReviewerNotificationRenderer renderer = new AssignReviewerNotificationRenderer(protocol, "added");
        IRBNotificationContext context = new IRBNotificationContext(protocol, protocolOnlineReview, "901", "Assign Reviewer", (NotificationRenderer)renderer);
        if (!this.getPromptUserForNotificationEditor(context)) {
            this.kcNotificationService.sendNotificationAndPersist(context, new IRBProtocolNotification(), protocol);
        }
    }

    private Date assignDefaultDueDate(ProtocolSubmissionBase protocolSubmission) {
        Object schedule;
        Date dueDate = null;
        CommitteeBase committee = protocolSubmission.getCommittee();
        if (committee != null && (schedule = committee.getCommitteeSchedule(protocolSubmission.getScheduleId())) != null) {
            dueDate = ((CommitteeScheduleBase)schedule).getScheduledDate();
        }
        return dueDate;
    }

    protected void updateReviewer(ProtocolSubmissionBase protocolSubmission, ProtocolReviewerBeanBase bean) {
        ProtocolReviewer reviewer = (ProtocolReviewer)this.protocolOnlineReviewService.getProtocolReviewer(bean.getPersonId(), bean.getNonEmployeeFlag(), protocolSubmission);
        reviewer.setReviewerTypeCode(bean.getReviewerTypeCode());
        this.businessObjectService.save((PersistableBusinessObject)reviewer);
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setProtocolOnlineReviewService(ProtocolOnlineReviewService protocolOnlineReviewService) {
        this.protocolOnlineReviewService = protocolOnlineReviewService;
    }

    public void setKcNotificationService(KcNotificationService kcNotificationService) {
        this.kcNotificationService = kcNotificationService;
    }
}

